/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.geo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.gcqlwrapper.GcqlProcessor;
import org.gcube.indexmanagement.gcqlwrapper.GcqlQueryContainer;
import org.gcube.indexmanagement.geo.GeoGcqlCollectionQuery;
import org.gcube.indexmanagement.geo.GeoGcqlQueryContainer;
import org.gcube.indexmanagement.geo.InclusionType;
import org.gcube.indexmanagement.geo.RTreeWrapper;
import org.gcube.indexmanagement.geo.RankingRequest;
import org.gcube.indexmanagement.geo.RefinementRequest;
import org.gcube.indexmanagement.geo.shape.Point;
import org.gcube.indexmanagement.geo.shape.Polygon;
import org.gcube.indexmanagement.geo.shape.PolygonProcessing;
import org.gcube.indexmanagement.resourceregistry.RRadaptor;
import search.library.util.cql.query.tree.GCQLAndNode;
import search.library.util.cql.query.tree.GCQLNode;
import search.library.util.cql.query.tree.GCQLNotNode;
import search.library.util.cql.query.tree.GCQLOrNode;
import search.library.util.cql.query.tree.GCQLProjectNode;
import search.library.util.cql.query.tree.GCQLQueryTreeManager;
import search.library.util.cql.query.tree.GCQLTermNode;
import search.library.util.cql.query.tree.Modifier;
import search.library.util.cql.query.tree.ModifierSet;

public class GeoGcqlProcessor
extends GcqlProcessor {
    private static final String POLYGON_REFINER = "PolygonalRefiner";
    static GCUBELog logger = new GCUBELog(GeoGcqlProcessor.class);
    private LinkedHashMap<String, String> projectedFields = new LinkedHashMap();
    private Integer numberOfDecimals = 4;
    private HashMap<String, ArrayList<String>> colLangPairs = new HashMap();

    public Integer getNumberOfDecimals() {
        return this.numberOfDecimals;
    }

    public void setNumberOfDecimals(Integer numberOfDecimals) {
        this.numberOfDecimals = numberOfDecimals;
    }

    public static void main(String[] args) {
        ArrayList<String> presentable = new ArrayList<String>();
        ArrayList<String> searchable = new ArrayList<String>();
        String gCQLQuery = "(((geo geosearch/colID=\"C\"/lang=\"en\"/inclusion=\"1\" \"10 10 10 20 20 20 20 10\") or (geo geosearch/colID=\"C\"/lang=\"en\"/inclusion=\"1\" \"0 0 0 8 4 8 4 0\")) and ((geo geosearch/colID=\"C\"/lang=\"en\"/inclusion=\"1\" \"-2 -6 -2 4 8 4 8 -6\") or (geo geosearch/colID=\"A\"/lang=\"en\"/inclusion=\"1\" \"-2 -6 -2 4 8 4 8 -6\")))";
        try {
            GcqlQueryContainer results = new GeoGcqlProcessor().processQuery(presentable, searchable, gCQLQuery, new RRadaptor("dummy"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setCurrentColLangPairs(HashMap<String, HashMap<String, Vector<RTreeWrapper>>> index) {
        for (Map.Entry<String, HashMap<String, Vector<RTreeWrapper>>> current : index.entrySet()) {
            String colID = current.getKey();
            ArrayList<String> langs = new ArrayList<String>();
            Iterator<String> langIter = current.getValue().keySet().iterator();
            while (langIter.hasNext()) {
                langs.add(langIter.next());
            }
            this.colLangPairs.put(colID, langs);
        }
    }

    @Override
    public GcqlQueryContainer processQuery(ArrayList<String> presentableFields, ArrayList<String> searchableFields, String gCQLQuery, RRadaptor adaptor) throws Exception {
        logger.trace((Object)("presentables: " + Arrays.toString(presentableFields.toArray(new String[presentableFields.size()]))));
        logger.trace((Object)("searchables: " + Arrays.toString(searchableFields.toArray(new String[searchableFields.size()]))));
        this.presentableFields = presentableFields;
        this.searchableFields = searchableFields;
        this.adaptor = adaptor;
        GCQLNode head = GCQLQueryTreeManager.parseGCQLString((String)gCQLQuery);
        GeoGcqlQueryContainer cont = this.processNode(head, false);
        return cont;
    }

    private GeoGcqlQueryContainer processNode(GCQLNode node, boolean not) throws Exception {
        if (node instanceof GCQLProjectNode) {
            return this.processNode((GCQLProjectNode)node, not);
        }
        if (node instanceof GCQLAndNode) {
            return this.processNode((GCQLAndNode)node, not);
        }
        if (node instanceof GCQLNotNode) {
            return this.processNode((GCQLNotNode)node, not);
        }
        if (node instanceof GCQLOrNode) {
            return this.processNode((GCQLOrNode)node, not);
        }
        if (node instanceof GCQLTermNode) {
            return this.processNode((GCQLTermNode)node, not);
        }
        throw new Exception("This node class is not supported: " + node.getClass().toString());
    }

    private GeoGcqlQueryContainer processNode(GCQLProjectNode node, boolean not) throws Exception {
        Vector projections = node.getProjectIndexes();
        for (ModifierSet projection : projections) {
            if (projection.getBase().equals("*")) {
                this.projectedFields.clear();
                return this.processNode(node.subtree, false);
            }
            String fieldLabel = this.adaptor.getFieldNameById(projection.getBase());
            String projField = this.findPresentable(fieldLabel);
            if (projField == null) {
                logger.error((Object)(fieldLabel + ", " + projection.getBase() + " is not a presentable field"));
                continue;
            }
            this.projectedFields.put(projection.getBase(), projField);
        }
        GeoGcqlQueryContainer result = this.processNode(node.subtree, false);
        result.setProjectedFields(this.projectedFields);
        return result;
    }

    private GeoGcqlQueryContainer processNode(GCQLTermNode node, boolean not) throws Exception {
        logger.debug((Object)("Term node - not: " + not));
        GeoGcqlQueryContainer result = new GeoGcqlQueryContainer(null);
        boolean found = false;
        for (RTreeWrapper.SupportedRelations relation : RTreeWrapper.SupportedRelations.values()) {
            if (!node.getRelation().getBase().equalsIgnoreCase(relation.toString())) continue;
            switch (relation) {
                case geosearch: {
                    ArrayList<RefinementRequest> refiners = new ArrayList<RefinementRequest>();
                    RankingRequest ranker = null;
                    InclusionType inclusion = null;
                    ArrayList<Point> vertices = new ArrayList<Point>();
                    String[] coords = GeoGcqlProcessor.splitTerms(node.getTerm());
                    if (coords.length < 8) {
                        logger.error((Object)("the term of geosearch must have at least 8 doubles, while this argument was provided: " + node.getTerm()));
                        throw new Exception("the term of geosearch must have at least 8 doubles, while this argument was provided: " + node.getTerm());
                    }
                    try {
                        for (int i = 0; i < coords.length; i += 2) {
                            Point p = new Point(new Double(Double.parseDouble(coords[i]) * Math.pow(10.0, this.getNumberOfDecimals().intValue())).longValue(), new Double(Double.parseDouble(coords[i + 1]) * Math.pow(10.0, this.getNumberOfDecimals().intValue())).longValue());
                            vertices.add(p);
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("Bad syntax for term of the geosearch relation: " + node.getTerm()), (Throwable)e);
                        throw new Exception("Bad syntax for term of the geosearch relation: " + node.getTerm(), e);
                    }
                    Polygon polygon = new Polygon(vertices);
                    String colID = null;
                    String lang = null;
                    block21: for (Modifier modifier : node.getRelation().getModifiers()) {
                        for (RTreeWrapper.GeoSearchModifiers geoMod : RTreeWrapper.GeoSearchModifiers.values()) {
                            if (!modifier.getType().equalsIgnoreCase(geoMod.toString())) continue;
                            String[] args = null;
                            String id = null;
                            ArrayList<String> arguments = null;
                            boolean rev = false;
                            switch (geoMod) {
                                case inclusion: {
                                    if (inclusion != null) {
                                        logger.warn((Object)"only one inclusion must be specified in a geosearch relation");
                                        break;
                                    }
                                    args = GeoGcqlProcessor.splitTerms(modifier.getValue());
                                    if (args.length > 1) {
                                        logger.error((Object)("The inclusion modifier must have 0 | 1 | 2, while the argument provided was: " + modifier.getValue()));
                                        throw new Exception("The inclusion modifier must have 0 | 1 | 2, while the argument provided was: " + modifier.getValue());
                                    }
                                    int inc = 0;
                                    try {
                                        inc = Integer.parseInt(args[0]);
                                    }
                                    catch (NumberFormatException e) {
                                        logger.error((Object)("The inclusion modifier must have 0 | 1 | 2, while the argument provided was: " + modifier.getValue()), (Throwable)e);
                                        throw new Exception("The inclusion modifier must have 0 | 1 | 2, while the argument provided was: " + modifier.getValue(), e);
                                    }
                                    if (inc == 0) {
                                        inclusion = InclusionType.intersect;
                                        break;
                                    }
                                    if (inc == 1) {
                                        inclusion = InclusionType.contains;
                                        break;
                                    }
                                    if (inc != 2) continue block21;
                                    inclusion = InclusionType.inside;
                                    break;
                                }
                                case colID: {
                                    if (colID != null) {
                                        logger.warn((Object)"only one colID must be specified in a geosearch relation");
                                        break;
                                    }
                                    args = GeoGcqlProcessor.splitTerms(modifier.getValue());
                                    if (args.length > 1) {
                                        logger.error((Object)("The colID modifier must be a single string, while the argument provided was: " + modifier.getValue()));
                                        throw new Exception("The colID modifier must be a single string, while the argument provided was: " + modifier.getValue());
                                    }
                                    colID = args[0];
                                    break;
                                }
                                case lang: {
                                    if (lang != null) {
                                        logger.warn((Object)"only one lang must be specified in a geosearch relation");
                                        break;
                                    }
                                    args = GeoGcqlProcessor.splitTerms(modifier.getValue());
                                    if (args.length > 1) {
                                        logger.error((Object)("The lang modifier must be a single string, while the argument provided was: " + modifier.getValue()));
                                        throw new Exception("The lang modifier must be a single string, while the argument provided was: " + modifier.getValue());
                                    }
                                    lang = args[0];
                                    break;
                                }
                                case not: {
                                    not = !not;
                                    break;
                                }
                                case ranker: {
                                    int i;
                                    if (ranker != null) {
                                        logger.warn((Object)"only one ranker modifier must be specified in a geosearch relation");
                                        break;
                                    }
                                    args = GeoGcqlProcessor.splitTerms(modifier.getValue());
                                    if (args.length < 1) {
                                        logger.error((Object)("invalid ranker modifier: " + modifier.getValue()));
                                        break;
                                    }
                                    id = null;
                                    arguments = new ArrayList();
                                    rev = false;
                                    try {
                                        id = args[0];
                                        rev = Boolean.parseBoolean(args[1]);
                                        for (i = 2; i < args.length; ++i) {
                                            arguments.add(args[i]);
                                        }
                                    }
                                    catch (Exception e) {
                                        logger.error((Object)("invalid ranker modifier: " + modifier.getValue()), (Throwable)e);
                                        throw new Exception("invalid ranker modifier: " + modifier.getValue(), e);
                                    }
                                    ranker = new RankingRequest(id, arguments.toArray(new String[arguments.size()]), rev);
                                    break;
                                }
                                case refiner: {
                                    int i;
                                    args = GeoGcqlProcessor.splitTerms(modifier.getValue());
                                    if (args.length < 1) {
                                        logger.error((Object)("invalid refiner modifier: " + modifier.getValue()));
                                        break;
                                    }
                                    id = null;
                                    arguments = new ArrayList<String>();
                                    try {
                                        id = args[0];
                                        for (i = 1; i < args.length; ++i) {
                                            arguments.add(args[i]);
                                        }
                                    }
                                    catch (Exception e) {
                                        logger.error((Object)("invalid refiner modifier: " + modifier.getValue()), (Throwable)e);
                                        throw new Exception("invalid refiner modifier: " + modifier.getValue(), e);
                                    }
                                    refiners.add(new RefinementRequest(polygon, id, arguments.toArray(new String[arguments.size()]), null, false));
                                    break;
                                }
                                default: {
                                    logger.error((Object)("Unsupported modifier: " + modifier.getValue()));
                                    break;
                                }
                            }
                            continue block21;
                        }
                    }
                    if (inclusion == null) {
                        logger.warn((Object)"the modifier for inclusion is missing in geosearch relation");
                        inclusion = InclusionType.intersect;
                    }
                    for (RefinementRequest req : refiners) {
                        req.setInclusion(inclusion);
                    }
                    if (colID != null && lang != null) {
                        GeoGcqlCollectionQuery colQuery = new GeoGcqlCollectionQuery(inclusion, polygon, refiners, ranker, not);
                        ArrayList<GeoGcqlCollectionQuery> queries = new ArrayList<GeoGcqlCollectionQuery>();
                        queries.add(colQuery);
                        HashMap<String, ArrayList<GeoGcqlCollectionQuery>> langMap = new HashMap<String, ArrayList<GeoGcqlCollectionQuery>>();
                        langMap.put(lang, queries);
                        result.queries.put(colID, langMap);
                        logger.debug((Object)("ColID: " + colID + " - Lang: " + lang + " - Query: " + colQuery.toString()));
                    } else if (colID != null && lang == null) {
                        ArrayList<String> langs = this.colLangPairs.get(colID);
                        if (langs == null) {
                            logger.error((Object)("This collection is not indexed in this geo Index resource: " + colID));
                            throw new Exception("This collection is not indexed in this geo Index resource: " + colID);
                        }
                        HashMap langMap = new HashMap();
                        for (String l : langs) {
                            GeoGcqlCollectionQuery colQuery = new GeoGcqlCollectionQuery(inclusion, polygon, refiners, ranker, not);
                            ArrayList<GeoGcqlCollectionQuery> queries = new ArrayList<GeoGcqlCollectionQuery>();
                            queries.add(colQuery);
                            langMap.put(l, queries);
                            logger.debug((Object)("ColID: " + colID + " - Lang: " + l + " - Query: " + colQuery.toString()));
                        }
                        result.queries.put(colID, langMap);
                    } else if (colID == null && lang == null) {
                        for (Map.Entry<String, ArrayList<String>> current : this.colLangPairs.entrySet()) {
                            String id = current.getKey();
                            ArrayList<String> langs = current.getValue();
                            HashMap langMap = new HashMap();
                            for (String l : langs) {
                                GeoGcqlCollectionQuery colQuery = new GeoGcqlCollectionQuery(inclusion, polygon, refiners, ranker, not);
                                ArrayList<GeoGcqlCollectionQuery> queries = new ArrayList<GeoGcqlCollectionQuery>();
                                queries.add(colQuery);
                                langMap.put(l, queries);
                                logger.debug((Object)("ColID: " + id + " - Lang: " + l + " - Query: " + colQuery.toString()));
                            }
                            result.queries.put(id, langMap);
                        }
                    } else {
                        logger.error((Object)"While a language is specified, a collection is not");
                        throw new Exception("While a language is specified, a collection is not");
                    }
                    found = true;
                    break;
                }
                default: {
                    logger.error((Object)("Bug! should not reach this point, since this relation is not supported: " + (Object)((Object)relation)));
                    throw new Exception("Bug! should not reach this point, since this relation is not supported: " + (Object)((Object)relation));
                }
            }
            break;
        }
        if (!found) {
            logger.error((Object)("This relation is not supported: " + node.getRelation().getBase()));
            throw new Exception("This relation is not supported: " + node.getRelation().getBase());
        }
        return result;
    }

    private GeoGcqlQueryContainer processNode(GCQLAndNode node, boolean not) throws Exception {
        GeoGcqlQueryContainer cont1 = this.processNode(node.left, not);
        GeoGcqlQueryContainer cont2 = this.processNode(node.right, not);
        logger.debug((Object)("And node - not: " + not));
        this.logNumberOfConditions(cont1);
        this.logNumberOfConditions(cont2);
        GeoGcqlQueryContainer result = new GeoGcqlQueryContainer(null);
        if (!not) {
            this.mergeQueries(cont1, cont2, result);
        } else {
            this.concatQueries(cont1, cont2, result);
        }
        return result;
    }

    private GeoGcqlQueryContainer processNode(GCQLOrNode node, boolean not) throws Exception {
        GeoGcqlQueryContainer cont1 = this.processNode(node.left, not);
        GeoGcqlQueryContainer cont2 = this.processNode(node.right, not);
        logger.debug((Object)("Or node - not: " + not));
        this.logNumberOfConditions(cont1);
        this.logNumberOfConditions(cont2);
        GeoGcqlQueryContainer result = new GeoGcqlQueryContainer(null);
        if (!not) {
            this.concatQueries(cont1, cont2, result);
        } else {
            this.mergeQueries(cont1, cont2, result);
        }
        return result;
    }

    private void concatQueries(GeoGcqlQueryContainer cont1, GeoGcqlQueryContainer cont2, GeoGcqlQueryContainer result) {
        result.queries = cont1.queries;
        for (Map.Entry<String, HashMap<String, ArrayList<GeoGcqlCollectionQuery>>> current : cont2.queries.entrySet()) {
            String colID = current.getKey();
            HashMap<String, ArrayList<GeoGcqlCollectionQuery>> outerLangMap = result.queries.get(colID);
            if (outerLangMap == null) {
                outerLangMap = new HashMap();
                result.queries.put(colID, outerLangMap);
            }
            for (Map.Entry<String, ArrayList<GeoGcqlCollectionQuery>> currentQueries : current.getValue().entrySet()) {
                String lang = currentQueries.getKey();
                ArrayList<GeoGcqlCollectionQuery> queryList = currentQueries.getValue();
                if (queryList == null) continue;
                ArrayList<GeoGcqlCollectionQuery> outerQueryList = outerLangMap.get(lang);
                if (outerQueryList == null) {
                    outerQueryList = new ArrayList();
                    outerLangMap.put(lang, outerQueryList);
                }
                outerQueryList.addAll(queryList);
            }
        }
    }

    private GeoGcqlQueryContainer processNode(GCQLNotNode node, boolean not) throws Exception {
        GeoGcqlQueryContainer cont1 = this.processNode(node.left, not);
        GeoGcqlQueryContainer cont2 = this.processNode(node.right, !not);
        logger.debug((Object)("Not node - not: " + not));
        this.logNumberOfConditions(cont1);
        this.logNumberOfConditions(cont2);
        GeoGcqlQueryContainer result = new GeoGcqlQueryContainer(null);
        if (!not) {
            this.mergeQueries(cont1, cont2, result);
        } else {
            this.concatQueries(cont1, cont2, result);
        }
        return result;
    }

    private void mergeQueries(GeoGcqlQueryContainer cont1, GeoGcqlQueryContainer cont2, GeoGcqlQueryContainer result) {
        for (Map.Entry<String, HashMap<String, ArrayList<GeoGcqlCollectionQuery>>> outerColEntry : cont1.queries.entrySet()) {
            String colID = outerColEntry.getKey();
            for (Map.Entry<String, ArrayList<GeoGcqlCollectionQuery>> outerLangEntry : outerColEntry.getValue().entrySet()) {
                ArrayList<GeoGcqlCollectionQuery> innerQuerySet;
                HashMap<String, ArrayList<GeoGcqlCollectionQuery>> inner;
                String lang = outerLangEntry.getKey();
                ArrayList<GeoGcqlCollectionQuery> outerQuerySet = outerLangEntry.getValue();
                if (outerQuerySet == null || outerQuerySet.size() == 0 || (inner = cont2.queries.get(colID)) == null || (innerQuerySet = inner.get(lang)) == null || innerQuerySet.size() == 0) continue;
                ArrayList<GeoGcqlCollectionQuery> newQuerySet = new ArrayList<GeoGcqlCollectionQuery>();
                for (GeoGcqlCollectionQuery outerQuery : outerQuerySet) {
                    for (GeoGcqlCollectionQuery innerQuery : innerQuerySet) {
                        GeoGcqlCollectionQuery newQuery = this.mergeCollectionQueries(outerQuery, innerQuery);
                        if (newQuery == null) continue;
                        newQuerySet.add(newQuery);
                    }
                }
                if (newQuerySet.size() <= 0) continue;
                HashMap<String, ArrayList<GeoGcqlCollectionQuery>> langQueries = result.queries.get(colID);
                if (langQueries == null) {
                    langQueries = new HashMap();
                }
                langQueries.put(lang, newQuerySet);
                result.queries.put(colID, langQueries);
            }
        }
    }

    private GeoGcqlCollectionQuery mergeCollectionQueries(GeoGcqlCollectionQuery outerQuery, GeoGcqlCollectionQuery innerQuery) {
        boolean not = innerQuery.isNot();
        if (!not) {
            if (outerQuery.getInclusion().equals((Object)InclusionType.contains) && innerQuery.getInclusion().equals((Object)InclusionType.contains)) {
                RankingRequest newRankReq;
                Polygon newPoly = PolygonProcessing.intersection(outerQuery.getSearchPolygon(), innerQuery.getSearchPolygon());
                if (newPoly == null) {
                    return null;
                }
                ArrayList<RefinementRequest> newRefReq = outerQuery.getRefineRequests();
                if (newRefReq == null) {
                    newRefReq = new ArrayList();
                }
                if (innerQuery.getRefineRequests() != null) {
                    newRefReq.addAll(innerQuery.getRefineRequests());
                }
                if ((newRankReq = outerQuery.getRankRequest()) == null) {
                    newRankReq = innerQuery.getRankRequest();
                } else if (innerQuery.getRankRequest() != null) {
                    logger.warn((Object)"Two rankers for the same collection query were found. The first one will be used");
                }
                return new GeoGcqlCollectionQuery(InclusionType.contains, newPoly, newRefReq, newRankReq, false);
            }
            if (outerQuery.getInclusion().equals((Object)InclusionType.inside) && innerQuery.getInclusion().equals((Object)InclusionType.inside)) {
                RankingRequest newRankReq;
                Polygon newPoly = PolygonProcessing.intersection(outerQuery.getSearchPolygon(), innerQuery.getSearchPolygon());
                ArrayList<RefinementRequest> newRefReq = new ArrayList<RefinementRequest>();
                if (newPoly == null) {
                    newPoly = outerQuery.getSearchPolygon();
                    newRefReq.add(new RefinementRequest(innerQuery.getSearchPolygon(), POLYGON_REFINER, null, InclusionType.inside, not));
                } else {
                    newPoly = PolygonProcessing.union(outerQuery.getSearchPolygon(), innerQuery.getSearchPolygon());
                }
                if (outerQuery.getRefineRequests() != null) {
                    newRefReq.addAll(outerQuery.getRefineRequests());
                }
                if (innerQuery.getRefineRequests() != null) {
                    newRefReq.addAll(innerQuery.getRefineRequests());
                }
                if ((newRankReq = outerQuery.getRankRequest()) == null) {
                    newRankReq = innerQuery.getRankRequest();
                } else if (innerQuery.getRankRequest() != null) {
                    logger.warn((Object)"Two rankers for the same collection query were found. The first one will be used");
                }
                return new GeoGcqlCollectionQuery(InclusionType.inside, newPoly, newRefReq, newRankReq, false);
            }
            if (outerQuery.getInclusion().equals((Object)InclusionType.contains) && innerQuery.getInclusion().equals((Object)InclusionType.inside) || outerQuery.getInclusion().equals((Object)InclusionType.inside) && innerQuery.getInclusion().equals((Object)InclusionType.contains)) {
                GeoGcqlCollectionQuery insideQuery = null;
                GeoGcqlCollectionQuery containsQuery = null;
                if (innerQuery.getInclusion().equals((Object)InclusionType.inside)) {
                    insideQuery = innerQuery;
                    containsQuery = outerQuery;
                } else {
                    insideQuery = outerQuery;
                    containsQuery = innerQuery;
                }
                if (!PolygonProcessing.isContained(insideQuery.getSearchPolygon(), containsQuery.getSearchPolygon())) {
                    return null;
                }
            }
            if ((outerQuery.getInclusion().equals((Object)InclusionType.contains) && innerQuery.getInclusion().equals((Object)InclusionType.intersect) || outerQuery.getInclusion().equals((Object)InclusionType.intersect) && innerQuery.getInclusion().equals((Object)InclusionType.contains)) && !PolygonProcessing.overlaps(innerQuery.getSearchPolygon(), outerQuery.getSearchPolygon())) {
                return null;
            }
            return this.newQueryWithAddedRefiner(innerQuery, outerQuery);
        }
        if (outerQuery.getInclusion().equals((Object)InclusionType.contains) && innerQuery.getInclusion().equals((Object)InclusionType.contains) && PolygonProcessing.isContained(outerQuery.getSearchPolygon(), innerQuery.getSearchPolygon())) {
            return null;
        }
        if (outerQuery.getInclusion().equals((Object)InclusionType.inside) && innerQuery.getInclusion().equals((Object)InclusionType.inside) && PolygonProcessing.isContained(innerQuery.getSearchPolygon(), outerQuery.getSearchPolygon())) {
            return null;
        }
        if (outerQuery.getInclusion().equals((Object)InclusionType.intersect) && innerQuery.getInclusion().equals((Object)InclusionType.intersect) && PolygonProcessing.isContained(outerQuery.getSearchPolygon(), innerQuery.getSearchPolygon())) {
            return null;
        }
        return this.newQueryWithAddedRefiner(innerQuery, outerQuery);
    }

    private GeoGcqlCollectionQuery newQueryWithAddedRefiner(GeoGcqlCollectionQuery innerQuery, GeoGcqlCollectionQuery outerQuery) {
        RankingRequest newRankReq;
        boolean not = innerQuery.isNot();
        ArrayList<RefinementRequest> newRefReq = new ArrayList<RefinementRequest>();
        newRefReq.add(new RefinementRequest(innerQuery.getSearchPolygon(), POLYGON_REFINER, null, innerQuery.getInclusion(), not));
        if (outerQuery.getRefineRequests() != null) {
            newRefReq.addAll(outerQuery.getRefineRequests());
        }
        if (not && innerQuery.getRefineRequests() != null) {
            for (RefinementRequest req : innerQuery.getRefineRequests()) {
                req.revertNot();
            }
        }
        if (innerQuery.getRefineRequests() != null) {
            newRefReq.addAll(innerQuery.getRefineRequests());
        }
        if ((newRankReq = outerQuery.getRankRequest()) == null) {
            newRankReq = innerQuery.getRankRequest();
        } else if (innerQuery.getRankRequest() != null) {
            logger.warn((Object)"Two rankers for the same collection query were found. The first one will be used");
        }
        return new GeoGcqlCollectionQuery(outerQuery.getInclusion(), outerQuery.getSearchPolygon(), newRefReq, newRankReq, false);
    }

    private void logNumberOfConditions(GeoGcqlQueryContainer queryContainer) {
        for (Map.Entry<String, HashMap<String, ArrayList<GeoGcqlCollectionQuery>>> currentColEntry : queryContainer.queries.entrySet()) {
            logger.debug((Object)(" Collection: " + currentColEntry.getKey()));
            for (Map.Entry<String, ArrayList<GeoGcqlCollectionQuery>> langEntries : currentColEntry.getValue().entrySet()) {
                logger.debug((Object)(" Language: " + langEntries.getKey()));
                logger.debug((Object)("Number of queries: " + langEntries.getValue().size()));
            }
        }
    }
}

