/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.common.discover;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.rest.index.common.discover.IndexDiscovererAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexDiscoverer
implements IndexDiscovererAPI {
    private static final Logger logger = LoggerFactory.getLogger(IndexDiscoverer.class);

    @Override
    public Set<String> discoverFulltextIndexNodes(String scope) {
        ScopeProvider.instance.set(scope);
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/Profile/ServiceClass/text() eq 'Index'").addCondition("$resource/Profile/ServiceName/text() eq 'FullTextIndexNode'");
        DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
        List eprs = client.submit((Query)query);
        HashSet<String> clusterHosts = new HashSet<String>();
        for (GCoreEndpoint epr : eprs) {
            if (!epr.scopes().contains((Object)scope) || !"ready".equals(epr.profile().deploymentData().status().toLowerCase())) continue;
            for (GCoreEndpoint.Profile.Endpoint e : epr.profile().endpointMap().values().toArray(new GCoreEndpoint.Profile.Endpoint[epr.profile().endpointMap().values().size()])) {
                if (e.uri().toString().endsWith("/gcube/resource")) continue;
                clusterHosts.add(e.uri().toString());
            }
        }
        logger.info("Discovered index cluster nodes: " + Arrays.toString(clusterHosts.toArray()));
        return clusterHosts;
    }
}

