/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.geoindexupdater;

import java.util.Calendar;
import java.util.concurrent.FutureTask;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.geoindexupdater.GeoIndexUpdaterResource;
import org.gcube.indexmanagement.geoindexupdater.InitThread;
import org.gcube.indexmanagement.geoindexupdater.StatefulContext;
import org.gcube.indexmanagement.geoindexupdater.stubs.Add;
import org.gcube.indexmanagement.geoindexupdater.stubs.AddEnvelope;
import org.gcube.indexmanagement.geoindexupdater.stubs.Process;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;

public class GeoIndexUpdaterService {
    static GCUBELog logger = new GCUBELog(GeoIndexUpdaterService.class);

    public GeoIndexUpdaterService() {
        logger.debug((Object)"GeoIndexService constructed");
    }

    public VOID add(Add add) throws GCUBEFault {
        try {
            GeoIndexUpdaterResource geoIndexResource = this.getResource();
            AddEnvelope[] envelopes = add.getValue();
            geoIndexResource.add(envelopes);
            geoIndexResource.setModified(Calendar.getInstance());
        }
        catch (Exception e) {
            throw new GCUBEUnrecoverableFault(new String[]{"Adding the envelope failed:" + e.getMessage()});
        }
        return new VOID();
    }

    public VOID process(Process arguments) throws GCUBEFault {
        try {
            String rsLocation = arguments.getResultSetLocation();
            boolean destroyAfterUpdate = arguments.getDestroyAfterUpdate() != null && arguments.getDestroyAfterUpdate() != false;
            return this.process(rsLocation, destroyAfterUpdate);
        }
        catch (Exception e) {
            logger.error((Object)"unable to insert rowset", (Throwable)e);
            throw new GCUBEFault(new String[]{"Darn, error while inserting rowset: " + e.toString()});
        }
    }

    private VOID process(String resultSetLocation, boolean destroyAfterUpdate) throws GCUBEFault {
        try {
            GeoIndexUpdaterResource geoUpdaterResource = this.getResource();
            FutureTask<Boolean> updateTask = geoUpdaterResource.processResultSet(resultSetLocation);
            if (destroyAfterUpdate) {
                this.selfDestructAfterUpdate(updateTask, geoUpdaterResource);
            }
            geoUpdaterResource.setModified(Calendar.getInstance());
            return new VOID();
        }
        catch (Exception e) {
            logger.error((Object)"unable to insert rowset", (Throwable)e);
            throw new GCUBEFault(new String[]{"Darn, error while inserting rowset: " + e.toString()});
        }
    }

    private void selfDestructAfterUpdate(final FutureTask<Boolean> rsConsumer, final GeoIndexUpdaterResource resource) {
        Thread destroyerThread = new Thread(){

            @Override
            public void run() {
                boolean doRemoval;
                try {
                    boolean success = (Boolean)rsConsumer.get();
                    if (success) {
                        logger.info((Object)"The update successfully finished. The updater will now be removed.");
                        doRemoval = true;
                    } else {
                        logger.info((Object)"The update was aborted due to updater removal. Additional removal task will not be performed.");
                        doRemoval = false;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"The update was aborted due to an exception. The updater will now be removed.", (Throwable)e);
                    doRemoval = true;
                }
                if (doRemoval) {
                    GCUBEWSResourceKey key = resource.getKey();
                    try {
                        StatefulContext.getPortTypeContext().getWSHome().remove((ResourceKey)key);
                        logger.info((Object)("The updater [" + key + "] was successfully destroyed."));
                    }
                    catch (Exception e) {
                        logger.error((Object)("Unable to destroy the updater [" + key + "] after finished update."), (Throwable)e);
                    }
                }
            }
        };
        try {
            InitThread.init(destroyerThread);
        }
        catch (Exception e) {
            logger.error((Object)"Could not initialize the new thread.", (Throwable)e);
        }
        destroyerThread.start();
    }

    private GeoIndexUpdaterResource getResource() throws ResourceException {
        return (GeoIndexUpdaterResource)StatefulContext.getPortTypeContext().getWSHome().find();
    }
}

