/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.geoindexupdater;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.StringField;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.common.DateParser;
import org.gcube.indexmanagement.common.IndexType;
import org.gcube.indexmanagement.common.IndexUpdaterWSResource;
import org.gcube.indexmanagement.common.XMLProfileParser;
import org.gcube.indexmanagement.common.XMLTokenReplacer;
import org.gcube.indexmanagement.geo.GeoIndexField;
import org.gcube.indexmanagement.geo.GeoIndexType;
import org.gcube.indexmanagement.geoindexmanagement.stubs.GeoIndexManagementPortType;
import org.gcube.indexmanagement.geoindexmanagement.stubs.StringArray;
import org.gcube.indexmanagement.geoindexmanagement.stubs.service.GeoIndexManagementServiceAddressingLocator;
import org.gcube.indexmanagement.geoindexupdater.GeoIndexUpdaterFactoryService;
import org.gcube.indexmanagement.geoindexupdater.ServiceContext;
import org.gcube.indexmanagement.geoindexupdater.StatefulContext;
import org.gcube.indexmanagement.geoindexupdater.stubs.AddEnvelope;
import org.gcube.indexmanagement.storagehandling.DeltaFileUploader;
import org.w3c.dom.Element;

public class GeoIndexUpdaterResource
extends IndexUpdaterWSResource {
    static GCUBELog logger = new GCUBELog(GeoIndexUpdaterResource.class);
    private DeltaFileUploader deltaUploader;
    private GeoIndexType indexTypeObject = null;
    private int numOfDeci;
    private String deltaPath;
    private File currentDeltaFile;
    private int deltaFileDocCount = 0;
    private int fileCount = 0;
    private ExecutorService threadPool;
    public static final String RP_GEOGRAPHICAL_SYSTEM = "GeographicalSystem";
    public static final String RP_UNIT_OF_MEASUREMENT = "UnitOfMeasurement";
    public static final String RP_NUMBER_OF_DECIMALS = "NumberOfDecimals";
    protected static final int MAX_ATTEMPTS = 10;
    protected static final long WAIT_PERIOD = 2000L;
    protected static final long RSTIMEOUT = 10L;
    protected static final String ROWSETFIELD = "Rowset";
    protected static String[] RPNames = new String[]{"GeographicalSystem", "UnitOfMeasurement", "NumberOfDecimals"};
    private GCUBEWSResourceKey key;

    public GCUBEWSResourceKey getKey() {
        return this.key;
    }

    public void initialise(Object ... args) throws Exception {
        this.setIsInitializing(true);
        super.initialize(StatefulContext.getPortTypeContext().getNamespace(), "http://gcube-system.org/namespaces/indexmanagement/GeoIndexManagementService", (String)args[1], (String)args[2], new String[0]);
        this.threadPool = Executors.newCachedThreadPool();
        this.key = (GCUBEWSResourceKey)args[0];
        String indexID = (String)args[1];
        this.deltaUploader = new DeltaFileUploader(indexID, (IndexUpdaterWSResource)this, (GCUBEServiceContext)ServiceContext.getContext());
        try {
            for (String rpName : RPNames) {
                this.createProperty(rpName);
            }
            this.setGeographicalSystem((String)args[3]);
            this.setUnitOfMeasurement((String)args[4]);
            Integer numberOfDecimals = (Integer)args[5];
            this.setNumberOfDecimals(numberOfDecimals);
            this.numOfDeci = numberOfDecimals >= 0 ? numberOfDecimals : 0;
            this.setConnectionID(String.valueOf(this.deltaUploader.getConnectionID()));
            this.setIndexTypeName((String)args[2]);
        }
        catch (Exception e) {
            logger.error((Object)"Error during resource initialization.", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        this.deltaPath = ServiceContext.getContext().getPersistenceRoot().getAbsolutePath() + "/delta/";
        this.currentDeltaFile = this.createNewDeltaFile();
        this.setIsInitializing(false);
    }

    public String getGeographicalSystem() {
        return (String)this.getResourcePropertySet().get(RP_GEOGRAPHICAL_SYSTEM).get(0);
    }

    public String getUnitOfMeasurement() {
        return (String)this.getResourcePropertySet().get(RP_UNIT_OF_MEASUREMENT).get(0);
    }

    public Integer getNumberOfDecimals() {
        return (Integer)this.getResourcePropertySet().get(RP_NUMBER_OF_DECIMALS).get(0);
    }

    public synchronized void setGeographicalSystem(String geographicalSystem) {
        this.getResourcePropertySet().get(RP_GEOGRAPHICAL_SYSTEM).clear();
        this.getResourcePropertySet().get(RP_GEOGRAPHICAL_SYSTEM).add((Object)geographicalSystem);
    }

    public synchronized void setUnitOfMeasurement(String unitOfMeasurement) {
        this.getResourcePropertySet().get(RP_UNIT_OF_MEASUREMENT).clear();
        this.getResourcePropertySet().get(RP_UNIT_OF_MEASUREMENT).add((Object)unitOfMeasurement);
    }

    public synchronized void setNumberOfDecimals(Integer numberOfDecimals) {
        this.getResourcePropertySet().get(RP_NUMBER_OF_DECIMALS).clear();
        this.getResourcePropertySet().get(RP_NUMBER_OF_DECIMALS).add((Object)numberOfDecimals);
    }

    public void setIndexTypeName(String indexTypeName) throws Exception {
        super.setIndexTypeName(indexTypeName);
        this.indexTypeObject = new GeoIndexType(indexTypeName, ServiceContext.getContext().getScope());
    }

    public void add(AddEnvelope[] envelopes) throws Exception {
        FileChannel outChannel = new FileOutputStream(this.currentDeltaFile, true).getChannel();
        for (int i = 0; i < envelopes.length; ++i) {
            if (this.isDeltaComplete()) {
                outChannel.close();
                this.closeCurrentDeltaFile();
                outChannel = new FileOutputStream(this.currentDeltaFile).getChannel();
            }
            this.addToDeltaFile(envelopes[i].getData(), envelopes[i].getX1(), envelopes[i].getX2(), envelopes[i].getY1(), envelopes[i].getY2(), envelopes[i].getTime(), outChannel);
        }
        outChannel.close();
        this.deltaUploader.upload(this.currentDeltaFile.getAbsolutePath(), this.getIndexTypeName(), envelopes.length);
        this.currentDeltaFile = this.createNewDeltaFile();
    }

    private File createNewDeltaFile() throws Exception {
        File deltaFile;
        File directory = new File(this.deltaPath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        do {
            String deltaFileName = this.deltaPath + this.key.getValue().toString() + this.fileCount;
            deltaFile = new File(deltaFileName);
            ++this.fileCount;
        } while (deltaFile.exists());
        deltaFile.createNewFile();
        return deltaFile;
    }

    public FutureTask<Boolean> processResultSet(final String resultSetLocation) throws RemoteException {
        try {
            logger.debug((Object)("Starting processing of resultset: " + resultSetLocation));
            FutureTask<Boolean> rsConsumer = new FutureTask<Boolean>(new IndexUpdaterThread<Boolean>(ServiceContext.getContext().getScope(), ServiceContext.getContext().getCallerCredentials()){

                @Override
                public Boolean doUpdate() throws Exception {
                    try {
                        GeoIndexUpdaterResource.this.setIndexStatus("UPDATING");
                        ForwardReader reader = new ForwardReader(new URI(resultSetLocation));
                        int pageCount = 1;
                        int RowSetCount = 0;
                        int maxFail = 10;
                        boolean hasMoreParts = false;
                        List<EndpointReferenceType> mgmtEprs = null;
                        for (int attempts = 0; (mgmtEprs == null || mgmtEprs.size() == 0) && attempts < 10; ++attempts) {
                            try {
                                LinkedList<String[]> props = new LinkedList<String[]>();
                                props.add(new String[]{"IndexID", GeoIndexUpdaterResource.this.getIndexID()});
                                mgmtEprs = GeoIndexUpdaterFactoryService.getWSResourceEPRsFromPropValuesAndNamespace(props, "http://gcube-system.org/namespaces/indexmanagement/GeoIndexManagementService", ServiceContext.getContext().getScope());
                            }
                            catch (Exception e) {
                                logger.error((Object)("Failed to query the IS for index management resources with IndexID = " + GeoIndexUpdaterResource.this.getIndexID()), (Throwable)e);
                                return false;
                            }
                            if (mgmtEprs != null && mgmtEprs.size() > 0) break;
                            Thread.sleep(2000L);
                        }
                        if (mgmtEprs == null || mgmtEprs.size() == 0) {
                            logger.error((Object)("Failed to find a Manager for IndexID = " + GeoIndexUpdaterResource.this.getIndexID()));
                            return false;
                        }
                        GeoIndexManagementServiceAddressingLocator IndexManagementInstanceLocator = new GeoIndexManagementServiceAddressingLocator();
                        GeoIndexManagementPortType IndexManagementInstance = null;
                        try {
                            IndexManagementInstance = IndexManagementInstanceLocator.getGeoIndexManagementPortTypePort((EndpointReferenceType)mgmtEprs.get(0));
                            IndexManagementInstance = (GeoIndexManagementPortType)GCUBERemotePortTypeContext.getProxy((Remote)IndexManagementInstance, (GCUBEScope)ServiceContext.getContext().getScope(), (GCUBESecurityManager[])new GCUBESecurityManager[]{ServiceContext.getContext()});
                        }
                        catch (Exception e) {
                            logger.error((Object)"Unable to get the portType for the Manager.", (Throwable)e);
                            return false;
                        }
                        logger.info((Object)"Starting to retrieve results:");
                        while (true) {
                            Record result;
                            int counter = 0;
                            while (true) {
                                try {
                                    result = reader.get(10L, TimeUnit.SECONDS);
                                }
                                catch (Exception e) {
                                    if (counter++ <= maxFail) {
                                        logger.error((Object)(GeoIndexUpdaterResource.this.getIndexID() + " get: failed for the " + counter + ". time."), (Throwable)e);
                                        Thread.yield();
                                        if (Thread.currentThread().isInterrupted()) {
                                            logger.debug((Object)"RS processor thread cancelled.");
                                            return false;
                                        }
                                        try {
                                            Thread.sleep(1000L);
                                        }
                                        catch (InterruptedException ie) {
                                            logger.debug((Object)"RS processor thread cancelled while waiting");
                                            return false;
                                        }
                                        continue;
                                    }
                                    logger.error((Object)(GeoIndexUpdaterResource.this.getIndexID() + " RS get giving up. FAILED!"), (Throwable)e);
                                    throw e;
                                }
                                break;
                            }
                            try {
                                if (result == null && (reader.getStatus() == IBuffer.Status.Dispose || reader.getStatus() == IBuffer.Status.Close && reader.availableRecords() == 0)) break;
                                if (result == null) continue;
                                Thread.yield();
                                if (Thread.currentThread().isInterrupted()) {
                                    logger.debug((Object)"RS processor thread cancelled while reading results.");
                                    return false;
                                }
                                String rowset = ((StringField)result.getField(GeoIndexUpdaterResource.ROWSETFIELD)).getPayload();
                                String lang = GeoIndexUpdaterResource.this.getLangRowset(rowset);
                                String colID = GeoIndexUpdaterResource.this.getColIDRowset(rowset);
                                GeoIndexUpdaterResource.this.deltaFileDocCount += GeoIndexUpdaterResource.this.addToDeltaFile(colID, lang, rowset, IndexManagementInstance);
                                logger.debug((Object)(GeoIndexUpdaterResource.this.getIndexID() + " Part#: " + pageCount++ + "RowSet count: " + ++RowSetCount + " DeltaFileCount: " + GeoIndexUpdaterResource.this.deltaFileDocCount));
                            }
                            catch (Exception e) {
                                logger.error((Object)("Unable to index: " + GeoIndexUpdaterResource.this.getIndexID() + " Part#: " + pageCount++), (Throwable)e);
                            }
                        }
                        GeoIndexUpdaterResource.this.closeCurrentDeltaFile();
                        logger.debug((Object)"Indexed all results. ");
                        GeoIndexUpdaterResource.this.setIndexStatus("FINISHED");
                        return true;
                    }
                    catch (Exception e) {
                        logger.error((Object)(GeoIndexUpdaterResource.this.getIndexID() + " update aborted."), (Throwable)e);
                        GeoIndexUpdaterResource.this.setIndexStatus("FINISHED");
                        throw e;
                    }
                }
            });
            this.threadPool.execute(rsConsumer);
            return rsConsumer;
        }
        catch (Exception e) {
            logger.error((Object)"Error while inserting rowset.", (Throwable)e);
            throw new RemoteException("Error while inserting rowset.", e);
        }
    }

    private void addToDeltaFile(String id, long x1, long x2, long y1, long y2, Long time, WritableByteChannel deltaChannel) throws Exception {
        Charset western = Charset.forName("ISO-8859-1");
        CharsetEncoder idEncoder = western.newEncoder();
        ByteBuffer idBuffer = idEncoder.encode(CharBuffer.wrap(id.toCharArray()));
        byte isTemporal = time == null ? (byte)0 : 1;
        ByteBuffer buffer = ByteBuffer.allocate(4 + idBuffer.limit() + 8 + 8 + 8 + 8 + 1 + 8);
        buffer.putInt(idBuffer.limit());
        buffer.put(idBuffer);
        buffer.putLong(x1);
        buffer.putLong(x2);
        buffer.putLong(y1);
        buffer.putLong(y2);
        buffer.put(isTemporal);
        if (isTemporal == 1) {
            buffer.putLong(time);
        }
        buffer.flip();
        deltaChannel.write(buffer);
    }

    private int addToDeltaFile(String colID, String lang, String rowset, GeoIndexManagementPortType IndexManagementInstance) throws Exception {
        int payloadIndex = rowset.indexOf("fullpayload");
        if (payloadIndex > -1) {
            String payload = rowset.substring(payloadIndex + "fullpayload".length()).trim();
            if (payload.charAt(0) != '\"') {
                logger.warn((Object)"please check the rowsets to be fed in the index. While there is a fullpayload keyword, it doesn't seem to be a FIELD");
            } else {
                int payloadStart = rowset.indexOf(62, payloadIndex);
                int testInsideElement = rowset.indexOf(60, payloadIndex);
                if (payloadStart == -1) {
                    logger.warn((Object)"please check the rowsets to be fed in the index. While there is a fullpayload keyword, it seems to in a weird spot");
                } else if (testInsideElement != -1 && payloadStart > testInsideElement) {
                    logger.warn((Object)"please check the rowsets to be fed in the index. While there is a fullpayload keyword, it doesn't seem to be INSIDE a FIELD");
                } else {
                    int payloadEnd = rowset.indexOf("</FIELD>", payloadStart);
                    if (payloadEnd == -1) {
                        logger.warn((Object)"please check the rowsets to be fed in the index. Thefullpayload keyword, must be out of FIELD");
                    }
                    payload = rowset.substring(payloadStart + 1, payloadEnd);
                    payload = XMLTokenReplacer.XMLUnresolve((String)payload);
                    rowset = rowset.substring(0, payloadStart + 1) + payload + rowset.substring(payloadEnd);
                }
            }
        }
        FileChannel deltaChannel = new FileOutputStream(this.currentDeltaFile, true).getChannel();
        XMLProfileParser XMLparser = new XMLProfileParser();
        XMLparser.readString(rowset, null);
        XMLparser.setRootNode("ROWSET");
        int docCount = 0;
        Charset western = Charset.forName("ISO-8859-1");
        CharsetEncoder isoEncoder = western.newEncoder();
        while (XMLparser.setNextField()) {
            if (this.isDeltaComplete()) {
                deltaChannel.close();
                this.closeCurrentDeltaFile();
                deltaChannel = new FileOutputStream(this.currentDeltaFile).getChannel();
            }
            HashMap<String, String> fieldData = new HashMap<String, String>();
            ++docCount;
            String id = XMLparser.getFieldByValue("id");
            String x1 = XMLparser.getFieldByValue("x1");
            String x2 = XMLparser.getFieldByValue("x2");
            String y1 = XMLparser.getFieldByValue("y1");
            String y2 = XMLparser.getFieldByValue("y2");
            fieldData.put("id", id);
            fieldData.put("x1", x1);
            fieldData.put("x2", x2 == null || x2.equals("") ? x1 : x2);
            fieldData.put("y1", y1);
            fieldData.put("y2", y2 == null || y2.equals("") ? y1 : y2);
            String[][] fields = XMLparser.getSubFields();
            StringBuilder allFields = new StringBuilder("");
            ArrayList<String> fieldNames = new ArrayList<String>();
            for (String fieldDefault : IndexType.GEODEFAULT) {
                fieldNames.add(colID + ":" + lang + ":" + "p" + ":" + fieldDefault);
            }
            fieldNames.add(colID + ":" + lang + ":" + "s" + ":" + "geo");
            block6: for (int i = 0; i < fields[0].length; ++i) {
                for (GeoIndexField field : this.indexTypeObject.fields) {
                    if (!field.name.equals(fields[0][i])) continue;
                    allFields.append(fields[0][i].length() + ":" + fields[0][i]);
                    String data = "";
                    if (field.dataType.equals((Object)GeoIndexField.DataType.DATE)) {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(DateParser.parse((String)fields[1][i]));
                        data = data + cal.getTimeInMillis();
                    } else {
                        data = data + fields[1][i];
                    }
                    allFields.append(data.length() + ":" + data);
                    if (!field.isReturnable) continue block6;
                    fieldNames.add(colID + ":" + lang + ":" + "p" + ":" + fields[0][i]);
                    continue block6;
                }
            }
            try {
                Object[] fNames = fieldNames.toArray(new String[fieldNames.size()]);
                logger.trace((Object)("Fields to add: " + Arrays.toString(fNames)));
                logger.trace((Object)("Collection to add: " + colID));
                IndexManagementInstance.addFields(new StringArray((String[])fNames));
                IndexManagementInstance.addCollectionID(colID);
            }
            catch (Exception e) {
                logger.error((Object)"Could not add the fields/collection to the manager: ", (Throwable)e);
                throw new Exception("Could not add the fields/collection to the manager: ", e);
            }
            ByteBuffer colIDBuffer = isoEncoder.encode(CharBuffer.wrap(colID.toCharArray()));
            ByteBuffer langBuffer = isoEncoder.encode(CharBuffer.wrap(lang.toCharArray()));
            ByteBuffer idBuffer = isoEncoder.encode(CharBuffer.wrap(((String)fieldData.get("id")).toCharArray()));
            ByteBuffer fieldsBuffer = isoEncoder.encode(CharBuffer.wrap(allFields.toString().toCharArray()));
            int bytesToAllocate = 12 + colIDBuffer.limit() + langBuffer.limit() + idBuffer.limit() + 8 + 8 + 8 + 8 + 4 + fieldsBuffer.limit();
            logger.debug((Object)("we will allocate " + bytesToAllocate + " bytes"));
            ByteBuffer buffer = ByteBuffer.allocate(bytesToAllocate);
            try {
                buffer.putInt(colIDBuffer.limit());
                buffer.put(colIDBuffer);
                buffer.putInt(langBuffer.limit());
                buffer.put(langBuffer);
                buffer.putInt(idBuffer.limit());
                buffer.put(idBuffer);
                buffer.putLong(new Double(Double.parseDouble((String)fieldData.get("x1")) * Math.pow(10.0, this.numOfDeci)).longValue());
                buffer.putLong(new Double(Double.parseDouble((String)fieldData.get("x2")) * Math.pow(10.0, this.numOfDeci)).longValue());
                buffer.putLong(new Double(Double.parseDouble((String)fieldData.get("y1")) * Math.pow(10.0, this.numOfDeci)).longValue());
                buffer.putLong(new Double(Double.parseDouble((String)fieldData.get("y2")) * Math.pow(10.0, this.numOfDeci)).longValue());
                buffer.putInt(fieldsBuffer.limit());
                buffer.put(fieldsBuffer);
            }
            catch (BufferOverflowException boe) {
                logger.error((Object)("BufferOverflowException. current buffer limit is: " + buffer.limit()), (Throwable)boe);
                throw boe;
            }
            buffer.flip();
            deltaChannel.write(buffer);
        }
        deltaChannel.close();
        return docCount;
    }

    public boolean isDeltaComplete() {
        return this.currentDeltaFile.length() > this.getDeltaFileSize();
    }

    public void closeCurrentDeltaFile() {
        try {
            logger.info((Object)("closing DeltaFile: " + this.currentDeltaFile.getAbsolutePath() + " of size: " + this.currentDeltaFile.length()));
            this.deltaUploader.upload(this.currentDeltaFile.getAbsolutePath(), this.getIndexTypeName(), this.deltaFileDocCount);
            this.currentDeltaFile = this.createNewDeltaFile();
            this.deltaFileDocCount = 0;
        }
        catch (Exception e) {
            logger.error((Object)"Error while closing delta file.", (Throwable)e);
        }
    }

    public void onResourceRemoval() {
        try {
            super.onResourceRemoval();
            this.threadPool.shutdownNow();
            this.currentDeltaFile.delete();
            this.deltaUploader.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error while removing GeoIndexUpdater resource.", (Throwable)e);
        }
    }

    public void onUpdaterNotificationReceived(Element arg0) {
    }

    private String getLangRowset(String rowset) {
        String regex = "<ROWSET[^>]*lang=\"([^\"]*?)\"";
        return this.getMatchRegex(regex, rowset);
    }

    private String getColIDRowset(String rowset) {
        String regex = "<ROWSET[^>]*colID=\"([^\"]*?)\"";
        return this.getMatchRegex(regex, rowset);
    }

    private String getMatchRegex(String regex, String rowset) {
        Matcher m = Pattern.compile(regex).matcher(rowset);
        String match = null;
        try {
            if (m.find() && (match = m.group(1).trim()).equals("")) {
                match = null;
            }
        }
        catch (Exception e) {
            logger.error((Object)(this.getIndexID() + " exception while getting idxType"), (Throwable)e);
        }
        return match;
    }

    private abstract class IndexUpdaterThread<T>
    implements Callable<T> {
        private GCUBEScope scope;
        private SecurityCredentials credential;

        public IndexUpdaterThread(GCUBEScope scope, SecurityCredentials credential) {
            this.scope = scope;
            this.credential = credential;
        }

        @Override
        public T call() throws Exception {
            try {
                Thread t = Thread.currentThread();
                ServiceContext.getContext().setScope(t, this.scope);
                ServiceContext.getContext().useCredentials(t, new SecurityCredentials[]{this.credential});
            }
            catch (Exception e) {
                logger.error((Object)"Failed to set scope and credentials on the index updater thread.");
            }
            return this.doUpdate();
        }

        public abstract T doUpdate() throws Exception;
    }
}

