package org.gcube.geoindexupdater.client.library.proxies;

import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils.Empty;
import org.gcube.geoindexupdater.client.library.beans.Types.Add;
import org.gcube.geoindexupdater.client.library.beans.Types.Destroy;
import org.gcube.geoindexupdater.client.library.beans.Types.Process;
import org.gcube.geoindexupdater.client.library.exceptions.GeoIndexUpdaterException;
import org.gcube.geoindexupdater.client.library.stubs.GeoIndexUpdaterStub;
import org.gcube.common.clients.Call;

public class GeoIndexUpdaterCLDefaultProxy implements GeoIndexUpdaterCLProxyI {

	private final ProxyDelegate<GeoIndexUpdaterStub> delegate;

	public GeoIndexUpdaterCLDefaultProxy(ProxyDelegate<GeoIndexUpdaterStub> config) {
		this.delegate = config;
	}

	public void add(final Add add) throws GeoIndexUpdaterException {
		Call<GeoIndexUpdaterStub, Empty> call = new Call<GeoIndexUpdaterStub, Empty>() {
			@Override
			public Empty call(GeoIndexUpdaterStub endpoint) throws Exception {
				return endpoint.add(add);
			}
		};
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw new GeoIndexUpdaterException(e);
		}
		
	}

	public void process(final Process process) throws GeoIndexUpdaterException {
		Call<GeoIndexUpdaterStub, Empty> call = new Call<GeoIndexUpdaterStub, Empty>() {
			@Override
			public Empty call(GeoIndexUpdaterStub endpoint) throws Exception {
				return endpoint.process(process);
			}
		};
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw new GeoIndexUpdaterException(e);
		}
		
	}

	@Override
	public void destroy() throws GeoIndexUpdaterException {
		Call<GeoIndexUpdaterStub, Empty> call = new Call<GeoIndexUpdaterStub, Empty>() {
			@Override
			public Empty call(GeoIndexUpdaterStub endpoint) throws Exception {
				endpoint.destroy(new Destroy());
				return null;
			}
		};
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw new GeoIndexUpdaterException(e);
		}
	}

}
