package org.gcube.geoindexupdater.client.library.plugins;

import javax.xml.ws.EndpointReference;

import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.fw.plugin.Plugin;
import org.gcube.common.clients.stubs.jaxws.StubFactory;
import org.gcube.geoindexupdater.client.library.proxies.GeoIndexUpdaterFactoryCLDefaultProxy;
import org.gcube.geoindexupdater.client.library.proxies.GeoIndexUpdaterFactoryCLProxyI;
import org.gcube.geoindexupdater.client.library.stubs.GeoIndexUpdaterFactoryStub;
import org.gcube.geoindexupdater.client.library.utils.GeoIndexUpdaterCLConstants;

/**
 * DTS Client Library plugin exposes information that allows CL Framework
 * components to act on behalf of DTS CL. 
 * 
 * @author john.gerbesiotis - DI NKUA
 * 
 */
public class GeoIndexUpdaterFactoryCLPlugin implements Plugin<GeoIndexUpdaterFactoryStub, GeoIndexUpdaterFactoryCLProxyI> {

	@Override
	public String name() {
		return GeoIndexUpdaterCLConstants.FACTORYNAME;
	}

	@Override
	public String namespace() {
		return GeoIndexUpdaterCLConstants.NAMESPACE;
	}

	@Override
	public String serviceClass() {
		return GeoIndexUpdaterCLConstants.gcubeClass;
	}

	@Override
	public String serviceName() {
		return GeoIndexUpdaterCLConstants.gcubeName;
	}
	
	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
		return fault;
	}

	@Override
	public GeoIndexUpdaterFactoryStub resolve(EndpointReference reference, ProxyConfig<?, ?> proxyConfig) throws Exception {
		return StubFactory.stubFor(GeoIndexUpdaterCLConstants.giuf).at(reference);
	}

	@Override
	public GeoIndexUpdaterFactoryCLProxyI newProxy(ProxyDelegate<GeoIndexUpdaterFactoryStub> delegate) {
		return new GeoIndexUpdaterFactoryCLDefaultProxy(delegate);
	}

}
