/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.geoindexmanagement;

import java.rmi.RemoteException;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.geoindexmanagement.GeoIndexManagementResource;
import org.gcube.indexmanagement.geoindexmanagement.StatefulContext;
import org.gcube.indexmanagement.geoindexmanagement.stubs.GetIndexInformationResponse;
import org.gcube.indexmanagement.geoindexmanagement.stubs.StringArray;

public class GeoIndexManagementService {
    static GCUBELog logger = new GCUBELog(GeoIndexManagementService.class);

    public GeoIndexManagementService() {
        logger.debug((Object)"GeoIndexManagementService constructed");
    }

    public GetIndexInformationResponse getIndexInformation(VOID request) throws GCUBEFault {
        try {
            GeoIndexManagementResource generatorResource = this.getResource();
            GetIndexInformationResponse response = new GetIndexInformationResponse();
            response.setIndexID(generatorResource.getIndexID());
            response.setIndexTypeName(generatorResource.getIndexTypeName());
            StringArray colIdsArray = new StringArray();
            colIdsArray.setArray(generatorResource.getCollectionID());
            response.setCollectionID(colIdsArray);
            StringArray fieldsArray = new StringArray();
            fieldsArray.setArray(generatorResource.getFields());
            response.setFields(fieldsArray);
            response.setGeographicalSystem(generatorResource.getGeographicalSystem());
            response.setUnitOfMeasurement(generatorResource.getUnitOfMeasurement());
            response.setNumberOfDecimals(generatorResource.getNumberOfDecimals().intValue());
            return response;
        }
        catch (RemoteException re) {
            throw new GCUBEFault(new String[]{re.getMessage()});
        }
    }

    public VOID setIndexTypeName(String indexTypeID) throws GCUBEFault {
        try {
            this.getResource().setIndexTypeName(indexTypeID);
            this.getResource().store();
        }
        catch (Exception ie) {
            throw new GCUBEUnrecoverableFault(new String[]{ie.getMessage()});
        }
        return new VOID();
    }

    public String getIndexTypeName(VOID empty) throws GCUBEFault {
        try {
            return this.getResource().getIndexTypeName();
        }
        catch (RemoteException re) {
            throw new GCUBEFault(new String[]{re.getMessage()});
        }
    }

    public VOID addCollectionID(String collectionID) throws GCUBEFault {
        try {
            this.getResource().addCollectionID(collectionID);
            this.getResource().store();
        }
        catch (RemoteException re) {
            throw new GCUBEFault(new String[]{re.getMessage()});
        }
        return new VOID();
    }

    public VOID addFields(StringArray fields) throws GCUBEFault {
        try {
            GeoIndexManagementResource resource = this.getResource();
            for (String field : fields.getArray()) {
                resource.addField(field);
            }
            resource.store();
        }
        catch (RemoteException re) {
            throw new GCUBEFault(new String[]{re.getMessage()});
        }
        return new VOID();
    }

    private GeoIndexManagementResource getResource() throws GCUBEFault {
        GCUBEWSResource resource = null;
        try {
            resource = StatefulContext.getPortTypeContext().getWSHome().find();
        }
        catch (Exception e) {
            throw new GCUBEFault(new String[]{"Unable to access resource. " + e.getMessage()});
        }
        GeoIndexManagementResource geoIndexResource = (GeoIndexManagementResource)resource;
        return geoIndexResource;
    }
}

