/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.geoindexmanagement;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.common.IndexManagementWSResource;
import org.gcube.indexmanagement.geoindexmanagement.StatefulContext;
import org.gcube.indexmanagement.geoindexmanagement.stubs.RPChangeType;
import org.gcube.indexmanagement.geoindexmanagement.stubs.SharedStateChangeNotificationMessageType;
import org.gcube.indexmanagement.geoindexmanagement.stubs.SharedStateChangeNotificationMessageWrapperType;
import org.gcube.indexmanagement.storagehandling.DeltaListManagementHandler;
import org.gcube.indexmanagement.storagehandling.DeltaListManager;
import org.gcube.indexmanagement.storagehandling.stubs.DeltaFileInfoType;
import org.globus.wsrf.ResourceException;

public class GeoIndexManagementResource
extends IndexManagementWSResource
implements DeltaListManager {
    public static final String RP_GEOGRAPHICAL_SYSTEM = "GeographicalSystem";
    public static final String RP_UNIT_OF_MEASUREMENT = "UnitOfMeasurement";
    public static final String RP_NUMBER_OF_DECIMALS = "NumberOfDecimals";
    protected static String[] RPNames = new String[]{"GeographicalSystem", "UnitOfMeasurement", "NumberOfDecimals"};
    static GCUBELog logger = new GCUBELog(GeoIndexManagementResource.class);
    private DeltaListManagementHandler managementHandler;

    public void initialise(Object ... args) throws Exception {
        this.setIsInitializing(true);
        GCUBEWSResourceKey key = (GCUBEWSResourceKey)args[0];
        if (args[1] == null) {
            args[1] = key.getValue().toString();
        }
        super.initialise(StatefulContext.getPortTypeContext().getNamespace(), (String)args[1], (String)args[2], (String[])args[3]);
        try {
            for (String rpName : RPNames) {
                this.createProperty(rpName);
            }
            this.setGeographicalSystem((String)args[4]);
            this.setUnitOfMeasurement((String)args[5]);
            this.setNumberOfDecimals((Integer)args[6]);
            this.managementHandler = new DeltaListManagementHandler((IndexManagementWSResource)this, "state_geo_" + (String)args[1]);
            this.setIsInitializing(false);
        }
        catch (Exception e) {
            logger.error((Object)"Error during resource initialization.", (Throwable)e);
            throw new ResourceException((Throwable)e);
        }
    }

    public void onStore(ObjectOutputStream oos) throws Exception {
        super.onStore(oos);
        oos.writeObject((String)this.getResourcePropertySet().get(RP_GEOGRAPHICAL_SYSTEM).get(0));
        oos.writeObject((String)this.getResourcePropertySet().get(RP_UNIT_OF_MEASUREMENT).get(0));
        oos.writeObject((Integer)this.getResourcePropertySet().get(RP_NUMBER_OF_DECIMALS).get(0));
        this.managementHandler.storeState(oos);
    }

    public void onLoad(ObjectInputStream ois, boolean firstLoad) throws Exception {
        this.setIsInitializing(true);
        super.onLoad(ois, firstLoad);
        this.createProperty(RP_GEOGRAPHICAL_SYSTEM);
        this.createProperty(RP_UNIT_OF_MEASUREMENT);
        this.createProperty(RP_NUMBER_OF_DECIMALS);
        this.setGeographicalSystem((String)ois.readObject());
        this.setUnitOfMeasurement((String)ois.readObject());
        this.setNumberOfDecimals((Integer)ois.readObject());
        this.managementHandler = new DeltaListManagementHandler();
        this.managementHandler.loadState(ois, firstLoad, (IndexManagementWSResource)this);
        this.setIsInitializing(false);
    }

    public String getGeographicalSystem() {
        return (String)this.getResourcePropertySet().get(RP_GEOGRAPHICAL_SYSTEM).get(0);
    }

    public String getUnitOfMeasurement() {
        return (String)this.getResourcePropertySet().get(RP_UNIT_OF_MEASUREMENT).get(0);
    }

    public Integer getNumberOfDecimals() {
        return (Integer)this.getResourcePropertySet().get(RP_NUMBER_OF_DECIMALS).get(0);
    }

    public void addCollectionID(String collectionID) {
        RPChangeType[] changes;
        super.addCollectionID(collectionID);
        for (RPChangeType change : changes = new RPChangeType[]{new RPChangeType(this.getResourcePropertySet().get("CollectionID").getMetaData().getName(), collectionID)}) {
            logger.debug((Object)("Adding RP change to notification message: " + change.getRPName() + " = " + change.getNewValue()));
        }
        SharedStateChangeNotificationMessageType message = new SharedStateChangeNotificationMessageType();
        message.setChangedRPs(changes);
        SharedStateChangeNotificationMessageWrapperType wrapper = new SharedStateChangeNotificationMessageWrapperType(message);
        this.sendSharedStateChangeNotification(wrapper);
    }

    public synchronized void setGeographicalSystem(String geographicalSystem) {
        this.getResourcePropertySet().get(RP_GEOGRAPHICAL_SYSTEM).clear();
        this.getResourcePropertySet().get(RP_GEOGRAPHICAL_SYSTEM).add((Object)geographicalSystem);
    }

    public synchronized void setUnitOfMeasurement(String unitOfMeasurement) {
        this.getResourcePropertySet().get(RP_UNIT_OF_MEASUREMENT).clear();
        this.getResourcePropertySet().get(RP_UNIT_OF_MEASUREMENT).add((Object)unitOfMeasurement);
    }

    public synchronized void setNumberOfDecimals(Integer numberOfDecimals) {
        this.getResourcePropertySet().get(RP_NUMBER_OF_DECIMALS).clear();
        this.getResourcePropertySet().get(RP_NUMBER_OF_DECIMALS).add((Object)numberOfDecimals);
    }

    public DeltaListManagementHandler getIndexManagerHandler() {
        return this.managementHandler;
    }

    public void onResourceRemoval() {
        try {
            super.onResourceRemoval();
            this.managementHandler.close();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to remove index management resource.", (Throwable)e);
        }
    }

    public boolean isDeltaValid(DeltaFileInfoType arg0) throws IndexException {
        return true;
    }
}

