/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.geoindexmanagement;

import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.geoindexmanagement.GeoIndexManagementResource;
import org.gcube.indexmanagement.geoindexmanagement.ServiceContext;
import org.gcube.indexmanagement.geoindexmanagement.StatefulContext;
import org.gcube.indexmanagement.geoindexmanagement.stubs.CreateResource;
import org.gcube.indexmanagement.geoindexmanagement.stubs.CreateResourceResponse;

public class GeoIndexManagementFactoryService
extends GCUBEPortType {
    private static GCUBELog logger = new GCUBELog(GeoIndexManagementFactoryService.class);
    private static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();

    public CreateResourceResponse createResource(CreateResource request) throws GCUBEFault {
        String indexID = request.getIndexID();
        String indexTypeID = "" + request.getIndexTypeID();
        String[] collectionID = request.getCollectionID();
        String geographicalSystem = "" + request.getGeographicalSystem();
        String unitOfMeasurement = "" + request.getUnitOfMeasurement();
        Integer numberOfDecimals = request.getNumberOfDecimals();
        CreateResourceResponse response = new CreateResourceResponse();
        try {
            GCUBEStatefulPortTypeContext ptcxt = StatefulContext.getPortTypeContext();
            GCUBEWSResourceKey key = ptcxt.makeKey(uuidGen.nextUUID());
            GCUBEWSResource geoIndexResource = ptcxt.getWSHome().create(key, new Object[]{key, indexID, indexTypeID, collectionID, geographicalSystem, unitOfMeasurement, numberOfDecimals});
            geoIndexResource.store();
            response.setEndpointReference(geoIndexResource.getEPR());
            response.setIndexID(((GeoIndexManagementResource)geoIndexResource).getIndexID());
            logger.info((Object)("GeoIndex (Management Resource) created. Returning indexID: " + response.getIndexID() + ", epr:\n" + response.getEndpointReference()));
            return response;
        }
        catch (Exception e) {
            logger.error((Object)"Error in createResource", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"*** In GeoIndexManagementFactoryService.createResource *** "});
        }
    }

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }
}

