/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.geoindexlookup;

import java.rmi.RemoteException;
import java.util.Calendar;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.geoindexlookup.GeoIndexLookupResource;
import org.gcube.indexmanagement.geoindexlookup.StatefulContext;
import org.gcube.indexmanagement.geoindexlookup.stubs.PluginInitializationException;
import org.gcube.indexmanagement.geoindexlookup.stubs.PluginNotFoundException;
import org.gcube.indexmanagement.geoindexlookup.stubs.SearchPolygon;
import org.globus.wsrf.ResourceException;

public class GeoIndexLookupService {
    String hostName = "";
    static GCUBELog logger = new GCUBELog(GeoIndexLookupService.class);

    public GeoIndexLookupService() {
        logger.debug((Object)"GeoIndexService constructed");
    }

    public String search(SearchPolygon poly) throws GCUBEUnrecoverableFault {
        try {
            long before = Calendar.getInstance().getTimeInMillis();
            GeoIndexLookupResource geoIndexResource = this.getResource();
            String rsLocator = geoIndexResource.search(poly.getCqlQuery(), poly.isNoncomplete());
            long after = Calendar.getInstance().getTimeInMillis();
            logger.info((Object)("Retrieved RSLocator in " + (after - before) + "ms."));
            return rsLocator;
        }
        catch (PluginNotFoundException pne) {
            logger.error((Object)"Failed to execute search query because a plugin was not found. ", (Throwable)pne);
            throw new GCUBEUnrecoverableFault(new String[]{pne.getMessage()});
        }
        catch (PluginInitializationException pie) {
            logger.error((Object)"Failed to execute search query because a plugin failed to initialize. ", (Throwable)pie);
            throw new GCUBEUnrecoverableFault(new String[]{pie.getMessage()});
        }
        catch (Exception e) {
            logger.error((Object)"Failed to execute search query. ", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{e.getMessage()});
        }
    }

    public VOID loadPlugins(VOID empty) throws GCUBEUnrecoverableFault {
        try {
            long before = Calendar.getInstance().getTimeInMillis();
            GeoIndexLookupResource geoIndexResource = this.getResource();
            geoIndexResource.loadPlugins();
            long after = Calendar.getInstance().getTimeInMillis();
            logger.info((Object)("Loaded plugins in " + (after - before) + "ms."));
        }
        catch (Exception e) {
            throw new GCUBEUnrecoverableFault(new String[]{e.getMessage()});
        }
        return new VOID();
    }

    public VOID setIndexTypeID(String indexTypeID) throws GCUBEUnrecoverableFault {
        try {
            this.getResource().setIndexTypeName(indexTypeID);
            this.getResource().store();
        }
        catch (Exception e) {
            throw new GCUBEUnrecoverableFault(new String[]{e.getMessage()});
        }
        return new VOID();
    }

    public String getIndexTypeID(VOID empty) throws GCUBEFault {
        try {
            return this.getResource().getIndexTypeName();
        }
        catch (RemoteException re) {
            throw new GCUBEFault(new String[]{re.getMessage()});
        }
    }

    private GeoIndexLookupResource getResource() throws ResourceException {
        return (GeoIndexLookupResource)StatefulContext.getPortTypeContext().getWSHome().find();
    }
}

