/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.geoindexlookup;

import com.vividsolutions.jts.geom.Envelope;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.common.XMLTokenReplacer;
import org.gcube.indexmanagement.common.mergesort.MergeSortElement;
import org.gcube.indexmanagement.common.mergesort.MergeSortPipe;
import org.gcube.indexmanagement.geo.DataWrapper;
import org.gcube.indexmanagement.geo.GeoIndexField;
import org.gcube.indexmanagement.geo.GeoIndexType;
import org.gcube.indexmanagement.geo.InclusionType;
import org.gcube.indexmanagement.geo.QueryResults;
import org.gcube.indexmanagement.geo.RTreeWrapper;
import org.gcube.indexmanagement.geo.ranking.RankEvaluator;
import org.gcube.indexmanagement.geo.refinement.Refiner;
import org.gcube.indexmanagement.geo.shape.Polygon;
import org.gcube.indexmanagement.geo.shape.Rectangle;

public class GeoIndexLookupSearchWorker
extends Thread {
    static GCUBELog logger = new GCUBELog(GeoIndexLookupSearchWorker.class);
    private MergeSortPipe pipe;
    private int workerID;
    private boolean flowControlled;
    private Vector<RTreeWrapper> index;
    private Envelope envelope;
    private Refiner[] refiners;
    private RankEvaluator ranker;
    private InclusionType containment;
    private GeoIndexType indexType = null;
    private String collectionID;
    private String language;
    private int numberOfDecimals;
    private boolean isComplete;
    private RandomAccessFile rawData = null;
    private LinkedHashMap<String, String> projections;

    public GeoIndexLookupSearchWorker(Vector<RTreeWrapper> index, String collectionID, String language, Polygon queryShape, InclusionType containment, Refiner[] refiners, RankEvaluator ranker, MergeSortPipe pipe, int workerID, boolean flowControlled, GeoIndexType indexType, int numberOfDecimals, boolean isComplete, RandomAccessFile raf, LinkedHashMap<String, String> projections) {
        this.ranker = ranker;
        this.refiners = refiners;
        this.index = index;
        this.pipe = pipe;
        this.workerID = workerID;
        this.flowControlled = flowControlled;
        Rectangle rect = queryShape.getBoundingBox();
        logger.info((Object)"filtering by the following rectangle:");
        logger.info((Object)rect);
        this.envelope = new Envelope((double)rect.getMinX(), (double)rect.getMaxX(), (double)rect.getMinY(), (double)rect.getMaxY());
        logger.info((Object)this.envelope);
        this.containment = containment;
        this.indexType = indexType;
        this.collectionID = collectionID;
        this.language = language;
        this.numberOfDecimals = numberOfDecimals;
        this.isComplete = isComplete;
        this.rawData = raf;
        this.projections = projections;
        for (Refiner refiner : refiners) {
            logger.info((Object)("Refiner " + refiner));
        }
        logger.info((Object)("RankEvaluater " + ranker));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            RTreeWrapper rTreeWrapper;
            int i;
            logger.info((Object)("workerID: " + this.workerID + ", Worker started..."));
            ArrayList<String> returnFields = new ArrayList<String>();
            if (this.projections != null && this.projections.size() > 0) {
                for (Map.Entry<String, String> current : this.projections.entrySet()) {
                    String proj = current.getValue();
                    Integer pos = this.indexType.getFieldPosition(proj);
                    if (pos == null) {
                        if (!proj.equalsIgnoreCase("ratio") && !proj.equalsIgnoreCase("gDocCollectionLang") && !proj.equalsIgnoreCase("gDocCollectionID") && !proj.equalsIgnoreCase("apxcount") && !proj.equalsIgnoreCase("docNr") && !proj.equalsIgnoreCase("mbr")) continue;
                        returnFields.add(proj);
                        continue;
                    }
                    GeoIndexField field = this.indexType.fields[pos];
                    if (!field.isReturnable) continue;
                    returnFields.add(field.name);
                }
            }
            long area = this.getArea(this.envelope);
            RTreeWrapper indexPart = null;
            boolean reachedTop = false;
            for (i = 0; i < this.index.size(); ++i) {
                indexPart = this.index.get(i);
                logger.info((Object)("workerID: " + this.workerID + ", pyramid part max area: " + indexPart.getMaxArea()));
                logger.info((Object)("workerID: " + this.workerID + ", area: " + indexPart.getMaxArea()));
                logger.info((Object)("workerID: " + this.workerID + ", i: " + i));
                if (area >= indexPart.getMaxArea()) continue;
                logger.info((Object)("workerID: " + this.workerID + ", Found pyramid part..."));
                ++i;
                break;
            }
            QueryResults result = null;
            logger.info((Object)("workerID: " + this.workerID + ", Starting loop... i: " + i));
            int j = --i;
            while ((result == null || result.getTotalHitCount() == 0) && j >= 0) {
                indexPart = this.index.get(j);
                logger.info((Object)("workerID: " + this.workerID + ", Starting search"));
                rTreeWrapper = indexPart;
                synchronized (rTreeWrapper) {
                    result = indexPart.performQuery(this.envelope, this.containment, this.refiners, this.ranker);
                }
                logger.info((Object)("workerID: " + this.workerID + ", Done searching"));
                if (result != null && result.getTotalHitCount() > 0) {
                    long after;
                    logger.info((Object)("Found " + result.getTotalHitCount() + " objects..."));
                    long before = Calendar.getInstance().getTimeInMillis();
                    int docCounter = 0;
                    ArrayList resultChunk = null;
                    logger.info((Object)("workerID: " + this.workerID + ", isFlowControlled: " + this.flowControlled));
                    while (!this.flowControlled && resultChunk == null || this.flowControlled && (resultChunk = result.getNext(20)) != null) {
                        int apxTotalFilteredCount;
                        double r = new Integer(result.getCurrentRefinedCount()).doubleValue() / (double)result.getCurrentUnrefinedCount();
                        if (!this.flowControlled) {
                            resultChunk = result.getAll();
                            apxTotalFilteredCount = result.getCurrentRefinedCount();
                        } else {
                            apxTotalFilteredCount = new Double((double)result.getTotalHitCount() * r).intValue();
                        }
                        for (DataWrapper geoData : resultChunk) {
                            GenericRecord rec = new GenericRecord();
                            ArrayList<StringField> fields = new ArrayList<StringField>();
                            String test = "" + r;
                            String count = "" + apxTotalFilteredCount;
                            String docNr = "" + ++docCounter;
                            String minX = "<minX>" + (double)geoData.getMinX() / Math.pow(10.0, this.numberOfDecimals) + "</minX>";
                            String maxX = "<maxX>" + (double)geoData.getMaxX() / Math.pow(10.0, this.numberOfDecimals) + "</maxX>";
                            String minY = "<minY>" + (double)geoData.getMinY() / Math.pow(10.0, this.numberOfDecimals) + "</minY>";
                            String maxY = "<maxY>" + (double)geoData.getMaxY() / Math.pow(10.0, this.numberOfDecimals) + "</maxY>";
                            String mbr = minX + maxX + minY + maxY;
                            String additionalFields = "";
                            SimpleDateFormat ourFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                            String rank = "";
                            double ranking = 0.0;
                            if (this.ranker != null) {
                                ranking = this.ranker.rank(geoData);
                                rank = "" + ranking;
                            }
                            if (rank.equals("")) {
                                rank = "unrankable";
                            }
                            fields.add(new StringField(rank));
                            fields.add(new StringField(geoData.getID()));
                            if (!this.isComplete) {
                                for (int idx = 0; idx < returnFields.size(); ++idx) {
                                    String proj = (String)returnFields.get(idx);
                                    if (proj.equalsIgnoreCase("ratio")) {
                                        fields.add(new StringField(test));
                                        continue;
                                    }
                                    if (proj.equalsIgnoreCase("apxcount")) {
                                        fields.add(new StringField(count));
                                        continue;
                                    }
                                    if (proj.equalsIgnoreCase("docNr")) {
                                        fields.add(new StringField(docNr));
                                        continue;
                                    }
                                    if (proj.equalsIgnoreCase("mbr")) {
                                        fields.add(new StringField(mbr));
                                        continue;
                                    }
                                    if (proj.equalsIgnoreCase("gDocCollectionID")) {
                                        fields.add(new StringField(this.collectionID));
                                        continue;
                                    }
                                    if (proj.equalsIgnoreCase("gDocCollectionLang")) {
                                        fields.add(new StringField(this.language));
                                        continue;
                                    }
                                    Integer pos = this.indexType.getFieldPosition(proj);
                                    GeoIndexField field = this.indexType.fields[pos];
                                    String fieldData = (String)geoData.getValue(field.name);
                                    if (fieldData == null) {
                                        fields.add(new StringField(""));
                                        continue;
                                    }
                                    if (field.dataType.equals((Object)GeoIndexField.DataType.DATE)) {
                                        try {
                                            fieldData = ourFormat.format(new Date(Long.parseLong(fieldData)));
                                        }
                                        catch (Exception e) {
                                            logger.error((Object)("workerID: " + this.workerID + ", Could not parse Date: " + fieldData), (Throwable)e);
                                        }
                                    }
                                    logger.trace((Object)("workerID: " + this.workerID + ", Field Name: " + field.name + "Field Data: " + fieldData));
                                    fields.add(new StringField(fieldData));
                                }
                            } else {
                                additionalFields = XMLTokenReplacer.XMLResolve((String)((String)geoData.getValue("fullpayload")));
                                logger.trace((Object)("workerID: " + this.workerID + ", Complete case. Data: " + additionalFields));
                                fields.add(new StringField(additionalFields));
                            }
                            rec.setFields(fields.toArray(new Field[fields.size()]));
                            logger.trace((Object)("workerID: " + this.workerID + ", Adding to the pipe. ID: " + geoData.getID() + ", colID: " + this.collectionID + ", rank: " + ranking));
                            MergeSortElement element = new MergeSortElement(this.language, geoData.getID());
                            element.setElement(rec);
                            element.setRank(ranking);
                            MergeSortPipe mergeSortPipe = this.pipe;
                            synchronized (mergeSortPipe) {
                                logger.trace((Object)("workerID: " + this.workerID + ", got the lock for the pipe"));
                                if (this.pipe.isStoped()) {
                                    logger.trace((Object)("workerID: " + this.workerID + ", pipe stopped, notify All"));
                                    this.pipe.notifyAll();
                                    break;
                                }
                                this.pipe.add(this.workerID, element);
                                logger.trace((Object)("workerID: " + this.workerID + ", added to the queue"));
                                if (this.pipe.sendMergerNotification()) {
                                    logger.trace((Object)("workerID: " + this.workerID + ", send mergeSorter notification"));
                                    this.pipe.notifyAll();
                                }
                            }
                        }
                        after = Calendar.getInstance().getTimeInMillis();
                        logger.info((Object)("workerID: " + this.workerID + ", serialized " + resultChunk.size() + " objects in " + (after - before) + "ms."));
                        if (!this.flowControlled) continue;
                        MergeSortPipe mergeSortPipe = this.pipe;
                        synchronized (mergeSortPipe) {
                            logger.trace((Object)("workerID: " + this.workerID + ", lets see if we must wait on the pipe"));
                            if (this.pipe.isStoped()) {
                                logger.trace((Object)("workerID: " + this.workerID + ", pipe stopped, notify All"));
                                this.pipe.setInActive(this.workerID);
                                this.pipe.notifyAll();
                                break;
                            }
                            while (this.pipe.canWorkerPause(this.workerID) && !this.pipe.isStoped()) {
                                logger.trace((Object)("workerID: " + this.workerID + ", will pause"));
                                long bef = Calendar.getInstance().getTimeInMillis();
                                this.pipe.wait();
                                long aft = Calendar.getInstance().getTimeInMillis();
                                logger.trace((Object)("workerID: " + this.workerID + ", was waiting for: " + (aft - bef)));
                            }
                            if (this.pipe.isStoped()) {
                                logger.trace((Object)("workerID: " + this.workerID + ", pipe stopped, notify All"));
                                this.pipe.setInActive(this.workerID);
                                this.pipe.notifyAll();
                                break;
                            }
                        }
                    }
                    after = Calendar.getInstance().getTimeInMillis();
                    logger.info((Object)("workerID: " + this.workerID + ", handled all " + result.getTotalHitCount() + " objects in " + (after - before) + "ms."));
                    this.pipe.setInActive(this.workerID);
                    MergeSortPipe mergeSortPipe = this.pipe;
                    synchronized (mergeSortPipe) {
                        this.pipe.notifyAll();
                    }
                    after = Calendar.getInstance().getTimeInMillis();
                    logger.info((Object)("workerID: " + this.workerID + ", worker set as inactive"));
                    return;
                }
                logger.info((Object)("workerID: " + this.workerID + ", Found no objects in this one..."));
                if (!reachedTop) {
                    if (++j != this.index.size()) continue;
                    j = i - 1;
                    reachedTop = true;
                    continue;
                }
                --j;
            }
            logger.info((Object)("workerID: " + this.workerID + ", worker will exit"));
            this.pipe.setInActive(this.workerID);
            rTreeWrapper = this.pipe;
            synchronized (rTreeWrapper) {
                this.pipe.notifyAll();
            }
            logger.info((Object)("workerID: " + this.workerID + ", exited"));
        }
        catch (Exception e) {
            logger.error((Object)("workerID: " + this.workerID + ", Error while searching."), (Throwable)e);
            this.pipe.setInActive(this.workerID);
            MergeSortPipe mergeSortPipe = this.pipe;
            synchronized (mergeSortPipe) {
                this.pipe.notifyAll();
            }
            logger.info((Object)("workerID: " + this.workerID + ", exited after error."));
        }
    }

    private long getArea(Envelope a) {
        return new Double((a.getMaxX() - a.getMinX()) * (a.getMaxY() - a.getMinY())).longValue();
    }
}

