/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.geoindexlookup;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.events.KeyValueEvent;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.common.IndexType;
import org.gcube.indexmanagement.common.ThreadOwner;
import org.gcube.indexmanagement.common.dupelimination.ResultsIdentifierSet;
import org.gcube.indexmanagement.common.mergesort.MergeSortElement;
import org.gcube.indexmanagement.common.mergesort.MergeSortPipe;
import org.gcube.indexmanagement.geo.GeoGcqlCollectionQuery;
import org.gcube.indexmanagement.geo.GeoGcqlQueryContainer;
import org.gcube.indexmanagement.geo.GeoIndexType;
import org.gcube.indexmanagement.geo.RTreeWrapper;
import org.gcube.indexmanagement.geo.RankingRequest;
import org.gcube.indexmanagement.geo.RefinementRequest;
import org.gcube.indexmanagement.geo.ranking.RankEvaluator;
import org.gcube.indexmanagement.geo.ranking.RankEvaluatorInitializationException;
import org.gcube.indexmanagement.geo.refinement.Refiner;
import org.gcube.indexmanagement.geo.refinement.RefinerInitializationException;
import org.gcube.indexmanagement.geoindexlookup.GeoIndexLookupQNames;
import org.gcube.indexmanagement.geoindexlookup.GeoIndexLookupSearchWorker;
import org.gcube.indexmanagement.geoindexlookup.stubs.PluginInitializationException;
import org.gcube.indexmanagement.geoindexlookup.stubs.PluginNotFoundException;
import org.oasis.wsrf.faults.BaseFaultType;

public class GeoIndexLookupSearchMergeSorter
extends Thread {
    static GCUBELog logger = new GCUBELog(GeoIndexLookupSearchMergeSorter.class);
    private boolean flowControl;
    private HashMap<String, HashMap<String, Vector<RTreeWrapper>>> indices;
    private GeoGcqlQueryContainer CQLQuery;
    private int numberOfDecimals;
    private GeoIndexType indexType;
    private boolean isComplete;
    private RandomAccessFile rawData;
    public static final int PARTSIZE = 20;
    private static final long RSTIMEOUT = 10L;
    private RecordWriter<GenericRecord> rsWriter;
    private ThreadOwner owner;
    private HashMap<String, Class<? extends RankEvaluator>> rankers;
    private HashMap<String, Class<? extends Refiner>> refiners;
    private HashSet<String> badRankers;
    private HashSet<String> badRefiners;

    public GeoIndexLookupSearchMergeSorter(HashMap<String, HashMap<String, Vector<RTreeWrapper>>> indices, GeoGcqlQueryContainer CQLQuery, GeoIndexType indexType, int numberOfDecimals, boolean isComplete, RandomAccessFile rawData, RecordWriter<GenericRecord> rsWriter, ThreadOwner owner, HashMap<String, Class<? extends RankEvaluator>> rankers, HashMap<String, Class<? extends Refiner>> refiners, HashSet<String> badRankers, HashSet<String> badRefiners) throws Exception {
        this.indices = indices;
        this.CQLQuery = CQLQuery;
        this.numberOfDecimals = numberOfDecimals;
        this.indexType = indexType;
        this.isComplete = isComplete;
        this.rawData = rawData;
        this.owner = owner;
        this.rsWriter = rsWriter;
        this.rankers = rankers;
        this.refiners = refiners;
        this.badRankers = badRankers;
        this.badRefiners = badRefiners;
        this.flowControl = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int resultsRetrieved = 0;
        GeoGcqlQueryContainer.QueriesContainer queries = this.CQLQuery.getArrayOfQueries();
        int numberOfQueries = queries.getQueries().size();
        ResultsIdentifierSet resultsIdSet = new ResultsIdentifierSet();
        ArrayList<GeoIndexLookupSearchWorker> workers = new ArrayList<GeoIndexLookupSearchWorker>(numberOfQueries);
        MergeSortPipe pipe = new MergeSortPipe(numberOfQueries);
        logger.debug((Object)("Initializing " + numberOfQueries + " workers"));
        try {
            for (int i = 0; i < numberOfQueries; ++i) {
                String collectionID = (String)queries.getColIDs().get(i);
                String language = (String)queries.getLangs().get(i);
                GeoGcqlCollectionQuery colQuery = (GeoGcqlCollectionQuery)queries.getQueries().get(i);
                workers.add(this.createWorker(colQuery, collectionID, language, pipe, i, this.CQLQuery.getProjectedFields()));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception while workers were being initialized: ", (Throwable)e);
            return;
        }
        logger.debug((Object)"Workers initialized");
        MergeSortPipe e = pipe;
        synchronized (e) {
            if (!this.flowControl) {
                pipe.setGetUntil(-1L);
            } else {
                pipe.setGetUntil(20L);
            }
        }
        logger.debug((Object)("Starting " + workers.size() + " workers"));
        for (GeoIndexLookupSearchWorker worker : workers) {
            worker.start();
        }
        logger.debug((Object)"Workers started");
        try {
            MergeSortPipe i$;
            while (true) {
                i$ = pipe;
                synchronized (i$) {
                    while (pipe.canMergeSorterPause() && !pipe.isStoped()) {
                        logger.trace((Object)"MergeSorter will pause now ");
                        long before = Calendar.getInstance().getTimeInMillis();
                        pipe.wait();
                        long after = Calendar.getInstance().getTimeInMillis();
                        logger.trace((Object)("MergeSorter waken up after: " + (after - before) + " millisecs"));
                    }
                    logger.trace((Object)"Checking if all active queues are non empty");
                    while (pipe.areAllQueuesNonEmpty()) {
                        MergeSortElement element = pipe.getNext();
                        if (element != null) {
                            logger.trace((Object)("Got result back with id: " + ((StringField)element.getElement().getField(1)).getPayload()));
                            if (resultsIdSet.canSend(element.getLang(), element.getId())) {
                                if (IndexType.sendIndication((long)(++resultsRetrieved))) {
                                    this.rsWriter.emit((BufferEvent)new KeyValueEvent("resultsNumber", "" + resultsRetrieved));
                                }
                                while (!this.rsWriter.put((Record)element.getElement(), 10L, TimeUnit.SECONDS)) {
                                    if (this.rsWriter.getStatus() == IBuffer.Status.Open) continue;
                                    this.rsWriter.emit((BufferEvent)new KeyValueEvent("resultsNumberFinal", "" + resultsRetrieved));
                                    pipe.setStop();
                                    pipe.notifyAll();
                                    this.rsWriter.close();
                                    return;
                                }
                            }
                        } else {
                            logger.trace((Object)"No result - Probably all the results are retrieved");
                            break;
                        }
                        if (pipe.getResultsSent() < pipe.getGetUntil()) continue;
                        logger.trace((Object)("results sent: " + pipe.getResultsSent() + ", results asked: " + pipe.getGetUntil()));
                        break;
                    }
                    if (pipe.isStoped()) {
                        logger.trace((Object)"Pipe is stoped - all the results are retrieved");
                        break;
                    }
                    if (this.flowControl && pipe.getResultsSent() >= pipe.getGetUntil()) {
                        logger.trace((Object)("We will wait on the ResultSet controlflow since, pipe.getResultsSent(): " + pipe.getResultsSent() + ", pipe.getGetUntil(): " + pipe.getGetUntil()));
                        if (this.rsWriter.getStatus() != IBuffer.Status.Open) {
                            this.rsWriter.emit((BufferEvent)new KeyValueEvent("resultsNumberFinal", "" + resultsRetrieved));
                            pipe.setStop();
                            pipe.notifyAll();
                            this.rsWriter.close();
                            return;
                        }
                        logger.info((Object)"creating more results... ");
                        pipe.setGetUntil(pipe.getGetUntil() + 20L);
                    }
                    if (pipe.sendWorkersNotification()) {
                        logger.trace((Object)"send workers notification for producing more");
                        pipe.notifyAll();
                    }
                }
            }
            logger.trace((Object)"Finished..");
            i$ = pipe;
            synchronized (i$) {
                pipe.setStop();
                pipe.notifyAll();
            }
            this.rsWriter.emit((BufferEvent)new KeyValueEvent("resultsNumberFinal", "" + resultsRetrieved));
            logger.trace((Object)"Closing Result Set");
            this.rsWriter.close();
        }
        catch (Exception e3) {
            logger.error((Object)"exception while merging results: ", (Throwable)e3);
            MergeSortPipe element = pipe;
            synchronized (element) {
                pipe.setStop();
                pipe.notifyAll();
            }
            logger.trace((Object)"Lets close the Result Set");
            try {
                this.rsWriter.emit((BufferEvent)new KeyValueEvent("resultsNumberFinal", "" + resultsRetrieved));
                this.rsWriter.close();
            }
            catch (Exception e2) {
                logger.warn((Object)"Could not close ResultSet");
            }
        }
    }

    private GeoIndexLookupSearchWorker createWorker(GeoGcqlCollectionQuery colQuery, String collectionID, String language, MergeSortPipe pipe, int workerID, LinkedHashMap<String, String> projections) throws Exception {
        Refiner[] refinerPlugins;
        RankEvaluator ranker;
        try {
            RankingRequest rankerReq = colQuery.getRankRequest();
            RefinementRequest[] refinerReq = colQuery.getRefineRequests().toArray(new RefinementRequest[colQuery.getRefineRequests().size()]);
            if (rankerReq != null) {
                String rankerID = rankerReq.getRankerID();
                Class<? extends RankEvaluator> rankerClass = this.rankers.get(rankerReq.getRankerID());
                if (rankerClass == null) {
                    if (this.badRankers.contains(rankerReq.getRankerID())) {
                        PluginNotFoundException e = new PluginNotFoundException();
                        e.setPluginName(rankerID);
                        e.addFaultDetail(GeoIndexLookupQNames.FAULT_DETAIL_MISSING_PLUGIN, "\n\t\t\tThe ranking plugin [" + rankerID + "] installed is not compatible with this index' GeoIndexType[" + this.indexType.getIndexTypeName() + "]. Please use a different ranking plugin.");
                        throw e;
                    }
                    PluginNotFoundException e = new PluginNotFoundException();
                    e.setPluginName(rankerID);
                    e.addFaultDetail(GeoIndexLookupQNames.FAULT_DETAIL_MISSING_PLUGIN, "\n\t\t\tThe ranking plugin [" + rankerID + "] is not installed. Please contact the IndexManager.");
                    throw e;
                }
                ranker = rankerClass.newInstance();
                ranker.init(colQuery.getSearchPolygon(), colQuery.getInclusion(), Boolean.valueOf(rankerReq.isReverse()), this.indexType, rankerReq.getArgs());
            } else {
                ranker = null;
            }
            if (refinerReq != null) {
                refinerPlugins = new Refiner[refinerReq.length];
                for (int i = 0; i < refinerReq.length; ++i) {
                    Class<? extends Refiner> refinerClass = this.refiners.get(refinerReq[i].getRefinerID());
                    if (refinerClass == null) {
                        if (this.badRefiners.contains(refinerReq[i].getRefinerID())) {
                            PluginNotFoundException e = new PluginNotFoundException();
                            e.setPluginName(refinerReq[i].getRefinerID());
                            e.addFaultDetail(GeoIndexLookupQNames.FAULT_DETAIL_MISSING_PLUGIN, "\n\t\t\tThe refiner plugin [" + refinerReq[i].getRefinerID() + "] installed is not compatible with this index' GeoIndexType[" + this.indexType.getIndexTypeName() + "]. Please use a different ranking plugin.");
                            throw e;
                        }
                        PluginNotFoundException e = new PluginNotFoundException();
                        e.setPluginName(refinerReq[i].getRefinerID());
                        e.addFaultDetail(GeoIndexLookupQNames.FAULT_DETAIL_MISSING_PLUGIN, "\n\t\t\tThe refiner plugin [" + refinerReq[i].getRefinerID() + "] is not installed. Please contact the IndexManager.");
                        throw e;
                    }
                    refinerPlugins[i] = refinerClass.newInstance();
                    refinerPlugins[i].init(refinerReq[i].getPolygon(), refinerReq[i].getInclusion(), this.indexType, refinerReq[i].isNot(), refinerReq[i].getArgs());
                }
            } else {
                refinerPlugins = new Refiner[]{};
            }
        }
        catch (PluginNotFoundException pe) {
            logger.error((Object)"Search failed because a plugin was not found.", (Throwable)pe);
            throw pe;
        }
        catch (RankEvaluatorInitializationException ree) {
            logger.error((Object)"Search failed because the rank evaluator failed to initialize.", (Throwable)ree);
            PluginInitializationException pInitEx = new PluginInitializationException();
            pInitEx.setFaultString(ree.getFaultString());
            pInitEx.setFaultCause(new BaseFaultType[]{ree});
            throw pInitEx;
        }
        catch (RefinerInitializationException re) {
            logger.error((Object)"Search failed because the refiner failed to initialize.", (Throwable)re);
            PluginInitializationException pInitEx = new PluginInitializationException();
            pInitEx.setFaultString(re.getFaultString());
            pInitEx.setFaultCause(new BaseFaultType[]{re});
            throw pInitEx;
        }
        return new GeoIndexLookupSearchWorker(this.indices.get(collectionID).get(language), collectionID, language, colQuery.getSearchPolygon(), colQuery.getInclusion(), refinerPlugins, ranker, pipe, workerID, this.flowControl, this.indexType, this.numberOfDecimals, this.isComplete, this.rawData, projections);
    }
}

