/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.geoindexlookup;

import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.pool.PoolConfig;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.pool.PoolObjectConfig;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSWriterFactory;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.common.IndexLookupWSResource;
import org.gcube.indexmanagement.common.ThreadOwner;
import org.gcube.indexmanagement.geo.DataWrapper;
import org.gcube.indexmanagement.geo.GeoGcqlProcessor;
import org.gcube.indexmanagement.geo.GeoGcqlQueryContainer;
import org.gcube.indexmanagement.geo.GeoIndexField;
import org.gcube.indexmanagement.geo.GeoIndexType;
import org.gcube.indexmanagement.geo.RTreeWrapper;
import org.gcube.indexmanagement.geo.ranking.RankEvaluator;
import org.gcube.indexmanagement.geo.refinement.Refiner;
import org.gcube.indexmanagement.geoindexlookup.GeoIndexLookupConfig;
import org.gcube.indexmanagement.geoindexlookup.GeoIndexLookupFactoryService;
import org.gcube.indexmanagement.geoindexlookup.GeoIndexLookupSearchMergeSorter;
import org.gcube.indexmanagement.geoindexlookup.InitThread;
import org.gcube.indexmanagement.geoindexlookup.ServiceContext;
import org.gcube.indexmanagement.geoindexlookup.StatefulContext;
import org.gcube.indexmanagement.geoindexlookup.stubs.PluginArgumentType;
import org.gcube.indexmanagement.geoindexlookup.stubs.RefinerInfoType;
import org.gcube.indexmanagement.geoindexlookup.stubs.SorterInfoType;
import org.gcube.indexmanagement.geoindexmanagement.stubs.GeoIndexManagementPortType;
import org.gcube.indexmanagement.geoindexmanagement.stubs.GetIndexInformationResponse;
import org.gcube.indexmanagement.geoindexmanagement.stubs.RPChangeType;
import org.gcube.indexmanagement.geoindexmanagement.stubs.SharedStateChangeNotificationMessageType;
import org.gcube.indexmanagement.geoindexmanagement.stubs.StringArray;
import org.gcube.indexmanagement.geoindexmanagement.stubs.service.GeoIndexManagementServiceAddressingLocator;
import org.gcube.indexmanagement.resourceregistry.RRadaptor;
import org.gcube.indexmanagement.storagehandling.DeltaFileConsumer;
import org.gcube.indexmanagement.storagehandling.IndexReplicator;
import org.globus.wsrf.config.ContainerConfig;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.w3c.dom.Element;

public class GeoIndexLookupResource
extends IndexLookupWSResource
implements ThreadOwner,
IndexReplicator {
    static GCUBELog logger = new GCUBELog(GeoIndexLookupResource.class);
    private GeoIndexLookupConfig geoConfig;
    private static RSWriterFactory rsFactory = null;
    public static final String RP_GEOGRAPHICAL_SYSTEM = "GeographicalSystem";
    public static final String RP_UNIT_OF_MEASUREMENT = "UnitOfMeasurement";
    public static final String RP_NUMBER_OF_DECIMALS = "NumberOfDecimals";
    public static final String RP_SORTER_INFO = "SorterInfo";
    public static final String RP_REFINER_INFO = "RefinerInfo";
    public static final String RP_ISCOMPLETE = "IsComplete";
    protected static String[] RPNames;
    private GeoIndexType indexTypeObject = null;
    private HashMap<String, HashMap<String, Vector<RTreeWrapper>>> index = new HashMap();
    private RandomAccessFile rawData;
    private boolean usePyramid = false;
    private int indexLevelRatio = 4;
    private HashMap<String, HashMap<String, Long>> biggestMaxArea = new HashMap();
    private HashMap<String, HashMap<String, Long>> smallestMinArea = new HashMap();
    private HashMap<String, Class<? extends RankEvaluator>> rankers;
    private HashMap<String, Class<? extends Refiner>> refiners;
    private HashSet<String> badRankers;
    private HashSet<String> badRefiners;
    private String dirPath;
    private String pluginPath = "";
    private DeltaFileConsumer deltaConsumer;
    private boolean bReadyToDie = false;
    private ArrayList<String> presentableFields = new ArrayList();
    private ArrayList<String> searchableFields = new ArrayList();
    private static final int MAX_ATTEMPTS = 10;
    private static final long WAIT_PERIOD = 2000L;

    public void initialise(Object ... args) throws Exception {
        this.setIsInitializing(true);
        ArrayList<String> supportedRelations = new ArrayList<String>();
        for (RTreeWrapper.SupportedRelations supportedRelations2 : RTreeWrapper.SupportedRelations.values()) {
            supportedRelations.add(supportedRelations2.toString());
        }
        super.initialise(StatefulContext.getPortTypeContext().getNamespace(), "http://gcube-system.org/namespaces/indexmanagement/GeoIndexManagementService", (String)args[1], (String)args[2], (String[])args[3], ServiceContext.getContext().getPersistenceRoot().getAbsolutePath() + "/delta/" + ((GCUBEWSResourceKey)this.getID()).getValue() + "/", supportedRelations.toArray(new String[supportedRelations.size()]));
        this.geoConfig = (GeoIndexLookupConfig)StatefulContext.getPortTypeContext().getProperty("config", new boolean[]{false});
        if (this.geoConfig != null) {
            logger.debug((Object)("Geo Index Lookup Config:\n   isCompleteBlocked: " + this.geoConfig.getIsCompleteBlocked() + "\n   number of nonCompleteColIDs: " + this.geoConfig.getNonCompleteColIDs().size()));
        }
        this.deltaConsumer = new DeltaFileConsumer((IndexLookupWSResource)this, (IndexReplicator)this, 0);
        try {
            for (String string : RPNames) {
                this.createProperty(string);
            }
            this.setIndexTypeID((String)args[2]);
            this.setGeographicalSystem((String)args[4]);
            this.setUnitOfMeasurement((String)args[5]);
            this.setNumberOfDecimals((Integer)args[6]);
            if ((Integer)args[6] >= 0) {
                this.setNumberOfDecimals((Integer)args[6]);
            } else {
                this.setNumberOfDecimals(0);
            }
        }
        catch (Exception exception) {
            logger.error((Object)"exception while initializing the geo lookup properties: ", (Throwable)exception);
            throw new RuntimeException(exception.getMessage());
        }
        this.dirPath = ServiceContext.getContext().getPersistenceRoot().getAbsolutePath() + "/rtree/";
        File file = new File(this.dirPath);
        file.mkdirs();
        this.rawData = new RandomAccessFile(this.dirPath + ((GCUBEWSResourceKey)this.getID()).getValue() + ".raw", "rw");
        this.pluginPath = ContainerConfig.getBaseDirectory() + "/etc/org.gcube.indexmanagement.geoindexlookup/plugins/";
        this.loadAllPlugins();
        this.setIsInitializing(false);
    }

    public synchronized void onStore(ObjectOutputStream oos) throws Exception {
        try {
            super.onStore(oos);
            oos.writeObject(this.getResourcePropertySet().get(RP_GEOGRAPHICAL_SYSTEM).get(0));
            oos.writeObject(this.getResourcePropertySet().get(RP_UNIT_OF_MEASUREMENT).get(0));
            oos.writeInt((Integer)this.getResourcePropertySet().get(RP_NUMBER_OF_DECIMALS).get(0));
            oos.writeObject((SorterInfoType)this.getResourcePropertySet().get(RP_SORTER_INFO).get(0));
            oos.writeObject((RefinerInfoType)this.getResourcePropertySet().get(RP_REFINER_INFO).get(0));
            oos.writeBoolean(this.usePyramid);
            oos.writeInt(this.indexLevelRatio);
            this.storeArea(oos, this.biggestMaxArea);
            this.storeArea(oos, this.smallestMinArea);
            oos.writeObject(this.dirPath);
            oos.writeObject(this.pluginPath);
            this.storeRTrees(oos, this.index);
            this.deltaConsumer.storeState(oos);
        }
        catch (Exception e) {
            logger.error((Object)"error on store: ", (Throwable)e);
            throw e;
        }
    }

    private void storeArea(ObjectOutputStream oos, HashMap<String, HashMap<String, Long>> area) throws Exception {
        oos.writeInt(area.size());
        for (Map.Entry<String, HashMap<String, Long>> current : area.entrySet()) {
            String colID = current.getKey();
            oos.writeObject(colID);
            HashMap<String, Long> langMap = current.getValue();
            oos.writeInt(langMap.size());
            for (Map.Entry<String, Long> currentLang : langMap.entrySet()) {
                String lang = currentLang.getKey();
                oos.writeObject(lang);
                oos.writeLong(currentLang.getValue());
            }
        }
    }

    private void loadArea(ObjectInputStream ois, HashMap<String, HashMap<String, Long>> area) throws Exception {
        int ids = ois.readInt();
        for (int i = 0; i < ids; ++i) {
            String colID = (String)ois.readObject();
            HashMap<String, Long> langMap = new HashMap<String, Long>();
            area.put(colID, langMap);
            int langs = ois.readInt();
            for (int j = 0; j < langs; ++j) {
                String language = (String)ois.readObject();
                Long areaValue = ois.readLong();
                langMap.put(language, areaValue);
            }
        }
    }

    private void storeRTrees(ObjectOutputStream oos, HashMap<String, HashMap<String, Vector<RTreeWrapper>>> indexMap) throws Exception {
        oos.writeInt(indexMap.size());
        for (Map.Entry<String, HashMap<String, Vector<RTreeWrapper>>> current : indexMap.entrySet()) {
            String colID = current.getKey();
            oos.writeObject(colID);
            HashMap<String, Vector<RTreeWrapper>> langMap = current.getValue();
            oos.writeInt(langMap.size());
            for (Map.Entry<String, Vector<RTreeWrapper>> currentLang : langMap.entrySet()) {
                String lang = currentLang.getKey();
                oos.writeObject(lang);
                Vector<RTreeWrapper> currentIndex = currentLang.getValue();
                if (currentIndex != null) {
                    oos.writeInt(currentIndex.size());
                    for (RTreeWrapper rt : currentIndex) {
                        oos.writeObject(rt.getIndexFile());
                        oos.writeLong(rt.getMaxArea());
                    }
                    continue;
                }
                oos.writeInt(0);
            }
        }
    }

    private void loadRTrees(ObjectInputStream ois, HashMap<String, HashMap<String, Vector<RTreeWrapper>>> indexMap) throws Exception {
        int ids = ois.readInt();
        for (int i = 0; i < ids; ++i) {
            String colID = (String)ois.readObject();
            HashMap langMap = new HashMap();
            indexMap.put(colID, langMap);
            int langs = ois.readInt();
            for (int j = 0; j < langs; ++j) {
                Vector<RTreeWrapper> indices;
                String language = (String)ois.readObject();
                int numIndexParts = ois.readInt();
                if (numIndexParts == 0) {
                    indices = null;
                } else {
                    indices = new Vector<RTreeWrapper>(numIndexParts);
                    for (int k = 0; k < numIndexParts; ++k) {
                        indices.add(new RTreeWrapper(new File((String)ois.readObject()), this.indexTypeObject, ois.readLong(), this.rawData));
                    }
                }
                langMap.put(language, indices);
            }
        }
    }

    public synchronized void onLoad(ObjectInputStream ois, boolean firstLoad) throws Exception {
        try {
            this.setIsInitializing(true);
            super.onLoad(ois, firstLoad);
            ArrayList<String> supportedRelations = new ArrayList<String>();
            for (RTreeWrapper.SupportedRelations supportedRelations2 : RTreeWrapper.SupportedRelations.values()) {
                supportedRelations.add(supportedRelations2.toString());
            }
            this.setSupportedRelations(supportedRelations.toArray(new String[supportedRelations.size()]));
            this.geoConfig = (GeoIndexLookupConfig)StatefulContext.getPortTypeContext().getProperty("config", new boolean[]{false});
            if (this.geoConfig != null) {
                logger.debug((Object)("Geo Index Lookup Config:\n   isCompleteBlocked: " + this.geoConfig.getIsCompleteBlocked() + "\n   number of nonCompleteColIDs: " + this.geoConfig.getNonCompleteColIDs().size()));
            }
            for (String string : RPNames) {
                this.createProperty(string);
            }
            this.setGeographicalSystem((String)ois.readObject());
            this.setUnitOfMeasurement((String)ois.readObject());
            this.setNumberOfDecimals(ois.readInt());
            this.setSorterInfo((SorterInfoType)ois.readObject());
            this.setRefinerInfo((RefinerInfoType)ois.readObject());
            this.setIndexTypeID(this.getIndexTypeName());
            this.usePyramid = ois.readBoolean();
            this.indexLevelRatio = ois.readInt();
            this.loadArea(ois, this.biggestMaxArea);
            this.loadArea(ois, this.smallestMinArea);
            this.dirPath = (String)ois.readObject();
            this.rawData = new RandomAccessFile(this.dirPath + ((GCUBEWSResourceKey)this.getID()).getValue() + ".raw", "rw");
            this.pluginPath = (String)ois.readObject();
            this.loadAllPlugins();
            this.loadRTrees(ois, this.index);
            this.deltaConsumer = new DeltaFileConsumer();
            this.deltaConsumer.loadState(ois, firstLoad, (IndexLookupWSResource)this, (IndexReplicator)this, 0);
            this.updateFields();
            this.setIsInitializing(false);
        }
        catch (Exception e) {
            logger.error((Object)"error on load: ", (Throwable)e);
            throw e;
        }
    }

    private void checkIsComplete() throws Exception {
        GeoIndexField[] fields = this.indexTypeObject.fields;
        this.setIsComplete(false);
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].name.equalsIgnoreCase("fullpayload")) continue;
            if (!fields[i].isReturnable || !fields[i].dataType.equals((Object)GeoIndexField.DataType.STRING)) {
                String msg = "wrong configuration for index type: " + this.getIndexTypeName() + ". fullpayload field has return: " + fields[i].isReturnable + ", store: " + fields[i].dataType;
                logger.error((Object)msg);
                throw new Exception(msg);
            }
            this.setIsComplete(true);
        }
        if (this.geoConfig.getIsCompleteBlocked().booleanValue()) {
            logger.info((Object)"This Lookup RI has the completeBlocked flag raised so this Lookup resource will be marked as not complete");
            this.setIsComplete(false);
        }
        for (String colID : this.getCollectionID()) {
            if (!this.geoConfig.getNonCompleteColIDs().contains(colID.trim())) continue;
            logger.info((Object)("This Lookup RI has marked colID: " + colID + " as nonComplete, so this Lookup resource will be marked as not complete"));
            this.setIsComplete(false);
        }
    }

    public void loadPlugins() {
        this.loadAllPlugins();
    }

    public SorterInfoType getSorterInfo() {
        return (SorterInfoType)this.getResourcePropertySet().get(RP_SORTER_INFO).get(0);
    }

    public RefinerInfoType getRefinerInfo() {
        return (RefinerInfoType)this.getResourcePropertySet().get(RP_REFINER_INFO).get(0);
    }

    public String getGeographicalSystem() {
        return (String)this.getResourcePropertySet().get(RP_GEOGRAPHICAL_SYSTEM).get(0);
    }

    public String getUnitOfMeasurement() {
        return (String)this.getResourcePropertySet().get(RP_UNIT_OF_MEASUREMENT).get(0);
    }

    public Integer getNumberOfDecimals() {
        return (Integer)this.getResourcePropertySet().get(RP_NUMBER_OF_DECIMALS).get(0);
    }

    public Boolean getIsComplete() {
        return (Boolean)this.getResourcePropertySet().get(RP_ISCOMPLETE).get(0);
    }

    public synchronized void setIsComplete(Boolean IsComplete) throws Exception {
        this.getResourcePropertySet().get(RP_ISCOMPLETE).clear();
        this.getResourcePropertySet().get(RP_ISCOMPLETE).add((Object)IsComplete);
    }

    public synchronized void setGeographicalSystem(String geographicalSystem) {
        this.getResourcePropertySet().get(RP_GEOGRAPHICAL_SYSTEM).clear();
        this.getResourcePropertySet().get(RP_GEOGRAPHICAL_SYSTEM).add((Object)geographicalSystem);
    }

    public synchronized void setUnitOfMeasurement(String unitOfMeasurement) {
        this.getResourcePropertySet().get(RP_UNIT_OF_MEASUREMENT).clear();
        this.getResourcePropertySet().get(RP_UNIT_OF_MEASUREMENT).add((Object)unitOfMeasurement);
    }

    public synchronized void setNumberOfDecimals(Integer numberOfDecimals) {
        this.getResourcePropertySet().get(RP_NUMBER_OF_DECIMALS).clear();
        this.getResourcePropertySet().get(RP_NUMBER_OF_DECIMALS).add((Object)numberOfDecimals);
    }

    public synchronized void setSorterInfo(SorterInfoType sorterInfo) {
        this.getResourcePropertySet().get(RP_SORTER_INFO).clear();
        this.getResourcePropertySet().get(RP_SORTER_INFO).add((Object)sorterInfo);
    }

    public synchronized void setRefinerInfo(RefinerInfoType refinerInfo) {
        this.getResourcePropertySet().get(RP_REFINER_INFO).clear();
        this.getResourcePropertySet().get(RP_REFINER_INFO).add((Object)refinerInfo);
    }

    public synchronized void setIndexTypeID(String indexTypeID) throws Exception {
        super.setIndexTypeName(indexTypeID);
        this.indexTypeObject = new GeoIndexType(indexTypeID, ServiceContext.getContext().getScope());
        this.checkIsComplete();
    }

    public boolean isReadyToDie() {
        return this.bReadyToDie;
    }

    public String search(String cqlQuery, boolean noncomplete) throws Exception {
        boolean indication = noncomplete;
        boolean completePayload = false;
        logger.debug((Object)("found indication " + indication + ". The lookup is built as: " + this.getIsComplete()));
        if (!this.getIsComplete().booleanValue() && !indication) {
            logger.error((Object)"The lookup resource is called for complete results, while it wasn't built as complete");
            completePayload = false;
        }
        if (this.getIsComplete().booleanValue() && !indication) {
            logger.debug((Object)"The lookup resource is called for complete results");
            completePayload = true;
        }
        if (!this.getIsComplete().booleanValue() && indication) {
            logger.debug((Object)"The lookup resource is called for noncomplete results");
            completePayload = false;
        }
        if (this.getIsComplete().booleanValue() && indication) {
            logger.info((Object)"The lookup resource is called for noncomplete results, while it was built as complete");
            completePayload = false;
        }
        RecordWriter rsWriter = null;
        String locator = null;
        try {
            logger.info((Object)(this.getID() + " received query at: " + Calendar.getInstance().getTime()));
            logger.info((Object)(this.getID() + " gCQL query: " + cqlQuery));
            GeoGcqlProcessor processor = new GeoGcqlProcessor();
            processor.setNumberOfDecimals(this.getNumberOfDecimals());
            processor.setCurrentColLangPairs(this.index);
            RRadaptor adaptor = new RRadaptor(ServiceContext.getContext().getScope().toString());
            GeoGcqlQueryContainer query = (GeoGcqlQueryContainer)processor.processQuery(this.presentableFields, this.searchableFields, cqlQuery, adaptor);
            FieldDefinition[] fieldDef = this.createFieldDefinition(query.getProjectedFields(), noncomplete, adaptor);
            RecordDefinition[] definition = new RecordDefinition[]{new GenericRecordDefinition(fieldDef)};
            rsWriter = new RecordWriter((IWriterProxy)new TCPWriterProxy(), definition);
            GeoIndexLookupSearchMergeSorter mergeSorter = new GeoIndexLookupSearchMergeSorter(this.index, query, this.indexTypeObject, this.getNumberOfDecimals(), completePayload, this.rawData, (RecordWriter<GenericRecord>)rsWriter, this, this.rankers, this.refiners, this.badRankers, this.badRefiners);
            mergeSorter.setPriority(1);
            mergeSorter.setDaemon(true);
            InitThread.init(mergeSorter);
            mergeSorter.start();
            locator = rsWriter.getLocator().toString();
        }
        catch (Exception e) {
            logger.error((Object)"Search query execution failed. ", (Throwable)e);
            throw e;
        }
        return locator;
    }

    private FieldDefinition[] createFieldDefinition(LinkedHashMap<String, String> projections, boolean nonComplete, RRadaptor adaptor) {
        ArrayList<StringFieldDefinition> fieldDef = new ArrayList<StringFieldDefinition>();
        fieldDef.add(new StringFieldDefinition("rank"));
        fieldDef.add(new StringFieldDefinition("ObjectID"));
        if (nonComplete) {
            if (projections != null && projections.size() > 0) {
                for (Map.Entry<String, String> current : projections.entrySet()) {
                    String proj = current.getValue();
                    String fieldId = current.getKey();
                    Integer pos = this.indexTypeObject.getFieldPosition(proj);
                    if (pos == null) {
                        logger.warn((Object)("projection: " + proj + ", is not part of the geo index type"));
                        if (!proj.equalsIgnoreCase("ratio") && !proj.equalsIgnoreCase("gDocCollectionLang") && !proj.equalsIgnoreCase("gDocCollectionID") && !proj.equalsIgnoreCase("apxcount") && !proj.equalsIgnoreCase("docNr") && !proj.equalsIgnoreCase("mbr")) continue;
                        fieldDef.add(new StringFieldDefinition(fieldId));
                        continue;
                    }
                    GeoIndexField field = this.indexTypeObject.fields[pos];
                    if (field.isReturnable) {
                        fieldDef.add(new StringFieldDefinition(fieldId));
                        continue;
                    }
                    logger.error((Object)("projection: " + proj + ", is not defined as returnable in the geo index type"));
                }
                if (fieldDef.size() == 2) {
                    logger.error((Object)" no valid projection ");
                }
            }
        } else {
            fieldDef.add(new StringFieldDefinition("fullpayload"));
        }
        return fieldDef.toArray(new FieldDefinition[fieldDef.size()]);
    }

    private RTreeWrapper makeIndexPart(String path, long maxArea) throws Exception {
        File indexFile = new File(path);
        logger.info((Object)("New indexPart -- maxArea = " + maxArea));
        return new RTreeWrapper(indexFile, this.indexTypeObject, maxArea, this.rawData);
    }

    private void loadAllPlugins() {
        this.refiners = new HashMap();
        this.rankers = new HashMap();
        this.badRefiners = new HashSet();
        this.badRankers = new HashSet();
        this.getResourcePropertySet().get(RP_REFINER_INFO).clear();
        this.getResourcePropertySet().get(RP_SORTER_INFO).clear();
        logger.info((Object)"Removed loaded plugins.");
        File pluginDir = new File(this.pluginPath);
        pluginDir.mkdirs();
        this.loadAllPlugins(pluginDir);
    }

    private void loadAllPlugins(File pluginDir) {
        File[] files = pluginDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            try {
                logger.debug((Object)("Plugin loader found file: " + files[i].getName()));
                if (files[i].isFile()) {
                    if (!files[i].getName().endsWith(".jar")) continue;
                    URLClassLoader loader = new URLClassLoader(new URL[]{files[i].toURI().toURL()}, Refiner.class.getClassLoader());
                    List<PluginInfo> pluginList = this.getPluginInfo(files[i]);
                    for (PluginInfo plugin : pluginList) {
                        this.loadPlugin(loader, plugin);
                    }
                    continue;
                }
                if (!files[i].isDirectory()) continue;
                this.loadAllPlugins(files[i]);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"Error while loading plugins.", (Throwable)e);
            }
        }
    }

    private void loadPlugin(URLClassLoader loader, PluginInfo plugin) throws Exception {
        if (plugin.isValid()) {
            if (plugin.getType().equalsIgnoreCase("Refiner")) {
                Class<?> extendedRefiner = loader.loadClass(plugin.getClassName());
                if (((Refiner)extendedRefiner.newInstance()).isIndexTypeCompatible(this.indexTypeObject)) {
                    this.refiners.put(plugin.getName(), extendedRefiner);
                } else {
                    this.badRefiners.add(plugin.getName());
                }
                RefinerInfoType info = new RefinerInfoType();
                info.setRefinerName(plugin.getName());
                info.setRefinerClassName(plugin.getClassName());
                info.setRefinerDescription(plugin.getDescription());
                info.setRefinerVersion(Double.valueOf(plugin.getVersion()));
                info.setRefinerArguments(plugin.getArguments());
                this.setRefinerInfo(info);
                logger.info((Object)"Loaded Refiner plugin: ");
                logger.info((Object)plugin);
                logger.info((Object)"Attributes used: ");
                for (PluginArgumentType attribute : plugin.getArguments()) {
                    logger.info((Object)(attribute.getArgumentName() + " (typehint: " + attribute.getArgumentTypeHint() + ")  "));
                }
            } else if (plugin.getType().equalsIgnoreCase("RankEvaluator")) {
                Class<?> extendedRanker = loader.loadClass(plugin.getClassName());
                if (((RankEvaluator)extendedRanker.newInstance()).isIndexTypeCompatible(this.indexTypeObject)) {
                    this.rankers.put(plugin.getName(), extendedRanker);
                } else {
                    this.badRankers.add(plugin.getName());
                }
                SorterInfoType info = new SorterInfoType();
                info.setSorterName(plugin.getName());
                info.setSorterClassName(plugin.getClassName());
                info.setSorterDescription(plugin.getDescription());
                info.setSorterVersion(Double.valueOf(plugin.getVersion()));
                info.setSorterArguments(plugin.getArguments());
                this.setSorterInfo(info);
                logger.info((Object)"Loaded Sorter plugin: ");
                logger.info((Object)plugin);
                logger.info((Object)"Attributes used: ");
                for (PluginArgumentType attribute : plugin.getArguments()) {
                    logger.info((Object)(attribute.getArgumentName() + " (typehint: " + attribute.getArgumentTypeHint() + ")  "));
                }
            }
        } else {
            logger.info((Object)"Could not load plugin; Not valid:");
            logger.info((Object)plugin);
        }
    }

    private List<PluginInfo> getPluginInfo(File jarFile) throws Exception {
        JarFile jar = new JarFile(jarFile);
        ArrayList<PluginInfo> plugins = new ArrayList<PluginInfo>();
        Map<String, Attributes> properties = jar.getManifest().getEntries();
        Set<String> pluginFiles = properties.keySet();
        for (String pluginPath : pluginFiles) {
            if (!pluginPath.endsWith(".class")) continue;
            PluginInfo pluginInfo = new PluginInfo(properties.get(pluginPath).getValue("PluginName"), pluginPath.replace('/', '.').substring(0, pluginPath.lastIndexOf(".class")), properties.get(pluginPath).getValue("PluginType"), properties.get(pluginPath).getValue("PluginVersion"), properties.get(pluginPath).getValue("PluginAttributes"), properties.get(pluginPath).getValue("PluginDescription"));
            plugins.add(pluginInfo);
            logger.info((Object)("Found plugin: " + pluginInfo.getName()));
        }
        return plugins;
    }

    public synchronized void mergeAddition(File file, String cmsID, int docCount) throws IndexException {
        logger.debug((Object)("Adding deltafile of size:" + file.length()));
        this.waitUntilInitialized();
        logger.debug((Object)"After waiting for Initialization");
        try {
            DataWrapper geoData;
            FileChannel inChannel = new FileInputStream(file).getChannel();
            int numNewDocs = 0;
            while ((geoData = DataWrapper.getInstance((GeoIndexType)this.indexTypeObject, (ReadableByteChannel)inChannel, (RandomAccessFile)this.rawData)) != null) {
                this.addEntry(geoData);
                ++numNewDocs;
            }
            inChannel.close();
            this.changeDocumentCount(numNewDocs);
            this.setModified(Calendar.getInstance());
            this.updateFields();
        }
        catch (Exception e) {
            logger.error((Object)"Error while merging addition.", (Throwable)e);
            throw new IndexException((Throwable)e);
        }
    }

    public void mergeDeletion(File file, String cmsID, int docCount) throws IndexException {
    }

    public void clearIndex() throws IndexException {
        this.deleteIndexFiles();
        this.setDocumentCount(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntry(DataWrapper geoData) throws IndexException {
        try {
            HashMap<String, Vector<Object>> colIndex;
            HashMap<String, Long> colBMaxA;
            String colID = geoData.getColID();
            String colLang = geoData.getColLang();
            HashMap<String, Long> colSMinA = this.smallestMinArea.get(colID);
            if (colSMinA == null) {
                colSMinA = new HashMap();
                this.smallestMinArea.put(colID, colSMinA);
            }
            if ((colBMaxA = this.biggestMaxArea.get(colID)) == null) {
                colBMaxA = new HashMap();
                this.biggestMaxArea.put(colID, colBMaxA);
            }
            if ((colIndex = this.index.get(colID)) == null) {
                colIndex = new HashMap();
                this.index.put(colID, colIndex);
            }
            Vector<Object> colRtree = colIndex.get(colLang);
            long area = this.getArea(geoData);
            RTreeWrapper indexPart = null;
            if (colRtree == null) {
                Long sMinA;
                colRtree = new Vector();
                if (this.usePyramid) {
                    sMinA = 2L * area / (long)(1 + this.indexLevelRatio);
                    colSMinA.put(colLang, sMinA);
                    Long bMaxA = sMinA * (long)this.indexLevelRatio;
                    colBMaxA.put(colLang, bMaxA);
                } else {
                    sMinA = new Long(0L);
                    Long bMaxA = Long.MAX_VALUE;
                    colSMinA.put(colLang, sMinA);
                    colBMaxA.put(colLang, bMaxA);
                }
                indexPart = this.makeIndexPart(this.dirPath + ((GCUBEWSResourceKey)this.getID()).getValue() + ".rtree" + colID + colLang + "0", colBMaxA.get(colLang));
                colRtree.add(indexPart);
                colIndex.put(colLang, colRtree);
            } else if (area >= colSMinA.get(colLang)) {
                if (area < colBMaxA.get(colLang)) {
                    for (int i = 0; i < colRtree.size() && area >= (indexPart = (RTreeWrapper)colRtree.get(i)).getMaxArea(); ++i) {
                    }
                } else {
                    while (area >= colBMaxA.get(colLang)) {
                        colBMaxA.put(colLang, colBMaxA.get(colLang) * (long)this.indexLevelRatio);
                        indexPart = this.makeIndexPart(this.dirPath + ((GCUBEWSResourceKey)this.getID()).getValue() + ".rtree" + colID + colLang + colRtree.size(), colBMaxA.get(colLang));
                        colRtree.add(indexPart);
                    }
                }
            } else {
                while (area < colSMinA.get(colLang)) {
                    indexPart = this.makeIndexPart(this.dirPath + ((GCUBEWSResourceKey)this.getID()).getValue() + ".rtree" + colID + colLang + colRtree.size(), colSMinA.get(colLang));
                    colRtree.add(0, indexPart);
                    colSMinA.put(colLang, colSMinA.get(colLang) / (long)this.indexLevelRatio);
                }
            }
            RTreeWrapper rTreeWrapper = indexPart;
            synchronized (rTreeWrapper) {
                indexPart.insert(geoData);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while adding entry.", (Throwable)e);
            throw new IndexException((Throwable)e);
        }
    }

    private long getArea(DataWrapper d) {
        return (d.getMaxX() - d.getMinX()) * (d.getMaxY() - d.getMinY());
    }

    public void onResourceRemoval() {
        try {
            super.onResourceRemoval();
            try {
                File deltaDir = new File(this.getIndexDataDirectory());
                File parentDir = deltaDir.getParentFile();
                deltaDir.delete();
                parentDir.delete();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.deleteIndexFiles();
            this.deltaConsumer.close();
            this.bReadyToDie = true;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to remove index lookup resource.", (Throwable)e);
        }
    }

    private void deleteIndexFiles() {
        File dataDir = new File(this.dirPath);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(((GCUBEWSResourceKey)GeoIndexLookupResource.this.getID()).getValue());
            }
        };
        for (File f : dataDir.listFiles(filter)) {
            logger.debug((Object)("Deleting file: " + f.getAbsolutePath()));
            f.delete();
        }
        this.index.clear();
    }

    public void onLookupNotificationReceived(Element message) {
        try {
            RPChangeType[] changes;
            SharedStateChangeNotificationMessageType notification = (SharedStateChangeNotificationMessageType)ObjectDeserializer.toObject((Element)message, SharedStateChangeNotificationMessageType.class);
            for (RPChangeType change : changes = notification.getChangedRPs()) {
                QName rpName = change.getRPName();
                if (!rpName.getLocalPart().equals("CollectionID")) continue;
                logger.debug((Object)(this.getID() + " adding CollectionID: " + change.getNewValue()));
                this.addCollectionID(change.getNewValue());
                this.store();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception while handling notification:" + message + " delivered to " + this.getIndexID() + "(" + this.getID() + ")"), (Throwable)e);
        }
    }

    private void updateFields() {
        int attempts;
        List<EndpointReferenceType> mgmtEprs = null;
        for (attempts = 0; (mgmtEprs == null || mgmtEprs.size() == 0) && attempts < 10; ++attempts) {
            try {
                LinkedList<String[]> props = new LinkedList<String[]>();
                props.add(new String[]{"IndexID", this.getIndexID()});
                mgmtEprs = GeoIndexLookupFactoryService.getWSResourceEPRsFromPropValuesAndNamespace(props, "http://gcube-system.org/namespaces/indexmanagement/GeoIndexManagementService", ServiceContext.getContext().getScope());
            }
            catch (Exception e) {
                logger.error((Object)("Failed to query the IS for index management resources with IndexID = " + this.getIndexID()), (Throwable)e);
            }
            if (mgmtEprs != null && mgmtEprs.size() > 0) break;
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (Exception e) {
                logger.warn((Object)"exception while sleeping: ", (Throwable)e);
                return;
            }
        }
        if (mgmtEprs == null || mgmtEprs.size() == 0) {
            logger.error((Object)("Failed to find a Manager for IndexID = " + this.getIndexID()));
            return;
        }
        GeoIndexManagementServiceAddressingLocator IndexManagementInstanceLocator = new GeoIndexManagementServiceAddressingLocator();
        GeoIndexManagementPortType IndexManagementInstance = null;
        try {
            IndexManagementInstance = IndexManagementInstanceLocator.getGeoIndexManagementPortTypePort((EndpointReferenceType)mgmtEprs.get(0));
            IndexManagementInstance = (GeoIndexManagementPortType)GCUBERemotePortTypeContext.getProxy((Remote)IndexManagementInstance, (GCUBEScope)ServiceContext.getContext().getScope(), (GCUBESecurityManager[])new GCUBESecurityManager[]{ServiceContext.getContext()});
        }
        catch (Exception e) {
            logger.error((Object)"Unable to get the portType for the Manager.", (Throwable)e);
            return;
        }
        attempts = 0;
        while (attempts < 10) {
            try {
                GetIndexInformationResponse response = IndexManagementInstance.getIndexInformation(new VOID());
                StringArray fields = response.getFields();
                if (fields == null) {
                    logger.warn((Object)"fields retrieved from IndexManagement is null");
                } else {
                    logger.debug((Object)("fields retrieved from IndexManagement: " + Arrays.toString(fields.getArray())));
                }
                this.setFields(fields.getArray());
                Object[] colIDs = response.getCollectionID().getArray();
                if (colIDs == null) {
                    logger.warn((Object)"colIDs retrieved from IndexManagement is null");
                } else {
                    logger.debug((Object)("colIDs retrieved from IndexManagement: " + Arrays.toString(colIDs)));
                }
                this.setCollectionID((String[])colIDs);
                break;
            }
            catch (Exception e) {
                logger.error((Object)("could not get field info after the " + attempts + "st/nd/rd/th attempt from manager: "), (Throwable)e);
                if (++attempts != 10) continue;
                logger.error((Object)"could not get field info from manager. Aborting..");
                return;
            }
        }
        this.filterFieldInfo(this.presentableFields, this.searchableFields);
    }

    static {
        PoolConfig config = new PoolConfig();
        try {
            PoolObjectConfig rsWriterConfig = (PoolObjectConfig)StatefulContext.getPortTypeContext().getProperty("rsWriterPoolConfig", new boolean[0]);
            config.add(rsWriterConfig);
            logger.debug((Object)"RSWriter configuration successfully retrieved.");
        }
        catch (Exception e) {
            logger.error((Object)"Trouble initializing factory pool configuration. Continuing with empty config.", (Throwable)e);
        }
        rsFactory = new RSWriterFactory(config);
        RPNames = new String[]{RP_GEOGRAPHICAL_SYSTEM, RP_UNIT_OF_MEASUREMENT, RP_NUMBER_OF_DECIMALS, RP_SORTER_INFO, RP_REFINER_INFO, RP_ISCOMPLETE};
    }

    private class PluginInfo {
        private String pluginName;
        private String pluginClass;
        private String pluginType;
        private String pluginDescription;
        private PluginArgumentType[] arguments;
        private double pluginVersion;

        public PluginInfo(String pluginName, String pluginClass, String pluginType, String pluginVersion, String combinedAttributes, String pluginDescription) {
            this.pluginName = pluginName;
            this.pluginClass = pluginClass;
            this.pluginType = pluginType;
            this.pluginVersion = 0.0;
            if (combinedAttributes == null || combinedAttributes.trim().equals("")) {
                this.arguments = new PluginArgumentType[0];
            } else {
                String[] attrStrings = combinedAttributes.split(",");
                this.arguments = new PluginArgumentType[attrStrings.length];
                for (int i = 0; i < attrStrings.length; ++i) {
                    int seperator = attrStrings[i].indexOf(58);
                    this.arguments[i] = seperator == -1 ? new PluginArgumentType(attrStrings[i], "default") : new PluginArgumentType(attrStrings[i].substring(0, seperator), attrStrings[i].substring(seperator + 1));
                }
            }
            this.pluginDescription = pluginDescription;
            try {
                this.pluginVersion = Double.parseDouble(pluginVersion);
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        public String getName() {
            return this.pluginName;
        }

        public String getClassName() {
            return this.pluginClass;
        }

        public String getType() {
            return this.pluginType;
        }

        public double getVersion() {
            return this.pluginVersion;
        }

        public PluginArgumentType[] getArguments() {
            return this.arguments;
        }

        public String getDescription() {
            return this.pluginDescription;
        }

        public boolean isValid() {
            return this.pluginName != null && this.pluginClass != null && this.pluginType != null;
        }

        public String toString() {
            return new StringBuffer("PluginInfo[ pluginName: ").append(this.pluginName).append(" -- pluginClass: ").append(this.pluginClass).append(" -- pluginType: ").append(this.pluginType).append(" -- pluginVersion: ").append(this.pluginVersion).append(" ]").toString();
        }
    }
}

