/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.geoindexlookup;

import java.rmi.Remote;
import java.util.LinkedList;
import java.util.List;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetrySameFault;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.geoindexlookup.ServiceContext;
import org.gcube.indexmanagement.geoindexlookup.StatefulContext;
import org.gcube.indexmanagement.geoindexlookup.stubs.CreateResource;
import org.gcube.indexmanagement.geoindexlookup.stubs.CreateResourceResponse;
import org.gcube.indexmanagement.geoindexmanagement.stubs.GeoIndexManagementPortType;
import org.gcube.indexmanagement.geoindexmanagement.stubs.GetIndexInformationResponse;
import org.gcube.indexmanagement.geoindexmanagement.stubs.service.GeoIndexManagementServiceAddressingLocator;

public class GeoIndexLookupFactoryService
extends GCUBEPortType {
    static GCUBELog logger = new GCUBELog(GeoIndexLookupFactoryService.class);
    static ISClient client = null;
    private static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();

    public CreateResourceResponse createResource(CreateResource request) throws GCUBEFault {
        String mainIndexID = request.getMainIndexID();
        logger.info((Object)("The indexId is: " + mainIndexID));
        List<EndpointReferenceType> eprList = null;
        int maxFails = 20;
        int pollInterval = 3000;
        try {
            int i;
            LinkedList<String[]> propValues = new LinkedList<String[]>();
            propValues.add(new String[]{"IndexID", mainIndexID});
            String mgmtNS = "http://gcube-system.org/namespaces/indexmanagement/GeoIndexManagementService";
            for (i = 0; i < maxFails && (eprList == null || eprList.size() == 0); ++i) {
                eprList = GeoIndexLookupFactoryService.getWSResourceEPRsFromPropValuesAndNamespace(propValues, mgmtNS, ServiceContext.getContext().getScope());
                if (eprList != null && eprList.size() != 0) continue;
                logger.debug((Object)("Unable to find management epr in IS. Query number " + i + ".  IndexID: [" + mainIndexID + "]" + " -- Trying again in " + pollInterval + "ms."));
                try {
                    Thread.sleep(pollInterval);
                    continue;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            logger.info((Object)("Found EPR in the " + i + "th attempt with EPR:" + eprList.get(0)));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to create resource.", (Throwable)e);
            throw new GCUBEFault(new String[]{e.getMessage()});
        }
        if (eprList == null || eprList.size() == 0) {
            throw new GCUBERetrySameFault(new String[]{"Unable to find management epr in IS.  IndexID: [" + mainIndexID + "]"});
        }
        logger.debug((Object)("Got the management EPR for the index [" + mainIndexID + "]"));
        logger.debug((Object)eprList.get(0));
        EndpointReferenceType mainIndexEpr = eprList.get(0);
        GeoIndexManagementServiceAddressingLocator geoIndexManagementInstanceLocator = new GeoIndexManagementServiceAddressingLocator();
        GeoIndexManagementPortType geoIndexManagementInstance = null;
        GetIndexInformationResponse info = null;
        try {
            geoIndexManagementInstance = geoIndexManagementInstanceLocator.getGeoIndexManagementPortTypePort(mainIndexEpr);
            geoIndexManagementInstance = (GeoIndexManagementPortType)GCUBERemotePortTypeContext.getProxy((Remote)geoIndexManagementInstance, (GCUBEScope)ServiceContext.getContext().getScope(), (GCUBESecurityManager[])new GCUBESecurityManager[]{ServiceContext.getContext()});
            info = geoIndexManagementInstance.getIndexInformation(new VOID());
        }
        catch (Exception e) {
            throw new GCUBERetrySameFault(new String[]{e.getMessage()});
        }
        String indexTypeID = info.getIndexTypeName();
        String[] collectionID = info.getCollectionID().getArray();
        String geographicalSystem = info.getGeographicalSystem();
        String unitOfMeasurement = info.getUnitOfMeasurement();
        Integer numberOfDecimals = info.getNumberOfDecimals();
        logger.info((Object)("Creating geoindex Lookup resource for: " + mainIndexID));
        CreateResourceResponse response = new CreateResourceResponse();
        try {
            GCUBEStatefulPortTypeContext ptcxt = StatefulContext.getPortTypeContext();
            GCUBEWSResourceKey key = ptcxt.makeKey(uuidGen.nextUUID());
            GCUBEWSResource geoIndexResource = ptcxt.getWSHome().create(key, new Object[]{key, mainIndexID, indexTypeID, collectionID, geographicalSystem, unitOfMeasurement, numberOfDecimals});
            geoIndexResource.store();
            response.setEndpointReference(geoIndexResource.getEPR());
            return response;
        }
        catch (Exception e) {
            logger.error((Object)"*** In GeoIndexLookupFactoryService.createResource: *** ", (Throwable)e);
            throw new GCUBEFault(new String[]{"*** In GeoIndexLookupFactoryService.createResource: *** " + e});
        }
    }

    static List<EndpointReferenceType> getWSResourceEPRsFromPropValuesAndNamespace(List<String[]> properties, String namespace, GCUBEScope scope) throws Exception {
        String filter = "$result/child::*[local-name()='" + properties.get(0)[0].trim() + "' and namespace-uri(.)='" + namespace.trim() + "']/string() eq '" + properties.get(0)[1].trim() + "'";
        for (int i = 1; i < properties.size(); ++i) {
            filter = filter + " and $result/child::*[local-name()='" + properties.get(i)[0].trim() + "' and namespace-uri(.)='" + namespace.trim() + "']/string() eq '" + properties.get(i)[1].trim() + "'";
        }
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        WSResourceQuery gquery = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
        gquery.addGenericCondition(filter);
        LinkedList<EndpointReferenceType> ret = new LinkedList<EndpointReferenceType>();
        for (RPDocument d : client.execute((ISQuery)gquery, scope)) {
            ret.add(d.getEndpoint());
        }
        return ret;
    }

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }
}

