/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.fulltextindexupdater;

import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.concurrent.FutureTask;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.fulltextindexupdater.FullTextIndexUpdaterContext;
import org.gcube.indexmanagement.fulltextindexupdater.FullTextIndexUpdaterResource;
import org.gcube.indexmanagement.fulltextindexupdater.InitThread;
import org.gcube.indexmanagement.fulltextindexupdater.stubs.Abort;
import org.gcube.indexmanagement.fulltextindexupdater.stubs.AbortResponse;
import org.gcube.indexmanagement.fulltextindexupdater.stubs.Commit;
import org.gcube.indexmanagement.fulltextindexupdater.stubs.CommitResponse;
import org.gcube.indexmanagement.fulltextindexupdater.stubs.DeleteDocuments;
import org.gcube.indexmanagement.fulltextindexupdater.stubs.DeleteDocumentsResponse;
import org.gcube.indexmanagement.fulltextindexupdater.stubs.FinishUpdate;
import org.gcube.indexmanagement.fulltextindexupdater.stubs.FinishUpdateResponse;
import org.gcube.indexmanagement.fulltextindexupdater.stubs.Process;
import org.gcube.indexmanagement.fulltextindexupdater.stubs.ProcessResponse;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceKey;

public class FullTextIndexUpdaterService {
    static GCUBELog logger = new GCUBELog(FullTextIndexUpdaterService.class);

    public ProcessResponse process(Process arguments) throws GCUBEFault {
        try {
            String rsLocation = arguments.getResultSetLocation();
            boolean destroyAfterUpdate = arguments.getDestroyAfterUpdate() != null && arguments.getDestroyAfterUpdate() != false;
            return this.process(rsLocation, destroyAfterUpdate);
        }
        catch (Exception e) {
            logger.error((Object)"unable to insert rowset", (Throwable)e);
            throw new GCUBEFault(new String[]{"Darn, error while inserting rowset: " + e.toString()});
        }
    }

    private ProcessResponse process(String resultSetLocation, boolean destroyAfterUpdate) throws GCUBEFault {
        try {
            FullTextIndexUpdaterResource batchUpdaterResource = this.getResource();
            FutureTask<Boolean> updateTask = batchUpdaterResource.processResultSet(resultSetLocation);
            if (destroyAfterUpdate) {
                this.selfDestructAfterUpdate(updateTask, batchUpdaterResource);
            }
            return new ProcessResponse();
        }
        catch (Exception e) {
            logger.error((Object)"unable to insert rowset", (Throwable)e);
            throw new GCUBEFault(new String[]{"Darn, error while inserting rowset: " + e.toString()});
        }
    }

    public DeleteDocumentsResponse deleteDocuments(DeleteDocuments request) throws GCUBEFault {
        try {
            FullTextIndexUpdaterResource batchUpdaterResource = this.getResource();
            batchUpdaterResource.deleteDocuments(request.getDocument());
            batchUpdaterResource.setModified(Calendar.getInstance());
            return new DeleteDocumentsResponse();
        }
        catch (Exception e) {
            logger.error((Object)"error while deleting documents", (Throwable)e);
            throw new GCUBEFault(new String[]{"Darn, error while deleting document: " + e.toString()});
        }
    }

    public CommitResponse commit(Commit empty) throws GCUBEFault {
        try {
            FullTextIndexUpdaterResource batchUpdaterResource = this.getResource();
            batchUpdaterResource.commit();
        }
        catch (Exception e) {
            logger.error((Object)"error while commiting", (Throwable)e);
            throw new GCUBEFault(new String[]{"Darn, error while inserting rowset: " + e.toString()});
        }
        return new CommitResponse();
    }

    public FinishUpdateResponse finishUpdate(FinishUpdate empty) throws GCUBEFault {
        try {
            FullTextIndexUpdaterResource batchUpdaterResource = this.getResource();
            batchUpdaterResource.commit();
            batchUpdaterResource.finishCurrentUpdate();
        }
        catch (Exception e) {
            logger.error((Object)"error while finishing update", (Throwable)e);
            throw new GCUBEFault(new String[]{"Darn, error while inserting rowset: " + e.toString()});
        }
        return new FinishUpdateResponse();
    }

    public AbortResponse abort(Abort empty) throws GCUBEFault {
        try {
            FullTextIndexUpdaterResource batchUpdaterResource = this.getResource();
            batchUpdaterResource.abort();
        }
        catch (Exception e) {
            logger.error((Object)"error while aborting", (Throwable)e);
            throw new GCUBEFault(new String[]{"Darn, error while aborting: " + e.toString()});
        }
        return new AbortResponse();
    }

    private void selfDestructAfterUpdate(final FutureTask<Boolean> rsConsumer, final FullTextIndexUpdaterResource resource) {
        Thread destroyerThread = new Thread(){

            @Override
            public void run() {
                boolean doRemoval;
                try {
                    boolean success = (Boolean)rsConsumer.get();
                    if (success) {
                        logger.info((Object)"The update successfully finished. The updater will now be removed.");
                        doRemoval = true;
                    } else {
                        logger.info((Object)"The update was aborted due to updater removal. Additional removal task will not be performed.");
                        doRemoval = false;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"The update was aborted due to an exception. The updater will now be removed.", (Throwable)e);
                    doRemoval = true;
                }
                if (doRemoval) {
                    GCUBEWSResourceKey key = (GCUBEWSResourceKey)resource.getID();
                    try {
                        FullTextIndexUpdaterContext.getPortTypeContext().getWSHome().remove((ResourceKey)key);
                        logger.info((Object)("The updater [" + key + "] was successfully destroyed."));
                    }
                    catch (Exception e) {
                        logger.error((Object)("Unable to destroy the updater [" + key + "] after finished update."), (Throwable)e);
                    }
                }
            }
        };
        try {
            InitThread.init(destroyerThread);
        }
        catch (Exception e) {
            logger.error((Object)"Could not initialize the new thread.", (Throwable)e);
        }
        destroyerThread.start();
    }

    private FullTextIndexUpdaterResource getResource() throws RemoteException {
        Resource resource = null;
        try {
            resource = ResourceContext.getResourceContext().getResource();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to access FT BatchUpdater resource", (Throwable)e);
            throw new RemoteException("Unable to access resource.", e);
        }
        FullTextIndexUpdaterResource UpdaterResource = (FullTextIndexUpdaterResource)resource;
        return UpdaterResource;
    }
}

