/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.fulltextindexupdater;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.StringField;
import java.io.File;
import java.net.URI;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.common.FullTextIndexType;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.common.IndexField;
import org.gcube.indexmanagement.common.IndexGenerator;
import org.gcube.indexmanagement.common.IndexUpdaterWSResource;
import org.gcube.indexmanagement.common.ThreadOwner;
import org.gcube.indexmanagement.common.XMLTokenReplacer;
import org.gcube.indexmanagement.common.linguistics.languageidplugin.LanguageIdFactory;
import org.gcube.indexmanagement.common.linguistics.languageidplugin.LanguageIdPlugin;
import org.gcube.indexmanagement.fulltextindexmanagement.stubs.FullTextIndexManagementPortType;
import org.gcube.indexmanagement.fulltextindexmanagement.stubs.RPChangeType;
import org.gcube.indexmanagement.fulltextindexmanagement.stubs.SharedStateChangeNotificationMessageType;
import org.gcube.indexmanagement.fulltextindexmanagement.stubs.StringArray;
import org.gcube.indexmanagement.fulltextindexmanagement.stubs.service.FullTextIndexManagementServiceAddressingLocator;
import org.gcube.indexmanagement.fulltextindexupdater.FullTextIndexUpdaterConfig;
import org.gcube.indexmanagement.fulltextindexupdater.FullTextIndexUpdaterContext;
import org.gcube.indexmanagement.fulltextindexupdater.FullTextIndexUpdaterFactoryService;
import org.gcube.indexmanagement.fulltextindexupdater.ServiceContext;
import org.gcube.indexmanagement.lucenewrapper.LuceneGenerator;
import org.gcube.indexmanagement.storagehandling.DeltaFileUploader;
import org.gcube.indexmanagement.storagehandling.stubs.DeltaActionType;
import org.globus.wsrf.config.ContainerConfig;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.w3c.dom.Element;

public class FullTextIndexUpdaterResource
extends IndexUpdaterWSResource
implements ThreadOwner {
    static GCUBELog logger = new GCUBELog(FullTextIndexUpdaterResource.class);
    public static final String RP_INDEX_FORMAT = "IndexFormat";
    public static final String RP_NOT_COMMITED_DOC_COUNT = "NotCommitedDocCount";
    public static final String RP_COMMITED_DOC_COUNT = "CommitedDocCount";
    public static final String RP_MERGED_DOC_COUNT = "MergedDocCount";
    public static final String RP_CONTENT_TYPE = "ContentType";
    protected static final int MAX_ATTEMPTS = 5;
    protected static final long WAIT_PERIOD = 5000L;
    protected static final String ROWSETFIELD = "Rowset";
    protected static final long RSTIMEOUT = 10L;
    protected static String[] RPNames = new String[]{"IndexFormat", "NotCommitedDocCount", "CommitedDocCount", "MergedDocCount", "ContentType"};
    private String indexDir = null;
    private String deletionDir = null;
    private volatile String indexFileName;
    private int indexCount = 0;
    private DeltaFileUploader uploader;
    private IndexGenerator indexGenerator;
    private LanguageIdPlugin lipl;
    private boolean updating = false;
    private FullTextIndexType idxType = null;
    private ExecutorService threadPool;
    private FullTextIndexUpdaterConfig config;

    protected void initialise(Object ... args) throws Exception {
        this.setIsInitializing(true);
        String indexID = (String)args[1];
        String[] collectionID = (String[])args[2];
        String indexTypeName = (String)args[3];
        String indexFormat = (String)args[4];
        String contentType = (String)args[5];
        String langIDPluginName = (String)args[6];
        super.initialize(FullTextIndexUpdaterContext.getPortTypeContext().getNamespace(), "http://gcube-system.org/namespaces/indexmanagement/FullTextIndexManagementService", indexID, indexTypeName, collectionID);
        this.indexDir = ServiceContext.getContext().getPersistenceRoot().getAbsolutePath() + "/indexData/lucene/";
        this.deletionDir = this.indexDir + "deletions/";
        try {
            for (String rpName : RPNames) {
                this.createProperty(rpName);
            }
            this.threadPool = Executors.newCachedThreadPool();
            this.uploader = new DeltaFileUploader(indexID, (IndexUpdaterWSResource)this, (GCUBEServiceContext)ServiceContext.getContext());
            this.config = (FullTextIndexUpdaterConfig)FullTextIndexUpdaterContext.getPortTypeContext().getProperty("config", new boolean[]{true});
            this.addConnectionID(this.uploader.getConnectionID());
            this.setIndexFormat(indexFormat);
            this.setNotCommitedDocCount(new Integer(0));
            this.setCommitedDocCount(new Integer(0));
            this.setMergedDocCount(new Integer(0));
            this.setContentType(contentType);
            this.indexFileName = indexID + "_" + ((GCUBEWSResourceKey)this.getID()).getValue() + "_update_" + this.indexCount;
            ++this.indexCount;
            if (indexTypeName != null) {
                this.idxType = new FullTextIndexType(indexTypeName, ServiceContext.getContext().getScope());
                this.indexGenerator = new LuceneGenerator(this.indexDir, this.deletionDir);
                this.indexGenerator.createIndex(this.indexFileName, this.idxType, true);
                this.indexGenerator.openIndex(this.indexFileName);
                this.indexGenerator.setIndexType(this.idxType);
            } else {
                this.indexGenerator = null;
            }
            if (langIDPluginName == null) {
                langIDPluginName = this.config.getLangIDPluginName();
            }
            String configFilePath = ContainerConfig.getBaseDirectory() + this.config.getLangIDConfigPath();
            logger.debug((Object)("Loading plugin using factory, config file: " + configFilePath));
            this.lipl = LanguageIdFactory.loadPlugin((String)langIDPluginName);
            this.lipl.init(configFilePath);
            this.setIsInitializing(false);
        }
        catch (Exception e) {
            logger.error((Object)"Error initializing", (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public String getIndexFormat() {
        return (String)this.getResourcePropertySet().get(RP_INDEX_FORMAT).get(0);
    }

    public int getNotCommitedDocCount() {
        return (Integer)this.getResourcePropertySet().get(RP_NOT_COMMITED_DOC_COUNT).get(0);
    }

    public int getCommitedDocCount() {
        return (Integer)this.getResourcePropertySet().get(RP_COMMITED_DOC_COUNT).get(0);
    }

    public int getMergedDocCount() {
        return (Integer)this.getResourcePropertySet().get(RP_MERGED_DOC_COUNT).get(0);
    }

    public void setContentType(String contentType) {
        this.getResourcePropertySet().get(RP_CONTENT_TYPE).clear();
        this.getResourcePropertySet().get(RP_CONTENT_TYPE).add((Object)contentType);
    }

    public void setIndexFormat(String indexFormat) {
        this.getResourcePropertySet().get(RP_INDEX_FORMAT).clear();
        this.getResourcePropertySet().get(RP_INDEX_FORMAT).add((Object)indexFormat);
    }

    public void setIndexTypeName(String indexTypeName) throws Exception {
        super.setIndexTypeName(indexTypeName);
        this.idxType = new FullTextIndexType(indexTypeName, ServiceContext.getContext().getScope());
    }

    public void setNotCommitedDocCount(int notCommitedDocCount) {
        this.getResourcePropertySet().get(RP_NOT_COMMITED_DOC_COUNT).clear();
        this.getResourcePropertySet().get(RP_NOT_COMMITED_DOC_COUNT).add((Object)new Integer(notCommitedDocCount));
    }

    public void setCommitedDocCount(int commitedDocCount) {
        this.getResourcePropertySet().get(RP_COMMITED_DOC_COUNT).clear();
        this.getResourcePropertySet().get(RP_COMMITED_DOC_COUNT).add((Object)new Integer(commitedDocCount));
    }

    public void setMergedDocCount(int mergedDocCount) {
        this.getResourcePropertySet().get(RP_MERGED_DOC_COUNT).clear();
        this.getResourcePropertySet().get(RP_MERGED_DOC_COUNT).add((Object)new Integer(mergedDocCount));
    }

    public FutureTask<Boolean> processResultSet(final String resultSetLocation) throws RemoteException {
        try {
            FutureTask<Boolean> rsConsumer = new FutureTask<Boolean>(new IndexUpdaterThread<Boolean>(ServiceContext.getContext().getScope(), ServiceContext.getContext().getCallerCredentials()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean doUpdate() throws Exception {
                    ForwardReader reader = new ForwardReader(new URI(resultSetLocation));
                    try {
                        int pageCount = 1;
                        int RowSetCount = 0;
                        int maxFail = 10;
                        boolean hasMoreParts = false;
                        List<EndpointReferenceType> mgmtEprs = null;
                        for (int attempts = 0; (mgmtEprs == null || mgmtEprs.size() == 0) && attempts < 5; ++attempts) {
                            try {
                                LinkedList<String[]> props = new LinkedList<String[]>();
                                props.add(new String[]{"IndexID", FullTextIndexUpdaterResource.this.getIndexID()});
                                mgmtEprs = FullTextIndexUpdaterFactoryService.getWSResourceEPRsFromPropValuesAndNamespace(props, "http://gcube-system.org/namespaces/indexmanagement/FullTextIndexManagementService", ServiceContext.getContext().getScope());
                            }
                            catch (Exception e) {
                                logger.error((Object)("Failed to query the IS for index management resources with IndexID = " + FullTextIndexUpdaterResource.this.getIndexID()), (Throwable)e);
                                FullTextIndexUpdaterResource.this.cancelUpdate();
                                return false;
                            }
                            if (mgmtEprs != null && mgmtEprs.size() > 0) break;
                            Thread.sleep(5000L);
                        }
                        if (mgmtEprs == null || mgmtEprs.size() == 0) {
                            logger.error((Object)("Failed to find a Manager for IndexID = " + FullTextIndexUpdaterResource.this.getIndexID()));
                            FullTextIndexUpdaterResource.this.cancelUpdate();
                            return false;
                        }
                        FullTextIndexManagementServiceAddressingLocator IndexManagementInstanceLocator = new FullTextIndexManagementServiceAddressingLocator();
                        FullTextIndexManagementPortType IndexManagementInstance = null;
                        try {
                            IndexManagementInstance = IndexManagementInstanceLocator.getFullTextIndexManagementPortTypePort((EndpointReferenceType)mgmtEprs.get(0));
                            IndexManagementInstance = (FullTextIndexManagementPortType)GCUBERemotePortTypeContext.getProxy((Remote)IndexManagementInstance, (GCUBEScope)ServiceContext.getContext().getScope(), (GCUBESecurityManager[])new GCUBESecurityManager[]{ServiceContext.getContext()});
                        }
                        catch (Exception e) {
                            logger.error((Object)"Unable to get the portType for the Manager.", (Throwable)e);
                            FullTextIndexUpdaterResource.this.cancelUpdate();
                            return false;
                        }
                        logger.debug((Object)"Starting to retrieve results from resultset:");
                        long before = Calendar.getInstance().getTimeInMillis();
                        while (true) {
                            Record result;
                            int counter = 0;
                            while (true) {
                                try {
                                    result = reader.get(10L, TimeUnit.SECONDS);
                                }
                                catch (Exception e) {
                                    if (counter++ <= maxFail) {
                                        logger.error((Object)(FullTextIndexUpdaterResource.this.getIndexID() + " get: failed for the " + counter + ". time."), (Throwable)e);
                                        Thread.yield();
                                        if (Thread.currentThread().isInterrupted()) {
                                            logger.debug((Object)"RS processor thread cancelled.");
                                            FullTextIndexUpdaterResource.this.indexGenerator.deleteIndex();
                                            return false;
                                        }
                                        try {
                                            Thread.sleep(1000L);
                                        }
                                        catch (InterruptedException ie) {
                                            logger.debug((Object)"RS processor thread cancelled while waiting");
                                            FullTextIndexUpdaterResource.this.indexGenerator.deleteIndex();
                                            return false;
                                        }
                                        continue;
                                    }
                                    logger.error((Object)(FullTextIndexUpdaterResource.this.getIndexID() + " RS get giving up. FAILED!"), (Throwable)e);
                                    throw e;
                                }
                                break;
                            }
                            if (result == null && (reader.getStatus() == IBuffer.Status.Dispose || reader.getStatus() == IBuffer.Status.Close && reader.availableRecords() == 0)) break;
                            try {
                                if (result != null) {
                                    String alteredRowset;
                                    String colID;
                                    Thread.yield();
                                    if (Thread.currentThread().isInterrupted()) {
                                        logger.debug((Object)"RS processor thread cancelled while reading results.");
                                        FullTextIndexUpdaterResource.this.indexGenerator.deleteIndex();
                                        return false;
                                    }
                                    String rowset = ((StringField)result.getField(FullTextIndexUpdaterResource.ROWSETFIELD)).getPayload();
                                    String rsIdxTypeID = FullTextIndexUpdaterResource.this.getIdxTypeNameRowset(rowset);
                                    String lang = FullTextIndexUpdaterResource.this.getLangRowset(rowset);
                                    if (lang == null || lang.equals("")) {
                                        lang = "unknown";
                                    }
                                    if ((colID = FullTextIndexUpdaterResource.this.getColIDRowset(rowset)) == null || colID.equals("")) {
                                        logger.error((Object)("No collection ID given in ROWSET: " + rowset));
                                        FullTextIndexUpdaterResource.this.cancelUpdate();
                                        return false;
                                    }
                                    if (rsIdxTypeID != null) {
                                        if (!rsIdxTypeID.equals(FullTextIndexUpdaterResource.this.getIndexTypeName())) {
                                            String rsIdxType = FullTextIndexUpdaterResource.this.getIdxType(rsIdxTypeID);
                                            if (FullTextIndexUpdaterResource.this.getIndexTypeName() != null) {
                                                logger.error((Object)("RowSet IndexType does not match previous previous IndexType. Update will be cancelled.\n" + rowset));
                                                FullTextIndexUpdaterResource.this.cancelUpdate();
                                                return false;
                                            }
                                            FullTextIndexUpdaterResource fullTextIndexUpdaterResource = FullTextIndexUpdaterResource.this;
                                            synchronized (fullTextIndexUpdaterResource) {
                                                FullTextIndexUpdaterResource.this.indexGenerator = (IndexGenerator)new LuceneGenerator(FullTextIndexUpdaterResource.this.indexDir, FullTextIndexUpdaterResource.this.deletionDir);
                                                FullTextIndexUpdaterResource.this.setIndexTypeName(rsIdxTypeID);
                                                FullTextIndexUpdaterResource.this.indexGenerator.createIndex(FullTextIndexUpdaterResource.this.indexFileName, FullTextIndexUpdaterResource.this.idxType, false);
                                                FullTextIndexUpdaterResource.this.indexGenerator.openIndex(FullTextIndexUpdaterResource.this.indexFileName);
                                            }
                                        }
                                    } else if (FullTextIndexUpdaterResource.this.getIndexTypeName() == null) {
                                        logger.error((Object)("IndexType missing. Unable to index rowset.\n" + rowset));
                                        FullTextIndexUpdaterResource.this.indexGenerator.deleteIndex();
                                        return false;
                                    }
                                    if ((alteredRowset = FullTextIndexUpdaterResource.this.preprocessRowset(rowset, lang, colID, IndexManagementInstance)) == null) {
                                        logger.error((Object)("could not preprocess rowset: " + rowset));
                                        FullTextIndexUpdaterResource.this.cancelUpdate();
                                        return false;
                                    }
                                    logger.debug((Object)("rowset before preprocessing: " + rowset));
                                    logger.debug((Object)("rowset after preprocessing: " + alteredRowset));
                                    FullTextIndexUpdaterResource.this.insertRowSet(alteredRowset);
                                    ++RowSetCount;
                                    if (FullTextIndexUpdaterResource.this.indexGenerator.getIndexFileSize() + FullTextIndexUpdaterResource.this.indexGenerator.getUnCommittedFileSize() >= FullTextIndexUpdaterResource.this.getDeltaFileSize()) {
                                        FullTextIndexUpdaterResource.this.commit();
                                    }
                                }
                                logger.debug((Object)(FullTextIndexUpdaterResource.this.getIndexID() + " Part#: " + pageCount++ + "RowSet count: " + RowSetCount));
                            }
                            catch (Exception e) {
                                logger.error((Object)("Unable to index: " + FullTextIndexUpdaterResource.this.getIndexID() + " Part#: " + pageCount++), (Throwable)e);
                            }
                        }
                        logger.debug((Object)"Nothing else to read!");
                        try {
                            reader.close();
                        }
                        catch (Exception e) {
                            logger.error((Object)"could not close reader");
                        }
                        FullTextIndexUpdaterResource.this.finishCurrentUpdate();
                        long after = Calendar.getInstance().getTimeInMillis();
                        logger.debug((Object)("Indexed all results in: " + (after - before)));
                        return true;
                    }
                    catch (Exception e) {
                        logger.error((Object)(FullTextIndexUpdaterResource.this.getIndexID() + " update aborted."), (Throwable)e);
                        try {
                            reader.close();
                        }
                        catch (Exception e1) {
                            logger.error((Object)"could not close reader in exception");
                        }
                        throw e;
                    }
                }
            });
            this.threadPool.execute(rsConsumer);
            return rsConsumer;
        }
        catch (Exception e) {
            logger.error((Object)"error while inserting rowset");
            throw new RemoteException("error while inserting rowset: " + e.toString());
        }
    }

    private void cancelUpdate() {
        try {
            this.indexGenerator.deleteIndex();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to delete local index file after update cancellation.", (Throwable)e);
        }
    }

    private String preprocessRowset(String rowset, String lang, String colID, FullTextIndexManagementPortType IndexManagementInstance) {
        int payloadIndex = rowset.indexOf("fullpayload");
        if (payloadIndex > -1) {
            logger.trace((Object)"Found payload field");
            String payload = rowset.substring(payloadIndex + "fullpayload".length()).trim();
            if (payload.charAt(0) != '\"') {
                logger.warn((Object)"please check the rowsets to be fed in the index. While there is a fullpayload keyword, it doesn't seem to be a FIELD");
            } else {
                int payloadStart = rowset.indexOf(62, payloadIndex);
                int testInsideElement = rowset.indexOf(60, payloadIndex);
                if (payloadStart == -1) {
                    logger.warn((Object)"please check the rowsets to be fed in the index. While there is a fullpayload keyword, it seems to in a weird spot");
                } else if (testInsideElement != -1 && payloadStart > testInsideElement) {
                    logger.warn((Object)"please check the rowsets to be fed in the index. While there is a fullpayload keyword, it doesn't seem to be INSIDE a FIELD");
                } else {
                    int payloadEnd = rowset.indexOf("</FIELD>", payloadStart);
                    if (payloadEnd == -1) {
                        logger.warn((Object)"please check the rowsets to be fed in the index. Thefullpayload keyword, must be out of FIELD");
                    }
                    payload = rowset.substring(payloadStart + 1, payloadEnd);
                    payload = XMLTokenReplacer.XMLUnresolve((String)payload);
                    rowset = rowset.substring(0, payloadStart + 1) + payload + rowset.substring(payloadEnd);
                }
            }
        }
        String alteredRowSet = "<ROWSET>\n";
        boolean first = true;
        for (String row : rowset.split("<ROW>")) {
            if (first) {
                first = false;
                continue;
            }
            String regex = "<FIELD\\s+(?:lang=\"([^\"]*?)\"\\s+)*(?:[^>]*?\\s+)??name=\"([^\"]*?)\"(?:\\s+lang=\"([^\"]*?)\"\\s*)*\\s*>\\s*(.*?)\\s*</";
            Matcher m = Pattern.compile(regex).matcher(row);
            HashMap<String, String> fields = new HashMap<String, String>();
            try {
                while (m.find()) {
                    String fieldName = m.group(2).trim();
                    String fieldContent = m.group(4).trim();
                    String sumContent = (String)fields.get(fieldName);
                    sumContent = sumContent == null ? fieldContent : sumContent + " " + fieldContent;
                    fields.put(fieldName, sumContent);
                }
            }
            catch (Exception e) {
                logger.error((Object)(this.getIndexID() + " exception while adding language fields"), (Throwable)e);
            }
            logger.trace((Object)("Fields keySet: " + fields.keySet().size()));
            ArrayList<String> toBeAdded = new ArrayList<String>();
            for (String field : fields.keySet()) {
                if (this.addToFieldInfo(toBeAdded, field, colID, lang)) continue;
                return null;
            }
            String content = null;
            content = (String)fields.get("gDocCollectionID");
            if (content != null) {
                logger.error((Object)(this.getIndexID() + "-- rowset has already a value: " + content + "for the reserved field " + "gDocCollectionID" + ", that will be dropped."));
            }
            fields.put("gDocCollectionID", colID);
            if (!this.addToFieldInfo(toBeAdded, "gDocCollectionID", colID, lang)) {
                return null;
            }
            content = null;
            content = (String)fields.get("gDocCollectionLang");
            if (content != null) {
                logger.error((Object)(this.getIndexID() + "-- rowset has already a value: " + content + "for the reserved field " + "gDocCollectionLang" + ", that will be dropped."));
            }
            fields.put("gDocCollectionLang", lang);
            if (!this.addToFieldInfo(toBeAdded, "gDocCollectionLang", colID, lang)) {
                return null;
            }
            toBeAdded.add(colID + ":" + lang + ":" + "s" + ":" + "allIndexes");
            Object[] fieldsToBeAdded = toBeAdded.toArray(new String[toBeAdded.size()]);
            logger.trace((Object)("fields to be added: " + Arrays.toString(fieldsToBeAdded)));
            Object[] colToBeAdded = new String[]{colID};
            logger.trace((Object)("Collections to be added: " + Arrays.toString(colToBeAdded)));
            try {
                StringArray colsStringArray = new StringArray();
                colsStringArray.setArray((String[])colToBeAdded);
                IndexManagementInstance.addCollections(colsStringArray);
                StringArray fieldsStringArray = new StringArray();
                fieldsStringArray.setArray((String[])fieldsToBeAdded);
                IndexManagementInstance.addFields(fieldsStringArray);
            }
            catch (Exception e) {
                logger.error((Object)"Could not add the fields/collection to the manager: ", (Throwable)e);
                return null;
            }
            if (fields.isEmpty()) continue;
            alteredRowSet = alteredRowSet + "   <ROW>\n";
            for (String field : fields.keySet()) {
                alteredRowSet = alteredRowSet + "      <FIELD name=\"" + field + "\">" + ((String)fields.get(field)).trim() + "</FIELD>\n";
            }
            alteredRowSet = alteredRowSet + "   </ROW>\n";
        }
        alteredRowSet = alteredRowSet + "</ROWSET>\n";
        return alteredRowSet;
    }

    private boolean addToFieldInfo(ArrayList<String> toBeAdded, String field, String colID, String lang) {
        boolean found = false;
        boolean searchable = false;
        boolean presentable = false;
        for (IndexField idxField : this.idxType.getFields()) {
            if (!idxField.name.equals(field)) continue;
            found = true;
            searchable = idxField.index;
            presentable = idxField.returned;
            break;
        }
        if (field.equalsIgnoreCase("ObjectID")) {
            searchable = true;
            presentable = false;
        } else if (!found) {
            logger.error((Object)("The field: " + field + ", is not declared in the indexType."));
            return false;
        }
        if (searchable) {
            toBeAdded.add(colID + ":" + lang + ":" + "s" + ":" + field);
        }
        if (presentable) {
            toBeAdded.add(colID + ":" + lang + ":" + "p" + ":" + field);
        }
        return true;
    }

    private String getIdxTypeNameRowset(String rowset) {
        String regex = "<ROWSET[^>]*idxType=\"([^\"]*?)\"";
        return this.getMatchRegex(regex, rowset);
    }

    private String getLangRowset(String rowset) {
        String regex = "<ROWSET[^>]*lang=\"([^\"]*?)\"";
        return this.getMatchRegex(regex, rowset);
    }

    private String getColIDRowset(String rowset) {
        String regex = "<ROWSET[^>]*colID=\"([^\"]*?)\"";
        return this.getMatchRegex(regex, rowset);
    }

    private String getMatchRegex(String regex, String rowset) {
        Matcher m = Pattern.compile(regex).matcher(rowset);
        String match = null;
        try {
            if (m.find() && (match = m.group(1).trim()).equals("")) {
                match = null;
            }
        }
        catch (Exception e) {
            logger.error((Object)(this.getIndexID() + " exception while getting idxType"), (Throwable)e);
        }
        return match;
    }

    private String getIdxType(String idxTypeName) {
        try {
            return new FullTextIndexType(idxTypeName, ServiceContext.getContext().getScope()).getIndexTypeAsString();
        }
        catch (Exception e) {
            logger.error((Object)(this.getIndexID() + " error getting IndexTypeDocument for id=\"" + idxTypeName + "\". Returning null."), (Throwable)e);
            return null;
        }
    }

    public synchronized void insertRowSet(String rowset) throws IndexException {
        int count = this.indexGenerator.insertRowSet(rowset);
        this.setNotCommitedDocCount(this.getNotCommitedDocCount() + count);
    }

    public synchronized void deleteDocuments(String[] IDs) throws IndexException {
        File deletionFile = this.indexGenerator.deleteDocuments(IDs);
        this.uploader.upload(this.deletionDir + deletionFile.getName(), DeltaActionType.Deletion, null, IDs.length);
        this.setNotCommitedDocCount(this.getNotCommitedDocCount() - IDs.length);
        this.commit();
    }

    public void abort() throws IndexException {
        this.indexGenerator.abort();
    }

    public synchronized void commit() throws IndexException {
        logger.debug((Object)"commit");
        if (!this.updating) {
            this.updating = true;
            this.setIndexStatus("UPDATING");
        }
        this.indexGenerator.commit();
        this.setModified(Calendar.getInstance());
        this.setCommitedDocCount(this.getCommitedDocCount() + this.getNotCommitedDocCount());
        this.setNotCommitedDocCount(0);
        this.setIsUpdated(true);
        this.sendMerge();
    }

    public synchronized void finishCurrentUpdate() throws IndexException {
        logger.debug((Object)"finishCurrentUpdate");
        if (!this.getIndexStatus().equals("FINISHED")) {
            logger.debug((Object)"Finished");
            this.commit();
            this.updating = false;
            this.setIndexStatus("FINISHED");
        }
    }

    public synchronized void sendMerge() {
        logger.debug((Object)"sendMerge");
        try {
            if (this.getIsUpdated()) {
                logger.debug((Object)"Index IS updated");
                String newIndexFileName = this.getIndexID() + "_" + ((GCUBEWSResourceKey)this.getID()).getValue() + "_update_" + this.indexCount;
                this.indexGenerator.createIndex(newIndexFileName, this.idxType, true);
                this.uploader.upload(this.indexDir + this.indexFileName, this.getIndexTypeName(), this.getCommitedDocCount());
                this.indexFileName = newIndexFileName;
                ++this.indexCount;
                this.setMergedDocCount(this.getMergedDocCount() + this.getCommitedDocCount());
                this.setCommitedDocCount(0);
                this.setIsUpdated(false);
            }
        }
        catch (IndexException e) {
            logger.error((Object)"Unable to create new deltaFile. Merge was not completed", (Throwable)e);
            return;
        }
    }

    public void onResourceRemoval() {
        try {
            this.threadPool.shutdownNow();
            this.finishCurrentUpdate();
            this.uploader.close();
            super.onResourceRemoval();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to remove index updater resource.", (Throwable)e);
        }
    }

    public boolean isReadyToDie() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpdaterNotificationReceived(Element message) {
        try {
            SharedStateChangeNotificationMessageType notification = (SharedStateChangeNotificationMessageType)ObjectDeserializer.toObject((Element)message, SharedStateChangeNotificationMessageType.class);
            RPChangeType[] changes = notification.getChangedRPs();
            FullTextIndexUpdaterResource fullTextIndexUpdaterResource = this;
            synchronized (fullTextIndexUpdaterResource) {
                for (RPChangeType change : changes) {
                    QName rpName = change.getRPName();
                    if (!rpName.getLocalPart().equals("IndexTypeName")) continue;
                    if (this.getIndexTypeName() == null) {
                        this.setIndexTypeName(change.getNewValue());
                        logger.debug((Object)(this.getIndexID() + " changed indexTypeName: " + change.getNewValue()));
                        continue;
                    }
                    if (this.getIndexTypeName().equals(change.getNewValue())) {
                        logger.debug((Object)(this.getIndexID() + " correct indexType received: " + change.getNewValue()));
                        continue;
                    }
                    logger.error((Object)("The IndexTypeName received from IndexManagement does not match the current IndexType (new=\"" + change.getNewValue() + "\" current=\"" + this.getIndexTypeName() + "\"). Any updates will be cancelled."));
                    this.threadPool.shutdownNow();
                    return;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception while handling notification:" + message + " delivered to " + this.getIndexID() + "_(" + this.getID() + ")"), (Throwable)e);
        }
    }

    private abstract class IndexUpdaterThread<T>
    implements Callable<T> {
        private GCUBEScope scope;
        private SecurityCredentials credential;

        public IndexUpdaterThread(GCUBEScope scope, SecurityCredentials credential) {
            this.scope = scope;
            this.credential = credential;
        }

        @Override
        public T call() throws Exception {
            try {
                Thread t = Thread.currentThread();
                ServiceContext.getContext().setScope(t, this.scope);
                ServiceContext.getContext().useCredentials(t, new SecurityCredentials[]{this.credential});
            }
            catch (Exception e) {
                logger.error((Object)"Failed to set scope and credentials on the index updater thread.");
            }
            return this.doUpdate();
        }

        public abstract T doUpdate() throws Exception;
    }
}

