/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.fulltextindexupdater;

import java.rmi.Remote;
import java.util.LinkedList;
import java.util.List;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetrySameFault;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.fulltextindexmanagement.stubs.FullTextIndexManagementPortType;
import org.gcube.indexmanagement.fulltextindexmanagement.stubs.GetIndexInformationResponse;
import org.gcube.indexmanagement.fulltextindexmanagement.stubs.service.FullTextIndexManagementServiceAddressingLocator;
import org.gcube.indexmanagement.fulltextindexupdater.FullTextIndexUpdaterContext;
import org.gcube.indexmanagement.fulltextindexupdater.FullTextIndexUpdaterResource;
import org.gcube.indexmanagement.fulltextindexupdater.ServiceContext;
import org.gcube.indexmanagement.fulltextindexupdater.stubs.CreateResource;
import org.gcube.indexmanagement.fulltextindexupdater.stubs.CreateResourceResponse;

public class FullTextIndexUpdaterFactoryService
extends GCUBEPortType {
    private static GCUBELog logger = new GCUBELog(FullTextIndexUpdaterFactoryService.class);
    private static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();

    public CreateResourceResponse createResource(CreateResource request) throws GCUBEFault {
        String contentType;
        String indexFormat;
        String indexTypeName;
        String[] collectionIDList;
        String mainIndexID = request.getMainIndexID();
        String langIDPluginName = request.getLangIDPluginName();
        CreateResourceResponse response = new CreateResourceResponse();
        FullTextIndexUpdaterResource resource = null;
        List<EndpointReferenceType> mgmtEprs = null;
        logger.debug((Object)(" >>> createResource " + request.getMainIndexID() + "\n"));
        try {
            LinkedList<String[]> props = new LinkedList<String[]>();
            props.add(new String[]{"IndexID", mainIndexID});
            mgmtEprs = FullTextIndexUpdaterFactoryService.getWSResourceEPRsFromPropValuesAndNamespace(props, "http://gcube-system.org/namespaces/indexmanagement/FullTextIndexManagementService", ServiceContext.getContext().getScope());
        }
        catch (Exception e) {
            logger.error((Object)("Failed to query the IS for index management resources with IndexID = " + request.getMainIndexID()), (Throwable)e);
            throw new GCUBERetrySameFault(new String[]{"Failed to query the IS for index management resources with IndexID = " + request.getMainIndexID()});
        }
        if (mgmtEprs == null || mgmtEprs.size() == 0) {
            logger.error((Object)"Unable to create updater resource: cannot locate the management resource");
            throw new GCUBERetrySameFault(new String[]{"Unable to create updater resource: cannot locate the management resource"});
        }
        FullTextIndexManagementServiceAddressingLocator IndexManagementInstanceLocator = new FullTextIndexManagementServiceAddressingLocator();
        try {
            FullTextIndexManagementPortType IndexManagementInstance = IndexManagementInstanceLocator.getFullTextIndexManagementPortTypePort(mgmtEprs.get(0));
            IndexManagementInstance = (FullTextIndexManagementPortType)GCUBERemotePortTypeContext.getProxy((Remote)IndexManagementInstance, (GCUBEScope)ServiceContext.getContext().getScope(), (GCUBESecurityManager[])new GCUBESecurityManager[]{ServiceContext.getContext()});
            GetIndexInformationResponse info = IndexManagementInstance.getIndexInformation(new VOID());
            collectionIDList = info.getCollectionID().getArray();
            indexTypeName = info.getIndexTypeName();
            indexFormat = info.getIndexFormat();
            contentType = info.getContentType();
            logger.info((Object)("Created batch updater resource for index " + mainIndexID));
        }
        catch (Exception e) {
            logger.error((Object)"Unable to retrieve index properties from the management resource.", (Throwable)e);
            throw new GCUBERetrySameFault(new String[]{"Unable to retrieve index properties from the management resource."});
        }
        try {
            GCUBEStatefulPortTypeContext ptctx = FullTextIndexUpdaterContext.getPortTypeContext();
            GCUBEWSResourceKey key = ptctx.makeKey(uuidGen.nextUUID());
            resource = (FullTextIndexUpdaterResource)ptctx.getWSHome().create(key, new Object[]{key, mainIndexID, collectionIDList, indexTypeName, indexFormat, contentType, langIDPluginName});
            response.setEndpointReference(resource.getEPR());
        }
        catch (Exception e) {
            logger.error((Object)"*** Unable to create updater resource ***", (Throwable)e);
            throw new GCUBERetrySameFault(new String[]{" *** Unable to create updater resource *** " + e.getMessage()});
        }
        logger.debug((Object)(" <<< createResource " + request.getMainIndexID() + "\n"));
        return response;
    }

    static List<EndpointReferenceType> getWSResourceEPRsFromPropValuesAndNamespace(List<String[]> properties, String namespace, GCUBEScope scope) throws Exception {
        String filter = "$result/child::*[local-name()='" + properties.get(0)[0].trim() + "' and namespace-uri(.)='" + namespace.trim() + "']/string() eq '" + properties.get(0)[1].trim() + "'";
        for (int i = 1; i < properties.size(); ++i) {
            filter = filter + " and $result/child::*[local-name()='" + properties.get(i)[0].trim() + "' and namespace-uri(.)='" + namespace.trim() + "']/string() eq '" + properties.get(i)[1].trim() + "'";
        }
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        WSResourceQuery gquery = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
        gquery.addGenericCondition(filter);
        LinkedList<EndpointReferenceType> ret = new LinkedList<EndpointReferenceType>();
        for (RPDocument d : client.execute((ISQuery)gquery, scope)) {
            ret.add(d.getEndpoint());
        }
        return ret;
    }

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }
}

