/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.index.forwardindexnode;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.rpc.ServiceException;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.types.VOID;
import org.gcube.common.resources.gcore.ServiceInstance;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.couchbase.CouchBaseNode;
import org.gcube.couchbase.entities.MetaIndex;
import org.gcube.index.forwardindexnode.Resource;
import org.gcube.index.forwardindexnode.ServiceContext;
import org.gcube.index.forwardindexnode.StatefulContext;
import org.gcube.index.forwardindexnode.stubs.CreateResource;
import org.gcube.index.forwardindexnode.stubs.CreateResourceResponse;
import org.gcube.index.forwardindexnode.stubs.ForwardIndexNodeFactoryPortType;
import org.gcube.index.forwardindexnode.stubs.ForwardIndexNodePortType;
import org.gcube.index.forwardindexnode.stubs.GetIndexInformationResponse;
import org.gcube.index.forwardindexnode.stubs.KeyDescriptionArray;
import org.gcube.index.forwardindexnode.stubs.KeyDescriptionType;
import org.gcube.index.forwardindexnode.stubs.StringArray;
import org.gcube.index.forwardindexnode.stubs.service.ForwardIndexNodeFactoryServiceAddressingLocator;
import org.gcube.index.forwardindexnode.stubs.service.ForwardIndexNodeServiceAddressingLocator;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.globus.wsrf.ResourceException;
import org.oasis.wsrf.lifetime.Destroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardIndexNode
extends GCUBEPortType {
    protected static final String FACTORY = "Factory";
    protected static final String SERVICE_NAME = "ForwardIndexNode";
    protected static final String SERVICE_CLASS = "Index";
    private static final String USE_CLUSTER_ID = "useClusterId";
    protected static final int TIMEOUT = 700000;
    private static final Logger logger = LoggerFactory.getLogger(ForwardIndexNode.class);
    private String clusterID = null;

    protected void onReady() throws Exception {
        super.onReady();
    }

    protected ServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public synchronized GetIndexInformationResponse getIndexInformation(VOID request) throws GCUBEFault {
        try {
            Resource managementResource = this.getResource();
            if (managementResource.isInitializing()) {
                throw new Exception("Resource is not initialized yet");
            }
            GetIndexInformationResponse response = new GetIndexInformationResponse();
            response.setIndexID(managementResource.getIndexID());
            StringArray colStringArray = new StringArray();
            colStringArray.setArray(managementResource.getCollectionID());
            response.setCollectionID(colStringArray);
            StringArray fieldStringArray = new StringArray();
            fieldStringArray.setArray(managementResource.getFields());
            response.setFields(fieldStringArray);
            return response;
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
            throw new GCUBEFault(new String[]{e.getMessage()});
        }
    }

    private void initializeClusterID() {
        StatefulContext pctx;
        boolean useClusterID;
        if (this.clusterID == null) {
            try {
                logger.info("clusterID was null");
                this.clusterID = (String)this.getResource().getResourcePropertySet().get("ClusterID").get(0);
                logger.info("after get resource clusterID is : " + this.clusterID);
            }
            catch (ResourceException e) {
                logger.error("Error while initializing cluster id", (Throwable)e);
            }
        }
        if (!(useClusterID = ((Boolean)(pctx = (StatefulContext)StatefulContext.getContext()).getProperty(USE_CLUSTER_ID, new boolean[0])).booleanValue())) {
            this.clusterID = ServiceContext.getContext().getScope().toString();
        }
    }

    public boolean feedLocator(String resultSetLocation) {
        this.initializeClusterID();
        final String fResultSetLocation = resultSetLocation;
        String key = this.getResouceKey();
        logger.info("resource key in feeding : " + key);
        final CouchBaseNode couchbaseNode = this.getForwardNode();
        new Thread(){

            @Override
            public void run() {
                try {
                    boolean result = couchbaseNode.feedLocator(fResultSetLocation);
                    logger.info("Feeding completed, result was: " + result);
                    if (result) {
                        ForwardIndexNode.this.updateManagerProperties(couchbaseNode);
                    }
                    logger.info("Properties updating completed");
                }
                catch (Exception e) {
                    logger.error("Exception", (Throwable)e);
                }
            }
        }.start();
        return true;
    }

    public String query(String queryString) {
        logger.info("Query : " + queryString);
        this.initializeClusterID();
        try {
            return this.getForwardNode().query(queryString);
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
            return "Caught Exception " + e.getMessage();
        }
    }

    public boolean shutdown(String nothing) {
        this.initializeClusterID();
        try {
            if (nothing != null && nothing.trim().equalsIgnoreCase("DELETE")) {
                this.getForwardNode().delete();
                this.updateManagerProperties(this.getForwardNode());
            }
            this.getForwardNode().shutdown();
            return true;
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
            return false;
        }
    }

    public boolean deleteCollection(String collectionID) {
        this.initializeClusterID();
        try {
            Boolean result = this.getForwardNode().deleteCollection(collectionID);
            logger.info("deleting completed, result was: " + result);
            if (result.booleanValue()) {
                this.updateManagerProperties(this.getForwardNode());
            }
            return result;
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
            return false;
        }
    }

    public boolean destroyNode(VOID voidType) {
        this.initializeClusterID();
        boolean hasFailed = false;
        HashMap<String, Set<String>> endpoints = ForwardIndexNode.discoverForwardIndexNodes(Arrays.asList(this.getForwardNodeClientScope()), this.clusterID);
        logger.info("Found endpoints to shutdown " + endpoints);
        logger.info("Deleting indices...");
        try {
            this.getForwardNode().delete();
        }
        catch (Exception e) {
            logger.error("Error deleting the indices...", (Throwable)e);
            return false;
        }
        logger.info("Deleting indices DONE");
        GCUBEScope scope = GCUBEScope.getScope((String)this.getForwardNodeClientScope());
        for (String endpoint : endpoints.keySet()) {
            for (String key : endpoints.get(endpoint)) {
                logger.info("Destoying resource " + endpoint + " " + key);
                try {
                    EndpointReferenceType factoryEPR = new EndpointReferenceType((URI)new AttributedURI(endpoint + FACTORY));
                    ForwardIndexNodeFactoryPortType fpt = new ForwardIndexNodeFactoryServiceAddressingLocator().getForwardIndexNodeFactoryPortTypePort(factoryEPR);
                    fpt = (ForwardIndexNodeFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)fpt, (GCUBEScope)scope, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
                    CreateResource cr = new CreateResource();
                    cr.setIndexID(key);
                    CreateResourceResponse crr = fpt.createResource(cr);
                    logger.info("created resource at endpoint " + crr.getEndpointReference());
                    ForwardIndexNodePortType pt = new ForwardIndexNodeServiceAddressingLocator().getForwardIndexNodePortTypePort(crr.getEndpointReference());
                    pt = (ForwardIndexNodePortType)GCUBERemotePortTypeContext.getProxy((Remote)pt, (GCUBEScope)scope, (int)700000, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
                    if (!pt.shutdown("")) {
                        logger.error("error deleting index at : " + endpoint);
                        hasFailed = true;
                        continue;
                    }
                    logger.info("Destroying of discovered resource...");
                    pt.destroy(new Destroy());
                    logger.info("Destroying of discovered resource...OK");
                }
                catch (URI.MalformedURIException e) {
                    logger.error("Exception", (Throwable)e);
                    hasFailed = true;
                }
                catch (ServiceException e) {
                    logger.error("Exception", (Throwable)e);
                    hasFailed = true;
                }
                catch (RemoteException e) {
                    logger.error("Exception", (Throwable)e);
                    hasFailed = true;
                }
                catch (Exception e) {
                    logger.error("Exception", (Throwable)e);
                    hasFailed = true;
                }
            }
        }
        return !hasFailed;
    }

    public boolean refresh(VOID voidType) {
        this.initializeClusterID();
        try {
            this.getForwardNode().loadMetaFromDatabase();
        }
        catch (Exception e) {
            logger.error("Exception ", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean rebuildMetaIndex(VOID voidType) {
        this.initializeClusterID();
        try {
            Resource managementResource = this.getResource();
            if (managementResource.isInitializing()) {
                throw new Exception("Resource is not initialized yet");
            }
            Object[] collectionIds = managementResource.getCollectionID();
            Object[] fields = managementResource.getFields();
            logger.info("Adding collectionsIDs: " + Arrays.toString(collectionIds));
            logger.info("Adding fields: " + Arrays.toString(fields));
            this.getForwardNode().loadMetaFromDatabase();
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean setCollections(StringArray collectionIDs) throws GCUBEFault {
        try {
            Resource resource = this.getResource();
            resource.setCollectionID(collectionIDs.getArray());
            resource.store();
        }
        catch (RemoteException re) {
            throw new GCUBEFault(new String[]{re.getMessage()});
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        return true;
    }

    public boolean setFields(StringArray fields) throws GCUBEFault {
        try {
            Resource resource = this.getResource();
            resource.setFields(fields.getArray());
            resource.store();
        }
        catch (RemoteException re) {
            throw new GCUBEFault(new String[]{re.getMessage()});
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        return true;
    }

    public boolean addKeyDescription(KeyDescriptionArray kda) throws GCUBEFault {
        try {
            Resource resource = this.getResource();
            KeyDescriptionType[] kdaOld = resource.getKeyDescription();
            HashMap<String, String> keyValues = new HashMap<String, String>();
            logger.info("clusterID was null");
            if (kda != null && kda.getArray() != null) {
                for (KeyDescriptionType kdt : kda.getArray()) {
                    keyValues.put(kdt.getKeyName(), kdt.getIndexTypeID());
                }
            }
            logger.info("about to add index types");
            this.getForwardNode().addIndexTypes(keyValues);
            KeyDescriptionType[] allKda = new KeyDescriptionType[kda.getArray().length + kdaOld.length];
            int i = 0;
            for (KeyDescriptionType kdt : kda.getArray()) {
                allKda[i++] = kdt;
            }
            for (KeyDescriptionType kdt : kdaOld) {
                allKda[i++] = kdt;
            }
            resource.setKeyDescription(allKda);
            resource.store();
        }
        catch (RemoteException re) {
            throw new GCUBEFault(new String[]{re.getMessage()});
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        return true;
    }

    public boolean setKeyDescription(KeyDescriptionArray kda) throws GCUBEFault {
        try {
            HashMap<String, String> keyValues = new HashMap<String, String>();
            logger.info("clusterID was null");
            if (kda != null && kda.getArray() != null) {
                for (KeyDescriptionType kdt : kda.getArray()) {
                    keyValues.put(kdt.getKeyName(), kdt.getIndexTypeID());
                }
            }
            logger.info("about to add index types");
            this.getForwardNode().addIndexTypes(keyValues);
            Resource resource = this.getResource();
            resource.setKeyDescription(kda.getArray());
            resource.store();
        }
        catch (RemoteException re) {
            throw new GCUBEFault(new String[]{re.getMessage()});
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        return true;
    }

    private boolean updateManagerProperties(CouchBaseNode forwardNode) throws GCUBEFault {
        this.initializeClusterID();
        forwardNode.loadMetaFromDatabase();
        MetaIndex meta = forwardNode.getMetaIndex();
        ArrayList collectionIdsToBeAdded = new ArrayList(meta.getCollections());
        ArrayList fieldsToBeAdded = new ArrayList(meta.getFields());
        logger.info("fields to be added: " + fieldsToBeAdded);
        logger.info("Collections to be added: " + collectionIdsToBeAdded);
        HashMap<String, Set<String>> endpoints = ForwardIndexNode.discoverForwardIndexNodes(Arrays.asList(forwardNode.getScope()), this.clusterID);
        StringArray sac = new StringArray();
        sac.setArray((String[])Arrays.copyOf(collectionIdsToBeAdded.toArray(), collectionIdsToBeAdded.toArray().length, String[].class));
        StringArray saf = new StringArray();
        saf.setArray((String[])Arrays.copyOf(fieldsToBeAdded.toArray(), fieldsToBeAdded.toArray().length, String[].class));
        for (String endpoint : endpoints.keySet()) {
            for (String key : endpoints.get(endpoint)) {
                logger.info("Recreating resource " + endpoint + " " + key);
                try {
                    EndpointReferenceType factoryEPR = new EndpointReferenceType((URI)new AttributedURI(endpoint + FACTORY));
                    ForwardIndexNodeFactoryPortType fpt = new ForwardIndexNodeFactoryServiceAddressingLocator().getForwardIndexNodeFactoryPortTypePort(factoryEPR);
                    String scope = forwardNode.getScope();
                    fpt = (ForwardIndexNodeFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)fpt, (GCUBEScope)GCUBEScope.getScope((String)scope), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
                    CreateResource cr = new CreateResource();
                    cr.setIndexID(key);
                    CreateResourceResponse crr = fpt.createResource(cr);
                    logger.info("created resource at endpoint " + crr.getEndpointReference());
                    ForwardIndexNodePortType pt = new ForwardIndexNodeServiceAddressingLocator().getForwardIndexNodePortTypePort(crr.getEndpointReference());
                    pt = (ForwardIndexNodePortType)GCUBERemotePortTypeContext.getProxy((Remote)pt, (GCUBEScope)GCUBEScope.getScope((String)forwardNode.getScope()), (int)700000, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
                    pt.setCollections(sac);
                    pt.setFields(saf);
                    logger.info("refreshing cache in " + crr.getEndpointReference());
                    pt.refresh(new VOID());
                }
                catch (URI.MalformedURIException e) {
                    logger.error("Exception", (Throwable)e);
                }
                catch (ServiceException e) {
                    logger.error("Exception", (Throwable)e);
                }
                catch (RemoteException e) {
                    logger.error("Exception", (Throwable)e);
                }
                catch (Exception e) {
                    logger.error("Exception", (Throwable)e);
                }
            }
        }
        return true;
    }

    public static HashMap<String, Set<String>> discover(String serviceName, String serviceClass, List<String> scopes, String clusterID) {
        logger.info("Discovering : serviceName " + serviceName + " serviceClass, " + serviceClass + " scopes : " + scopes + " clusterID : " + clusterID);
        HashMap<String, Set<String>> endpoints = new HashMap<String, Set<String>>();
        for (String scope : scopes) {
            ScopeProvider.instance.set(scope);
            XQuery query = ICFactory.queryFor(ServiceInstance.class);
            query.addNamespace("ns1", java.net.URI.create("http://gcube-system.org/namespaces/index/ForwardIndexNode/service")).addCondition("$resource/Data/gcube:ServiceClass/text() eq '" + serviceClass + "'").addCondition("$resource/Data/gcube:ServiceName/text() eq '" + serviceName + "'").addCondition("$resource/Data/ns1:ClusterID/text() eq '" + clusterID + "'");
            DiscoveryClient client = ICFactory.clientFor(ServiceInstance.class);
            List resources = client.submit((Query)query);
            for (ServiceInstance se : resources) {
                Set<Object> wsr;
                logger.info("service instance properties : " + se.properties());
                String endpoint = se.endpoint().toString();
                if (endpoints.containsKey(endpoint)) {
                    wsr = endpoints.get(endpoint);
                    wsr.add(se.key());
                    endpoints.put(endpoint, wsr);
                    continue;
                }
                wsr = new HashSet();
                wsr.add(se.key());
                endpoints.put(endpoint, wsr);
            }
        }
        return endpoints;
    }

    public static HashMap<String, Set<String>> discoverByIndexID(String serviceName, String serviceClass, List<String> scopes, String indexID, String epr) {
        logger.info("Discovering : serviceName " + serviceName + " serviceClass, " + serviceClass + " scopes : " + scopes + " indexID : " + indexID);
        HashMap<String, Set<String>> endpoints = new HashMap<String, Set<String>>();
        for (String scope : scopes) {
            ScopeProvider.instance.set(scope);
            XQuery query = ICFactory.queryFor(ServiceInstance.class);
            query.addNamespace("ns1", java.net.URI.create("http://gcube-system.org/namespaces/index/ForwardIndexNode/service")).addCondition("$resource/Data/gcube:ServiceClass/text() eq '" + serviceClass + "'").addCondition("$resource/Data/gcube:ServiceName/text() eq '" + serviceName + "'").addCondition("$resource/Data/ns1:IndexID/text() eq '" + indexID + "'").addCondition("$resource/Source/text() eq '" + epr + "'");
            DiscoveryClient client = ICFactory.clientFor(ServiceInstance.class);
            List resources = client.submit((Query)query);
            for (ServiceInstance se : resources) {
                Set<Object> wsr;
                String endpoint = se.endpoint().toString();
                if (endpoints.containsKey(endpoint)) {
                    wsr = endpoints.get(endpoint);
                    wsr.add(se.key());
                    endpoints.put(endpoint, wsr);
                    continue;
                }
                wsr = new HashSet();
                wsr.add(se.key());
                endpoints.put(endpoint, wsr);
            }
        }
        return endpoints;
    }

    public static HashMap<String, Set<String>> discoverForwardIndexNodes(List<String> scopes, String clusterID) {
        return ForwardIndexNode.discover(SERVICE_NAME, SERVICE_CLASS, scopes, clusterID);
    }

    private Resource getResource() throws ResourceException {
        return (Resource)StatefulContext.getContext().getWSHome().find();
    }

    private String getResouceKey() {
        try {
            String resourceKey = this.getResource().getResourceKey();
            logger.info("getResouceKey : " + resourceKey);
            return resourceKey;
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
            return null;
        }
    }

    private CouchBaseNode getForwardNode() {
        try {
            return this.getResource().getForwardNodeClient().getForwardNode();
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
            return null;
        }
    }

    private String getForwardNodeClientScope() {
        try {
            return this.getResource().getForwardNodeClient().getScope();
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) {
        ForwardIndexNode.discoverForwardIndexNodes(Arrays.asList("/gcube/devsec"), "/gcube/devsec");
    }
}

