/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.elasticsearch;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import gr.uoa.di.madgik.commons.server.ConnectionManagerConfig;
import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.carrot2.elasticsearch.ClusteringAction;
import org.carrot2.elasticsearch.DocumentGroup;
import org.carrot2.elasticsearch.ListAlgorithmsAction;
import org.carrot2.elasticsearch.LogicalField;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.elasticsearch.search.SearchHit;
import org.gcube.elasticsearch.FTNodeCache;
import org.gcube.elasticsearch.FullTextNodeHelpers;
import org.gcube.elasticsearch.entities.ClusterResponse;
import org.gcube.elasticsearch.helpers.ElasticSearchHelper;
import org.gcube.elasticsearch.helpers.QueryParser;
import org.gcube.elasticsearch.helpers.RowsetParser;
import org.gcube.indexmanagement.common.FullTextIndexType;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.common.IndexField;
import org.gcube.indexmanagement.resourceregistry.RRadaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullTextNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(FullTextNode.class);
    private static final long RSTIMEOUT = 10L;
    private static final int CLUSTER_HEALTH_YELLOW_TIMEOUT = 25;
    private static final int CLUSTER_HEALTH_GREEN_TIMEOUT = 5;
    private static final int DEFAULT_MAX_TERMS = 50;
    private static Integer BULKREQUEST_SIZE = 5000;
    private static Integer DEFAULT_NUM_OF_REPLICAS = 0;
    private static Integer DEFAULT_NUM_OF_SHARDS = 1;
    private static Integer MAX_FRAGMENT_CNT = 5;
    private static Integer MAX_FRAGMENT_SIZE = 150;
    private static String DEFAULT_DATADIR = ".";
    public static String META_INDEX = "meta-index";
    public static String ACTIVE_INDEX = "active_index";
    public static String ALL_INDEXES = "allIndexes";
    private static int INDEX_REFRESH_INTERVAL = 60;
    public static String DEFAULT_INDEXSTORE = "file system";
    public static String DEFAULT_ANALYZER = "simple";
    public static String KEYWORD_ANALYZER = "keyword";
    private Client indexClient;
    private Node indexNode;
    private Set<String> indexTypes = Sets.newConcurrentHashSet();
    private FTNodeCache cache;
    private String clusterName;
    private String defaultIndexName;
    private Integer noOfReplicas;
    private Integer noOfShards;
    private Integer maxResults;
    private String scope;
    private Integer maxFragmentCnt;
    private Integer maxFragmentSize;
    private String dataDir;
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private String hostname;
    private String indexStore;
    private transient RRadaptor rradaptor;
    static final String FILE_INDEX_NAME = "file-index";
    static final String FILE_INDEX_TYPE = "file-index-type";

    public FullTextNode(Builder builder) throws ResourceRegistryException, InterruptedException {
        this.hostname = builder.hostname;
        this.clusterName = builder.clusterName;
        this.defaultIndexName = builder.indexName;
        this.noOfReplicas = builder.noOfReplicas;
        this.noOfShards = builder.noOfShards;
        this.scope = builder.scope;
        this.maxFragmentCnt = builder.maxFragmentCnt;
        this.maxFragmentSize = builder.maxFragmentSize;
        this.dataDir = builder.dataDir;
        this.indexStore = builder.indexStore;
        this.maxResults = builder.maxResults;
        this.cache = new FTNodeCache();
        this.initialize(builder.useRR);
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getIndexName() {
        return this.defaultIndexName;
    }

    public Integer getNoOfReplicas() {
        return this.noOfReplicas;
    }

    public Integer getNoOfShards() {
        return this.noOfShards;
    }

    public String getScope() {
        return this.scope;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getMaxFragmentCnt() {
        return this.maxFragmentCnt;
    }

    public Integer getMaxFragmentSize() {
        return this.maxFragmentSize;
    }

    public Client getIndexClient() {
        return this.indexClient;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FullTextNode [indexNode=").append(this.indexNode).append(", cache=").append(this.cache).append(", clusterName=").append(this.clusterName).append(", indexName=").append(this.defaultIndexName).append(", noOfReplicas=").append(this.noOfReplicas).append(", noOfShards=").append(this.noOfShards).append(", scope=").append(this.scope).append(", maxFragmentCnt=").append(this.maxFragmentCnt).append(", maxFragmentSize=").append(this.maxFragmentSize).append("]");
        return builder.toString();
    }

    public void addIndexType(String indexTypeStr, String indexName) throws IndexException {
        FullTextIndexType indexType = QueryParser.retrieveIndexType(indexTypeStr, this.scope, this.cache);
        this.addIndexType(indexTypeStr, indexType, indexName);
    }

    public void addIndexType(String indexTypeStr, FullTextIndexType indexType, String indexName) throws IndexException {
        logger.info("Calling addIndexType");
        if (indexType == null) {
            logger.warn("IndexType is null");
            throw new IndexException("Trying to null as IndexType. Check how you got it");
        }
        QueryParser.addFullTextIndexTypeIntoCache(indexTypeStr, this.scope, indexType, this.cache);
        if (this.indexTypes.contains(indexName + "-" + indexTypeStr)) {
            logger.info("IndexType has already been added.");
            return;
        }
        IndicesAdminClient iac = this.indexClient.admin().indices();
        logger.info("Checking if index exists");
        if (((IndicesExistsResponse)iac.prepareExists(new String[]{indexName}).get()).isExists()) {
            logger.info("Index already exists");
        } else {
            CreateIndexRequestBuilder createIndexRequest = iac.prepareCreate(indexName).setSettings(this.getIndexCreateSetting());
            logger.info("Create Index Request : " + createIndexRequest.request());
            CreateIndexResponse cir = (CreateIndexResponse)createIndexRequest.get();
            logger.info("Create Index Response : " + cir);
        }
        logger.trace("Index Type");
        logger.trace("-----------------------------------------------");
        logger.trace(indexType.toString());
        logger.trace("-----------------------------------------------");
        HashMap<String, Map<Object, Object>> mapping = new HashMap<String, Map<Object, Object>>();
        ArrayList<String> presentables = new ArrayList<String>();
        ArrayList<String> searchables = new ArrayList<String>();
        ArrayList<String> highlightables = new ArrayList<String>();
        for (IndexField idxTypeField : indexType.getFields()) {
            String store;
            String string = store = idxTypeField.store ? "yes" : "no";
            String index = idxTypeField.index ? (idxTypeField.tokenize ? "analyzed" : "not_analyzed") : "no";
            if (idxTypeField.name.equalsIgnoreCase("gDocCollectionID") || idxTypeField.name.equalsIgnoreCase("ObjectID")) {
                index = "analyzed";
            }
            String type = idxTypeField.type != null && idxTypeField.type.trim().length() > 0 ? idxTypeField.type : "string";
            Map<Object, Object> fieldMap = new HashMap<String, Object>();
            if (type.equalsIgnoreCase("file")) {
                Map<String, Object> fileMapping = FullTextNode.getFileIndexMappingMap();
                logger.info("---------------------------");
                logger.info(fileMapping.toString());
                logger.info("---------------------------");
                fieldMap = FullTextNode.getFileIndexMappingMap();
                presentables.add(idxTypeField.name);
                presentables.add(idxTypeField.name + "." + "title");
                presentables.add(idxTypeField.name + "." + "date");
                presentables.add(idxTypeField.name + "." + "content");
                presentables.add(idxTypeField.name + "." + "author");
                searchables.add(idxTypeField.name);
                searchables.add(idxTypeField.name + "." + "title");
                searchables.add(idxTypeField.name + "." + "date");
                searchables.add(idxTypeField.name + "." + "content");
                searchables.add(idxTypeField.name + "." + "author");
                highlightables.add(idxTypeField.name);
            } else {
                fieldMap.put("type", type);
                fieldMap.put("index", index);
                fieldMap.put("boost", Float.valueOf(idxTypeField.boost));
                fieldMap.put("copy_to", idxTypeField.name + "_raw");
                if (idxTypeField.name.equalsIgnoreCase("gDocCollectionID") || idxTypeField.name.equalsIgnoreCase("ObjectID")) {
                    fieldMap.put("analyzer", KEYWORD_ANALYZER);
                } else {
                    fieldMap.put("analyzer", DEFAULT_ANALYZER);
                }
                HashMap<String, Object> rawFieldMap = new HashMap<String, Object>();
                rawFieldMap.put("type", type);
                rawFieldMap.put("index", "not_analyzed");
                rawFieldMap.put("boost", Float.valueOf(idxTypeField.boost));
                mapping.put(idxTypeField.name + "_raw", rawFieldMap);
                if (idxTypeField.highlightable && idxTypeField.returned) {
                    highlightables.add(idxTypeField.name);
                }
                if (idxTypeField.returned) {
                    presentables.add(idxTypeField.name);
                }
                if (idxTypeField.index) {
                    searchables.add(idxTypeField.name);
                }
            }
            mapping.put(idxTypeField.name, fieldMap);
        }
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("type", "string");
        fieldMap.put("index", "analyzed");
        fieldMap.put("analyzer", KEYWORD_ANALYZER);
        mapping.put("ObjectID", fieldMap);
        fieldMap = new HashMap();
        fieldMap.put("type", "string");
        fieldMap.put("index", "analyzed");
        fieldMap.put("analyzer", KEYWORD_ANALYZER);
        mapping.put("sid", fieldMap);
        this.cache.presentableFieldsPerIndexType.put(indexTypeStr, presentables);
        this.cache.searchableFieldsPerIndexType.put(indexTypeStr, searchables);
        this.cache.highlightableFieldsPerIndexType.put(indexTypeStr, highlightables);
        logger.info("1. in addIndexType cache presentables   : " + this.cache.presentableFieldsPerIndexType);
        logger.info("1. in addIndexType cache searchables    : " + this.cache.searchableFieldsPerIndexType);
        logger.info("1. in addIndexType cache highlightables : " + this.cache.highlightableFieldsPerIndexType);
        HashMap<String, HashMap<String, Map<Object, Object>>> propertyMap = new HashMap<String, HashMap<String, Map<Object, Object>>>();
        propertyMap.put("properties", mapping);
        HashMap<String, HashMap<String, HashMap<String, Map<Object, Object>>>> mappingMap = new HashMap<String, HashMap<String, HashMap<String, Map<Object, Object>>>>();
        mappingMap.put(indexTypeStr, propertyMap);
        String json = null;
        try {
            json = ElasticSearchHelper.createJSONObject(mappingMap).string();
        }
        catch (IOException e) {
            throw new IndexException("could not deserialize file mapping");
        }
        logger.info("json : " + json);
        PutMappingResponse pmr = (PutMappingResponse)iac.preparePutMapping(new String[0]).setIndices(new String[]{indexName}).setType(indexTypeStr).setSource(json).get();
        logger.info("Update Settings Response : " + pmr.toString());
        this.indexTypes.add(indexTypeStr + "-" + indexName);
    }

    public void createOrJoinCluster() {
        logger.info("creating or joining cluster");
        logger.info("cluster.name : " + this.clusterName);
        logger.info("index.number_of_replicas : " + this.noOfReplicas);
        logger.info("index.number_of_shards : " + this.noOfShards);
        logger.info("path.data : " + this.dataDir);
        Settings settings = this.getIndexCreateSetting();
        this.indexNode = NodeBuilder.nodeBuilder().client(false).clusterName(this.clusterName).settings(settings).node();
        this.indexClient = this.indexNode.client();
        this.waitClusterState();
    }

    private void waitClusterState() {
        logger.info("will wait for 5 seconds until the cluster status turns to green");
        try {
            this.indexClient.admin().cluster().prepareHealth(new String[0]).setWaitForGreenStatus().get(TimeValue.timeValueSeconds((long)5L));
            logger.info("cluster status has turned to green");
        }
        catch (Exception e) {
            logger.info("Cluster state did not turn to green. Will wait for 25 seconds until the cluster status turns to yellow");
            try {
                this.indexClient.admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().get(TimeValue.timeValueSeconds((long)25L));
                logger.info("cluster status has turned to yellow");
            }
            catch (Exception ex) {
                logger.warn("Error while waiting for the status to turn yellow. If this node was the first (or one of the first nodes) that hold an index with multiple shards this error is expected, since the 1st node might hold part of the index. If one of the last nodes reports this error then the index is unstable");
            }
        }
    }

    public String getESTransportAddress() {
        logger.info("getting transport address for node : " + this.hostname);
        String transportAddress = null;
        for (NodeInfo ni : (NodesInfoResponse)this.indexClient.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()) {
            TransportAddress address = ni.getTransport().getAddress().publishAddress();
            InetSocketTransportAddress sockAddress = null;
            if (!(address instanceof InetSocketTransportAddress)) continue;
            sockAddress = (InetSocketTransportAddress)address;
            String hostname = sockAddress.address().getHostName();
            String hoststring = sockAddress.address().getHostString();
            Integer port = sockAddress.address().getPort();
            logger.info("checking hostname : " + hostname + " hosttring : " + hoststring + " port : " + port);
            if (!hostname.equalsIgnoreCase(this.hostname)) continue;
            transportAddress = hostname + ":" + port;
            break;
        }
        logger.info("found transport address : " + transportAddress);
        return transportAddress;
    }

    public void joinCluster(List<String> hosts) throws IOException {
        String hostStr = Joiner.on((String)",").join(hosts);
        logger.info("joining cluster of known node : " + hosts);
        logger.info("cluster.name                  : " + this.clusterName);
        logger.info("index.number_of_replicas      :    " + this.noOfReplicas);
        logger.info("index.number_of_shards        : " + this.noOfShards);
        logger.info("path.data                     : " + this.dataDir);
        logger.info("hostStr                       : " + hostStr);
        Settings settings = ImmutableSettings.settingsBuilder().put(this.getIndexCreateSetting()).put("discovery.zen.ping.multicast.ping.enabled", false).put("discovery.zen.ping.multicast.enabled", false).put("discovery.zen.ping.unicast.enabled", true).put("discovery.zen.ping.unicast.hosts", hostStr).build();
        this.indexNode = NodeBuilder.nodeBuilder().client(false).clusterName(this.clusterName).settings(settings).node();
        this.indexClient = this.indexNode.client();
        this.waitClusterState();
    }

    public void close() {
        this.indexClient.close();
        this.indexNode.close();
        try {
            this.executorService.shutdown();
        }
        catch (Exception e) {
            logger.warn("error while closing executor service");
        }
    }

    private void initialize(Boolean useRRAdaptor) throws ResourceRegistryException, InterruptedException {
        this.initialize();
        if (useRRAdaptor.booleanValue()) {
            logger.info("Initializing ResourceRegistry");
            try {
                ResourceRegistry.startBridging();
                TimeUnit.SECONDS.sleep(1L);
                while (!ResourceRegistry.isInitialBridgingComplete()) {
                    TimeUnit.SECONDS.sleep(10L);
                }
            }
            catch (ResourceRegistryException e) {
                logger.error("Resource Registry could not be initialized", (Throwable)e);
                throw e;
            }
            catch (InterruptedException e) {
                logger.error("Resource Registry could not be initialized", (Throwable)e);
                throw e;
            }
            this.rradaptor = new RRadaptor();
            logger.info("Initializing ResourceRegistry is DONE");
        } else {
            logger.info("ResourceRegistry will NOT be initialized as configured");
        }
    }

    private void initialize() {
        TCPConnectionManager.Init((ConnectionManagerConfig)new ConnectionManagerConfig(this.hostname, Arrays.asList(new PortRange(4000, 4100)), true));
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
    }

    public String query(String queryString, Set<String> securityIdentifiers) throws IndexException, GRS2WriterException {
        return this.query(queryString, 0, -1, securityIdentifiers);
    }

    public String query(String queryString, Set<String> securityIdentifiers, Boolean useRR) throws IndexException, GRS2WriterException {
        return this.query(queryString, 0, -1, securityIdentifiers, useRR);
    }

    public String query(String queryString, Integer from, Integer maxHits, Set<String> securityIdentifiers) throws GRS2WriterException, IndexException {
        return this.query(queryString, from, maxHits, securityIdentifiers, Boolean.TRUE);
    }

    public String query(String queryString, Integer from, Integer maxHits, Set<String> securityIdentifiers, Boolean useRR) throws GRS2WriterException, IndexException {
        logger.info("calling query with : " + queryString + ". RR : " + (this.rradaptor != null) + " useRR : " + useRR);
        if (useRR.booleanValue()) {
            return FullTextNodeHelpers.query(this.indexClient, queryString, from, maxHits, securityIdentifiers, this.cache, this.maxResults, this.maxFragmentCnt, this.maxFragmentSize, this.rradaptor, ACTIVE_INDEX, this.executorService);
        }
        return FullTextNodeHelpers.query(this.indexClient, queryString, from, maxHits, securityIdentifiers, this.cache, this.maxResults, this.maxFragmentCnt, this.maxFragmentSize, null, ACTIVE_INDEX, this.executorService);
    }

    public Map<String, Integer> frequentTerms(String queryString, Set<String> securityIdentifiers) throws IndexException, GRS2WriterException {
        return this.frequentTerms(queryString, 50, securityIdentifiers);
    }

    public Map<String, Integer> frequentTerms(String queryString, Set<String> securityIdentifiers, Boolean useRR) throws IndexException, GRS2WriterException {
        return this.frequentTerms(queryString, 50, securityIdentifiers, useRR);
    }

    public Map<String, Integer> frequentTerms(String queryString, Integer maxTerms, Set<String> securityIdentifiers) throws GRS2WriterException, IndexException {
        return this.frequentTerms(queryString, maxTerms, securityIdentifiers, Boolean.TRUE);
    }

    public Map<String, Integer> frequentTerms(String queryString, Integer maxTerms, Set<String> securityIdentifiers, Boolean useRR) throws GRS2WriterException, IndexException {
        logger.info("calling query with : " + queryString + ". RR : " + (this.rradaptor != null) + " useRR : " + useRR);
        if (useRR.booleanValue()) {
            return FullTextNodeHelpers.frequentTerms(this.indexClient, queryString, maxTerms, securityIdentifiers, this.cache, this.rradaptor, ACTIVE_INDEX);
        }
        return FullTextNodeHelpers.frequentTerms(this.indexClient, queryString, maxTerms, securityIdentifiers, this.cache, null, ACTIVE_INDEX);
    }

    public String queryStream(String queryString, Set<String> securityIdentifiers) throws IndexException, GRS2WriterException {
        return this.queryStream(queryString, -1, securityIdentifiers);
    }

    public String queryStream(String queryString, int maxHits, Set<String> securityIdentifiers) throws IndexException, GRS2WriterException {
        return FullTextNodeHelpers.queryStream(this.indexClient, queryString, maxHits, this.cache, securityIdentifiers, this.maxResults, this.maxFragmentCnt, this.maxFragmentSize, this.rradaptor, ACTIVE_INDEX, this.executorService);
    }

    public boolean activateIndex(String indexName) {
        String idxName = null;
        idxName = indexName != null ? indexName : this.defaultIndexName;
        IndicesAliasesResponse iar = (IndicesAliasesResponse)this.indexClient.admin().indices().prepareAliases().addAlias(idxName, ACTIVE_INDEX).get();
        logger.info("Alias for  : " + idxName + " does not exist. Creating now");
        if (!iar.isAcknowledged()) {
            logger.warn("Alias for  : " + idxName + " creation failed");
            return false;
        }
        logger.info("Alias for  : " + idxName + " created");
        this.recreateMetaIndex();
        return true;
    }

    public boolean deactivateIndex(String indexName) {
        IndicesAliasesResponse iar = (IndicesAliasesResponse)this.indexClient.admin().indices().prepareAliases().removeAlias(indexName, ACTIVE_INDEX).get();
        if (!iar.isAcknowledged()) {
            logger.warn("Couldn't remove : " + indexName + " from alias");
            return false;
        }
        logger.info(indexName + " removed from alias");
        this.recreateMetaIndex();
        return true;
    }

    public boolean deleteIndex() {
        boolean indexRet = ElasticSearchHelper.delete(this.indexClient, ACTIVE_INDEX);
        return indexRet;
    }

    public boolean deleteMeta() {
        boolean metaRet = ElasticSearchHelper.delete(this.indexClient, META_INDEX);
        return metaRet;
    }

    public boolean deleteAll() {
        boolean indexRet = ElasticSearchHelper.deleteAllIndices(this.indexClient);
        return indexRet;
    }

    public boolean deleteIndex(String indexName) {
        this.deactivateIndex(indexName);
        boolean indexRet = ElasticSearchHelper.delete(this.indexClient, indexName);
        if (indexRet) {
            this.recreateMetaIndex();
        }
        return indexRet;
    }

    public boolean deleteTempIndex(String indexName) {
        boolean indexRet = ElasticSearchHelper.delete(this.indexClient, indexName);
        return indexRet;
    }

    public void deleteDocuments(List<String> docIDs) {
        ElasticSearchHelper.deleteDocuments(this.indexClient, ACTIVE_INDEX, docIDs);
    }

    public Boolean deleteCollection(String collID) {
        Boolean result = ElasticSearchHelper.deleteCollection(this.indexClient, ACTIVE_INDEX, collID);
        if (result.booleanValue()) {
            this.recreateMetaIndex();
        }
        return result;
    }

    public void commitMeta() {
        ElasticSearchHelper.commit(this.indexClient, META_INDEX);
    }

    public void commit() {
        ElasticSearchHelper.commit(this.indexClient, ACTIVE_INDEX);
    }

    public void commit(String indexName) {
        ElasticSearchHelper.commit(this.indexClient, indexName);
    }

    public void clearIndex(String indexTypeName) {
        ElasticSearchHelper.clearIndex(this.indexClient, ACTIVE_INDEX, indexTypeName);
    }

    public boolean feedRowset(String rowset, String indexName, Set<String> securityIdentifiers) {
        BulkRequestBuilder bulkRequest = this.indexClient.prepareBulk();
        boolean status = this.feedRowset(bulkRequest, rowset, indexName, securityIdentifiers);
        if (status) {
            long before = System.currentTimeMillis();
            BulkResponse bulkResponse = (BulkResponse)bulkRequest.setConsistencyLevel(WriteConsistencyLevel.ONE).get();
            long after = System.currentTimeMillis();
            logger.info("Time for commiting the bulk requests : " + (double)(after - before) / 1000.0 + " secs");
            logger.info("bulkResponse : " + (double)bulkResponse.getTookInMillis() / 1000.0 + " secs");
            logger.info("bulkResponse : " + bulkResponse);
            if (bulkResponse.hasFailures()) {
                logger.info("failures have happened");
            }
            this.commit(indexName);
        } else {
            logger.info("feedRowset failed");
        }
        return status;
    }

    public boolean feedLocator(String resultSetLocation, Set<String> securityIdentifiers) throws GRS2ReaderException, URISyntaxException, GRS2RecordDefinitionException, GRS2BufferException {
        return this.feedLocator(resultSetLocation, this.defaultIndexName, securityIdentifiers);
    }

    public Boolean feedLocator(String resultSetLocation, String indexName, Set<String> securityIdentifiers) throws GRS2ReaderException, URISyntaxException, GRS2RecordDefinitionException, GRS2BufferException {
        logger.info("Initializing reader at resultset : " + resultSetLocation);
        ForwardReader reader = new ForwardReader(new URI(resultSetLocation));
        reader.setIteratorTimeout(10L);
        reader.setIteratorTimeUnit(TimeUnit.MINUTES);
        int rowSetCount = 0;
        boolean success = true;
        long beforeFeed = System.currentTimeMillis();
        BulkRequestBuilder bulkRequest = this.indexClient.prepareBulk();
        try {
            logger.info("Initializing resultset reader iterator");
            Iterator it = reader.iterator();
            while (it.hasNext()) {
                logger.trace("Getting result : " + rowSetCount);
                long before = System.currentTimeMillis();
                Record result = (Record)it.next();
                long after = System.currentTimeMillis();
                logger.trace("Time for getting record from Result Set : " + (double)(after - before) / 1000.0 + " secs");
                before = System.currentTimeMillis();
                String rowset = RowsetParser.getRowsetFromResult(result);
                after = System.currentTimeMillis();
                logger.trace("Time for getting rowset from record : " + (double)(after - before) / 1000.0 + " secs");
                success = this.feedRowset(bulkRequest, rowset, indexName, securityIdentifiers);
                if (!success) {
                    logger.warn("feed rowset failed : " + rowset);
                } else {
                    logger.info("Result " + rowSetCount + " inserted");
                    if (++rowSetCount % BULKREQUEST_SIZE != 0) continue;
                    logger.info("BulkRequest reached  " + BULKREQUEST_SIZE + " records and will be executed");
                    if (FullTextNode.doBulk(bulkRequest).booleanValue()) {
                        bulkRequest = this.indexClient.prepareBulk();
                        continue;
                    }
                    bulkRequest = null;
                    success = false;
                }
                break;
            }
        }
        catch (Exception e) {
            logger.info("Exception will feeding", (Throwable)e);
            success = false;
        }
        reader.close();
        if (success) {
            logger.info("BulkRequest will insert the last  " + rowSetCount % BULKREQUEST_SIZE + " records");
            if (rowSetCount > 0) {
                if (rowSetCount % BULKREQUEST_SIZE == 0) {
                    logger.info("no records to add in the final bulk request");
                } else if (FullTextNode.doBulk(bulkRequest).booleanValue()) {
                    logger.info("last bulk request succedded. will commit now");
                    this.commit(indexName);
                    logger.info("Total number of records fed : " + rowSetCount);
                } else {
                    success = false;
                }
            } else {
                logger.warn("no records to add");
            }
        }
        long afterFeed = System.currentTimeMillis();
        logger.info("Total insert time : " + (double)(afterFeed - beforeFeed) / 1000.0);
        if (rowSetCount == 0) {
            logger.info("feed will return false since NO RECORDS were added");
            return false;
        }
        if (success) {
            logger.info("feed will return " + success + " since some records were added successfullly");
        } else {
            logger.info("feed will return " + success + " since some records were added. but errors occured during that");
        }
        return success;
    }

    private static Boolean doBulk(BulkRequestBuilder bulkRequest) {
        long beforeBulk = System.currentTimeMillis();
        BulkResponse bulkResponse = (BulkResponse)bulkRequest.setConsistencyLevel(WriteConsistencyLevel.ONE).get();
        long afterBulk = System.currentTimeMillis();
        logger.info("Time for commiting the bulk requests : " + (double)(afterBulk - beforeBulk) / 1000.0 + " secs");
        logger.info("bulkResponse : " + (double)bulkResponse.getTookInMillis() / 1000.0 + " secs");
        logger.info("bulkResponse : " + bulkResponse);
        if (bulkResponse.hasFailures()) {
            logger.warn("failures have happened. Message : " + bulkResponse.buildFailureMessage());
            logger.warn("Details ");
            for (BulkItemResponse brItem : bulkResponse.getItems()) {
                logger.warn("id : " + brItem.getId() + " " + brItem.getIndex() + " " + brItem.getType() + ", Failure Message : " + brItem.getFailureMessage());
            }
            logger.warn("failures have happened. Message : " + bulkResponse.buildFailureMessage());
            logger.warn("Error. Feeding failed");
            return false;
        }
        logger.info("bulk request finished without errors");
        return true;
    }

    private boolean feedRowset(BulkRequestBuilder bulkRequest, String rowset, String indexName, Set<String> securityIdentifiers) {
        long before = System.currentTimeMillis();
        String rsIdxTypeID = RowsetParser.getIdxTypeNameRowset(rowset);
        long after = System.currentTimeMillis();
        logger.trace("Time for getting rsIdxTypeID from rowset : " + (double)(after - before) / 1000.0 + " secs");
        logger.trace("Result IndexTypeID : " + rsIdxTypeID);
        before = System.currentTimeMillis();
        String lang = RowsetParser.getLangRowset(rowset);
        after = System.currentTimeMillis();
        logger.trace("Time for getting lang from rowset : " + (double)(after - before) / 1000.0 + " secs");
        logger.trace("Result lang : " + lang);
        if (lang == null || lang.equals("")) {
            lang = "unknown";
        }
        before = System.currentTimeMillis();
        String colID = RowsetParser.getColIDRowset(rowset);
        after = System.currentTimeMillis();
        logger.trace("Time for colID lang from rowset : " + (double)(after - before) / 1000.0 + " secs");
        logger.trace("Result colID : " + colID);
        if (colID == null || colID.equals("")) {
            logger.trace("No collection ID given in ROWSET: " + rowset);
            return false;
        }
        indexName = FullTextNode.createIndexName(indexName, colID, false);
        try {
            this.addIndexType(rsIdxTypeID, indexName);
        }
        catch (Exception e) {
            logger.error("Add index type exception", (Throwable)e);
            return false;
        }
        if (rsIdxTypeID == null || !this.indexTypes.contains(rsIdxTypeID + "-" + indexName)) {
            logger.error("IndexType : " + rsIdxTypeID + "-" + indexName + " not in indexTypes : " + this.indexTypes);
            return false;
        }
        logger.trace("Time for preprocessRowset : " + (double)(after - before) / 1000.0 + " secs");
        before = System.currentTimeMillis();
        FullTextIndexType idxType = this.cache.cachedIndexTypes.get(QueryParser.createIndexTypekey(rsIdxTypeID, this.scope));
        logger.trace("index type for name : " + idxType.getIndexTypeName());
        logger.trace("all indexTypes in cache : " + this.cache.cachedIndexTypes.keySet());
        Boolean insertResult = ElasticSearchHelper.insertRowSet(bulkRequest, this.indexClient, indexName, idxType, this.indexTypes, rowset, securityIdentifiers);
        if (!insertResult.booleanValue()) {
            logger.error("error in inserting the rowset " + rowset);
            return false;
        }
        after = System.currentTimeMillis();
        logger.trace("Time for insertRowSet : " + (double)(after - before) / 1000.0 + " secs");
        return true;
    }

    private static String createIndexName(String indexName, String collectionID, Boolean useCollectionID) {
        if (useCollectionID.booleanValue()) {
            return collectionID + "_" + indexName;
        }
        return indexName;
    }

    private void bindIndexType(String indexTypeStr, String indexName) {
        logger.info("Calling bindIndexType");
        FullTextIndexType indexType = QueryParser.retrieveIndexType(indexTypeStr, this.scope, this.cache);
        logger.info("Index Type");
        logger.info("-----------------------------------------------");
        logger.info(indexType.toString());
        logger.info("-----------------------------------------------");
        ArrayList presentables = Lists.newArrayList();
        ArrayList searchables = Lists.newArrayList();
        ArrayList highlightables = Lists.newArrayList();
        for (IndexField idxTypeField : indexType.getFields()) {
            if (idxTypeField.type.equalsIgnoreCase("file")) {
                presentables.add(idxTypeField.name);
                presentables.add(idxTypeField.name + "." + "title");
                presentables.add(idxTypeField.name + "." + "date");
                presentables.add(idxTypeField.name + "." + "content");
                presentables.add(idxTypeField.name + "." + "author");
                searchables.add(idxTypeField.name);
                searchables.add(idxTypeField.name + "." + "title");
                searchables.add(idxTypeField.name + "." + "date");
                searchables.add(idxTypeField.name + "." + "content");
                searchables.add(idxTypeField.name + "." + "author");
                highlightables.add(idxTypeField.name);
                continue;
            }
            if (idxTypeField.highlightable && idxTypeField.returned) {
                highlightables.add(idxTypeField.name);
            }
            if (idxTypeField.returned) {
                presentables.add(idxTypeField.name);
            }
            if (!idxTypeField.index) continue;
            searchables.add(idxTypeField.name);
        }
        this.indexTypes.add(indexTypeStr + "-" + indexName);
        this.cache.presentableFieldsPerIndexType.put(indexTypeStr, presentables);
        this.cache.searchableFieldsPerIndexType.put(indexTypeStr, searchables);
        this.cache.highlightableFieldsPerIndexType.put(indexTypeStr, highlightables);
        logger.info("1. in bindIndexType cache presentables   : " + this.cache.presentableFieldsPerIndexType);
        logger.info("1. in bindIndexType cache searchables    : " + this.cache.searchableFieldsPerIndexType);
        logger.info("1. in bindIndexType cache highlightables : " + this.cache.highlightableFieldsPerIndexType);
    }

    public void refreshIndexTypesOfIndex() {
        ClusterStateResponse clusterResponse = (ClusterStateResponse)this.indexClient.admin().cluster().prepareState().get();
        logger.info("clusterResponse : " + clusterResponse);
        ImmutableOpenMap aliases = clusterResponse.getState().getMetaData().aliases();
        logger.info("aliases : " + aliases);
        ImmutableOpenMap alias = (ImmutableOpenMap)aliases.get((Object)ACTIVE_INDEX);
        logger.info("alias : " + alias);
        if (alias != null && alias.size() > 0) {
            logger.info("alias is not null");
            for (String indexName : Sets.newHashSet((Iterator)alias.keysIt())) {
                logger.info("indexName for alias : " + indexName);
                IndexMetaData indexMetaData = clusterResponse.getState().getMetaData().index(indexName);
                logger.info("indexMetaData : " + indexMetaData);
                ImmutableOpenMap mappings = indexMetaData.mappings();
                logger.info("mappings : " + mappings);
                HashSet indexTypes = Sets.newHashSet();
                if (mappings != null && mappings.size() > 0) {
                    logger.info("mappings not null. creating index types from the keys...");
                    indexTypes = Sets.newHashSet((Iterator)mappings.keysIt());
                    logger.info("mappings not null. creating index types from the keys...OK");
                }
                logger.info("index types found in index : " + indexTypes);
                for (String indexType : indexTypes) {
                    logger.info("adding index type : " + indexType);
                    try {
                        this.bindIndexType(indexType, indexName);
                        logger.info("adding index type : " + indexType + " succeded");
                    }
                    catch (Exception e) {
                        logger.info("adding index type : " + indexType + " failed");
                    }
                }
            }
        }
    }

    public boolean addMetaIndex() {
        int counter = 0;
        Map result = null;
        while (true) {
            try {
                SearchResponse response = (SearchResponse)this.indexClient.prepareSearch(new String[]{META_INDEX}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).get();
                for (SearchHit hit : response.getHits().getHits()) {
                    result = hit.getSource();
                }
            }
            catch (IndexMissingException e) {
                logger.warn("Index missing, proceeding to creation");
            }
            catch (Exception e) {
                logger.warn("Not initialized yet, retrying");
                ++counter;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    logger.error("Failed to sleep", (Throwable)e);
                }
                if (counter != 10) continue;
                return false;
            }
            break;
        }
        if (result == null) {
            try {
                logger.info("does not exist but will force a delete on meta to resolve inconsistencies");
                this.deleteMeta();
            }
            catch (Exception e) {
                logger.warn("error while deleting the meta index", (Throwable)e);
            }
            try {
                ImmutableMap document = ImmutableMap.builder().put((Object)"collectionIDs", (Object)Collections.EMPTY_LIST).put((Object)"fields", (Object)Collections.EMPTY_LIST).build();
                IndicesAdminClient iac = this.indexClient.admin().indices();
                logger.info("creating meta-index response");
                CreateIndexResponse cir = (CreateIndexResponse)iac.prepareCreate(META_INDEX).setSettings(this.getMetaIndexCreateSetting()).get();
                logger.info("created meta-index response : " + cir.toString());
                IndexResponse response = (IndexResponse)this.indexClient.prepareIndex(META_INDEX, META_INDEX).setSource(ElasticSearchHelper.createJSONObject((Map<String, ? extends Object>)document).string()).setConsistencyLevel(WriteConsistencyLevel.ONE).execute().actionGet();
                logger.info("Add empty records to meta-index response id : " + response.getId());
                logger.info("committing meta-index");
                this.commitMeta();
                logger.info("Added empty meta-index");
            }
            catch (Exception e) {
                logger.error("Failed to add meta index", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public void recreateMetaIndex() {
        logger.info("will recreate the meta index");
        List<Object> collections = null;
        ArrayList fields = null;
        if (!ElasticSearchHelper.exists(this.indexClient, ACTIVE_INDEX)) {
            collections = Lists.newArrayList();
            fields = Lists.newArrayList();
            logger.info(ACTIVE_INDEX + " does not exist");
        } else {
            logger.info("will commit active index in order to make it searchable");
            this.commit();
            logger.info("commit finished");
            collections = this.getAllCollections();
            logger.info("all collections in the active index are : " + collections);
            fields = Lists.newArrayList();
            for (String string : collections) {
                Set<String> languages = this.getLanguagesOfCollection(string);
                logger.info("all languages of collection : " + string + " are " + languages);
                for (String lang : languages) {
                    logger.info("language of collection : " + string + " is " + lang);
                    Set<String> indexTypes = ElasticSearchHelper.getIndexTypesByCollectionIDNoCache(string, this.indexClient, ACTIVE_INDEX);
                    logger.info("index types of collection : " + string + " is " + indexTypes);
                    for (String indexTypeName : indexTypes) {
                        FullTextIndexType indexType = QueryParser.retrieveIndexType(indexTypeName, this.scope, this.cache);
                        logger.info("index type retrieved for indextypename : " + indexTypeName + " is " + indexType);
                        logger.info("index type has fields : " + Arrays.toString(indexType.getFields()));
                        for (IndexField field : indexType.getFields()) {
                            String fieldName = field.name;
                            if (field.returned) {
                                String presentableField = string + ":" + lang + ":" + "p" + ":" + fieldName;
                                fields.add(presentableField);
                            }
                            if (!field.index) continue;
                            String searchableField = string + ":" + lang + ":" + "s" + ":" + fieldName;
                            fields.add(searchableField);
                        }
                    }
                    fields.add(string + ":" + lang + ":" + "s" + ":" + ALL_INDEXES);
                }
                logger.info("collection : " + string + " has fields : " + fields);
            }
        }
        logger.info("invalidating cache...");
        this.cache.invalidate();
        logger.info("invalidating cache...OK");
        logger.info("rebuilding meta index...");
        this.rebuildMetaIndex(collections, fields);
        logger.info("rebuilding meta index...OK");
        logger.info("refreshing index types of index...");
        this.refreshIndexTypesOfIndex();
        logger.info("refreshing index types of index...OK");
        logger.info("commiting meta index...");
        this.commitMeta();
        logger.info("commiting meta index...OK");
    }

    private void updateExistingDocumentInMetaIndex(String document) throws Exception {
        Map result = null;
        String id = null;
        long version = 0L;
        SearchResponse searchResponse = (SearchResponse)this.indexClient.prepareSearch(new String[]{META_INDEX}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).get();
        if (searchResponse.getHits().getHits().length != 1) {
            logger.error("meta index should always have exactly 1 document");
            throw new Exception("meta index should always have exactly 1 document");
        }
        SearchHit hit = searchResponse.getHits().getHits()[0];
        result = hit.getSource();
        id = hit.getId();
        version = hit.getVersion();
        if (result != null) {
            ++version;
        }
        IndexResponse indexResponse = (IndexResponse)this.indexClient.prepareIndex(META_INDEX, META_INDEX, id).setSource(document).setConsistencyLevel(WriteConsistencyLevel.ONE).setVersion(version).get();
        logger.info("Add records to meta-index response id : " + indexResponse.getId());
        logger.info("Inserted colIDs and fields to " + META_INDEX);
        logger.info("committing meta-index");
    }

    public boolean rebuildMetaIndex(List<String> collectionIds, List<String> fields) {
        if (!this.deleteMeta()) {
            logger.warn("problem while deleting the meta index");
            return false;
        }
        if (!this.addMetaIndex()) {
            logger.warn("problem while creating the meta index");
            return false;
        }
        try {
            ImmutableMap document = ImmutableMap.builder().put((Object)"collectionIDs", collectionIds).put((Object)"fields", fields).build();
            logger.info("documented to be added in metaindex add : " + document);
            this.updateExistingDocumentInMetaIndex(ElasticSearchHelper.createJSONObject((Map<String, ? extends Object>)document).string());
            logger.info("Rebuilt meta-index");
        }
        catch (Exception e) {
            logger.error("Failed to rebuild meta index", (Throwable)e);
            return false;
        }
        return true;
    }

    public void invalidateCache() {
        this.cache.invalidate();
    }

    public Set<String> getCollectionsOfIndex(String indexName) {
        Set<String> collectionsOfIndex = ElasticSearchHelper.getAllCollectionsOfIndex(this.indexClient, indexName);
        logger.info("collectionsOfIndex : " + indexName + " count : " + collectionsOfIndex);
        return collectionsOfIndex;
    }

    public Long getCollectionDocumentsCount(String collectionID) {
        Long count = ElasticSearchHelper.collectionDocumentsCountElasticSearch(this.indexClient, ACTIVE_INDEX, collectionID);
        logger.info("collection : " + collectionID + " count : " + count);
        return count;
    }

    public Set<String> getIndicesOfCollection(String collection) {
        Set<String> indicesOfCollection = ElasticSearchHelper.indicesOfCollection(this.indexClient, ACTIVE_INDEX, collection);
        logger.info("indicesOfCollection : " + collection + " count : " + indicesOfCollection);
        return indicesOfCollection;
    }

    public List<String> getAllCollections() {
        return Lists.newArrayList(ElasticSearchHelper.allCollectionsOfIndexElasticSearch(this.indexClient, ACTIVE_INDEX));
    }

    public Set<String> getLanguagesOfCollection(String collection) {
        return ElasticSearchHelper.getLanguagesOfCollection(this.indexClient, ACTIVE_INDEX, collection);
    }

    public Map<String, List<String>> getCollectionsAndFieldsOfIndexFromMeta() {
        SearchResponse response = (SearchResponse)this.indexClient.prepareSearch(new String[]{META_INDEX}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
        try {
            List collections = (List)response.getHits().getHits()[0].getSource().get("collectionIDs");
            List fields = (List)response.getHits().getHits()[0].getSource().get("fields");
            ImmutableMap result = ImmutableMap.builder().put((Object)"collections", (Object)collections).put((Object)"fields", (Object)fields).build();
            return result;
        }
        catch (Exception e) {
            logger.warn("Error while getting collections of index", (Throwable)e);
            return null;
        }
    }

    public List<String> getCollectionsFromMeta() {
        ArrayList collections = Lists.newArrayList();
        try {
            SearchResponse response = (SearchResponse)this.indexClient.prepareSearch(new String[]{META_INDEX}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
            if (response.getHits().getHits().length == 0) {
                logger.warn("no collections found in the meta-index");
                return collections;
            }
            Object collObj = response.getHits().getHits()[0].getSource().get("collectionIDs");
            logger.info("meta index document : " + response.getHits().getHits()[0].getSource());
            if (collObj instanceof String) {
                collections.add(collObj.toString());
            } else if (collObj instanceof List) {
                collections.addAll((List)collObj);
            }
            return collections;
        }
        catch (Exception e) {
            logger.warn("Error while getting collections of index", (Throwable)e);
            return collections;
        }
    }

    public List<String> getFieldsFromMeta() {
        ArrayList fields = Lists.newArrayList();
        SearchResponse response = (SearchResponse)this.indexClient.prepareSearch(new String[]{META_INDEX}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
        try {
            Object fieldsObj = response.getHits().getHits()[0].getSource().get("fields");
            if (response.getHits().getHits().length == 0) {
                logger.warn("no collections found in the meta-index");
                return fields;
            }
            logger.info("meta index document : " + response.getHits().getHits()[0].getSource());
            if (fieldsObj instanceof String) {
                fields.add(fieldsObj.toString());
            }
            if (fieldsObj instanceof List) {
                fields.addAll((List)fieldsObj);
            }
            return fields;
        }
        catch (Exception e) {
            logger.warn("Error while getting fields of index", (Throwable)e);
            return fields;
        }
    }

    private Settings getIndexCreateSetting() {
        Settings settings = ImmutableSettings.builder().put("index.number_of_replicas", String.valueOf(this.noOfReplicas)).put("index.number_of_shards", String.valueOf(this.noOfShards)).put("index.store", this.indexStore).put("index.refresh_interval", INDEX_REFRESH_INTERVAL).put("path.data", this.dataDir).build();
        return settings;
    }

    private Settings getMetaIndexCreateSetting() {
        Settings settings = ImmutableSettings.builder().put("index.number_of_replicas", String.valueOf(this.noOfReplicas)).put("index.number_of_shards", 1).put("index.store", this.indexStore).put("index.refresh_interval", 0).put("path.data", this.dataDir).build();
        return settings;
    }

    public Boolean createFileIndex() {
        return FullTextNode.createFileIndex(this.indexClient, FILE_INDEX_NAME, FILE_INDEX_TYPE, this.getIndexCreateSetting());
    }

    public static Boolean createFileIndex(Client indexClient, String indexName, String indexType, Settings settings) {
        IndicesAdminClient iac = indexClient.admin().indices();
        logger.info("Checking if index exists");
        if (((IndicesExistsResponse)iac.prepareExists(new String[]{indexName}).get()).isExists()) {
            logger.info("Index already exists");
            return true;
        }
        CreateIndexRequestBuilder createIndexRequest = iac.prepareCreate(indexName).setSettings(settings);
        logger.info("Create Index Request : " + createIndexRequest.request());
        CreateIndexResponse cir = (CreateIndexResponse)createIndexRequest.get();
        logger.info("Create Index Response : " + cir);
        XContentBuilder fileIndexMapping = FullTextNode.getFileIndexMapping(indexType);
        PutMappingResponse pmr = (PutMappingResponse)iac.preparePutMapping(new String[0]).setIndices(new String[]{indexName}).setType(indexType).setSource(fileIndexMapping).get();
        return pmr.isAcknowledged();
    }

    public void addFile(String base64) throws IOException {
        FullTextNode.addFile(this.indexClient, base64, FILE_INDEX_NAME, FILE_INDEX_TYPE);
    }

    public static void addFile(Client indexClient, String base64, String indexName, String indexType) throws IOException {
        HashMap<String, String> doc = new HashMap<String, String>();
        doc.put("file", base64);
        XContentBuilder json = ElasticSearchHelper.createJSONObject(doc);
        logger.info("inserting file");
        logger.info(json.string());
        indexClient.prepareIndex(indexName, indexType).setSource(json).get();
    }

    private static XContentBuilder getFileIndexMapping(String type) {
        XContentBuilder builder = null;
        try {
            builder = XContentFactory.jsonBuilder().startObject().startObject(type).startObject("properties").startObject("file").field("type", "attachment").startObject("fields").startObject("file").field("index", "analyzed").field("store", "true").endObject().startObject("date").field("index", "analyzed").field("store", "true").endObject().startObject("author").field("index", "analyzed").field("store", "true").endObject().startObject("content").field("store", "true").endObject().startObject("title").field("index", "analyzed").field("store", "true").endObject().endObject().endObject().endObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return builder;
    }

    private static Map<String, Object> getFileIndexMappingMap() {
        XContentBuilder builder = null;
        try {
            builder = XContentFactory.jsonBuilder().startObject().field("type", "attachment").startObject("fields").startObject("file").field("index", "analyzed").field("store", "true").endObject().startObject("date").field("index", "analyzed").field("store", "true").endObject().startObject("author").field("index", "analyzed").field("store", "true").endObject().startObject("content").field("store", "true").endObject().startObject("title").field("index", "analyzed").field("store", "true").endObject().endObject().endObject();
            Map map = (Map)new Gson().fromJson(builder.string(), new TypeToken<Map<String, Object>>(){}.getType());
            return map;
        }
        catch (Exception e) {
            logger.error("error while serializing index type for file type");
            return null;
        }
    }

    public static void main(String[] args) throws IOException {
        System.out.println(FullTextNode.getFileIndexMapping("XXXXX").string());
    }

    public List<ClusterResponse> cluster(String query, String queryHint, Integer numberOfClusters, String urlField, List<String> titleFields, List<String> contentFields, List<String> languageFields, Set<String> sids, String algorithm, Integer searchHits) {
        return FullTextNodeHelpers.clustering(this.indexClient, query, queryHint, numberOfClusters, urlField, titleFields, contentFields, languageFields, this.rradaptor, sids, algorithm, searchHits);
    }

    public void listAlgorithms() {
        DocumentGroup[] groups;
        ListAlgorithmsAction.ListAlgorithmsActionResponse ral = (ListAlgorithmsAction.ListAlgorithmsActionResponse)ListAlgorithmsAction.INSTANCE.newRequestBuilder(this.indexClient).get();
        logger.info("algorithms : ", (Object)ral.getAlgorithms());
        System.out.println(ral.getAlgorithms());
        SearchRequestBuilder srb = this.indexClient.prepareSearch(new String[]{ACTIVE_INDEX}).setSize(10000).setFrom(0).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"_all", (Object)"soccer")).addFields(new String[]{"ObjectID", "title", "content"});
        System.out.println(srb.toString());
        Integer clusterCount = 2;
        ClusteringAction.ClusteringActionRequestBuilder ca = ClusteringAction.INSTANCE.newRequestBuilder(this.indexClient).setAlgorithm((String)ral.getAlgorithms().get(1)).setQueryHint("soccer").setSearchRequest(srb.request()).addFieldMapping("ObjectID", LogicalField.URL).addFieldMapping("title", LogicalField.TITLE).addFieldMapping("content", LogicalField.CONTENT).addAttribute("LingoClusteringAlgorithm.desiredClusterCountBase", (Object)clusterCount);
        System.out.println(ca.toString());
        ClusteringAction.ClusteringActionResponse car = (ClusteringAction.ClusteringActionResponse)ca.get();
        SearchHit[] hits = car.getSearchResponse().getHits().getHits();
        for (DocumentGroup documentGroup : groups = car.getDocumentGroups()) {
            System.out.println(documentGroup.getLabel());
        }
        for (DocumentGroup documentGroup : hits) {
            System.out.println(documentGroup.getSourceAsString());
        }
    }

    static /* synthetic */ Integer access$000() {
        return DEFAULT_NUM_OF_REPLICAS;
    }

    static /* synthetic */ Integer access$100() {
        return DEFAULT_NUM_OF_SHARDS;
    }

    static /* synthetic */ Integer access$200() {
        return MAX_FRAGMENT_CNT;
    }

    static /* synthetic */ Integer access$300() {
        return MAX_FRAGMENT_SIZE;
    }

    static /* synthetic */ String access$400() {
        return DEFAULT_DATADIR;
    }

    public static class Builder {
        String hostname;
        Boolean useRR = true;
        String clusterName;
        String indexName;
        Integer noOfReplicas = FullTextNode.access$000();
        Integer noOfShards = FullTextNode.access$100();
        String scope;
        Integer maxFragmentCnt = FullTextNode.access$200();
        Integer maxFragmentSize = FullTextNode.access$300();
        String dataDir = FullTextNode.access$400();
        String indexStore = DEFAULT_INDEXSTORE;
        Integer maxResults;

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder dataDir(String dataDir) {
            this.dataDir = dataDir;
            return this;
        }

        public Builder indexStore(String indexStore) {
            this.indexStore = indexStore;
            return this;
        }

        public Builder useResourceRegistry(Boolean useRR) {
            this.useRR = useRR;
            return this;
        }

        public Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public Builder noOfReplicas(Integer noOfReplicas) {
            this.noOfReplicas = noOfReplicas;
            return this;
        }

        public Builder noOfShards(Integer noOfShards) {
            this.noOfShards = noOfShards;
            return this;
        }

        public Builder maxFragmentCnt(Integer maxFragmentCnt) {
            this.maxFragmentCnt = maxFragmentCnt;
            return this;
        }

        public Builder maxFragmentSize(Integer maxFragmentSize) {
            this.maxFragmentSize = maxFragmentSize;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public FullTextNode build() throws ResourceRegistryException, InterruptedException {
            if (this.hostname == null) {
                throw new IllegalStateException("hostname not given");
            }
            return new FullTextNode(this);
        }
    }
}

