/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.elasticsearch;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.events.KeyValueEvent;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.gcube.elasticsearch.FTNodeCache;
import org.gcube.elasticsearch.helpers.ElasticSearchHelper;
import org.gcube.elasticsearch.helpers.QueryParser;
import org.gcube.elasticsearch.parser.ElasticSearchParser;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.resourceregistry.RRadaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullTextNodeHelpers
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final Logger logger = LoggerFactory.getLogger(FullTextNodeHelpers.class);
    private static final long RSTIMEOUT = 30L;

    public static String query(Client indexClient, String queryString, Integer from, Integer maxHits, Set<String> securityIdentifiers, FTNodeCache cache, Integer defaultMaxResults, final Integer maxFragmentCnt, Integer maxFragmentSize, RRadaptor rradaptor, String indexName) throws GRS2WriterException, IndexException {
        logger.info("queryString received : " + queryString);
        logger.info("securityIdentifiers  : " + securityIdentifiers);
        logger.info("maxHits              : " + maxHits);
        final long starttime = System.currentTimeMillis();
        long starttime_part = System.currentTimeMillis();
        long starttime_part_t = System.currentTimeMillis();
        ElasticSearchParser parsedQueryContainer = new ElasticSearchParser(queryString, rradaptor, FullTextNodeHelpers.filterSecurityIdentifiers(securityIdentifiers));
        long endtime_part_t = System.currentTimeMillis();
        logger.info(" ~> time to create the ElasticSearchParser : " + (double)(endtime_part_t - starttime_part_t) / 1000.0 + " secs");
        starttime_part_t = System.currentTimeMillis();
        ArrayList<String> projections = parsedQueryContainer.getProjects();
        endtime_part_t = System.currentTimeMillis();
        logger.info(" ~> projections : " + projections);
        logger.info(" ~> time to get the projections from parser : " + (double)(endtime_part_t - starttime_part_t) / 1000.0 + " secs");
        starttime_part_t = System.currentTimeMillis();
        QueryBuilder qb = parsedQueryContainer.parse();
        endtime_part_t = System.currentTimeMillis();
        logger.info(" ~> query builder : " + qb);
        logger.info(" ~> time to parse the query in the parser : " + (double)(endtime_part_t - starttime_part_t) / 1000.0 + " secs");
        logger.info("query after parse : " + qb.toString());
        starttime_part_t = System.currentTimeMillis();
        ArrayList<AbstractMap.SimpleEntry<String, String>> sortBys = parsedQueryContainer.getSortBys();
        endtime_part_t = System.currentTimeMillis();
        logger.info(" ~> sortbys : " + sortBys);
        logger.info(" ~> time to get the sortbys from parser : " + (double)(endtime_part_t - starttime_part_t) / 1000.0 + " secs");
        final boolean distinct = parsedQueryContainer.getDistincts().size() > 0;
        logger.info(" ~> distinct : " + distinct);
        logger.info(" ~> time to get distinct from parser : " + (double)(endtime_part_t - starttime_part_t) / 1000.0 + " secs");
        starttime_part_t = System.currentTimeMillis();
        Set<String> collIDs = parsedQueryContainer.getCollections();
        endtime_part_t = System.currentTimeMillis();
        logger.info(" ~> time to get the collection from parser : " + (double)(endtime_part_t - starttime_part_t) / 1000.0 + " secs");
        logger.info("collectionID of query : " + collIDs);
        starttime_part_t = System.currentTimeMillis();
        Set<String> indexTypes = QueryParser.getIndexTypesByCollectionIDs(cache.indexTypesByCollIDs, collIDs, indexClient, indexName);
        endtime_part_t = System.currentTimeMillis();
        logger.info(" ~> time to get the indexTypes from cache : " + (double)(endtime_part_t - starttime_part_t) / 1000.0 + " secs");
        logger.info("indexTypes for collectionIDs : " + indexTypes);
        logger.info("cache : " + cache);
        logger.info("cache indextypes    by coll id    : " + cache.indexTypesByCollIDs);
        logger.info("cache presentables    by idx type : " + cache.presentableFieldsPerIndexType);
        logger.info("cache searchables     by idx type : " + cache.searchableFieldsPerIndexType);
        logger.info("cache highlightables  by idx type : " + cache.highlightableFieldsPerIndexType);
        List<String> presentables = QueryParser.createPresentableForIndexTypes(cache.presentableFieldsPerIndexType, indexTypes);
        logger.info("presentables for index types : " + presentables);
        List<String> searchables = QueryParser.createSearchablesForIndexTypes(cache.searchableFieldsPerIndexType, indexTypes);
        logger.info("searchables for index types : " + searchables);
        List<String> highlightables = QueryParser.createHighlightablesForIndexTypes(cache.highlightableFieldsPerIndexType, indexTypes);
        logger.info("highlightables for index types : " + highlightables);
        List<String> projectedFields = new ArrayList<String>(projections);
        if (projectedFields.contains("*")) {
            projectedFields = presentables;
        }
        if (projectedFields.contains("S")) {
            projectedFields.remove("S");
        }
        if (projectedFields.contains("ObjectID")) {
            projectedFields.remove("ObjectID");
        }
        long endtime_part = System.currentTimeMillis();
        logger.info("parsing time : " + (double)(endtime_part - starttime_part) / 1000.0 + " secs");
        if (maxHits < 0 && defaultMaxResults != null) {
            logger.trace("max results for query not given. will use global maxResults : " + defaultMaxResults);
            maxHits = defaultMaxResults;
        } else if (maxHits > 0 && defaultMaxResults != null) {
            logger.trace("max results for query given." + maxHits + " global maxResults : " + defaultMaxResults);
            maxHits = Math.min(maxHits, defaultMaxResults);
        }
        starttime_part = System.currentTimeMillis();
        final SearchHit[] hits = projections.contains("S") ? ElasticSearchHelper.queryElasticSearch(indexClient, indexName, qb, maxHits, highlightables, projectedFields, maxFragmentSize, maxFragmentCnt, from, sortBys) : ElasticSearchHelper.queryElasticSearch(indexClient, indexName, qb, maxHits, from, projectedFields, sortBys);
        endtime_part = System.currentTimeMillis();
        logger.info("elasticsearch query time : " + (double)(endtime_part - starttime_part) / 1000.0 + " secs");
        logger.info("Number of hits returned by index : " + hits.length);
        System.out.println("Number of hits returned by index : " + hits.length);
        logger.info("emitting key value event with key : resultsNumberFinal and value : " + hits.length);
        final List<String> returnFields = projections.contains("*") ? presentables : projections;
        final RecordWriter<GenericRecord> rsWriter = QueryParser.initRSWriterForSearchHits(returnFields, rradaptor);
        rsWriter.emit((BufferEvent)new KeyValueEvent("resultsNumberFinal", String.valueOf(hits.length)));
        final HashSet recHashes = new HashSet();
        new Thread(){

            @Override
            public void run() {
                try {
                    for (SearchHit hit : hits) {
                        if (distinct) {
                            int recHash = hit.getSourceAsString().hashCode();
                            if (recHashes.contains(recHash)) {
                                logger.info("duplicate found. skipping..");
                                continue;
                            }
                            recHashes.add(hit.getSourceAsString().hashCode());
                        }
                        if (!QueryParser.writeSearchHitInResultSet(hit, (RecordWriter<GenericRecord>)rsWriter, returnFields, maxFragmentCnt, 30L)) break;
                    }
                    if (rsWriter.getStatus() != IBuffer.Status.Dispose) {
                        rsWriter.close();
                    }
                }
                catch (Exception e) {
                    logger.error("Error during search.", (Throwable)e);
                    try {
                        if (rsWriter.getStatus() != IBuffer.Status.Dispose) {
                            rsWriter.close();
                        }
                    }
                    catch (Exception ex) {
                        logger.error("Error while closing RS writer.", (Throwable)ex);
                    }
                }
                logger.info("total query time : " + (double)(System.currentTimeMillis() - starttime) / 1000.0 + " secs");
            }
        }.start();
        logger.info("results locator : " + rsWriter.getLocator());
        return rsWriter.getLocator().toString();
    }

    public static String queryStream(final Client indexClient, String queryString, Integer maxHits, FTNodeCache cache, Set<String> securityIdentifiers, Integer defaultMaxResults, final Integer maxFragmentCnt, final Integer maxFragmentSize, RRadaptor rradaptor, final String indexName) throws GRS2WriterException, IndexException {
        logger.info("queryString received : " + queryString);
        logger.info("maxHits              : " + maxHits);
        final long starttime = System.currentTimeMillis();
        long starttime_part = System.currentTimeMillis();
        ElasticSearchParser parsedQueryContainer = new ElasticSearchParser(queryString, rradaptor, FullTextNodeHelpers.filterSecurityIdentifiers(securityIdentifiers));
        final ArrayList<String> projections = parsedQueryContainer.getProjects();
        final QueryBuilder qb = parsedQueryContainer.parse();
        logger.info("query after parse : " + qb.toString());
        final ArrayList<AbstractMap.SimpleEntry<String, String>> sortBys = parsedQueryContainer.getSortBys();
        boolean distinct = parsedQueryContainer.getDistincts().size() > 0;
        Set<String> collIDs = parsedQueryContainer.getCollections();
        logger.info("collectionID of query : " + collIDs);
        Set<String> indexTypes = QueryParser.getIndexTypesByCollectionIDs(cache.indexTypesByCollIDs, collIDs, indexClient, indexName);
        logger.info("indexTypes for collectionIDs : " + indexTypes);
        logger.info("cache : " + cache);
        logger.info("cache indextypes    by coll id    : " + cache.indexTypesByCollIDs);
        logger.info("cache presentables    by idx type : " + cache.presentableFieldsPerIndexType);
        logger.info("cache searchables     by idx type : " + cache.searchableFieldsPerIndexType);
        logger.info("cache highlightables  by idx type : " + cache.highlightableFieldsPerIndexType);
        List<String> presentables = QueryParser.createPresentableForIndexTypes(cache.presentableFieldsPerIndexType, indexTypes);
        logger.info("presentables for index types : " + presentables);
        List<String> searchables = QueryParser.createSearchablesForIndexTypes(cache.searchableFieldsPerIndexType, indexTypes);
        logger.info("searchables for index types : " + searchables);
        final List<String> highlightables = QueryParser.createHighlightablesForIndexTypes(cache.highlightableFieldsPerIndexType, indexTypes);
        logger.info("highlightables for index types : " + highlightables);
        List<String> projectedFields = new ArrayList<String>(projections);
        if (projectedFields.contains("*")) {
            projectedFields = presentables;
        }
        if (projectedFields.contains("S")) {
            projectedFields.remove("S");
        }
        long endtime_part = System.currentTimeMillis();
        logger.info("parsing time : " + (double)(endtime_part - starttime_part) / 1000.0 + " secs");
        if (maxHits < 0 && defaultMaxResults != null) {
            logger.trace("max results for query not given. will use global maxResults : " + defaultMaxResults);
            maxHits = defaultMaxResults;
        } else if (maxHits > 0 && defaultMaxResults != null) {
            logger.trace("max results for query given." + maxHits + " global maxResults : " + defaultMaxResults);
            maxHits = Math.min(maxHits, defaultMaxResults);
        }
        long numberOfHits = ElasticSearchHelper.queryCountElasticSearch(indexClient, indexName, qb);
        if (maxHits > 0 && numberOfHits > (long)maxHits.intValue()) {
            numberOfHits = maxHits.intValue();
        }
        logger.info("Number of hits returned by index : " + numberOfHits);
        final List<String> returnFields = projections.contains("*") ? presentables : projections;
        final RecordWriter<GenericRecord> rsWriter = QueryParser.initRSWriterForSearchHits(returnFields, rradaptor);
        logger.info("emitting key value event with key : resultsNumberFinal and value : " + numberOfHits);
        rsWriter.emit((BufferEvent)new KeyValueEvent("resultsNumberFinal", String.valueOf(numberOfHits)));
        final List<String> projectedFieldsList = projectedFields;
        final int fHits = maxHits;
        Runnable writerRun = new Runnable(){

            @Override
            public void run() {
                try {
                    SearchResponse scrollResp = projections.contains("S") ? ElasticSearchHelper.queryElasticSearchScroll(indexClient, indexName, qb, fHits, highlightables, projectedFieldsList, maxFragmentSize, maxFragmentCnt, sortBys) : ElasticSearchHelper.queryElasticSearchScroll(indexClient, indexName, qb, fHits, projectedFieldsList, sortBys);
                    int hits = 0;
                    do {
                        SearchHit hit;
                        scrollResp = ElasticSearchHelper.getNextSearchResponse(indexClient, scrollResp);
                        logger.info("hits from scroll : " + scrollResp.getHits().getHits().length);
                        Iterator i$ = scrollResp.getHits().iterator();
                        while (i$.hasNext() && QueryParser.writeSearchHitInResultSet(hit = (SearchHit)i$.next(), (RecordWriter<GenericRecord>)rsWriter, returnFields, maxFragmentCnt, 30L)) {
                        }
                        if (rsWriter.getStatus() == IBuffer.Status.Dispose) continue;
                        rsWriter.close();
                    } while (scrollResp.getHits().getHits().length != 0 && ++hits <= fHits);
                }
                catch (Exception e) {
                    logger.error("Error during search.", (Throwable)e);
                    try {
                        if (rsWriter.getStatus() != IBuffer.Status.Dispose) {
                            rsWriter.close();
                        }
                    }
                    catch (Exception ex) {
                        logger.error("Error while closing RS writer.", (Throwable)ex);
                    }
                }
                logger.info("total query time : " + (double)(System.currentTimeMillis() - starttime) / 1000.0 + " secs");
            }
        };
        new Thread(writerRun).start();
        logger.info("results locator : " + rsWriter.getLocator());
        return rsWriter.getLocator().toString();
    }

    private static Set<String> filterSecurityIdentifiers(Set<String> sids) {
        if (sids == null) {
            return Sets.newHashSet();
        }
        Predicate<String> predicate = new Predicate<String>(){

            public boolean apply(String input) {
                boolean ret = !Strings.isNullOrEmpty((String)input);
                return ret;
            }
        };
        return Sets.newHashSet((Iterable)Iterables.filter(sids, (Predicate)predicate));
    }

    public static void main(String[] args) {
        HashSet mysids = null;
        System.out.println(FullTextNodeHelpers.filterSecurityIdentifiers(mysids));
        mysids = Sets.newHashSet();
        System.out.println(FullTextNodeHelpers.filterSecurityIdentifiers(mysids));
        mysids = Sets.newHashSet((Object[])new String[]{""});
        mysids.add("sid1");
        mysids.add("");
        mysids.add("sid2");
        System.out.println(FullTextNodeHelpers.filterSecurityIdentifiers(mysids));
        mysids = Sets.newHashSet((Object[])new String[]{"", ""});
        System.out.println(FullTextNodeHelpers.filterSecurityIdentifiers(mysids));
    }
}

