/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.elasticsearch;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import gr.uoa.di.madgik.commons.server.ConnectionManagerConfig;
import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.elasticsearch.search.SearchHit;
import org.gcube.elasticsearch.FTNodeCache;
import org.gcube.elasticsearch.FullTextNodeHelpers;
import org.gcube.elasticsearch.helpers.ElasticSearchHelper;
import org.gcube.elasticsearch.helpers.QueryParser;
import org.gcube.elasticsearch.helpers.RowsetParser;
import org.gcube.indexmanagement.common.FullTextIndexType;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.common.IndexField;
import org.gcube.indexmanagement.resourceregistry.RRadaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullTextNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(FullTextNode.class);
    private static Integer BULKREQUEST_SIZE = 5000;
    private static Integer DEFAULT_NUM_OF_REPLICAS = 0;
    private static Integer DEFAULT_NUM_OF_SHARDS = 1;
    private static Integer MAX_FRAGMENT_CNT = 5;
    private static Integer MAX_FRAGMENT_SIZE = 150;
    private static String DEFAULT_DATADIR = ".";
    private static final long RSTIMEOUT = 5L;
    private static String ALL_INDEXES = "allIndexes";
    public static String META_INDEX = "meta-index";
    public static String TEMP_PREFIX = "temp";
    public static String INDEX_PREFIX = "idx";
    public static String ACTIVE_INDEX = "active_index";
    private static int INDEX_REFRESH_INTERVAL = 60;
    public static String DEFAULT_INDEXNAME = "default_index";
    public static String DEFAULT_INDEXSTORE = "file system";
    public static String DEFAULT_ANALYZER = "simple";
    public static String KEYWORD_ANALYZER = "keyword";
    private Client indexClient;
    private Node indexNode;
    private Set<String> indexTypes = new HashSet<String>();
    private FTNodeCache cache;
    private String clusterName;
    private String defaultIndexName;
    private Integer noOfReplicas;
    private Integer noOfShards;
    private Integer maxResults;
    private String scope;
    private Integer maxFragmentCnt;
    private Integer maxFragmentSize;
    private String dataDir = DEFAULT_DATADIR;
    private transient RRadaptor rradaptor;
    private String hostname;
    private HashMap<String, FullTextIndexType> colForField = new HashMap();
    static final String FILE_INDEX_NAME = "file-index";
    static final String FILE_INDEX_TYPE = "file-index-type";

    public FullTextNode(String hostname) throws ResourceRegistryException, InterruptedException {
        this(hostname, true);
        logger.info("Initializing FullTextNode");
        this.cache = new FTNodeCache();
        this.initialize(true);
    }

    public FullTextNode(String hostname, Boolean useRRAdaptor) throws ResourceRegistryException, InterruptedException {
        logger.info("Initializing FullTextNode");
        this.cache = new FTNodeCache();
        this.hostname = hostname;
        this.initialize(useRRAdaptor);
    }

    public FullTextNode(String hostname, String clusterName, String indexName, Integer noOfReplicas, Integer noOfShards, String scope, Integer maxFragmentCnt, Integer maxFragmentSize, Boolean useRRAdaptor) throws ResourceRegistryException, InterruptedException {
        this(hostname, useRRAdaptor);
        this.clusterName = clusterName;
        this.defaultIndexName = indexName;
        this.noOfReplicas = noOfReplicas;
        this.noOfShards = noOfShards;
        this.scope = scope;
        this.maxFragmentCnt = maxFragmentCnt;
        this.maxFragmentSize = maxFragmentSize;
    }

    public FullTextNode(String hostname, String clusterName, String indexName, Integer noOfReplicas, Integer noOfShards, String scope, Integer maxFragmentCnt, Integer maxFragmentSize) throws ResourceRegistryException, InterruptedException {
        this(hostname);
        this.clusterName = clusterName;
        this.defaultIndexName = indexName;
        this.noOfReplicas = noOfReplicas;
        this.noOfShards = noOfShards;
        this.scope = scope;
        this.maxFragmentCnt = maxFragmentCnt;
        this.maxFragmentSize = maxFragmentSize;
    }

    public FullTextNode(String hostname, String clusterName, String indexName, String scope, Boolean useRRAdaptor) throws ResourceRegistryException, InterruptedException {
        this(hostname, useRRAdaptor);
        this.clusterName = clusterName;
        this.defaultIndexName = indexName;
        this.noOfReplicas = DEFAULT_NUM_OF_REPLICAS;
        this.noOfShards = DEFAULT_NUM_OF_SHARDS;
        this.scope = scope;
        this.maxFragmentCnt = MAX_FRAGMENT_CNT;
        this.maxFragmentSize = MAX_FRAGMENT_SIZE;
    }

    public FullTextNode(String hostname, String clusterName, String indexName, String scope) throws ResourceRegistryException, InterruptedException {
        this(hostname);
        this.clusterName = clusterName;
        this.defaultIndexName = indexName;
        this.noOfReplicas = DEFAULT_NUM_OF_REPLICAS;
        this.noOfShards = DEFAULT_NUM_OF_SHARDS;
        this.scope = scope;
        this.maxFragmentCnt = MAX_FRAGMENT_CNT;
        this.maxFragmentSize = MAX_FRAGMENT_SIZE;
    }

    public FullTextNode(String hostname, String dataDir, String clusterName, String indexName, Integer noOfReplicas, Integer noOfShards, String scope, Integer maxFragmentCnt, Integer maxFragmentSize, Boolean useRRAdaptor) throws ResourceRegistryException, InterruptedException {
        this(hostname, clusterName, indexName, noOfReplicas, noOfShards, scope, maxFragmentCnt, maxFragmentSize, useRRAdaptor);
        this.dataDir = dataDir;
    }

    public FullTextNode(String hostname, String dataDir, String clusterName, String indexName, Integer noOfReplicas, Integer noOfShards, String scope, Integer maxFragmentCnt, Integer maxFragmentSize) throws ResourceRegistryException, InterruptedException {
        this(hostname, clusterName, indexName, noOfReplicas, noOfShards, scope, maxFragmentCnt, maxFragmentSize);
        this.dataDir = dataDir;
    }

    public FullTextNode(String hostname, String dataDir, String clusterName, String indexName, String scope, Boolean useRRAdaptor) throws ResourceRegistryException, InterruptedException {
        this(hostname, clusterName, indexName, scope, useRRAdaptor);
        this.dataDir = dataDir;
    }

    public FullTextNode(String hostname, String dataDir, String clusterName, String indexName, String scope) throws ResourceRegistryException, InterruptedException {
        this(hostname, clusterName, indexName, scope);
        this.dataDir = dataDir;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getIndexName() {
        return this.defaultIndexName;
    }

    public Integer getNoOfReplicas() {
        return this.noOfReplicas;
    }

    public Integer getNoOfShards() {
        return this.noOfShards;
    }

    public String getScope() {
        return this.scope;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getMaxFragmentCnt() {
        return this.maxFragmentCnt;
    }

    public Integer getMaxFragmentSize() {
        return this.maxFragmentSize;
    }

    public Client getIndexClient() {
        return this.indexClient;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FullTextNode [indexNode=").append(this.indexNode).append(", cache=").append(this.cache).append(", clusterName=").append(this.clusterName).append(", indexName=").append(this.defaultIndexName).append(", noOfReplicas=").append(this.noOfReplicas).append(", noOfShards=").append(this.noOfShards).append(", scope=").append(this.scope).append(", maxFragmentCnt=").append(this.maxFragmentCnt).append(", maxFragmentSize=").append(this.maxFragmentSize).append("]");
        return builder.toString();
    }

    public synchronized void addIndexType(String indexTypeStr, String indexName) throws Exception {
        FullTextIndexType indexType = QueryParser.retrieveIndexType(indexTypeStr, this.scope, this.cache);
        this.addIndexType(indexTypeStr, indexType, indexName);
    }

    public synchronized void addIndexType(String indexTypeStr, FullTextIndexType indexType, String indexName) throws Exception {
        logger.info("Calling addIndexType");
        if (indexType == null) {
            logger.warn("IndexType is null");
            throw new Exception("Trying to null as IndexType. Check how you got it");
        }
        QueryParser.addFullTextIndexTypeIntoCache(indexTypeStr, this.scope, indexType, this.cache);
        if (this.indexTypes.contains(indexName + "-" + indexTypeStr)) {
            logger.info("IndexType has already been added.");
            return;
        }
        IndicesAdminClient iac = this.indexClient.admin().indices();
        logger.info("Checking if index exists");
        if (((IndicesExistsResponse)iac.prepareExists(new String[]{indexName}).get()).isExists()) {
            logger.info("Index already exists");
        } else {
            CreateIndexRequestBuilder createIndexRequest = iac.prepareCreate(indexName).setSettings(this.getIndexCreateSetting());
            logger.info("Create Index Request : " + createIndexRequest.request());
            CreateIndexResponse cir = (CreateIndexResponse)createIndexRequest.get();
            logger.info("Create Index Response : " + cir);
        }
        logger.trace("Index Type");
        logger.trace("-----------------------------------------------");
        logger.trace(indexType.toString());
        logger.trace("-----------------------------------------------");
        HashMap mapping = new HashMap();
        ArrayList<String> presentables = new ArrayList<String>();
        ArrayList<String> searchables = new ArrayList<String>();
        ArrayList<String> highlightables = new ArrayList<String>();
        for (IndexField idxTypeField : indexType.getFields()) {
            String store;
            String string = store = idxTypeField.store ? "yes" : "no";
            String index = idxTypeField.index ? (idxTypeField.tokenize ? "analyzed" : "not_analyzed") : "no";
            if (idxTypeField.name.equalsIgnoreCase("gDocCollectionID") || idxTypeField.name.equalsIgnoreCase("ObjectID")) {
                index = "analyzed";
            }
            String type = idxTypeField.type != null && idxTypeField.type.trim().length() > 0 ? idxTypeField.type : "string";
            HashMap<String, Object> fieldMap = new HashMap<String, Object>();
            fieldMap.put("type", type);
            fieldMap.put("index", index);
            fieldMap.put("boost", Float.valueOf(idxTypeField.boost));
            fieldMap.put("copy_to", idxTypeField.name + "_raw");
            if (idxTypeField.name.equalsIgnoreCase("gDocCollectionID") || idxTypeField.name.equalsIgnoreCase("ObjectID")) {
                fieldMap.put("analyzer", KEYWORD_ANALYZER);
            } else {
                fieldMap.put("analyzer", DEFAULT_ANALYZER);
            }
            mapping.put(idxTypeField.name, fieldMap);
            HashMap<String, Object> rawFieldMap = new HashMap<String, Object>();
            rawFieldMap.put("type", type);
            rawFieldMap.put("index", "not_analyzed");
            rawFieldMap.put("boost", Float.valueOf(idxTypeField.boost));
            mapping.put(idxTypeField.name + "_raw", rawFieldMap);
            if (idxTypeField.highlightable && idxTypeField.returned) {
                highlightables.add(idxTypeField.name);
            }
            if (idxTypeField.returned) {
                presentables.add(idxTypeField.name);
            }
            if (!idxTypeField.index) continue;
            searchables.add(idxTypeField.name);
        }
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("type", "string");
        fieldMap.put("index", "analyzed");
        fieldMap.put("analyzer", KEYWORD_ANALYZER);
        mapping.put("ObjectID", fieldMap);
        fieldMap = new HashMap();
        fieldMap.put("type", "string");
        fieldMap.put("index", "analyzed");
        fieldMap.put("analyzer", KEYWORD_ANALYZER);
        mapping.put("sid", fieldMap);
        this.cache.presentableFieldsPerIndexType.put(indexTypeStr, presentables);
        this.cache.searchableFieldsPerIndexType.put(indexTypeStr, searchables);
        this.cache.highlightableFieldsPerIndexType.put(indexTypeStr, highlightables);
        logger.info("1. in addIndexType cache presentables   : " + this.cache.presentableFieldsPerIndexType);
        logger.info("1. in addIndexType cache searchables    : " + this.cache.searchableFieldsPerIndexType);
        logger.info("1. in addIndexType cache highlightables : " + this.cache.highlightableFieldsPerIndexType);
        HashMap propertyMap = new HashMap();
        propertyMap.put("properties", mapping);
        HashMap mappingMap = new HashMap();
        mappingMap.put(indexTypeStr, propertyMap);
        String json = ElasticSearchHelper.createJSONObject(mappingMap).string();
        logger.info("json : " + json);
        PutMappingResponse pmr = (PutMappingResponse)iac.preparePutMapping(new String[0]).setIndices(new String[]{indexName}).setType(indexTypeStr).setSource(json).get();
        logger.info("Update Settings Response : " + pmr.toString());
        this.indexTypes.add(indexTypeStr + "-" + indexName);
    }

    public void createOrJoinCluster() {
        logger.info("creating or joining cluster");
        logger.info("cluster.name : " + this.clusterName);
        logger.info("index.number_of_replicas : " + this.noOfReplicas);
        logger.info("index.number_of_shards : " + this.noOfShards);
        logger.info("path.data : " + this.dataDir);
        Settings settings = this.getIndexCreateSetting();
        this.indexNode = NodeBuilder.nodeBuilder().client(false).clusterName(this.clusterName).settings(settings).node();
        this.indexClient = this.indexNode.client();
    }

    public String getESTransportAddress() {
        logger.info("getting transport address for node : " + this.hostname);
        String transportAddress = null;
        for (NodeInfo ni : (NodesInfoResponse)this.indexClient.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()) {
            TransportAddress address = ni.getTransport().getAddress().publishAddress();
            InetSocketTransportAddress sockAddress = null;
            if (!(address instanceof InetSocketTransportAddress)) continue;
            sockAddress = (InetSocketTransportAddress)address;
            String hostname = sockAddress.address().getHostName();
            String hoststring = sockAddress.address().getHostString();
            Integer port = sockAddress.address().getPort();
            logger.info("checking hostname : " + hostname + " hosttring : " + hoststring + " port : " + port);
            if (!hostname.equalsIgnoreCase(this.hostname)) continue;
            transportAddress = hostname + ":" + port;
            break;
        }
        logger.info("found transport address : " + transportAddress);
        return transportAddress;
    }

    public void joinCluster(List<String> hosts) throws IOException {
        String hostStr = Joiner.on((String)",").join(hosts);
        logger.info("joining cluster of known node : " + hosts);
        logger.info("cluster.name                  : " + this.clusterName);
        logger.info("index.number_of_replicas      :    " + this.noOfReplicas);
        logger.info("index.number_of_shards        : " + this.noOfShards);
        logger.info("path.data                     : " + this.dataDir);
        logger.info("hostStr                       : " + hostStr);
        Settings settings = ImmutableSettings.settingsBuilder().put(this.getIndexCreateSetting()).put("discovery.zen.ping.multicast.ping.enabled", false).put("discovery.zen.ping.multicast.enabled", false).put("discovery.zen.ping.unicast.enabled", true).put("discovery.zen.ping.unicast.hosts", hostStr).build();
        this.indexNode = NodeBuilder.nodeBuilder().client(false).clusterName(this.clusterName).settings(settings).node();
        this.indexClient = this.indexNode.client();
    }

    public String query(String queryString, Set<String> securityIdentifiers) throws IndexException, GRS2WriterException {
        return this.query(queryString, 0, -1, securityIdentifiers);
    }

    public String query(String queryString, Set<String> securityIdentifiers, Boolean useRR) throws IndexException, GRS2WriterException {
        return this.query(queryString, 0, -1, securityIdentifiers, useRR);
    }

    public String query(String queryString, Integer from, Integer maxHits, Set<String> securityIdentifiers) throws GRS2WriterException, IndexException {
        return this.query(queryString, from, maxHits, securityIdentifiers, Boolean.TRUE);
    }

    public String query(String queryString, Integer from, Integer maxHits, Set<String> securityIdentifiers, Boolean useRR) throws GRS2WriterException, IndexException {
        logger.info("calling query with : " + queryString + ". RR : " + (this.rradaptor != null) + " useRR : " + useRR);
        if (useRR.booleanValue()) {
            return FullTextNodeHelpers.query(this.indexClient, queryString, from, maxHits, securityIdentifiers, this.cache, this.maxResults, this.maxFragmentCnt, this.maxFragmentSize, this.rradaptor, ACTIVE_INDEX);
        }
        return FullTextNodeHelpers.query(this.indexClient, queryString, from, maxHits, securityIdentifiers, this.cache, this.maxResults, this.maxFragmentCnt, this.maxFragmentSize, null, ACTIVE_INDEX);
    }

    public String queryStream(String queryString, Set<String> securityIdentifiers) throws IndexException, GRS2WriterException {
        return this.queryStream(queryString, -1, securityIdentifiers);
    }

    public String queryStream(String queryString, int maxHits, Set<String> securityIdentifiers) throws IndexException, GRS2WriterException {
        return FullTextNodeHelpers.queryStream(this.indexClient, queryString, maxHits, this.cache, securityIdentifiers, this.maxResults, this.maxFragmentCnt, this.maxFragmentSize, this.rradaptor, ACTIVE_INDEX);
    }

    public boolean activateIndex(String indexName) {
        String idxName = null;
        idxName = indexName != null ? indexName : this.defaultIndexName;
        IndicesAliasesResponse iar = (IndicesAliasesResponse)this.indexClient.admin().indices().prepareAliases().addAlias(idxName, ACTIVE_INDEX).get();
        logger.info("Alias for  : " + idxName + " does not exist. Creating now");
        if (!iar.isAcknowledged()) {
            logger.warn("Alias for  : " + idxName + " creation failed");
            return false;
        }
        logger.info("Alias for  : " + idxName + " created");
        return true;
    }

    public boolean deactivateIndex(String indexName) {
        IndicesAliasesResponse iar = (IndicesAliasesResponse)this.indexClient.admin().indices().prepareAliases().removeAlias(indexName, ACTIVE_INDEX).get();
        if (!iar.isAcknowledged()) {
            logger.warn("Couldn't remove : " + indexName + " from alias");
            return false;
        }
        logger.info(indexName + " removed from alias");
        return true;
    }

    public boolean deleteIndex() {
        boolean indexRet = ElasticSearchHelper.delete(this.indexClient, ACTIVE_INDEX);
        return indexRet;
    }

    public boolean deleteMeta() {
        boolean metaRet = ElasticSearchHelper.delete(this.indexClient, META_INDEX);
        return metaRet;
    }

    public boolean deleteAll() {
        boolean indexRet = ElasticSearchHelper.deleteAllIndices(this.indexClient);
        return indexRet;
    }

    public Set<String> getCollectionsOfIndex(String indexName) {
        Set<String> collectionsOfIndex = ElasticSearchHelper.getAllCollectionsOfIndex(this.indexClient, indexName);
        logger.info("collectionsOfIndex : " + indexName + " count : " + collectionsOfIndex);
        return collectionsOfIndex;
    }

    public Long getCollectionDocuments(String collectionID) {
        Long count = ElasticSearchHelper.collectionDocumentsCountElasticSearch(this.indexClient, ACTIVE_INDEX, collectionID);
        logger.info("collection : " + collectionID + " count : " + count);
        return count;
    }

    public Set<String> getIndicesOfCollection(String collection) {
        Set<String> indicesOfCollection = ElasticSearchHelper.indicesOfCollection(this.indexClient, ACTIVE_INDEX, collection);
        logger.info("indicesOfCollection : " + collection + " count : " + indicesOfCollection);
        return indicesOfCollection;
    }

    public boolean deleteIndex(String indexName) {
        this.deactivateIndex(indexName);
        Set<String> collectionsOfIndex = ElasticSearchHelper.getAllCollectionsOfIndex(this.indexClient, indexName);
        boolean indexRet = ElasticSearchHelper.delete(this.indexClient, indexName);
        boolean doDelete = false;
        IndicesAdminClient iac = this.indexClient.admin().indices();
        logger.info("Checking if alias exists");
        if (!((IndicesExistsResponse)iac.prepareExists(new String[]{ACTIVE_INDEX}).get()).isExists()) {
            logger.info("alias does not exist");
            doDelete = false;
        } else {
            logger.info("alias exists");
            doDelete = true;
        }
        if (indexRet) {
            if (doDelete) {
                for (String collID : collectionsOfIndex) {
                    if (!ElasticSearchHelper.collectionExists(this.indexClient, ACTIVE_INDEX, collID).booleanValue()) {
                        logger.info("collection : " + collID + " does not exist in the rest indices");
                        Boolean updateResult = this.updateManagerPropertiesRemoveCollID(collID);
                        if (updateResult.booleanValue()) continue;
                        logger.warn("meta index is not updated");
                        return false;
                    }
                    logger.info("collection : " + collID + " exists in the rest indices");
                }
            } else {
                logger.info("alias does not exist so we will delete the collections from meta");
                for (String collID : collectionsOfIndex) {
                    Boolean updateResult = this.updateManagerPropertiesRemoveCollID(collID);
                    if (updateResult.booleanValue()) continue;
                    logger.warn("meta index is not updated");
                    return false;
                }
            }
            this.commitMeta();
        }
        return indexRet;
    }

    public void deleteDocuments(List<String> docIDs) {
        ElasticSearchHelper.deleteDocuments(this.indexClient, ACTIVE_INDEX, docIDs);
    }

    public Boolean deleteCollection(String collID) {
        Boolean result = ElasticSearchHelper.deleteCollection(this.indexClient, ACTIVE_INDEX, collID);
        if (result.booleanValue()) {
            Boolean updateResult = this.updateManagerPropertiesRemoveCollID(collID);
            if (!updateResult.booleanValue()) {
                logger.warn("meta index is not updated");
                return false;
            }
            this.commitMeta();
        }
        return result;
    }

    public void commitMeta() {
        ElasticSearchHelper.commit(this.indexClient, META_INDEX);
    }

    public void commit() {
        ElasticSearchHelper.commit(this.indexClient, ACTIVE_INDEX);
    }

    public void commit(String indexName) {
        ElasticSearchHelper.commit(this.indexClient, indexName);
    }

    public void clearIndex(String indexTypeName) {
        ElasticSearchHelper.clearIndex(this.indexClient, ACTIVE_INDEX, indexTypeName);
    }

    public void close() {
        this.indexClient.close();
        this.indexNode.close();
    }

    private void initialize(Boolean useRRAdaptor) throws ResourceRegistryException, InterruptedException {
        this.initialize();
        if (useRRAdaptor.booleanValue()) {
            logger.info("Initializing ResourceRegistry");
            try {
                ResourceRegistry.startBridging();
                TimeUnit.SECONDS.sleep(1L);
                while (!ResourceRegistry.isInitialBridgingComplete()) {
                    TimeUnit.SECONDS.sleep(10L);
                }
            }
            catch (ResourceRegistryException e) {
                logger.error("Resource Registry could not be initialized", (Throwable)e);
                throw e;
            }
            catch (InterruptedException e) {
                logger.error("Resource Registry could not be initialized", (Throwable)e);
                throw e;
            }
            this.rradaptor = new RRadaptor();
            logger.info("Initializing ResourceRegistry is DONE");
        } else {
            logger.info("ResourceRegistry will NOT be initialized as configured");
        }
    }

    private void initialize() {
        TCPConnectionManager.Init((ConnectionManagerConfig)new ConnectionManagerConfig(this.hostname, Arrays.asList(new PortRange(4000, 4100)), true));
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
    }

    public boolean feedRowset(String rowset, String indexName, Set<String> securityIdentifiers) {
        HashMap<String, FullTextIndexType> colForIdTypes;
        BulkRequestBuilder bulkRequest = this.indexClient.prepareBulk();
        boolean status = this.feedRowset(bulkRequest, rowset, colForIdTypes = new HashMap<String, FullTextIndexType>(), indexName, securityIdentifiers);
        if (status) {
            long before = System.currentTimeMillis();
            BulkResponse bulkResponse = (BulkResponse)bulkRequest.setConsistencyLevel(WriteConsistencyLevel.ONE).get();
            long after = System.currentTimeMillis();
            logger.info("Time for commiting the bulk requests : " + (double)(after - before) / 1000.0 + " secs");
            logger.info("bulkResponse : " + (double)bulkResponse.getTookInMillis() / 1000.0 + " secs");
            logger.info("bulkResponse : " + bulkResponse);
            if (bulkResponse.hasFailures()) {
                logger.info("failures have happened");
            }
            this.commit(indexName);
        } else {
            logger.info("feedRowset failed");
        }
        return status;
    }

    public boolean feedLocator(String resultSetLocation, String indexName, Set<String> securityIdentifiers) throws GRS2ReaderException, URISyntaxException, GRS2RecordDefinitionException, GRS2BufferException {
        return this.feedLocator(resultSetLocation, this.colForField, indexName, securityIdentifiers);
    }

    public boolean feedLocator(String resultSetLocation, Set<String> securityIdentifiers) throws GRS2ReaderException, URISyntaxException, GRS2RecordDefinitionException, GRS2BufferException {
        return this.feedLocator(resultSetLocation, this.colForField, this.defaultIndexName, securityIdentifiers);
    }

    public Boolean feedLocator(String resultSetLocation, HashMap<String, FullTextIndexType> colForField, Set<String> securityIdentifiers) throws GRS2ReaderException, URISyntaxException, GRS2RecordDefinitionException, GRS2BufferException {
        return this.feedLocator(resultSetLocation, colForField, this.defaultIndexName, securityIdentifiers);
    }

    public Boolean feedLocator(String resultSetLocation, HashMap<String, FullTextIndexType> colForField, String indexName, Set<String> securityIdentifiers) throws GRS2ReaderException, URISyntaxException, GRS2RecordDefinitionException, GRS2BufferException {
        logger.info("Initializing reader at resultset : " + resultSetLocation);
        ForwardReader reader = new ForwardReader(new URI(resultSetLocation));
        reader.setIteratorTimeout(5L);
        reader.setIteratorTimeUnit(TimeUnit.MINUTES);
        int rowSetCount = 0;
        boolean success = true;
        long beforeFeed = System.currentTimeMillis();
        BulkRequestBuilder bulkRequest = this.indexClient.prepareBulk();
        try {
            logger.info("Initializing resultset reader iterator");
            Iterator it = reader.iterator();
            while (it.hasNext()) {
                logger.trace("Getting result : " + rowSetCount);
                long before = System.currentTimeMillis();
                Record result = (Record)it.next();
                long after = System.currentTimeMillis();
                logger.trace("Time for getting record from Result Set : " + (double)(after - before) / 1000.0 + " secs");
                before = System.currentTimeMillis();
                String rowset = RowsetParser.getRowsetFromResult(result);
                after = System.currentTimeMillis();
                logger.trace("Time for getting rowset from record : " + (double)(after - before) / 1000.0 + " secs");
                success = this.feedRowset(bulkRequest, rowset, colForField, indexName, securityIdentifiers);
                if (!success) {
                    logger.warn("feed rowset failed : " + rowset);
                } else {
                    logger.info("Result " + rowSetCount + " inserted");
                    if (++rowSetCount % BULKREQUEST_SIZE != 0) continue;
                    logger.info("BulkRequest reached  " + BULKREQUEST_SIZE + " records and will be executed");
                    if (FullTextNode.doBulk(bulkRequest).booleanValue()) {
                        bulkRequest = this.indexClient.prepareBulk();
                        continue;
                    }
                    bulkRequest = null;
                    success = false;
                }
                break;
            }
        }
        catch (Exception e) {
            logger.info("Exception will feeding", (Throwable)e);
            success = false;
        }
        reader.close();
        if (success) {
            logger.info("BulkRequest will insert the last  " + rowSetCount % BULKREQUEST_SIZE + " records");
            if (rowSetCount > 0) {
                if (rowSetCount % BULKREQUEST_SIZE == 0) {
                    logger.info("no records to add in the final bulk request");
                } else if (FullTextNode.doBulk(bulkRequest).booleanValue()) {
                    logger.info("last bulk request succedded. will commit now");
                    this.commit(indexName);
                    this.updateManagerProperties(colForField);
                    this.commitMeta();
                    logger.info("Total number of records fed : " + rowSetCount);
                } else {
                    success = false;
                }
            } else {
                logger.warn("no records to add");
            }
        }
        long afterFeed = System.currentTimeMillis();
        logger.info("Total insert time : " + (double)(afterFeed - beforeFeed) / 1000.0);
        return success;
    }

    private static Boolean doBulk(BulkRequestBuilder bulkRequest) {
        long beforeBulk = System.currentTimeMillis();
        BulkResponse bulkResponse = (BulkResponse)bulkRequest.setConsistencyLevel(WriteConsistencyLevel.ONE).get();
        long afterBulk = System.currentTimeMillis();
        logger.info("Time for commiting the bulk requests : " + (double)(afterBulk - beforeBulk) / 1000.0 + " secs");
        logger.info("bulkResponse : " + (double)bulkResponse.getTookInMillis() / 1000.0 + " secs");
        logger.info("bulkResponse : " + bulkResponse);
        if (bulkResponse.hasFailures()) {
            logger.warn("failures have happened. Message : " + bulkResponse.buildFailureMessage());
            logger.warn("Details ");
            for (BulkItemResponse brItem : bulkResponse.getItems()) {
                logger.warn("id : " + brItem.getId() + " " + brItem.getIndex() + " " + brItem.getType() + ", Failure Message : " + brItem.getFailureMessage());
            }
            logger.warn("failures have happened. Message : " + bulkResponse.buildFailureMessage());
            logger.warn("Error. Feeding failed");
            return false;
        }
        logger.info("bulk request finished without errors");
        return true;
    }

    private boolean feedRowset(BulkRequestBuilder bulkRequest, String rowset, HashMap<String, FullTextIndexType> colForIdTypes, String indexName, Set<String> securityIdentifiers) {
        long before = System.currentTimeMillis();
        String rsIdxTypeID = RowsetParser.getIdxTypeNameRowset(rowset);
        long after = System.currentTimeMillis();
        logger.trace("Time for getting rsIdxTypeID from rowset : " + (double)(after - before) / 1000.0 + " secs");
        logger.trace("Result IndexTypeID : " + rsIdxTypeID);
        before = System.currentTimeMillis();
        String lang = RowsetParser.getLangRowset(rowset);
        after = System.currentTimeMillis();
        logger.trace("Time for getting lang from rowset : " + (double)(after - before) / 1000.0 + " secs");
        logger.trace("Result lang : " + lang);
        if (lang == null || lang.equals("")) {
            lang = "unknown";
        }
        before = System.currentTimeMillis();
        String colID = RowsetParser.getColIDRowset(rowset);
        after = System.currentTimeMillis();
        logger.trace("Time for colID lang from rowset : " + (double)(after - before) / 1000.0 + " secs");
        logger.trace("Result colID : " + colID);
        if (colID == null || colID.equals("")) {
            logger.trace("No collection ID given in ROWSET: " + rowset);
            return false;
        }
        indexName = FullTextNode.createIndexName(indexName, colID, false);
        try {
            this.addIndexType(rsIdxTypeID, indexName);
        }
        catch (Exception e) {
            logger.error("Add index type exception", (Throwable)e);
            return false;
        }
        if (rsIdxTypeID == null || !this.indexTypes.contains(rsIdxTypeID + "-" + indexName)) {
            logger.error("IndexType : " + rsIdxTypeID + "-" + indexName + " not in indexTypes : " + this.indexTypes);
            return false;
        }
        logger.trace("Time for preprocessRowset : " + (double)(after - before) / 1000.0 + " secs");
        before = System.currentTimeMillis();
        FullTextIndexType idxType = this.cache.cachedIndexTypes.get(QueryParser.createIndexTypekey(rsIdxTypeID, this.scope));
        logger.trace("index type for name : " + idxType.getIndexTypeName());
        logger.trace("all indexTypes in cache : " + this.cache.cachedIndexTypes.keySet());
        Boolean insertResult = ElasticSearchHelper.insertRowSet(bulkRequest, this.indexClient, indexName, idxType, this.indexTypes, rowset, securityIdentifiers);
        if (!insertResult.booleanValue()) {
            logger.error("error in inserting the rowset " + rowset);
            return false;
        }
        after = System.currentTimeMillis();
        logger.trace("Time for insertRowSet : " + (double)(after - before) / 1000.0 + " secs");
        colForIdTypes.put(colID + ":" + lang, idxType);
        return true;
    }

    private static String createIndexName(String indexName, String collectionID, Boolean useCollectionID) {
        if (useCollectionID.booleanValue()) {
            return collectionID + "_" + indexName;
        }
        return indexName;
    }

    private synchronized void bindIndexType(String indexTypeStr, String indexName) {
        logger.info("Calling bindIndexType");
        FullTextIndexType indexType = QueryParser.retrieveIndexType(indexTypeStr, this.scope, this.cache);
        logger.info("Index Type");
        logger.info("-----------------------------------------------");
        logger.info(indexType.toString());
        logger.info("-----------------------------------------------");
        ArrayList<String> presentables = new ArrayList<String>();
        ArrayList<String> searchables = new ArrayList<String>();
        ArrayList<String> highlightables = new ArrayList<String>();
        for (IndexField idxTypeField : indexType.getFields()) {
            if (idxTypeField.highlightable && idxTypeField.returned) {
                highlightables.add(idxTypeField.name);
            }
            if (idxTypeField.returned) {
                presentables.add(idxTypeField.name);
            }
            if (!idxTypeField.index) continue;
            searchables.add(idxTypeField.name);
        }
        this.indexTypes.add(indexTypeStr + "-" + indexName);
        this.cache.presentableFieldsPerIndexType.put(indexTypeStr, presentables);
        this.cache.searchableFieldsPerIndexType.put(indexTypeStr, searchables);
        this.cache.highlightableFieldsPerIndexType.put(indexTypeStr, highlightables);
        logger.info("1. in bindIndexType cache presentables   : " + this.cache.presentableFieldsPerIndexType);
        logger.info("1. in bindIndexType cache searchables    : " + this.cache.searchableFieldsPerIndexType);
        logger.info("1. in bindIndexType cache highlightables : " + this.cache.highlightableFieldsPerIndexType);
    }

    public void refreshIndexTypesOfIndex() {
        ClusterStateResponse clusterResponse = (ClusterStateResponse)this.indexClient.admin().cluster().prepareState().get();
        logger.info("clusterResponse : " + clusterResponse);
        ImmutableOpenMap aliases = clusterResponse.getState().getMetaData().aliases();
        logger.info("aliases : " + aliases);
        ImmutableOpenMap alias = (ImmutableOpenMap)aliases.get((Object)ACTIVE_INDEX);
        logger.info("alias : " + alias);
        if (alias != null && alias.size() > 0) {
            logger.info("alias is not null");
            for (String indexName : Sets.newHashSet((Iterator)alias.keysIt())) {
                logger.info("indexName for alias : " + indexName);
                IndexMetaData indexMetaData = clusterResponse.getState().getMetaData().index(indexName);
                logger.info("indexMetaData : " + indexMetaData);
                ImmutableOpenMap mappings = indexMetaData.mappings();
                logger.info("mappings : " + mappings);
                HashSet indexTypes = new HashSet();
                if (mappings != null && mappings.size() > 0) {
                    logger.info("mappings not null. creating index types from the keys...");
                    indexTypes = Sets.newHashSet((Iterator)mappings.keysIt());
                    logger.info("mappings not null. creating index types from the keys...OK");
                }
                logger.info("index types found in index : " + indexTypes);
                for (String indexType : indexTypes) {
                    logger.info("adding index type : " + indexType);
                    try {
                        this.bindIndexType(indexType, indexName);
                        logger.info("adding index type : " + indexType + " succeded");
                    }
                    catch (Exception e) {
                        logger.info("adding index type : " + indexType + " failed");
                    }
                }
            }
        }
    }

    public boolean updateManagerProperties(HashMap<String, FullTextIndexType> colForIdTypes) {
        Map result = null;
        String id = null;
        long version = 0L;
        try {
            SearchResponse response = (SearchResponse)this.indexClient.prepareSearch(new String[]{META_INDEX}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).get();
            for (SearchHit hit : response.getHits().getHits()) {
                result = hit.getSource();
                id = hit.getId();
                version = hit.getVersion();
            }
        }
        catch (Exception e) {
            logger.warn("No meta-index yet", (Throwable)e);
        }
        List<String> collectionIdsToBeAdded = new ArrayList();
        ArrayList<String> fieldsToBeAdded = new ArrayList();
        if (result != null && (List)result.get("collectionIDs") != null) {
            collectionIdsToBeAdded = (List)result.get("collectionIDs");
        }
        if (result != null && (List)result.get("fields") != null) {
            fieldsToBeAdded = (List)result.get("fields");
        }
        Set<String> keys = colForIdTypes.keySet();
        for (String colIDandLang : keys) {
            IndexField[] fields;
            FullTextIndexType index = colForIdTypes.get(colIDandLang);
            for (IndexField field : fields = index.getFields()) {
                if (RowsetParser.addToFieldInfo(fieldsToBeAdded, field.name, colIDandLang, index)) continue;
                return false;
            }
            fieldsToBeAdded.add(colIDandLang + ":" + "s" + ":" + ALL_INDEXES);
            collectionIdsToBeAdded.add(colIDandLang.split(":")[0]);
        }
        HashSet<String> hs1 = new HashSet<String>();
        HashSet<String> hs2 = new HashSet<String>();
        hs1.addAll(collectionIdsToBeAdded);
        hs2.addAll(fieldsToBeAdded);
        try {
            HashMap<String, HashSet<String>> document = new HashMap<String, HashSet<String>>();
            document.put("collectionIDs", hs1);
            document.put("fields", hs2);
            if (result != null) {
                ++version;
            }
            IndexResponse response = (IndexResponse)this.indexClient.prepareIndex(META_INDEX, META_INDEX, id).setSource(ElasticSearchHelper.createJSONObject(document).string()).setConsistencyLevel(WriteConsistencyLevel.ONE).setVersion(version).get();
            logger.info("Add records to meta-index response id : " + response.getId());
            logger.info("Inserted colIDs and fields to " + META_INDEX);
            logger.info("committing meta-index");
            this.commitMeta();
            logger.info("Added records to meta-index");
        }
        catch (IOException e) {
            logger.error("Caught an exception: ", (Throwable)e);
        }
        return true;
    }

    public boolean updateManagerPropertiesRemoveCollID(String collectionID) {
        logger.info("removing collection : " + collectionID + " from meta index");
        Map result = null;
        String id = null;
        long version = 0L;
        try {
            SearchResponse response = (SearchResponse)this.indexClient.prepareSearch(new String[]{META_INDEX}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).get();
            for (SearchHit hit : response.getHits().getHits()) {
                result = hit.getSource();
                id = hit.getId();
                version = hit.getVersion();
            }
        }
        catch (Exception e) {
            logger.warn("No meta-index yet", (Throwable)e);
        }
        List collectionIdsToBeAdded = new ArrayList();
        List fieldsToBeAdded = new ArrayList();
        if (result != null && (List)result.get("collectionIDs") != null) {
            collectionIdsToBeAdded = (List)result.get("collectionIDs");
        }
        if (result != null && (List)result.get("fields") != null) {
            fieldsToBeAdded = (List)result.get("fields");
        }
        if (collectionIdsToBeAdded.contains(collectionID)) {
            collectionIdsToBeAdded.remove(collectionID);
        }
        ArrayList<String> fieldsTobeRemoved = new ArrayList<String>();
        for (String field : fieldsToBeAdded) {
            if (!field.startsWith(collectionID + ":")) continue;
            fieldsTobeRemoved.add(field);
        }
        fieldsToBeAdded.removeAll(fieldsTobeRemoved);
        HashSet hs1 = new HashSet();
        HashSet hs2 = new HashSet();
        hs1.addAll(collectionIdsToBeAdded);
        hs2.addAll(fieldsToBeAdded);
        try {
            HashMap document = new HashMap();
            document.put("collectionIDs", hs1);
            document.put("fields", hs2);
            if (result != null) {
                ++version;
            }
            logger.info("meta will contain : " + document + " now");
            IndexResponse response = (IndexResponse)this.indexClient.prepareIndex(META_INDEX, META_INDEX, id).setSource(ElasticSearchHelper.createJSONObject(document).string()).setConsistencyLevel(WriteConsistencyLevel.ONE).setVersion(version).get();
            logger.info("Add records to meta-index response id : " + response.getId());
            logger.info("Inserted colIDs and fields to " + META_INDEX);
            logger.info("committing meta-index");
            this.commitMeta();
            logger.info("Added records to meta-index");
        }
        catch (IOException e) {
            logger.error("Caught an exception: ", (Throwable)e);
        }
        return true;
    }

    public boolean addMetaIndex() {
        int counter = 0;
        Map result = null;
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            logger.error("Failed to sleep", (Throwable)e);
        }
        while (true) {
            try {
                SearchResponse response = (SearchResponse)this.indexClient.prepareSearch(new String[]{META_INDEX}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).get();
                for (SearchHit hit : response.getHits().getHits()) {
                    result = hit.getSource();
                }
            }
            catch (IndexMissingException e) {
                logger.warn("Index missing, proceeding to creation");
            }
            catch (Exception e) {
                logger.warn("Not initialized yet, retrying");
                ++counter;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    logger.error("Failed to sleep", (Throwable)e);
                }
                if (counter != 10) continue;
                return false;
            }
            break;
        }
        if (result == null) {
            try {
                HashMap<String, String[]> document = new HashMap<String, String[]>();
                document.put("collectionIDs", new String[0]);
                document.put("fields", new String[0]);
                IndicesAdminClient iac = this.indexClient.admin().indices();
                logger.info("creating meta-index response");
                CreateIndexResponse cir = (CreateIndexResponse)iac.prepareCreate(META_INDEX).setSettings(this.getIndexCreateSetting()).get();
                logger.info("created meta-index response : " + cir.toString());
                IndexResponse response = (IndexResponse)this.indexClient.prepareIndex(META_INDEX, META_INDEX).setSource(ElasticSearchHelper.createJSONObject(document).string()).setConsistencyLevel(WriteConsistencyLevel.ONE).execute().actionGet();
                logger.info("Add empty records to meta-index response id : " + response.getId());
                logger.info("committing meta-index");
                this.commitMeta();
                logger.info("Added empty meta-index");
            }
            catch (IOException e) {
                logger.error("Failed to add meta index", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public void invalidateCache() {
        this.cache.invalidate();
    }

    public boolean rebuildMetaIndex(List<String> collectionIds, List<String> fields) {
        DeleteMappingRequest deleteMapping = new DeleteMappingRequest(new String[]{META_INDEX}).types(new String[]{META_INDEX});
        this.indexClient.admin().indices().deleteMapping(deleteMapping).actionGet();
        try {
            HashMap<String, List<String>> document = new HashMap<String, List<String>>();
            document.put("collectionIDs", collectionIds);
            document.put("fields", fields);
            this.indexClient.prepareIndex(META_INDEX, META_INDEX).setSource(ElasticSearchHelper.createJSONObject(document).string()).setConsistencyLevel(WriteConsistencyLevel.ONE).get();
            logger.info("Rebuilt meta-index");
        }
        catch (IOException e) {
            logger.error("Failed to rebuild meta index", (Throwable)e);
            return false;
        }
        return true;
    }

    public Map<String, List<String>> getCollectionsAndFieldsOfIndex() {
        SearchResponse response = (SearchResponse)this.indexClient.prepareSearch(new String[]{META_INDEX}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
        try {
            List collections = (List)response.getHits().getHits()[0].getSource().get("collectionIDs");
            List fields = (List)response.getHits().getHits()[0].getSource().get("fields");
            HashMap<String, List<String>> result = new HashMap<String, List<String>>();
            result.put("collections", collections);
            result.put("fields", fields);
            return result;
        }
        catch (Exception e) {
            logger.warn("Error while getting collections of index", (Throwable)e);
            return null;
        }
    }

    public List<String> getCollectionOfIndex() {
        SearchResponse response = (SearchResponse)this.indexClient.prepareSearch(new String[]{META_INDEX}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
        try {
            List collections = (List)response.getHits().getHits()[0].getSource().get("collectionIDs");
            return collections;
        }
        catch (Exception e) {
            logger.warn("Error while getting collections of index", (Throwable)e);
            return null;
        }
    }

    public List<String> getFieldsOfIndex() {
        SearchResponse response = (SearchResponse)this.indexClient.prepareSearch(new String[]{META_INDEX}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
        try {
            List fields = (List)response.getHits().getHits()[0].getSource().get("fields");
            return fields;
        }
        catch (Exception e) {
            logger.warn("Error while getting fields of index", (Throwable)e);
            return null;
        }
    }

    private Settings getIndexCreateSetting() {
        Settings settings = ImmutableSettings.builder().put("index.number_of_replicas", String.valueOf(this.noOfReplicas)).put("index.number_of_shards", String.valueOf(this.noOfShards)).put("index.store", DEFAULT_INDEXSTORE).put("index.refresh_interval", INDEX_REFRESH_INTERVAL).put("path.data", this.dataDir).build();
        return settings;
    }

    public Boolean createFileIndex() {
        return FullTextNode.createFileIndex(this.indexClient, FILE_INDEX_NAME, FILE_INDEX_TYPE, this.getIndexCreateSetting());
    }

    public static Boolean createFileIndex(Client indexClient, String indexName, String indexType, Settings settings) {
        IndicesAdminClient iac = indexClient.admin().indices();
        logger.info("Checking if index exists");
        if (((IndicesExistsResponse)iac.prepareExists(new String[]{indexName}).get()).isExists()) {
            logger.info("Index already exists");
            return true;
        }
        CreateIndexRequestBuilder createIndexRequest = iac.prepareCreate(indexName).setSettings(settings);
        logger.info("Create Index Request : " + createIndexRequest.request());
        CreateIndexResponse cir = (CreateIndexResponse)createIndexRequest.get();
        logger.info("Create Index Response : " + cir);
        XContentBuilder fileIndexMapping = FullTextNode.getFileIndexMapping(indexType);
        PutMappingResponse pmr = (PutMappingResponse)iac.preparePutMapping(new String[0]).setIndices(new String[]{indexName}).setType(indexType).setSource(fileIndexMapping).get();
        return pmr.isAcknowledged();
    }

    public void addFile(String base64) throws IOException {
        FullTextNode.addFile(this.indexClient, base64, FILE_INDEX_NAME, FILE_INDEX_TYPE);
    }

    public static void addFile(Client indexClient, String base64, String indexName, String indexType) throws IOException {
        HashMap<String, String> doc = new HashMap<String, String>();
        doc.put("file", base64);
        XContentBuilder json = ElasticSearchHelper.createJSONObject(doc);
        logger.info("inserting file");
        logger.info(json.string());
        indexClient.prepareIndex(indexName, indexType).setSource(json).get();
    }

    private static XContentBuilder getFileIndexMapping(String type) {
        XContentBuilder builder = null;
        try {
            builder = XContentFactory.jsonBuilder().startObject().startObject(type).startObject("properties").startObject("file").field("type", "attachment").startObject("fields").startObject("file").field("index", "analyzed").field("store", "true").endObject().startObject("date").field("index", "analyzed").field("store", "true").endObject().startObject("author").field("index", "analyzed").field("store", "true").endObject().startObject("content").field("store", "true").endObject().startObject("title").field("index", "analyzed").field("store", "true").endObject().endObject().endObject().endObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return builder;
    }
}

