/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.workflow.adaptor.utils.jdl;

import gr.uoa.di.madgik.workflow.adaptor.utils.jdl.JDLJobExtractor;
import gr.uoa.di.madgik.workflow.adaptor.utils.jdl.JDLParsingUtils;
import gr.uoa.di.madgik.workflow.adaptor.utils.jdl.ParsedJDLInfo;
import gr.uoa.di.madgik.workflow.exception.WorkflowValidationException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDLDAGExtractor {
    private static Logger logger = LoggerFactory.getLogger(JDLDAGExtractor.class);
    private Map<String, String> KeyValues;

    public JDLDAGExtractor(Map<String, String> KeyValues) {
        this.KeyValues = KeyValues;
    }

    public ParsedJDLInfo ProcessKeys() throws WorkflowValidationException {
        ParsedJDLInfo Internal = new ParsedJDLInfo();
        Internal.jobDescriptionType = ParsedJDLInfo.JobDescriptionType.DAG;
        Internal.SetParsingMode(JDLParsingUtils.StripQuotes(JDLParsingUtils.GetKeyValue(this.KeyValues, ParsedJDLInfo.KnownKeys.ParsingMode, false)));
        Internal.SetMaxRunningNodes(JDLParsingUtils.GetKeyValue(this.KeyValues, ParsedJDLInfo.KnownKeys.Max_Running_Nodes, false));
        Internal.Rank = JDLParsingUtils.GetKeyValue(this.KeyValues, ParsedJDLInfo.KnownKeys.Rank, false);
        Internal.Requirements = JDLParsingUtils.GetKeyValue(this.KeyValues, ParsedJDLInfo.KnownKeys.Requirements, false);
        Internal.SetNodesCollocation(JDLParsingUtils.GetKeyValue(this.KeyValues, ParsedJDLInfo.KnownKeys.NodesCollocation, false));
        Internal.SetConnectionMode(JDLParsingUtils.StripQuotes(JDLParsingUtils.GetKeyValue(this.KeyValues, ParsedJDLInfo.KnownKeys.ConnectionMode, false)));
        String nodes = JDLParsingUtils.GetDefinitionBlock(JDLParsingUtils.GetKeyValue(this.KeyValues, ParsedJDLInfo.KnownKeys.Nodes, false));
        String dependencies = JDLParsingUtils.GetKeyValue(this.KeyValues, ParsedJDLInfo.KnownKeys.Dependencies, false);
        Map<String, String> nodeList = JDLParsingUtils.GetKeyValues(nodes);
        for (String nodeName : nodeList.keySet()) {
            Map<String, String> defList = JDLParsingUtils.GetKeyValues(JDLParsingUtils.GetDefinitionBlock(nodeList.get(nodeName)));
            String definition = JDLParsingUtils.GetKeyValue(defList, ParsedJDLInfo.KnownKeys.Description, true);
            Map<String, String> jobList = JDLParsingUtils.GetKeyValues(JDLParsingUtils.GetDefinitionBlock(definition));
            JDLJobExtractor jobextr = new JDLJobExtractor(jobList);
            ParsedJDLInfo nfo = jobextr.ProcessKeys();
            Internal.Nodes.put(nodeName, nfo);
            logger.debug("Node with name " + nodeName + " and definition value " + nfo.ToXML());
        }
        ParsedJDLInfo.JobType type = null;
        for (ParsedJDLInfo nfo : Internal.Nodes.values()) {
            if (!nfo.jobType.equals((Object)type) && type != null) {
                throw new WorkflowValidationException();
            }
            type = nfo.jobType;
        }
        Internal.jobType = type;
        logger.debug("Dependencies=" + dependencies);
        Internal.Dependencies = JDLParsingUtils.GetDependencies(dependencies);
        return Internal;
    }
}

