/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.urlresolutionlibrary.nonstreamable;

import gr.uoa.di.madgik.urlresolutionlibrary.nonstreamable.BittorrentLocator;
import gr.uoa.di.madgik.urlresolutionlibrary.nonstreamable.NonStreamable;
import gr.uoa.di.madgik.urlresolutionlibrary.streamable.Streamable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StreamableDecorator
implements Streamable {
    private static Logger logger = Logger.getLogger(StreamableDecorator.class.getName());
    private NonStreamable locator;
    private InputStream is;
    private File file;

    public StreamableDecorator(NonStreamable locator) {
        this.locator = locator;
    }

    @Override
    public InputStream getInputStream() throws Exception {
        this.locator.download();
        this.file = this.locator.getFile();
        if (this.file.isDirectory()) {
            this.file.delete();
            throw new Exception("Directory can not be streamed");
        }
        this.is = new FileInputStream(this.file);
        return this.is;
    }

    @Override
    public void close() {
        try {
            this.file.delete();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Streamable Decorator file deletion failed", e);
        }
        if (this.locator instanceof BittorrentLocator) {
            try {
                ((BittorrentLocator)this.locator).getTempDir().delete();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Streamable Decorator bittorent temporary directory deletion failed", e);
            }
        }
        try {
            this.is.close();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Streamable Decorator inputstream close failed", e);
        }
    }
}

