/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.textExtraction.job.utils;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import org.gcube.application.framework.contentmanagement.exceptions.ViewPublishingException;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentWriter;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.DocumentProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.Property;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.PropertyTypes;
import org.gcube.contentmanagement.gcubedocumentlibrary.views.MetadataView;
import org.gcube.contentmanagement.gcubemodellibrary.elements.BaseInnerElement;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeMetadata;

public class ViewManagementUtils {
    public static String createMetadataView(String collectionId, String name, String description, String schemaName, Locale schemaLanguage, String schemaURI, String scope) throws ViewPublishingException {
        MetadataView view = new MetadataView(GCUBEScope.getScope((String)scope));
        view.setCollectionId(collectionId);
        view.setName(name);
        view.setDescription(description);
        try {
            view.setProjection(schemaLanguage, schemaName, new URI(schemaURI));
            try {
                view.publish();
                return view.id();
            }
            catch (GCUBEException e) {
                throw new ViewPublishingException((Throwable)e);
            }
            catch (IllegalStateException e) {
                throw new ViewPublishingException((Throwable)e);
            }
            catch (Exception e) {
                throw new ViewPublishingException((Throwable)e);
            }
        }
        catch (URISyntaxException e) {
            throw new ViewPublishingException((Throwable)e);
        }
    }

    public static void addGCubeMetadataForDocument(String documentId, String collectionId, String schemaName, Locale schemaLanguage, String schemaURI, InputStream payload, String scope) {
        GCubeMetadata meta = new GCubeMetadata();
        try {
            meta.setSchemaName(schemaName);
            meta.setLanguage(schemaLanguage);
            meta.setSchemaURI(new URI(schemaURI));
            meta.setBytestream(payload);
            DocumentWriter cmWriter = new DocumentWriter(collectionId, GCUBEScope.getScope((String)scope));
            DocumentReader cmReader = new DocumentReader(collectionId, GCUBEScope.getScope((String)scope));
            DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.NAME, (Property[])new PropertyTypes.DocumentProperty[0]);
            GCubeDocument document = cmReader.get(documentId, (Projection)dp);
            document.metadata().add((BaseInnerElement)meta);
            cmWriter.update(document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

