/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.textExtraction.job.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Random;
import javax.xml.rpc.ServiceException;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.gcube.application.framework.contentmanagement.exceptions.ReadingRSException;
import org.gcube.application.framework.contentmanagement.exceptions.ServiceEPRRetrievalException;
import org.gcube.application.framework.contentmanagement.exceptions.TransformationException;
import org.gcube.application.framework.contentmanagement.util.DocumentInfos;
import org.gcube.application.framework.core.cache.RIsManager;
import org.gcube.application.framework.core.cache.factories.ApplicationCredentials;
import org.gcube.application.framework.core.security.ServiceContextManager;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.faults.GCUBERetryEquivalentFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.RecordAttribute;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementGeneric;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceLocalType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLIterator;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLReader;
import org.gcube.datatransformation.datatransformationservice.stubs.ContentType;
import org.gcube.datatransformation.datatransformationservice.stubs.DataTransformationServicePortType;
import org.gcube.datatransformation.datatransformationservice.stubs.Input;
import org.gcube.datatransformation.datatransformationservice.stubs.Output;
import org.gcube.datatransformation.datatransformationservice.stubs.Parameter;
import org.gcube.datatransformation.datatransformationservice.stubs.TransformData;
import org.gcube.datatransformation.datatransformationservice.stubs.TransformDataResponse;
import org.gcube.datatransformation.datatransformationservice.stubs.service.DataTransformationServiceAddressingLocator;
import org.gcube.execution.ocrservice.stubs.OCRServiceFactoryPortType;
import org.gcube.execution.ocrservice.stubs.service.OCRServiceFactoryServiceAddressingLocator;
import org.gcube.execution.textExtraction.job.utils.MyFTPClient;
import org.gcube.informationsystem.cache.SrvType;
import org.globus.ftp.exception.ClientException;
import org.globus.ftp.exception.ServerException;
import org.ietf.jgss.GSSCredential;

public class TextExtractionUtils {
    public static String transformPDFDocumentsToText(String listLocation, String ftpHost, String ftpUser, String ftpPort, String ftpPassword, String ftpDirectory, String scope, String suggestedDtsEpr) throws Exception {
        TransformData request = new TransformData();
        Input input = new Input();
        input.setInputType("URIList");
        input.setInputValue(listLocation);
        System.out.println("The URI Location IS: " + listLocation);
        request.setInput(input);
        Output output = new Output();
        output.setOutputType("FTP");
        output.setOutputValue(ftpHost);
        Parameter param1 = new Parameter("username", ftpUser);
        Parameter param2 = new Parameter("password", ftpPassword);
        Parameter param3 = new Parameter("port", ftpPort);
        Parameter param4 = new Parameter("directory", ftpDirectory);
        output.setOutputparameters(new Parameter[]{param1, param2, param3, param4});
        request.setOutput(output);
        ContentType targetContentType = new ContentType();
        targetContentType.setMimeType("text/plain");
        Parameter[] contentTypeParameters = new Parameter[]{};
        targetContentType.setParameters(contentTypeParameters);
        request.setTargetContentType(targetContentType);
        request.setCreateReport(true);
        DataTransformationServicePortType dts = null;
        if (suggestedDtsEpr != null && !suggestedDtsEpr.equals("")) {
            try {
                dts = TextExtractionUtils.getSuggestedDataTransformationServicePortType(suggestedDtsEpr, scope);
            }
            catch (Exception e) {
                System.out.println("The suggestion for the DTS EPR failed. Getting another EPR from IS.");
                dts = TextExtractionUtils.getDataTransformationServicePortType(scope, suggestedDtsEpr);
                e.printStackTrace();
            }
        } else {
            dts = TextExtractionUtils.getDataTransformationServicePortType(scope, suggestedDtsEpr);
        }
        String rslocator = null;
        try {
            TransformDataResponse response = dts.transformData(request);
            rslocator = response.getReportEPR();
        }
        catch (GCUBERetryEquivalentFault e) {
            throw new TransformationException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TransformationException((Throwable)e);
        }
        System.out.println("Output: " + rslocator);
        return rslocator;
    }

    public static ArrayList<DocumentInfos> getListOfFailuresFromReport(String rsLocator, ArrayList<DocumentInfos> allDocuments, String ftpHost, String repositoryId, String randomUUIDString, String query) throws ReadingRSException {
        FileWriter fstream = null;
        try {
            fstream = new FileWriter("metaInfo_" + randomUUIDString + ".txt");
        }
        catch (IOException e1) {
            System.err.println("Problem while creating file in disc");
        }
        BufferedWriter out = new BufferedWriter(fstream);
        RSXMLReader reader = TextExtractionUtils.getRSClient(rsLocator);
        RSXMLIterator iterator = null;
        ArrayList<DocumentInfos> listOfFailures = new ArrayList<DocumentInfos>();
        try {
            iterator = reader.getRSIterator();
        }
        catch (Exception e) {
            throw new ReadingRSException((Throwable)e);
        }
        System.out.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        System.out.println("ITERATE RESULTSET");
        System.out.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        int i = 0;
        while (iterator.hasNext()) {
            ++i;
            System.out.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            System.out.println("BEGINNING");
            System.out.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            ResultElementBase res = iterator.next(ResultElementGeneric.class);
            System.out.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            System.out.println("ENDED: " + i);
            System.out.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            try {
                DocumentInfos di;
                String report = res.RS_toXML();
                RecordAttribute[] tmp = res.getRecordAttributes("DocID");
                String sourceId = tmp[0].getAttrValue();
                boolean success = TextExtractionUtils.getStatusReport(report, sourceId);
                if (!success) {
                    di = new DocumentInfos();
                    di = TextExtractionUtils.findDocumentInfosFromDocumentURI(allDocuments, sourceId);
                    listOfFailures.add(di);
                } else {
                    di = new DocumentInfos();
                    di = TextExtractionUtils.findDocumentInfosFromDocumentURI(allDocuments, sourceId);
                    String metaInfo = TextExtractionUtils.createFileRecord("ftp://" + ftpHost + "/" + repositoryId + "/" + di.getName() + ".txt", di.getReferenceId());
                    System.out.println("The record is: " + metaInfo);
                    try {
                        out.write(metaInfo + "\n");
                    }
                    catch (IOException e) {
                        System.err.println("Problem while writting record to file");
                    }
                }
                System.out.println("The REPORT for the document: " + sourceId + "is:" + report);
            }
            catch (Exception e) {
                throw new ReadingRSException((Throwable)e);
            }
        }
        try {
            String hostname = TextExtractionUtils.getHostName();
            out.write("\n\n" + query + " *** " + hostname);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        System.out.println("Number of RESULTSET iterations: " + i);
        System.out.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        try {
            out.close();
        }
        catch (IOException e1) {
            System.err.println("Problem while closing buffer");
        }
        return listOfFailures;
    }

    private static String getHostName() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            byte[] ipAddr = addr.getAddress();
            String hostname = addr.getHostName();
            System.out.println("hostname=" + hostname);
            return hostname;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "hostname";
        }
    }

    private static String createFileRecord(String fileName, String fileRepId) {
        String record = "\"" + fileName + "\"" + " " + "\"" + fileRepId + "\"";
        return record;
    }

    private static boolean getStatusReport(String report, String sourceId) {
        System.out.println("Getting report for document: " + sourceId);
        return !report.contains("<STATUS>FAILED</STATUS>");
    }

    private static DocumentInfos findDocumentInfosFromDocumentURI(ArrayList<DocumentInfos> allDocuments, String documentURI) {
        for (int i = 0; i < allDocuments.size(); ++i) {
            System.out.println("Comparing: " + allDocuments.get(i).getPdfURI() + " with " + documentURI);
            if (!allDocuments.get(i).getPdfURI().equals(documentURI)) continue;
            return allDocuments.get(i);
        }
        return null;
    }

    protected static RSXMLReader getRSClient(String epr) throws ReadingRSException {
        RSXMLReader client = null;
        try {
            client = RSXMLReader.getRSXMLReader((RSLocator)new RSLocator(epr)).makeLocal((RSResourceType)new RSResourceLocalType());
        }
        catch (Exception e) {
            throw new ReadingRSException((Throwable)e);
        }
        return client;
    }

    private static DataTransformationServicePortType getSuggestedDataTransformationServicePortType(String suggestedEPR, String scope) throws Exception {
        DataTransformationServicePortType dts = null;
        try {
            EndpointReferenceType endpoint = new EndpointReferenceType();
            endpoint.setAddress((AttributedURI)new Address(suggestedEPR));
            DataTransformationServiceAddressingLocator dtsLocator = new DataTransformationServiceAddressingLocator();
            dts = dtsLocator.getDataTransformationServicePortTypePort(endpoint);
            dts = (DataTransformationServicePortType)ServiceContextManager.applySecurity((Remote)dts, (GCUBEScope)GCUBEScope.getScope((String)scope), (GSSCredential)ApplicationCredentials.getInstance().getCredential(scope));
        }
        catch (GCUBEScope.MalformedScopeExpressionException e) {
            throw new ServiceEPRRetrievalException((Throwable)e);
        }
        catch (Exception e) {
            throw new ServiceEPRRetrievalException((Throwable)e);
        }
        return dts;
    }

    private static OCRServiceFactoryPortType getSuggestedOCRPortType(String suggestedEpr, String scope) throws ServiceEPRRetrievalException {
        EndpointReferenceType factoryEPR = new EndpointReferenceType();
        try {
            factoryEPR.setAddress((AttributedURI)new Address(suggestedEpr));
        }
        catch (URI.MalformedURIException e) {
            e.printStackTrace();
            throw new ServiceEPRRetrievalException((Throwable)e);
        }
        OCRServiceFactoryPortType stub = null;
        try {
            stub = new OCRServiceFactoryServiceAddressingLocator().getOCRServiceFactoryPortTypePort(factoryEPR);
            stub = (OCRServiceFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)stub, (GCUBEScope)GCUBEScope.getScope((String)scope), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw new ServiceEPRRetrievalException((Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceEPRRetrievalException((Throwable)e);
        }
        return stub;
    }

    private static OCRServiceFactoryPortType getRandomOCRPortType(String scope) throws ServiceEPRRetrievalException {
        String ocrEPR = TextExtractionUtils.getOCRServiceEPR(scope);
        EndpointReferenceType factoryEPR = new EndpointReferenceType();
        try {
            factoryEPR.setAddress((AttributedURI)new Address(ocrEPR));
        }
        catch (URI.MalformedURIException e) {
            e.printStackTrace();
            throw new ServiceEPRRetrievalException((Throwable)e);
        }
        OCRServiceFactoryPortType stub = null;
        try {
            stub = new OCRServiceFactoryServiceAddressingLocator().getOCRServiceFactoryPortTypePort(factoryEPR);
            stub = (OCRServiceFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)stub, (GCUBEScope)GCUBEScope.getScope((String)scope), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw new ServiceEPRRetrievalException((Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceEPRRetrievalException((Throwable)e);
        }
        return stub;
    }

    private static DataTransformationServicePortType getDataTransformationServicePortType(String scope, String suggestedEpr) throws Exception {
        EndpointReference[] dtsURIs = null;
        try {
            dtsURIs = RIsManager.getInstance().getISCache(GCUBEScope.getScope((String)scope)).getEPRsFor("DataTransformation", "DataTransformationService", SrvType.SIMPLE.name());
        }
        catch (Exception e) {
            throw new ServiceEPRRetrievalException((Throwable)e);
        }
        String dtsAddress = new String();
        Random random = new Random();
        for (int i = 0; i < dtsURIs.length && (dtsAddress = dtsURIs[random.nextInt(dtsURIs.length)].getAddress().toString()).equals(suggestedEpr); ++i) {
        }
        EndpointReferenceType endpoint = new EndpointReferenceType();
        endpoint.setAddress((AttributedURI)new Address(dtsAddress));
        DataTransformationServiceAddressingLocator dtsLocator = new DataTransformationServiceAddressingLocator();
        DataTransformationServicePortType dts = dtsLocator.getDataTransformationServicePortTypePort(endpoint);
        try {
            dts = (DataTransformationServicePortType)ServiceContextManager.applySecurity((Remote)dts, (GCUBEScope)GCUBEScope.getScope((String)scope), (GSSCredential)ApplicationCredentials.getInstance().getCredential(scope));
        }
        catch (GCUBEScope.MalformedScopeExpressionException e) {
            throw new ServiceEPRRetrievalException((Throwable)e);
        }
        catch (Exception e) {
            throw new ServiceEPRRetrievalException((Throwable)e);
        }
        return dts;
    }

    public static ArrayList<String> performOCRtoPDF_HTTPInput(ArrayList<DocumentInfos> failedDocuments, String suggestedOCREpr, String scope, String ftpHost, String ftpUser, String ftpPassword, String ftpPort, String randomUUIDString2, String repositoryId) throws ServiceEPRRetrievalException {
        FileWriter fstream = null;
        try {
            fstream = new FileWriter("metaInfo_" + randomUUIDString2 + ".txt");
        }
        catch (IOException e1) {
            System.err.println("Problem while creating file in disc");
        }
        BufferedWriter out = new BufferedWriter(fstream);
        ArrayList<String> HocrOutputSSIDs = new ArrayList<String>();
        for (int i = 0; i < failedDocuments.size(); ++i) {
            String metaInfo = TextExtractionUtils.createFileRecord(failedDocuments.get(i).getPdfURI(), failedDocuments.get(i).getReferenceId());
            System.out.println("The record is: " + metaInfo);
            try {
                out.write(metaInfo + "\n");
                continue;
            }
            catch (IOException e) {
                System.err.println("Problem while writting record to file");
            }
        }
        try {
            out.close();
        }
        catch (IOException e1) {
            System.err.println("Problem while closing buffer");
        }
        return HocrOutputSSIDs;
    }

    private static String getOCRServiceEPR(String scope) {
        EndpointReference[] ocrService = null;
        System.out.println("Looking for an OCRService epr");
        try {
            ocrService = RIsManager.getInstance().getISCache(GCUBEScope.getScope((String)scope)).getEPRsFor("Execution", "OCRService", SrvType.FACTORY.name());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ocrService != null && ocrService.length > 0) {
            System.out.println("The ocrService epr is: " + ocrService[0]);
            return ocrService[0].getAddress().toString();
        }
        System.out.println("The ocrService epr is NULL");
        return null;
    }

    public static void storeFileInFTP(String randomUUIDString, String ftpHost, int ftpPort, String ftpUser, String ftpPassword, String metadataFolderName) {
        File metaFile = new File("metaInfo_" + randomUUIDString + ".txt");
        System.out.println("TextExtractionBenchmarking: Uploading file to FTP.");
        MyFTPClient ftpClient = new MyFTPClient();
        try {
            ftpClient.connect(ftpHost, ftpPort, ftpUser, ftpPassword);
        }
        catch (ServerException e1) {
            System.err.println("Problem while connecting to FTP server for writting meta info");
            e1.printStackTrace();
        }
        catch (IOException e1) {
            System.err.println("Problem while connecting to FTP server for writting meta info");
            e1.printStackTrace();
        }
        System.out.println("Target Folder: " + metadataFolderName);
        try {
            ftpClient.uploadFile(metaFile, metadataFolderName + "/metaInfo_" + randomUUIDString + ".txt", false);
        }
        catch (ServerException e1) {
            System.err.println("Problem while uploading meta info to FTP server");
            e1.printStackTrace();
        }
        catch (ClientException e1) {
            System.err.println("Problem while uploading meta info to FTP server");
            e1.printStackTrace();
        }
        catch (IOException e1) {
            System.err.println("Problem while uploading meta info to FTP server");
            e1.printStackTrace();
        }
        try {
            ftpClient.closeConnection();
        }
        catch (ServerException e1) {
            System.err.println("Problem while closing connection to FTP server");
        }
        catch (IOException e1) {
            System.err.println("Problem while closing connection to FTP server");
        }
        System.out.println("TextExtractionBenchmarking: File uploaded to FTP! The location is: " + metadataFolderName + "/metaInfo_" + randomUUIDString + ".txt");
        metaFile.delete();
    }

    public static void deleteFileFromFTP(String fileName, String ftpHost, int ftpPort, String ftpUser, String ftpPassword, String metadataFolderName) {
        File metaFile = new File(fileName);
        System.out.println("TextExtractionBenchmarking: Deleting file from FTP.");
        MyFTPClient ftpClient = new MyFTPClient();
        try {
            ftpClient.connect(ftpHost, ftpPort, ftpUser, ftpPassword);
        }
        catch (ServerException e1) {
            System.err.println("Problem while connecting to FTP server for deleting dts input");
            e1.printStackTrace();
        }
        catch (IOException e1) {
            System.err.println("Problem while connecting to FTP server for deleting dts input");
            e1.printStackTrace();
        }
        System.out.println("Target Folder: " + metadataFolderName);
        try {
            ftpClient.deleteFile(metadataFolderName + "/" + fileName);
        }
        catch (ServerException e1) {
            System.err.println("Problem while uploading meta info to FTP server");
            e1.printStackTrace();
        }
        catch (ClientException e1) {
            System.err.println("Problem while uploading meta info to FTP server");
            e1.printStackTrace();
        }
        catch (IOException e1) {
            System.err.println("Problem while uploading meta info to FTP server");
            e1.printStackTrace();
        }
        try {
            ftpClient.closeConnection();
        }
        catch (ServerException e1) {
            System.err.println("Problem while closing connection to FTP server");
        }
        catch (IOException e1) {
            System.err.println("Problem while closing connection to FTP server");
        }
        System.out.println("TextExtractionBenchmarking: File deleted from FTP! The location is: " + metadataFolderName + "/" + fileName);
        metaFile.delete();
    }
}

