/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.textExtraction.job.utils;

import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderInvalidArgumentException;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.reader.RandomReader;
import gr.uoa.di.madgik.grs.reader.decorators.keepalive.KeepAliveReader;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import org.gcube.application.framework.search.library.exception.gRS2CreationException;
import org.gcube.execution.textExtraction.job.utils.JobDigitalObject;

public class JobResultSetConsumer {
    IRecordReader<GenericRecord> reader;
    ListIterator<GenericRecord> iter;
    String rsLocator;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<JobDigitalObject> getAllResultIds(String scope, String guid) {
        ArrayList<JobDigitalObject> rsIds = new ArrayList<JobDigitalObject>();
        try {
            while (this.reader.getStatus() != IBuffer.Status.Dispose && (this.reader.getStatus() != IBuffer.Status.Close || this.reader.availableRecords() != 0)) {
                GenericRecord rec = (GenericRecord)this.reader.get(240L, TimeUnit.SECONDS);
                try {
                    if (rec == null) {
                        System.out.println("The record is null!");
                        if (this.reader.getStatus() == IBuffer.Status.Dispose) {
                            System.out.println("The buffer status is DISPOSE");
                        } else if (this.reader.getStatus() == IBuffer.Status.Close) {
                            System.out.println("The buffer status is CLOSE");
                        } else {
                            System.out.println("The buffer status is neither!");
                        }
                    }
                    Field DocId = rec.getField("ObjectID");
                    StringField docId = (StringField)DocId;
                    Field CollID = rec.getField("gDocCollectionID");
                    StringField colId = null;
                    if (CollID != null) {
                        colId = (StringField)CollID;
                    }
                    JobDigitalObject dobj = new JobDigitalObject(scope, docId.getPayload(), colId.getPayload());
                    Field[] flds = rec.getFields();
                    for (int i = 0; i < flds.length; ++i) {
                        if (!flds[i].getFieldDefinition().getName().equals(guid)) continue;
                        StringField strFld = (StringField)flds[i];
                        dobj.setTitle(strFld.getPayload());
                    }
                    rsIds.add(dobj);
                }
                catch (GRS2RecordDefinitionException e) {
                    e.printStackTrace();
                }
                catch (GRS2BufferException e) {
                    e.printStackTrace();
                }
            }
            System.out.println("Returning number of all ids: " + rsIds.size());
            return rsIds;
        }
        catch (GRS2ReaderException e) {
            e.printStackTrace();
        }
        return rsIds;
    }

    public JobResultSetConsumer(String RSLocator2) throws URISyntaxException, gRS2CreationException {
        this.rsLocator = RSLocator2;
        URI locator = new URI(RSLocator2);
        try {
            this.reader = new RandomReader(locator);
            this.reader = new KeepAliveReader(this.reader, 20L, TimeUnit.SECONDS, 20L, TimeUnit.MINUTES);
            this.iter = (ListIterator)this.reader.iterator();
        }
        catch (GRS2ReaderException e) {
            throw new gRS2CreationException((Throwable)e);
        }
        catch (GRS2ReaderInvalidArgumentException e) {
            throw new gRS2CreationException((Throwable)e);
        }
    }
}

