/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.textExtraction.job.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.contentmanagement.contentmanager.stubs.calls.ManagerCall;
import org.gcube.contentmanagement.contentmanager.stubs.model.protocol.URIs;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentWriter;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;

public class JobDigitalObject {
    private String oid;
    private String uri;
    private String colID;
    private String colName;
    String scope;
    private String title;
    private String metadataID;

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getColID() {
        return this.colID;
    }

    public void setColID(String colID) {
        this.colID = colID;
    }

    public String getColName() {
        return this.colName;
    }

    public void setColName(String colName) {
        this.colName = colName;
    }

    public String getObjectId() {
        return this.oid;
    }

    public void setObjectId(String oid) {
        this.oid = oid;
    }

    public String getCollectionID() {
        return this.colID;
    }

    public void setCollectionID(String colID) {
        this.colID = colID;
    }

    public void setMetadataID(String metadataId) {
        this.metadataID = metadataId;
    }

    public String getMetadataID() {
        return this.metadataID;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public JobDigitalObject(String session, String oid, String colID) {
        this.scope = session;
        this.oid = oid;
        this.colID = colID;
        this.metadataID = "";
        System.out.println("The oid is: " + oid);
        if (oid != null) {
            this.uri = URIs.make((String)colID, (String[])new String[]{oid}).toString();
        }
        this.title = "";
    }

    public static JobDigitalObject createNewDigitalObject(String collectionID, InputStream content, String fileName, String scope, String mimeType) {
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        byte[] buffer = new byte[512];
        try {
            int c;
            while ((c = content.read(buffer, 0, buffer.length)) != -1) {
                temp.write(buffer, 0, c);
            }
        }
        catch (IOException e1) {
            System.err.println("failed to read content to be added" + e1.getStackTrace());
        }
        DocumentWriter writer = null;
        try {
            writer = new DocumentWriter(collectionID, GCUBEScope.getScope((String)scope));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        GCubeDocument document = new GCubeDocument();
        document.setCollectionID(collectionID);
        document.setName(fileName);
        document.setBytestream(buffer);
        document.setMimeType(mimeType);
        String objectID = null;
        try {
            objectID = writer.add(document);
        }
        catch (ManagerCall.DiscoveryException e) {
            e.printStackTrace();
        }
        catch (GCUBEException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new JobDigitalObject(scope, objectID, collectionID);
    }
}

