/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.textExtraction.job;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Random;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.application.framework.contentmanagement.exceptions.ReadingRSException;
import org.gcube.application.framework.contentmanagement.exceptions.ServiceEPRRetrievalException;
import org.gcube.application.framework.contentmanagement.exceptions.TransformationException;
import org.gcube.application.framework.contentmanagement.util.DocumentInfos;
import org.gcube.application.framework.core.cache.RIsManager;
import org.gcube.application.framework.core.cache.factories.ApplicationCredentials;
import org.gcube.application.framework.core.security.ServiceContextManager;
import org.gcube.common.core.faults.GCUBERetryEquivalentFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.RecordAttribute;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementGeneric;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceLocalType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLIterator;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLReader;
import org.gcube.datatransformation.datatransformationservice.stubs.ContentType;
import org.gcube.datatransformation.datatransformationservice.stubs.DataTransformationServicePortType;
import org.gcube.datatransformation.datatransformationservice.stubs.Input;
import org.gcube.datatransformation.datatransformationservice.stubs.Output;
import org.gcube.datatransformation.datatransformationservice.stubs.Parameter;
import org.gcube.datatransformation.datatransformationservice.stubs.TransformData;
import org.gcube.datatransformation.datatransformationservice.stubs.TransformDataResponse;
import org.gcube.datatransformation.datatransformationservice.stubs.service.DataTransformationServiceAddressingLocator;
import org.gcube.informationsystem.cache.SrvType;
import org.ietf.jgss.GSSCredential;

public class TestFTPDTS {
    public static void main(String[] args) {
        try {
            String rsLocator = TestFTPDTS.transformPDFDocumentsToText("http://dl10.di.uoa.gr:8181/dtsFTP.txt", "ftp.d4science-ii.research-infrastructures.eu", "d4s-w", "21", "_fDf4tt", "/4bc54b10-9661-11e0-b316-9c541a3a1781", "/gcube/devNext", "http://dl07.di.uoa.gr:8080/wsrf/services/gcube/datatransformation/DataTransformationService");
            ArrayList<Object> failedDocuments = new ArrayList();
            failedDocuments = TestFTPDTS.getListOfFailuresFromReport(rsLocator);
            System.out.println("TextExtractionBenchmarking: Transformation from DTS completed. Number of failures: " + failedDocuments.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String transformPDFDocumentsToText(String listLocation, String ftpHost, String ftpUser, String ftpPort, String ftpPassword, String ftpDirectory, String scope, String suggestedDtsEpr) throws Exception {
        TransformData request = new TransformData();
        Input input = new Input();
        input.setInputType("FTP");
        input.setInputValue(ftpHost);
        Parameter ipUser = new Parameter();
        ipUser.setName("username");
        ipUser.setValue(ftpUser);
        Parameter ipPassword = new Parameter();
        ipPassword.setName("password");
        ipPassword.setValue(ftpPassword);
        Parameter ipDirectory = new Parameter();
        ipDirectory.setName("directory");
        ipDirectory.setValue(ftpDirectory + "/dtsInput/dtsFTP.txt");
        Parameter ipPort = new Parameter();
        ipPort.setName("port");
        ipPort.setValue(ftpPort);
        input.setInputparameters(new Parameter[]{ipUser, ipPassword, ipDirectory, ipPort});
        System.out.println("The URI Location IS: " + ftpHost);
        request.setInput(input);
        Output output = new Output();
        output.setOutputType("FTP");
        output.setOutputValue(ftpHost);
        Parameter param1 = new Parameter("username", ftpUser);
        Parameter param2 = new Parameter("password", ftpPassword);
        Parameter param3 = new Parameter("port", ftpPort);
        Parameter param4 = new Parameter("directory", ftpDirectory);
        output.setOutputparameters(new Parameter[]{param1, param2, param3, param4});
        request.setOutput(output);
        ContentType targetContentType = new ContentType();
        targetContentType.setMimeType("text/plain");
        Parameter[] contentTypeParameters = new Parameter[]{};
        targetContentType.setParameters(contentTypeParameters);
        request.setTargetContentType(targetContentType);
        request.setCreateReport(true);
        DataTransformationServicePortType dts = null;
        try {
            dts = TestFTPDTS.getSuggestedDataTransformationServicePortType(suggestedDtsEpr, scope);
        }
        catch (Exception e) {
            System.out.println("The suggestion for the DTS EPR failed. Getting another EPR from IS.");
            dts = TestFTPDTS.getDataTransformationServicePortType(scope);
            e.printStackTrace();
        }
        String rslocator = null;
        try {
            TransformDataResponse response = dts.transformData(request);
            rslocator = response.getReportEPR();
        }
        catch (GCUBERetryEquivalentFault e) {
            throw new TransformationException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new TransformationException((Throwable)e);
        }
        System.out.println("Output: " + rslocator);
        return rslocator;
    }

    public static ArrayList<DocumentInfos> getListOfFailuresFromReport(String rsLocator) throws ReadingRSException {
        RSXMLReader reader = TestFTPDTS.getRSClient(rsLocator);
        RSXMLIterator iterator = null;
        ArrayList<DocumentInfos> listOfFailures = new ArrayList<DocumentInfos>();
        try {
            iterator = reader.getRSIterator();
        }
        catch (Exception e) {
            throw new ReadingRSException((Throwable)e);
        }
        while (iterator.hasNext()) {
            ResultElementBase res = iterator.next(ResultElementGeneric.class);
            try {
                String report = res.RS_toXML();
                RecordAttribute[] tmp = res.getRecordAttributes("DocID");
                String sourceId = tmp[0].getAttrValue();
                boolean success = TestFTPDTS.getStatusReport(report, sourceId);
                if (!success) {
                    System.out.println("FAIL!!!!!!!!!");
                } else {
                    System.out.println("SUCCESS!!!!!!!!!");
                }
                System.out.println("The REPORT for the document: " + sourceId + "is:" + report);
            }
            catch (Exception e) {
                throw new ReadingRSException((Throwable)e);
            }
        }
        return listOfFailures;
    }

    private static boolean getStatusReport(String report, String sourceId) {
        System.out.println("Getting report for document: " + sourceId);
        return !report.contains("<STATUS>FAILED</STATUS>");
    }

    private static DocumentInfos findDocumentInfosFromDocumentURI(ArrayList<DocumentInfos> allDocuments, String documentURI) {
        for (int i = 0; i < allDocuments.size(); ++i) {
            System.out.println("Comparing: " + allDocuments.get(i).getPdfURI() + " with " + documentURI);
            if (!allDocuments.get(i).getPdfURI().equals(documentURI)) continue;
            return allDocuments.get(i);
        }
        return null;
    }

    private static DataTransformationServicePortType getDataTransformationServicePortType(String scope) throws Exception {
        EndpointReference[] dtsURIs = null;
        try {
            dtsURIs = RIsManager.getInstance().getISCache(GCUBEScope.getScope((String)scope)).getEPRsFor("DataTransformation", "DataTransformationService", SrvType.SIMPLE.name());
        }
        catch (Exception e) {
            throw new ServiceEPRRetrievalException((Throwable)e);
        }
        Random random = new Random();
        String dtsAddress = dtsURIs[random.nextInt(dtsURIs.length)].getAddress().toString();
        EndpointReferenceType endpoint = new EndpointReferenceType();
        endpoint.setAddress((AttributedURI)new Address(dtsAddress));
        DataTransformationServiceAddressingLocator dtsLocator = new DataTransformationServiceAddressingLocator();
        DataTransformationServicePortType dts = dtsLocator.getDataTransformationServicePortTypePort(endpoint);
        try {
            dts = (DataTransformationServicePortType)ServiceContextManager.applySecurity((Remote)dts, (GCUBEScope)GCUBEScope.getScope((String)scope), (GSSCredential)ApplicationCredentials.getInstance().getCredential(scope));
        }
        catch (GCUBEScope.MalformedScopeExpressionException e) {
            throw new ServiceEPRRetrievalException((Throwable)e);
        }
        catch (Exception e) {
            throw new ServiceEPRRetrievalException((Throwable)e);
        }
        return dts;
    }

    protected static RSXMLReader getRSClient(String epr) throws ReadingRSException {
        RSXMLReader client = null;
        try {
            client = RSXMLReader.getRSXMLReader((RSLocator)new RSLocator(epr)).makeLocal((RSResourceType)new RSResourceLocalType());
        }
        catch (Exception e) {
            throw new ReadingRSException((Throwable)e);
        }
        return client;
    }

    private static DataTransformationServicePortType getSuggestedDataTransformationServicePortType(String suggestedEPR, String scope) throws Exception {
        DataTransformationServicePortType dts = null;
        try {
            EndpointReferenceType endpoint = new EndpointReferenceType();
            endpoint.setAddress((AttributedURI)new Address(suggestedEPR));
            DataTransformationServiceAddressingLocator dtsLocator = new DataTransformationServiceAddressingLocator();
            dts = dtsLocator.getDataTransformationServicePortTypePort(endpoint);
            dts = (DataTransformationServicePortType)ServiceContextManager.applySecurity((Remote)dts, (GCUBEScope)GCUBEScope.getScope((String)scope), (GSSCredential)ApplicationCredentials.getInstance().getCredential(scope));
        }
        catch (GCUBEScope.MalformedScopeExpressionException e) {
            throw new ServiceEPRRetrievalException((Throwable)e);
        }
        catch (Exception e) {
            throw new ServiceEPRRetrievalException((Throwable)e);
        }
        return dts;
    }
}

