/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.rr.bridge;

import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.bridge.IRegistryProvider;
import gr.uoa.di.madgik.rr.element.IDaoElement;
import gr.uoa.di.madgik.rr.element.config.StaticConfigurationDao;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadata;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadataDao;
import gr.uoa.di.madgik.rr.element.search.Field;
import gr.uoa.di.madgik.rr.element.search.FieldDao;
import gr.uoa.di.madgik.rr.element.search.Presentable;
import gr.uoa.di.madgik.rr.element.search.PresentableDao;
import gr.uoa.di.madgik.rr.element.search.Searchable;
import gr.uoa.di.madgik.rr.element.search.SearchableDao;
import gr.uoa.di.madgik.rr.element.search.index.DataSource;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainerDao;
import gr.uoa.di.madgik.rr.utils.DatastoreHelper;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.execution.rr.bridge.BridgeHelper;
import org.gcube.execution.rr.bridge.FieldModel;

public class GCubeRepositoryProvider
implements IRegistryProvider {
    private static Logger logger = Logger.getLogger(GCubeRepositoryProvider.class.getName());
    public static String RRModelGenericResourceNameDef = "ResourceRegistryModel";
    public static String RRModelGenericResourceSecondaryTypeDef = "ResourceRegistryModel";
    public static String RRModelGenericResourceName = RRModelGenericResourceNameDef;
    public static String RRModelGenericResourceSecondaryType = RRModelGenericResourceSecondaryTypeDef;
    public Set<Class<?>> inMemoryTargets = new HashSet();

    public void readConfiguration(Properties config) {
        if (config == null) {
            return;
        }
        boolean defaultUsed = true;
        String value = null;
        value = config.getProperty("modelGenericResourceSecondaryType");
        if (value != null) {
            String secTypeValue = value;
            value = config.getProperty("modelGenericResourceName");
            if (value != null) {
                RRModelGenericResourceSecondaryType = secTypeValue;
                RRModelGenericResourceName = value;
                defaultUsed = false;
                logger.log(Level.INFO, "Using Model Generic Resource secondary type: " + RRModelGenericResourceSecondaryType);
                logger.log(Level.INFO, "Using Model Generic Resource name: " + RRModelGenericResourceName);
            }
        }
        if (defaultUsed) {
            logger.log(Level.INFO, "Using default Model Generic Resource secondary type: " + RRModelGenericResourceSecondaryType);
            logger.log(Level.INFO, "Using default Model Generic Resource name: " + RRModelGenericResourceName);
        }
        try {
            BridgeHelper.initializeIndexTypes(config);
        }
        catch (ResourceRegistryException e) {
            logger.log(Level.WARNING, "Could not initialize index types. Defaults will be used", e);
            BridgeHelper.initializeIndexTypes();
        }
    }

    public boolean isReadPolicySupported(RRContext.ReadPolicy policy) throws ResourceRegistryException {
        switch (policy) {
            case READ_LOCAL: {
                return false;
            }
            case READ_THROUGH: {
                return false;
            }
            case REFRESH_AHEAD: {
                return ResourceRegistry.getContext().isDatastoreSupported(RRContext.DatastoreType.LOCAL) && ResourceRegistry.getContext().isDatastoreSupported(RRContext.DatastoreType.LOCALBUFFER);
            }
        }
        return false;
    }

    public boolean isWritePolicySupported(RRContext.WritePolicy policy) throws ResourceRegistryException {
        switch (policy) {
            case WRITE_THROUGH: {
                return false;
            }
            case WRITE_LOCAL: {
                return false;
            }
            case WRITE_BEHIND: {
                return ResourceRegistry.getContext().isDatastoreSupported(RRContext.DatastoreType.LOCAL) && ResourceRegistry.getContext().isDatastoreSupported(RRContext.DatastoreType.LOCALBUFFER);
            }
        }
        return false;
    }

    public void setInMemoryTargets(Set<Class<?>> items) {
        this.inMemoryTargets = items;
    }

    public void persistDirect(Class<?> item, String id) throws ResourceRegistryException {
        throw new ResourceRegistryException("Operation not supported");
    }

    public void persistDirect(Class<?> items) throws ResourceRegistryException {
        throw new ResourceRegistryException("Operation not supported");
    }

    public void persist(Set<Class<?>> items) throws ResourceRegistryException {
        logger.log(Level.INFO, "starting aligning");
        this.alignOutgoing(items);
        logger.log(Level.INFO, "starting persisting");
        this.bridgeOutgoing(items);
        logger.log(Level.INFO, "finished persisting");
    }

    public void retrieve(Set<Class<?>> items) throws ResourceRegistryException {
        logger.log(Level.INFO, "starting retrieving");
        this.bridgeIncoming(items);
        logger.log(Level.INFO, "starting aligning");
        this.alignIncoming(items);
        logger.log(Level.INFO, "finished retrieving");
    }

    public void retrieveDirect(Class<?> item, String id) throws ResourceRegistryException {
        throw new ResourceRegistryException("Operation not supported");
    }

    public void retrieveDirect(Class<?> item) throws ResourceRegistryException {
        throw new ResourceRegistryException("Operation not supported");
    }

    public void prefetchInMemoryItems() throws ResourceRegistryException {
        BridgeHelper.prefetchInMemoryItems(this.inMemoryTargets);
    }

    private void bridgeIncoming(Set<Class<?>> targets) throws ResourceRegistryException {
        try {
            BridgeHelper.retrieveScopes();
            FieldModel.retrieve();
            for (Class<?> include : targets) {
                logger.log(Level.INFO, "retrieving info from IS for element " + include.getName());
                Set<IDaoElement> items = BridgeHelper.getElement(include);
                logger.log(Level.INFO, "buffering information retrieved for element " + include.getName());
                DatastoreHelper.bufferItems(items);
            }
        }
        catch (Exception ex) {
            throw new ResourceRegistryException("could not bridge incoming elements", (Throwable)ex);
        }
    }

    private void alignIncoming(Set<Class<?>> targets) throws ResourceRegistryException {
        boolean locked = false;
        Lock writeLock = ResourceRegistry.getContext().getExclusiveLock();
        try {
            boolean updateMode = !targets.contains(FieldDao.class) || !targets.contains(SearchableDao.class) || !targets.contains(PresentableDao.class);
            RRContext.DatastoreType datastoreType = ResourceRegistry.isInitialBridgingComplete() && updateMode ? RRContext.DatastoreType.LOCAL : RRContext.DatastoreType.LOCALBUFFER;
            List allFields = Field.getAll((boolean)true, (RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER);
            List allDataSources = DataSource.getAll((boolean)false, (RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER);
            Set allMetadata = DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER, ElementMetadataDao.class);
            writeLock.lock();
            locked = true;
            List updatedFieldsMetadata = ElementMetadata.getUpdatedFieldsMetadata((boolean)true);
            for (ElementMetadata m : updatedFieldsMetadata) {
                m.delete(true, RRContext.DatastoreType.LOCAL);
            }
            writeLock.unlock();
            locked = false;
            if (targets.contains(FieldIndexContainerDao.class)) {
                Set elems = DatastoreHelper.retrieveAll((RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER, FieldIndexContainerDao.class);
                HashSet<Class<FieldIndexContainerDao>> purge = new HashSet<Class<FieldIndexContainerDao>>();
                purge.add(FieldIndexContainerDao.class);
                DatastoreHelper.clear((RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER, purge);
                for (IDaoElement el : elems) {
                    if (!(el instanceof FieldIndexContainerDao)) continue;
                    Field f = null;
                    for (Field field : allFields) {
                        if (!field.getName().equals(((FieldIndexContainerDao)el).getField())) continue;
                        f = field;
                        break;
                    }
                    if (f == null) continue;
                    ((FieldIndexContainerDao)el).setField(f.getID());
                }
                DatastoreHelper.bufferItems((Set)elems);
            }
            for (Field f : allFields) {
                Searchable item;
                DataSource ds;
                for (Searchable s : f.getSearchables()) {
                    ds = null;
                    for (DataSource d : allDataSources) {
                        if (!d.getID().equals(s.getLocator())) continue;
                        ds = d;
                        break;
                    }
                    if (ds != null) {
                        logger.info("Datasource " + ds.getID() + " scopes : " + ds.getScopes());
                    }
                    if (ds != null) {
                        s.getDatasourceScopes().addAll(ds.getScopes());
                    }
                    item = new Searchable();
                    item.setID(s.getID());
                    item.setCollection(s.getCollection());
                    item.setField(s.getField());
                    item.setLocator(s.getLocator());
                    item.setExpression(s.getExpression());
                    item.setOrder(s.isOrder());
                    item.getCapabilities().addAll(s.getCapabilities());
                    item.setDatasourceScopes(s.getDatasourceScopes());
                    item.store(true, datastoreType);
                }
                for (Presentable p : f.getPresentables()) {
                    ds = null;
                    for (DataSource d : allDataSources) {
                        if (!d.getID().equals(p.getLocator())) continue;
                        ds = d;
                        break;
                    }
                    if (ds != null) {
                        p.getDatasourceScopes().addAll(ds.getScopes());
                    }
                    item = new Presentable();
                    item.setID(p.getID());
                    item.setCollection(p.getCollection());
                    item.setField(p.getField());
                    item.setLocator(p.getLocator());
                    item.setExpression(p.getExpression());
                    item.setOrder(p.isOrder().booleanValue());
                    item.setPresentationInfo(p.getPresentationInfo());
                    item.setDatasourceScopes(p.getDatasourceScopes());
                    item.store(true, datastoreType);
                }
            }
        }
        catch (Exception ex) {
            throw new ResourceRegistryException("could not align incoming elements", (Throwable)ex);
        }
        finally {
            if (locked) {
                writeLock.unlock();
            }
        }
    }

    private void alignOutgoing(Set<Class<?>> targets) throws ResourceRegistryException {
    }

    private void bridgeOutgoing(Set<Class<?>> targets) throws ResourceRegistryException {
        try {
            String scopes;
            String serialization;
            GCUBEGenericResource resource;
            String scopes2;
            String serialization2;
            logger.log(Level.INFO, "retrieving field info from local");
            logger.log(Level.INFO, "targets : " + targets);
            Set<IDaoElement> fields = new HashSet();
            Set<IDaoElement> searchables = new HashSet();
            Set<IDaoElement> presentables = new HashSet();
            Set<IDaoElement> metadata = new HashSet();
            IDaoElement staticConfig = null;
            boolean updateFields = false;
            boolean updateSearchables = false;
            boolean updatePresentables = false;
            boolean updateMetadata = false;
            boolean updateConfig = false;
            if (targets.contains(FieldDao.class)) {
                logger.log(Level.INFO, "retrieving info for " + FieldDao.class.getName());
                fields = DatastoreHelper.retrieveAll((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, FieldDao.class);
                logger.log(Level.INFO, "done retrieving info for " + fields.size() + " " + FieldDao.class.getName());
                updateFields = true;
            }
            if (targets.contains(SearchableDao.class)) {
                logger.log(Level.INFO, "retrieving info for " + SearchableDao.class.getName());
                searchables = DatastoreHelper.retrieveAll((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, SearchableDao.class);
                logger.log(Level.INFO, "done retrieving info for " + searchables.size() + " " + SearchableDao.class.getName());
                updateSearchables = true;
            }
            if (targets.contains(PresentableDao.class)) {
                logger.log(Level.INFO, "retrieving info for " + PresentableDao.class.getName());
                presentables = DatastoreHelper.retrieveAll((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, PresentableDao.class);
                logger.log(Level.INFO, "done retrieving info for " + presentables.size() + " " + PresentableDao.class.getName());
                updatePresentables = true;
            }
            if (targets.contains(ElementMetadataDao.class)) {
                logger.log(Level.INFO, "retrieving info for " + ElementMetadataDao.class.getName());
                metadata = DatastoreHelper.retrieveAll((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, ElementMetadataDao.class);
                logger.log(Level.INFO, "done retrieving info for " + metadata.size() + " " + ElementMetadataDao.class.getName());
                updateMetadata = true;
            }
            if (targets.contains(StaticConfigurationDao.class)) {
                logger.log(Level.INFO, "retrieving info for " + StaticConfigurationDao.class.getName());
                Set staticConfigs = DatastoreHelper.retrieveAll((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, StaticConfigurationDao.class);
                logger.log(Level.INFO, "done retrieving info for " + staticConfigs.size() + " " + StaticConfigurationDao.class.getName());
                if (staticConfigs.size() > 1) {
                    throw new ResourceRegistryException("Multiple static configuration elements were found");
                }
                if (!staticConfigs.isEmpty()) {
                    staticConfig = (IDaoElement)staticConfigs.iterator().next();
                }
                updateConfig = true;
            }
            if (!(updateFields || updateSearchables || updatePresentables || updateMetadata || updateConfig)) {
                return;
            }
            logger.log(Level.INFO, "finished retrieving field info from local");
            ResourceRegistryException re = null;
            List<GCUBEGenericResource> resources = null;
            if (updateFields) {
                logger.log(Level.INFO, "updating field directory gcube generic resource");
                try {
                    resources = BridgeHelper.getPublishedFieldResources();
                }
                catch (Exception ex) {
                    throw new ResourceRegistryException("could not retrieve remote field directory", (Throwable)ex);
                }
                logger.log(Level.INFO, "resources      : " + resources);
                if (resources != null) {
                    logger.log(Level.INFO, "resources size : " + resources.size());
                }
                if (resources.size() > 0) {
                    for (GCUBEGenericResource resource2 : resources) {
                        logger.log(Level.INFO, "---------------------------------------------------");
                        logger.log(Level.INFO, "Adding resource");
                        logger.log(Level.INFO, resource2.getID());
                        logger.log(Level.INFO, resource2.getName());
                        logger.log(Level.INFO, resource2.getDescription());
                        logger.log(Level.INFO, resource2.getBody());
                        logger.log(Level.INFO, "---------------------------------------------------");
                        resource2.setDescription(Long.toString(new Date().getTime()));
                        serialization2 = BridgeHelper.buildFieldDirectorySerialization(fields);
                        scopes2 = "(";
                        for (GCUBEScope s : BridgeHelper.getFieldModelScopes()) {
                            scopes2 = scopes2 + s + " ";
                        }
                        scopes2 = scopes2 + ")";
                        logger.log(Level.FINE, "updating field directory resource serialization in scope " + scopes2 + " to :\n" + serialization2);
                        resource2.setBody(serialization2);
                        try {
                            BridgeHelper.publishFieldResource(resource2, false);
                        }
                        catch (Exception ex) {
                            throw new ResourceRegistryException("could not publish remote field profile", (Throwable)ex);
                        }
                    }
                } else {
                    resource = null;
                    try {
                        resource = (GCUBEGenericResource)GHNContext.getImplementation(GCUBEGenericResource.class);
                    }
                    catch (Exception ex) {
                        throw new ResourceRegistryException("could not retrieve generic resource instance", (Throwable)ex);
                    }
                    resource.addScope(BridgeHelper.getFieldModelScopes());
                    resource.setName(RRModelGenericResourceName);
                    resource.setSecondaryType(RRModelGenericResourceSecondaryType);
                    resource.setDescription(Long.toString(new Date().getTime()));
                    serialization = BridgeHelper.buildFieldDirectorySerialization(fields);
                    scopes = "(";
                    for (GCUBEScope s : BridgeHelper.getFieldModelScopes()) {
                        scopes = scopes + s + " ";
                    }
                    scopes = scopes + ")";
                    logger.log(Level.FINE, "adding field directory resource serialization in scope " + scopes + " to :\n" + serialization);
                    resource.setBody(serialization);
                    try {
                        logger.log(Level.INFO, "Adding NEW resource : " + resource);
                        BridgeHelper.publishFieldResource(resource, true);
                        logger.log(Level.INFO, "Adding NEW resource done ");
                    }
                    catch (Exception ex) {
                        throw new ResourceRegistryException("could not publish remote field profile", (Throwable)ex);
                    }
                }
                logger.log(Level.INFO, "finished updating field directory gcube generic resource");
                List deletedFieldsMetadata = ElementMetadata.getDeletedFieldsMetadata((boolean)true);
                HashSet deletedFieldIds = new HashSet();
                for (ElementMetadata m : deletedFieldsMetadata) {
                    try {
                        resources = null;
                        try {
                            resources = BridgeHelper.getPublishedFieldResourcesForField((String)m.getProperties().get("id"));
                        }
                        catch (Exception ex) {
                            throw new ResourceRegistryException("could not retrieve remote field profile", (Throwable)ex);
                        }
                        if (resources.size() > 0) {
                            for (GCUBEGenericResource resource3 : resources) {
                                String scopes3 = "(";
                                for (GCUBEScope s : BridgeHelper.getFieldModelScopes()) {
                                    scopes3 = scopes3 + s + " ";
                                }
                                scopes3 = scopes3 + ")";
                                logger.log(Level.FINE, "deleting resource for field " + (String)m.getProperties().get("id") + " in scope " + scopes3);
                                try {
                                    BridgeHelper.deleteFieldResource(resource3);
                                    deletedFieldIds.add(m.getProperties().get("id"));
                                }
                                catch (Exception ex) {
                                    throw new ResourceRegistryException("could not delete remote field profile", (Throwable)ex);
                                }
                            }
                        }
                        m.delete(true, RRContext.DatastoreType.LOCAL);
                    }
                    catch (ResourceRegistryException e) {
                        logger.log(Level.WARNING, "Could not delete remote field profiles");
                        re = e;
                    }
                }
                List updatedFieldsMetadata = ElementMetadata.getUpdatedFieldsMetadata((boolean)true);
                HashSet updatedFieldIds = new HashSet();
                for (ElementMetadata m : updatedFieldsMetadata) {
                    updatedFieldIds.add(m.getProperties().get("id"));
                }
                logger.log(Level.INFO, "Updating fields");
                logger.log(Level.INFO, "updatedFieldIds " + updatedFieldIds);
                for (IDaoElement f : fields) {
                    try {
                        FieldDao field = (FieldDao)f;
                        logger.log(Level.INFO, "1. updating gcube generic resource for field " + field.getName() + " (" + field.getID() + ")");
                        if (deletedFieldIds.contains(f.getID())) continue;
                        logger.log(Level.INFO, "2. updating gcube generic resource for field " + field.getName() + " (" + field.getID() + ")");
                        resources = null;
                        try {
                            resources = BridgeHelper.getPublishedFieldResourcesForField(field.getID());
                        }
                        catch (Exception ex) {
                            throw new ResourceRegistryException("could not retrieve remote field profile", (Throwable)ex);
                        }
                        logger.log(Level.INFO, "resources      : " + resources);
                        if (resources != null) {
                            logger.log(Level.INFO, "resources size : " + resources.size());
                        }
                        if (resources.size() > 0) {
                            for (GCUBEGenericResource resource4 : resources) {
                                resource4.setDescription(Long.toString(new Date().getTime()));
                                String serialization3 = BridgeHelper.updateFieldSerialization(resource4.getBody(), (IDaoElement)field, searchables, presentables, updateFields, updateSearchables, updatePresentables);
                                String scopes4 = "(";
                                for (GCUBEScope s : BridgeHelper.getFieldModelScopes()) {
                                    scopes4 = scopes4 + s + " ";
                                }
                                scopes4 = scopes4 + ")";
                                logger.log(Level.FINE, "updating resource serialization for field " + field.getName() + " (" + field.getID() + ")" + " in scope " + scopes4 + " to :\n" + serialization3);
                                resource4.setBody(serialization3);
                                try {
                                    BridgeHelper.publishFieldResource(resource4, false);
                                }
                                catch (Exception ex) {
                                    throw new ResourceRegistryException("could not publish remote field profile", (Throwable)ex);
                                }
                            }
                        } else {
                            GCUBEGenericResource resource5 = null;
                            try {
                                resource5 = (GCUBEGenericResource)GHNContext.getImplementation(GCUBEGenericResource.class);
                            }
                            catch (Exception ex) {
                                throw new ResourceRegistryException("could not retrieve generic resource instance", (Throwable)ex);
                            }
                            resource5.addScope(BridgeHelper.getFieldModelScopes());
                            resource5.setName(RRModelGenericResourceName + "." + field.getID());
                            resource5.setSecondaryType(RRModelGenericResourceSecondaryType);
                            resource5.setDescription(Long.toString(new Date().getTime()));
                            String serialization4 = BridgeHelper.buildFieldSerialization((IDaoElement)field, searchables, presentables);
                            String scopes5 = "(";
                            for (GCUBEScope s : BridgeHelper.getFieldModelScopes()) {
                                scopes5 = scopes5 + s + " ";
                            }
                            scopes5 = scopes5 + ")";
                            logger.log(Level.FINE, "adding resource serialization for field " + field.getName() + " (" + field.getID() + ")" + " in scope " + scopes5 + " to :\n" + serialization4);
                            resource5.setBody(serialization4);
                            try {
                                BridgeHelper.publishFieldResource(resource5, true);
                            }
                            catch (Exception ex) {
                                throw new ResourceRegistryException("could not publish remote field profile", (Throwable)ex);
                            }
                        }
                        logger.log(Level.INFO, "finished updating gcube generic resource");
                    }
                    catch (ResourceRegistryException e) {
                        re = e;
                        logger.log(Level.WARNING, "Error creating/updating gcube generic resource for field " + ((FieldDao)f).getName() + "(" + ((FieldDao)f).getID() + ")");
                    }
                }
            }
            if (updateMetadata) {
                logger.log(Level.INFO, "updating element metadata gcube generic resource");
                resources = null;
                try {
                    resources = BridgeHelper.getPublishedMetadataResources();
                }
                catch (Exception ex) {
                    throw new ResourceRegistryException("could not retrieve remote element metadata", (Throwable)ex);
                }
                if (resources.size() > 0) {
                    for (GCUBEGenericResource resource2 : resources) {
                        resource2.setDescription(Long.toString(new Date().getTime()));
                        serialization2 = BridgeHelper.buildElementMetadataSerialization(metadata);
                        scopes2 = "(";
                        for (GCUBEScope s : BridgeHelper.getFieldModelScopes()) {
                            scopes2 = scopes2 + s + " ";
                        }
                        scopes2 = scopes2 + ")";
                        logger.log(Level.FINE, "updating element metadata resource serialization in scope " + scopes2 + " to :\n" + serialization2);
                        resource2.setBody(serialization2);
                        try {
                            BridgeHelper.publishFieldResource(resource2, false);
                        }
                        catch (Exception ex) {
                            throw new ResourceRegistryException("could not publish remote element metadata", (Throwable)ex);
                        }
                    }
                } else {
                    resource = null;
                    try {
                        resource = (GCUBEGenericResource)GHNContext.getImplementation(GCUBEGenericResource.class);
                    }
                    catch (Exception ex) {
                        throw new ResourceRegistryException("could not retrieve generic resource instance", (Throwable)ex);
                    }
                    resource.addScope(BridgeHelper.getFieldModelScopes());
                    resource.setName(RRModelGenericResourceName + ".Metadata");
                    resource.setSecondaryType(RRModelGenericResourceSecondaryType);
                    resource.setDescription(Long.toString(new Date().getTime()));
                    serialization = BridgeHelper.buildElementMetadataSerialization(metadata);
                    scopes = "(";
                    for (GCUBEScope s : BridgeHelper.getFieldModelScopes()) {
                        scopes = scopes + s + " ";
                    }
                    scopes = scopes + ")";
                    logger.log(Level.FINE, "adding element metadata resource serialization in scope " + scopes + " to :\n" + serialization);
                    resource.setBody(serialization);
                    try {
                        BridgeHelper.publishFieldResource(resource, true);
                    }
                    catch (Exception ex) {
                        throw new ResourceRegistryException("could not publish remote field profiles", (Throwable)ex);
                    }
                }
                logger.log(Level.INFO, "finished updating element metadata gcube generic resource");
            }
            if (updateConfig) {
                logger.log(Level.INFO, "updating static configuration gcube generic resource");
                resources = null;
                try {
                    resources = BridgeHelper.getPublishedStaticConfigResources();
                }
                catch (Exception ex) {
                    throw new ResourceRegistryException("could not retrieve remote static configuration", (Throwable)ex);
                }
                if (resources.size() > 0) {
                    for (GCUBEGenericResource resource2 : resources) {
                        resource2.setDescription(Long.toString(new Date().getTime()));
                        serialization2 = BridgeHelper.buildStaticConfigSerialization(staticConfig);
                        scopes2 = "(";
                        for (GCUBEScope s : BridgeHelper.getFieldModelScopes()) {
                            scopes2 = scopes2 + s + " ";
                        }
                        scopes2 = scopes2 + ")";
                        logger.log(Level.FINE, "updating static configuration resource serialization in scope " + scopes2 + " to :\n" + serialization2);
                        resource2.setBody(serialization2);
                        try {
                            BridgeHelper.publishFieldResource(resource2, false);
                        }
                        catch (Exception ex) {
                            throw new ResourceRegistryException("could not publish remote element metadata", (Throwable)ex);
                        }
                    }
                } else {
                    resource = null;
                    try {
                        resource = (GCUBEGenericResource)GHNContext.getImplementation(GCUBEGenericResource.class);
                    }
                    catch (Exception ex) {
                        throw new ResourceRegistryException("could not retrieve generic resource instance", (Throwable)ex);
                    }
                    resource.addScope(BridgeHelper.getFieldModelScopes());
                    resource.setName(RRModelGenericResourceName + ".StaticConfig");
                    resource.setSecondaryType(RRModelGenericResourceSecondaryType);
                    resource.setDescription(Long.toString(new Date().getTime()));
                    serialization = BridgeHelper.buildStaticConfigSerialization(staticConfig);
                    scopes = "(";
                    for (GCUBEScope s : BridgeHelper.getFieldModelScopes()) {
                        scopes = scopes + s + " ";
                    }
                    scopes = scopes + ")";
                    logger.log(Level.FINE, "adding static configuration resource serialization in scope " + scopes + " to :\n" + serialization);
                    resource.setBody(serialization);
                    try {
                        BridgeHelper.publishFieldResource(resource, true);
                    }
                    catch (Exception ex) {
                        throw new ResourceRegistryException("could not publish remote static configuration", (Throwable)ex);
                    }
                }
                logger.log(Level.INFO, "finished updating static configuration gcube generic resource");
            }
            if (re != null) {
                throw re;
            }
        }
        catch (Exception ex) {
            throw new ResourceRegistryException("could not bridge outgoing elements", (Throwable)ex);
        }
    }

    static {
        BridgeHelper.initializeIndexTypes();
    }
}

