/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.rr.configuration.impl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.gcube.execution.rr.configuration.ConfigurationProvider;

public class ConfigurationProviderPortalImpl
implements ConfigurationProvider {
    private Properties properties = null;

    private synchronized Properties getPropertyFile() throws FileNotFoundException, IOException {
        if (this.properties != null) {
            return this.properties;
        }
        String filename = System.getenv("CATALINA_HOME") + "/conf/infrastructure.properties";
        this.properties = new Properties();
        this.properties.load(new FileInputStream(filename));
        return this.properties;
    }

    public List<String> getGHNContextStartScopes() {
        try {
            Properties prop = this.getPropertyFile();
            String infrastructure = prop.getProperty("infrastructure");
            List<String> scopes = Arrays.asList(prop.getProperty("scopes").split(","));
            ArrayList<String> startScopes = new ArrayList<String>();
            for (String sc : scopes) {
                startScopes.add("/" + infrastructure + "/" + sc.trim());
            }
            return startScopes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<String> getGHNContextScopes() {
        try {
            Properties prop = this.getPropertyFile();
            String infrastructure = prop.getProperty("infrastructure");
            List<String> scopes = Arrays.asList(prop.getProperty("scopes").split(","));
            ArrayList<String> startScopes = new ArrayList<String>();
            for (String sc : scopes) {
                startScopes.add("/" + infrastructure + "/" + sc);
            }
            return startScopes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isClientMode() {
        try {
            Properties prop = this.getPropertyFile();
            boolean isClientMode = Boolean.valueOf(prop.getProperty("clientMode", "true"));
            return isClientMode;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }
}

