/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.engine.monitoring;

import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.engine.monitoring.consumer.ExecutionNodesLoadConsumer;
import gr.uoa.di.madgik.execution.engine.monitoring.resource.ExecutionNodesLoad;
import gr.uoa.di.madgik.execution.engine.utilities.Helper;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionMonitor {
    private Logger log = LoggerFactory.getLogger((String)ExecutionMonitor.class.getName());
    private static ExecutionNodesLoad hostingNodesLoad;
    private static ExecutionNodesLoadConsumer executionNodesLoadConsumer;

    public ExecutionMonitor(String resourceID) {
        hostingNodesLoad = new ExecutionNodesLoad();
        executionNodesLoadConsumer = new ExecutionNodesLoadConsumer(resourceID, hostingNodesLoad);
    }

    public void init() {
        executionNodesLoadConsumer.subscribeForExecutionNodeLoad();
    }

    public boolean evaluate(ExecutionHandle handle, float util) {
        Set<String> hostingNodes = Helper.getHostingNodes(handle);
        for (String node : hostingNodes) {
            float percUsage;
            if (hostingNodesLoad.get(node) == null) {
                this.log.info("No status has been reported for node " + node + " submiting anyway. And setting node ustilization to maximum.");
                hostingNodesLoad.put(node, Float.valueOf(1.0f));
                percUsage = 0.0f;
            } else {
                percUsage = hostingNodesLoad.get(node).floatValue();
            }
            if (!this.evaluate(percUsage, util)) {
                this.log.debug("Execution plan with required utilization " + util + " did not fulfil requirements on node " + node + " with utilization " + percUsage);
                return false;
            }
            this.log.debug("Execution plan with required utilization " + util + " did fulfil requirements on node " + node + " with utilization " + percUsage);
        }
        for (String node : hostingNodes) {
            Float percUsage = hostingNodesLoad.get(node);
            if (!(percUsage.floatValue() + util <= 1.0f)) continue;
            float prevPerc = hostingNodesLoad.put(node, Float.valueOf(percUsage.floatValue() + util)).floatValue();
            this.log.trace("Node: " + node + " with utilization: " + prevPerc + " set to: " + (percUsage.floatValue() + util));
        }
        return true;
    }

    private boolean evaluate(float perc, float util) {
        return perc + util <= 1.0f;
    }

    public void terminate() {
        executionNodesLoadConsumer.UnregisterFromExecutionNodeLoad();
    }

    public Object getLoadUpdatesAvailable() {
        return hostingNodesLoad.getUpdateAvailable();
    }
}

