/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.ocrservice.utils;

import gr.uoa.di.madgik.environment.exception.EnvironmentInformationSystemException;
import gr.uoa.di.madgik.environment.exception.EnvironmentValidationException;
import gr.uoa.di.madgik.environment.hint.EnvHint;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.hint.NamedEnvHint;
import gr.uoa.di.madgik.is.InformationSystem;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.Remote;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.execution.workflowengine.service.stubs.WorkflowEngineServicePortType;
import org.gcube.execution.workflowengine.service.stubs.service.WorkflowEngineServiceAddressingLocator;

public class ServiceUtils {
    private static Random randGen = new Random();
    private static final int DefaultInvocationTimeout = 600000;

    protected static void Init() throws EnvironmentValidationException {
        EnvHintCollection Hints = new EnvHintCollection();
        Hints.AddHint(new NamedEnvHint("StorageSystemDeleteOnExit", new EnvHint(Boolean.FALSE.toString())));
        Hints.AddHint(new NamedEnvHint("StorageSystemLocalFileSystemBufferPath", new EnvHint("/tmp/")));
        System.out.println("Initializing Information System");
        InformationSystem.Init((String)"gr.uoa.di.madgik.environment.gcube.GCubeInformationSystemProvider", (EnvHintCollection)Hints);
    }

    public static String GetStringFilePayload(String path) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(new File(path)));
        StringBuilder buf = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            buf.append(line);
            buf.append("\n");
        }
        reader.close();
        return buf.toString();
    }

    public static byte[] GetByteFilePayload(String path) throws IOException {
        int read;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        BufferedInputStream bin = new BufferedInputStream(new FileInputStream(new File(path)));
        byte[] b = new byte[4096];
        while ((read = bin.read(b)) >= 0) {
            bout.write(b, 0, read);
        }
        bin.close();
        bout.flush();
        bout.close();
        return bout.toByteArray();
    }

    public static String GetWorkflowEngineEndpoint(String Scope) throws Exception {
        EnvHintCollection ISHints = new EnvHintCollection();
        ISHints.AddHint(new NamedEnvHint("GCubeActionScope", new EnvHint(Scope)));
        List eps = InformationSystem.RetrieveByQualifier((String)"ServiceClass:Execution,ServiceName:WorkflowEngineService", (EnvHintCollection)ISHints);
        if (eps == null || eps.size() == 0) {
            throw new EnvironmentInformationSystemException("No usable WorkflowEngine end point found");
        }
        String endpoint = (String)eps.get(randGen.nextInt(eps.size()));
        return endpoint;
    }

    public static WorkflowEngineServicePortType GetWorkflowEnginePortType(String Scope, String endpoint) throws Exception {
        EndpointReferenceType endpointT = new EndpointReferenceType();
        endpointT.setAddress((AttributedURI)new Address(endpoint));
        WorkflowEngineServiceAddressingLocator wflocator = new WorkflowEngineServiceAddressingLocator();
        WorkflowEngineServicePortType wf = wflocator.getWorkflowEngineServicePortTypePort(endpointT);
        wf = (WorkflowEngineServicePortType)GCUBERemotePortTypeContext.getProxy((Remote)wf, (GCUBEScope)GCUBEScope.getScope((String)Scope), (int)600000, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        return wf;
    }

    protected static void WriteExecutionID(String path, String ExecutionID, String endpoint, String Scope) throws IOException {
        FileWriter w = new FileWriter(new File(path));
        w.write(endpoint);
        w.write("\n");
        w.write(ExecutionID);
        w.write("\n");
        w.write(Scope);
        w.write("\n");
        w.flush();
        w.close();
    }

    protected static String WritePlan(String plan, boolean isCompleted) throws IOException {
        File tmp = null;
        tmp = isCompleted ? File.createTempFile(UUID.randomUUID().toString(), ".final.plan.xml") : File.createTempFile(UUID.randomUUID().toString(), ".initial.plan.xml");
        FileWriter w = new FileWriter(tmp);
        w.write(plan);
        w.flush();
        w.close();
        return tmp.toString();
    }

    public static String GetWorkflowEngineURL(String path) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(new File(path)));
        String url = r.readLine();
        r.close();
        return url;
    }

    public static String GetWorkflowEngineExecutionID(String path) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(new File(path)));
        r.readLine();
        String id = r.readLine();
        r.close();
        return id;
    }

    public static String GetWorkflowEngineExecutionScope(String path) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(new File(path)));
        r.readLine();
        r.readLine();
        String id = r.readLine();
        r.close();
        return id;
    }

    public static String getStringDate() {
        SimpleDateFormat dateFormatGmt = new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss");
        dateFormatGmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            return dateFormatGmt.parse(dateFormatGmt.format(new Date())).toString();
        }
        catch (ParseException e) {
            return new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy").format(Calendar.getInstance().getTime()).toString();
        }
    }

    public static boolean fileExists(String filename) {
        try {
            File f = new File(filename);
            return f.exists();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String findOcropus() {
        try {
            File folder = new File(System.getenv("$GLOBUS_LOCATION") + "/Ocropus");
            File[] arr$ = folder.listFiles();
            int len$ = arr$.length;
            int i$ = 0;
            if (i$ < len$) {
                File f = arr$[i$];
                if (f.getName().matches("*cropus*.tar.gz.gz")) {
                    // empty if block
                }
                return f.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void main() {
        System.out.println(ServiceUtils.findOcropus());
    }
}

