/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.ocrservice.utils;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.smsplugin.util.GCubeCollections;
import org.gcube.contentmanagement.contentmanager.stubs.CollectionReference;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentWriter;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.DocumentProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.Property;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.PropertyTypes;
import org.gcube.contentmanagement.gcubedocumentlibrary.util.Collection;
import org.gcube.contentmanagement.gcubedocumentlibrary.util.Collections;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;

public class CMUtils {
    private static GCUBELog logger = new GCUBELog(CMUtils.class);
    public static String ocrOcropusCollectionPrefix = "ocrOcropusCollection_";

    public static String getOCROcropusCollection(GCUBEScope scope) {
        String name = ocrOcropusCollectionPrefix + scope.getName();
        try {
            List collections = Collections.findByName((GCUBEScope)scope, (String)name);
            if (collections != null && collections.size() > 0) {
                if (collections.size() > 1) {
                    logger.warn((Object)"More than one OCROcropusCollections detected with the same name. The first one will be used");
                }
                logger.info((Object)("Returning the ID of the OCROcropusCollection with name --> " + name + ". The ID is --> " + ((Collection)collections.get(0)).getId()));
                return ((Collection)collections.get(0)).getId();
            }
        }
        catch (Exception e) {
            logger.error((Object)("An exception was thrown while trying to find OCROcropusCollection with name: " + name));
            return null;
        }
        return null;
    }

    public static CollectionReference createOCROcropusCollection(GCUBEScope scope) {
        List collectionReferences;
        String collectionName = ocrOcropusCollectionPrefix + scope.getName();
        String description = "This collection was created by OCR Service to hold the ocropus file that is needed to be sent to the execution node when a new job is submitted";
        CollectionReference colRef = null;
        boolean propagateRequest = true;
        boolean readable = true;
        boolean writable = true;
        try {
            collectionReferences = GCubeCollections.createGCubeCollection((boolean)propagateRequest, (String)collectionName, (String)description, (boolean)false, (boolean)readable, (boolean)writable, (GCUBEScope)scope, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        }
        catch (Exception e) {
            logger.error((Object)"An exception was thrown while trying to create a collection.", (Throwable)e);
            return colRef;
        }
        if (collectionReferences != null) {
            logger.debug((Object)("Collection with name: " + collectionName + " has just been created. Only one reference should have been returned"));
            if (collectionReferences.size() > 1) {
                logger.debug((Object)"More than one references have been returned. The first one will be used");
            }
            colRef = (CollectionReference)collectionReferences.get(0);
            logger.debug((Object)("The ID of the created collection is " + colRef.getCollectionID()));
        }
        return colRef;
    }

    public static String createOCRDocument(DocumentWriter writer, String documentName, InputStream bytestream, GCUBEScope scope) throws GCUBEFault {
        try {
            logger.debug((Object)"Trying to create a new document in CMS.....");
            logger.debug((Object)("NAME --> " + documentName));
            GCubeDocument document = new GCubeDocument();
            document.setName(documentName);
            document.setBytestream(bytestream);
            String documentId = writer.add(document);
            logger.info((Object)("A new document has been created with name --> " + documentName + " and ID --> " + documentId));
            return documentId;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to create a new document to the collection with ID--> " + writer.collectionID() + " with name " + documentName), (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to create a new document to the collection with ID--> " + writer.collectionID() + " with name " + documentName});
        }
    }

    public static DocumentReader getDocumentReaderByID(String collectionID, GCUBEScope scope) throws Exception {
        try {
            return new DocumentReader(collectionID, scope);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static DocumentReader getDocumentReaderByCollectionReference(CollectionReference colRef, GCUBEScope scope) throws Exception {
        try {
            return new DocumentReader(colRef, scope);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static DocumentWriter getDocumentWriterByID(String collectionID, GCUBEScope scope) throws Exception {
        try {
            return new DocumentWriter(collectionID, scope);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static DocumentWriter getDocumentWriterByCollectionReference(CollectionReference colRef, GCUBEScope scope) throws Exception {
        try {
            return new DocumentWriter(colRef, scope);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static String deleteAllOCROcropusCollections(GCUBEScope scope) {
        String name = ocrOcropusCollectionPrefix + scope.getName();
        try {
            List collections = Collections.findByName((GCUBEScope)scope, (String)name);
            if (collections != null) {
                logger.debug((Object)("Going to delete " + collections.size() + " ocrOcropus collections"));
                for (int i = 0; i < collections.size(); ++i) {
                    String collectionId = ((Collection)collections.get(i)).getId();
                    logger.debug((Object)("Deleting ocropusCollection with id='" + collectionId + "'"));
                    GCubeCollections.deleteGCubeCollection((String)collectionId, (boolean)true, (GCUBEScope)scope, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("An exception was thrown while trying to find OCROcropusCollection with name: " + name));
            return null;
        }
        return null;
    }

    public static String findDocumentCMReferenceFromName(DocumentReader reader, String name, GCUBEScope scope) throws GCUBEFault {
        GCubeDocument document = null;
        try {
            DocumentProjection projection = (DocumentProjection)((DocumentProjection)Projections.document().with((Property)Projections.NAME, (Property[])new PropertyTypes.DocumentProperty[0])).withValue((Property)Projections.NAME, (Object)name);
            RemoteIterator documentIterator = reader.get((Projection)projection);
            if (!documentIterator.hasNext()) {
                logger.debug((Object)("There are no documents with the name --> " + name));
                return null;
            }
            logger.debug((Object)"There is at least one document in collection");
            document = (GCubeDocument)documentIterator.next();
            logger.debug((Object)("Found document with URI: " + document.uri().toString() + " and name: " + name));
            return document.uri().toString();
        }
        catch (Exception e) {
            logger.error((Object)("Failed to find the uri of the document with name: " + name + ". An exception was thrown"), (Throwable)e);
            throw new GCUBEUnrecoverableFault(e, new String[]{"Failed to find the uri of the document with name: " + name});
        }
    }

    public static void printCollectionDocs(String collectionId, GCUBEScope scope) {
        DocumentProjection dp = Projections.document();
        try {
            logger.debug((Object)("Getting documents of collection: " + collectionId));
            DocumentReader cmReader = new DocumentReader(collectionId, scope);
            RemoteIterator documentIterator = cmReader.get((Projection)dp);
            int i = 0;
            logger.debug((Object)"Collection documents:");
            while (documentIterator.hasNext()) {
                GCubeDocument document = (GCubeDocument)documentIterator.next();
                String uri = document.uri().toURL().toString();
                String id = document.id();
                logger.debug((Object)("document uri: " + uri + " id: " + id));
                if (++i <= 5) continue;
                logger.debug((Object)("There are more than " + i + " documents."));
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception occured" + e));
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        GCUBEScope scope = GCUBEScope.getScope((String)args[0]);
        logger.debug((Object)"Creating OCRFilesCollection now");
        CollectionReference ocrFilesCollectionReference = CMUtils.createOCROcropusCollection(scope);
        logger.debug((Object)("Created OCRFilesCollection now with collectionId: " + ocrFilesCollectionReference.getCollectionID()));
        DocumentWriter writer = CMUtils.getDocumentWriterByCollectionReference(ocrFilesCollectionReference, scope);
        logger.debug((Object)("Reading 2 files of OCR under " + System.getenv("GLOBUS_LOCATION")));
        FileInputStream ocropusFile = new FileInputStream(System.getenv("GLOBUS_LOCATION") + "/ocrjob.sh");
        logger.debug((Object)"Creating ocropus document ");
        CMUtils.createOCRDocument(writer, "ocropus-0.3.1-i386-JK.tar.gz.gz", ocropusFile, scope);
        CMUtils.printCollectionDocs(ocrFilesCollectionReference.getCollectionID(), scope);
    }
}

