/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.ocrservice.tests;

import java.io.FileInputStream;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.contentmanagement.contentmanager.stubs.CollectionReference;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentWriter;
import org.gcube.execution.ocrservice.utils.CMUtils;

public class UploadOcropusClient {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage:    java org.gcube.execution.ocrservice.tests.UploadOcropusClient <GCUBE scope>   <path of ocropus.tar.gz");
            System.out.println("Example:  java org.gcube.execution.ocrservice.tests.UploadOcropusClient /gcube/devNext $GLOBUS_LOCATION/Ocropus/Ocropus-1.0.0.tar.gz");
            System.exit(1);
        }
        try {
            System.out.println("Scope:                  " + args[0]);
            System.out.println("Ocropus file to upload: " + args[1]);
            System.out.println("");
            GCUBEScope scope = GCUBEScope.getScope((String)args[0]);
            System.out.println("Going to delete all collections with name='" + CMUtils.ocrOcropusCollectionPrefix + "_" + args[0]);
            CMUtils.deleteAllOCROcropusCollections(scope);
            CollectionReference ocropusCollectionReference = null;
            System.out.println("We will create ocrOcropusCollection now in scope " + scope);
            ocropusCollectionReference = CMUtils.createOCROcropusCollection(scope);
            if (ocropusCollectionReference == null) {
                System.out.println("Could not create collection.");
                System.exit(1);
            }
            System.out.println("Created ocropus collection with id: " + ocropusCollectionReference.getCollectionID() + " scope:" + scope);
            DocumentWriter writer = CMUtils.getDocumentWriterByCollectionReference(ocropusCollectionReference, scope);
            System.out.println("Reading 1 file of ocropus.tar.gz.gz" + args[1]);
            FileInputStream ocropusFile = new FileInputStream(args[1]);
            System.out.println("Creating ocropus document ");
            String cmRef = CMUtils.createOCRDocument(writer, "ocropus.tar.gz.gz", ocropusFile, scope);
            System.out.println("Stored in CMS with ref: cms://" + ocropusCollectionReference.getCollectionID() + "/" + cmRef);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

