/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.ocrservice.tests;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.rmi.Remote;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.types.VOID;
import org.gcube.execution.ocrservice.stubs.AccessInfoFTP;
import org.gcube.execution.ocrservice.stubs.InputResource;
import org.gcube.execution.ocrservice.stubs.LanguageEnumType;
import org.gcube.execution.ocrservice.stubs.OCRServiceFactoryPortType;
import org.gcube.execution.ocrservice.stubs.OCRServicePortType;
import org.gcube.execution.ocrservice.stubs.StatusResponseType;
import org.gcube.execution.ocrservice.stubs.Submit;
import org.gcube.execution.ocrservice.stubs.SubmitBulk;
import org.gcube.execution.ocrservice.stubs.service.OCRServiceAddressingLocator;
import org.gcube.execution.ocrservice.stubs.service.OCRServiceFactoryServiceAddressingLocator;
import org.oasis.wsrf.lifetime.Destroy;

public class TestOCRService {
    private static boolean destroyWSResources = false;
    private static long pollPeriodMilliSeconds = 10000L;
    private static SubmissionType subType = SubmissionType.jdlAdaptor;
    private static String proxyPath = "/tmp/proxy";
    private static boolean isBulk = false;
    private static String owner = "TestOCRService_Client";
    private static boolean chokePDFOutput = false;
    private static boolean storeFTP = false;
    private static String ftpUsername = "\u00adrenats";
    private static String ftpPassword = "123456";
    private static String ftpPort = "-1";
    private static String ftpLocation = "ftp://mpagasas.di.uoa.gr/b4ba3a10-b47d-11e0-9e5d-fda94ff03826";

    public static void main(String[] args) {
        String usage = "Usage: \tjava org.gcube.execution.ocrservice.tests.TestOCRService <ocr factory address> <gcube scope> <resource key> <resource access> <value> <language> <optional job name in >=0 words >\n\nExample 1:\n\tjava org.gcube.execution.ocrservice.tests.TestOCRService http://jazzman.di.uoa.gr:8080/wsrf/services/gcube/execution/ocrservice/OCRServiceFactory /d4science.research-infrastructures.eu/INSPIRE NobelAnnounce.pdf Reference http://dl.dropbox.com/u/19792897/NobelAnnounce.pdf eng OCR on NobelAnnouce 2 page document \n\nExample 2:\n\tjava org.gcube.execution.ocrservice.tests.TestOCRService http://jazzman.di.uoa.gr:8080/wsrf/services/gcube/execution/ocrservice/OCRServiceFactory /d4science.research-infrastructures.eu/INSPIRE NobelAnnounce.pdf CMSReference cms://ab2f4d80-87b1-11e0-9fbc-f078a392f5cc/b1beaf60-87b1-11e0-9fbc-f078a392f5cc eng OCR on NobelAnnouce 2 page document \n\nExample 3a:\n\tjava org.gcube.execution.ocrservice.tests.TestOCRService http://jazzman.di.uoa.gr:8080/wsrf/services/gcube/execution/ocrservice/OCRServiceFactory /d4science.research-infrastructures.eu/INSPIRE NobelAnnounce.pdf InMessageString /home/stefanos/NobelAnnounce.pdf eng OCR on NobelAnnouce 2 page document \n\nExample 3b:\n\tjava org.gcube.execution.ocrservice.tests.TestOCRService http://jazzman.di.uoa.gr:8080/wsrf/services/gcube/execution/ocrservice/OCRServiceFactory /d4science.research-infrastructures.eu/INSPIRE NobelAnnounce.pdf InMessageBytes /home/stefanos/NobelAnnounce.pdf eng OCR on NobelAnnouce 2 page document \n";
        try {
            if (args.length < 6) {
                System.err.println("Usage: \tjava org.gcube.execution.ocrservice.tests.TestOCRService <ocr factory address> <gcube scope> <resource key> <resource access> <value> <language> <optional job name in >=0 words >\n\nExample 1:\n\tjava org.gcube.execution.ocrservice.tests.TestOCRService http://jazzman.di.uoa.gr:8080/wsrf/services/gcube/execution/ocrservice/OCRServiceFactory /d4science.research-infrastructures.eu/INSPIRE NobelAnnounce.pdf Reference http://dl.dropbox.com/u/19792897/NobelAnnounce.pdf eng OCR on NobelAnnouce 2 page document \n\nExample 2:\n\tjava org.gcube.execution.ocrservice.tests.TestOCRService http://jazzman.di.uoa.gr:8080/wsrf/services/gcube/execution/ocrservice/OCRServiceFactory /d4science.research-infrastructures.eu/INSPIRE NobelAnnounce.pdf CMSReference cms://ab2f4d80-87b1-11e0-9fbc-f078a392f5cc/b1beaf60-87b1-11e0-9fbc-f078a392f5cc eng OCR on NobelAnnouce 2 page document \n\nExample 3a:\n\tjava org.gcube.execution.ocrservice.tests.TestOCRService http://jazzman.di.uoa.gr:8080/wsrf/services/gcube/execution/ocrservice/OCRServiceFactory /d4science.research-infrastructures.eu/INSPIRE NobelAnnounce.pdf InMessageString /home/stefanos/NobelAnnounce.pdf eng OCR on NobelAnnouce 2 page document \n\nExample 3b:\n\tjava org.gcube.execution.ocrservice.tests.TestOCRService http://jazzman.di.uoa.gr:8080/wsrf/services/gcube/execution/ocrservice/OCRServiceFactory /d4science.research-infrastructures.eu/INSPIRE NobelAnnounce.pdf InMessageBytes /home/stefanos/NobelAnnounce.pdf eng OCR on NobelAnnouce 2 page document \n");
                System.exit(1);
            }
            String jobName = "";
            for (int i = 6; i < args.length; ++i) {
                jobName = jobName + args[i] + " ";
            }
            System.out.println("");
            System.out.println("TestOCRService client started with arguments:");
            System.out.println("OCR Factory Service: " + args[0]);
            System.out.println("Scope:               " + args[1]);
            System.out.println("Key:                 " + args[2]);
            System.out.println("Access:              " + args[3]);
            System.out.println("Value:               " + args[4]);
            System.out.println("Language:            " + args[5]);
            System.out.println("JobName:             " + jobName);
            System.out.println("isBulk:              " + isBulk);
            System.out.println("Adaptor:             " + subType.toString());
            System.out.println("Choke pdf output:    " + chokePDFOutput);
            System.out.println("Store in ftp:        " + storeFTP);
            EndpointReferenceType factoryEPR = new EndpointReferenceType((URI)new AttributedURI(args[0]));
            System.out.println("\nGetting factory stub...");
            OCRServiceFactoryPortType stub1 = new OCRServiceFactoryServiceAddressingLocator().getOCRServiceFactoryPortTypePort(factoryEPR);
            stub1 = (OCRServiceFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)stub1, (GCUBEScope)GCUBEScope.getScope((String)args[1].trim()), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
            System.out.println("Preparing input of OCR job...");
            Submit sub = new Submit();
            sub.setLanguage(TestOCRService.getLanguageFromString(args[5]));
            AccessInfoFTP ftpAccess = new AccessInfoFTP();
            ftpAccess.setUserName("renats");
            ftpAccess.setPassword(ftpPassword.trim());
            ftpAccess.setLocation(ftpLocation.trim());
            ftpAccess.setPort(ftpPort);
            sub.setFtpAccess(ftpAccess);
            InputResource input = new InputResource();
            if (args[3].equals("Reference")) {
                input.setResourceKey(args[2]);
                input.setResourceAccess("Reference");
                input.setResourceReference(args[4]);
            } else if (args[3].equals("CMSReference")) {
                input.setResourceKey(args[2]);
                input.setResourceAccess("CMSReference");
                input.setResourceReference(args[4]);
            } else if (args[3].equals("InMessageString")) {
                input.setResourceKey(args[2]);
                input.setResourceAccess("InMessageString");
                input.setInMessageStringPayload(TestOCRService.GetStringFilePayload(args[4]));
            } else if (args[3].equals("InMessageBytes")) {
                input.setResourceKey(args[2]);
                input.setResourceAccess("InMessageBytes");
                input.setInMessageBytePayload(TestOCRService.GetByteFilePayload(args[4]));
            } else {
                System.err.println("Usage: \tjava org.gcube.execution.ocrservice.tests.TestOCRService <ocr factory address> <gcube scope> <resource key> <resource access> <value> <language> <optional job name in >=0 words >\n\nExample 1:\n\tjava org.gcube.execution.ocrservice.tests.TestOCRService http://jazzman.di.uoa.gr:8080/wsrf/services/gcube/execution/ocrservice/OCRServiceFactory /d4science.research-infrastructures.eu/INSPIRE NobelAnnounce.pdf Reference http://dl.dropbox.com/u/19792897/NobelAnnounce.pdf eng OCR on NobelAnnouce 2 page document \n\nExample 2:\n\tjava org.gcube.execution.ocrservice.tests.TestOCRService http://jazzman.di.uoa.gr:8080/wsrf/services/gcube/execution/ocrservice/OCRServiceFactory /d4science.research-infrastructures.eu/INSPIRE NobelAnnounce.pdf CMSReference cms://ab2f4d80-87b1-11e0-9fbc-f078a392f5cc/b1beaf60-87b1-11e0-9fbc-f078a392f5cc eng OCR on NobelAnnouce 2 page document \n\nExample 3a:\n\tjava org.gcube.execution.ocrservice.tests.TestOCRService http://jazzman.di.uoa.gr:8080/wsrf/services/gcube/execution/ocrservice/OCRServiceFactory /d4science.research-infrastructures.eu/INSPIRE NobelAnnounce.pdf InMessageString /home/stefanos/NobelAnnounce.pdf eng OCR on NobelAnnouce 2 page document \n\nExample 3b:\n\tjava org.gcube.execution.ocrservice.tests.TestOCRService http://jazzman.di.uoa.gr:8080/wsrf/services/gcube/execution/ocrservice/OCRServiceFactory /d4science.research-infrastructures.eu/INSPIRE NobelAnnounce.pdf InMessageBytes /home/stefanos/NobelAnnounce.pdf eng OCR on NobelAnnouce 2 page document \n");
                System.exit(1);
            }
            if (subType == SubmissionType.gridAdaptor) {
                try {
                    sub.setGridProxy(TestOCRService.GetByteFilePayload(proxyPath));
                }
                catch (Exception ex) {
                    throw new Exception("To submit ocr job with grid adaptor, put proxy in " + proxyPath);
                }
            }
            sub.setOwner(owner);
            sub.setJobName(jobName);
            sub.setInputResource(input);
            sub.setChokePDFOutput(chokePDFOutput);
            sub.setStoreFTP(storeFTP);
            System.out.println("Submitting OCR job...");
            EndpointReferenceType resourceEpr = null;
            resourceEpr = !isBulk ? stub1.submit(sub).getEndpointReference() : stub1.submitBulk(TestOCRService.replaceStubsToBulk(sub)).getEndpointReference();
            OCRServicePortType stub2 = new OCRServiceAddressingLocator().getOCRServicePortTypePort(resourceEpr);
            stub2 = (OCRServicePortType)GCUBERemotePortTypeContext.getProxy((Remote)stub2, (GCUBEScope)GCUBEScope.getScope((String)args[1]), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
            System.out.println("OCR job was submitted");
            System.out.println("Calling status() until completion\n");
            StatusResponseType status = null;
            do {
                status = stub2.status(new VOID());
                System.out.println("Description:    " + status.getStatusDescription());
                System.out.println("Last poll date: " + status.getLastPollDate());
                System.out.println("");
                Thread.sleep(pollPeriodMilliSeconds);
            } while (!status.isCompleted());
            if (destroyWSResources) {
                stub2.destroy(new Destroy());
            }
            System.out.println("");
            System.out.println("OCR Job has finished:");
            System.out.println("-----------------------------------------------------");
            System.out.println("Job Name:        " + status.getJobName());
            System.out.println("Description:     " + status.getStatusDescription());
            System.out.println("Submited:        " + status.getSubmitDate());
            System.out.println("Last Poll:       " + status.getLastPollDate());
            System.out.println("Error:           " + status.getError());
            System.out.println("ErrorDetails:    " + status.getErrorDetails());
            System.out.println("hocr   ssid: \t " + status.getHocrOutputSSID());
            System.out.println("pdf    ssid: \t " + status.getPdfOutputSSID());
            System.out.println("stdout ssid: \t " + status.getJoboutSSID());
            System.out.println("stderr ssid: \t " + status.getJoberrSSID());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String GetStringFilePayload(String path) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(new File(path)));
        StringBuilder buf = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            buf.append(line);
            buf.append("\n");
        }
        reader.close();
        return buf.toString();
    }

    public static byte[] GetByteFilePayload(String path) throws IOException {
        int read;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        BufferedInputStream bin = new BufferedInputStream(new FileInputStream(new File(path)));
        byte[] b = new byte[4096];
        while ((read = bin.read(b)) >= 0) {
            bout.write(b, 0, read);
        }
        bin.close();
        bout.flush();
        bout.close();
        return bout.toByteArray();
    }

    private static LanguageEnumType getLanguageFromString(String language) throws Exception {
        if (language == null) {
            return LanguageEnumType.eng;
        }
        if (language.trim().equals("eng")) {
            return LanguageEnumType.eng;
        }
        if (language.trim().equals("deu")) {
            return LanguageEnumType.deu;
        }
        if (language.trim().equals("fra")) {
            return LanguageEnumType.fra;
        }
        if (language.trim().equals("ita")) {
            return LanguageEnumType.ita;
        }
        if (language.trim().equals("nld")) {
            return LanguageEnumType.nld;
        }
        if (language.trim().equals("spa")) {
            return LanguageEnumType.spa;
        }
        throw new Exception("Invalid language '" + language + "' (valid values are: eng,deu,fra,ita,nld,spa)");
    }

    private static SubmitBulk replaceStubsToBulk(Submit sub) {
        SubmitBulk sub2 = new SubmitBulk();
        sub2.setGridProxy(sub.getGridProxy());
        sub2.setInputResource(sub.getInputResource());
        sub2.setJobName(sub.getJobName());
        sub2.setLanguage(sub.getLanguage());
        sub2.setOwner(sub.getOwner());
        return sub2;
    }

    private static enum SubmissionType {
        jdlAdaptor,
        gridAdaptor;

    }
}

