/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.ocrservice;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.execution.ocrservice.OCRServiceResource;
import org.gcube.execution.ocrservice.OCRServiceResourceHome;
import org.gcube.execution.ocrservice.StatefulContext;
import org.gcube.execution.ocrservice.utils.ServiceUtils;
import org.gcube.execution.workflowengine.service.stubs.JobOutput;
import org.gcube.execution.workflowengine.service.stubs.StatusReport;
import org.gcube.execution.workflowengine.service.stubs.StatusRequest;
import org.gcube.execution.workflowengine.service.stubs.WorkflowEngineServicePortType;
import org.globus.wsrf.ResourceKey;

public class OCRStatusPoller
implements Runnable {
    private static GCUBELog logger = new GCUBELog(OCRStatusPoller.class);
    private static long period = 25000L;

    @Override
    public void run() {
        block6: while (true) {
            try {
                Thread.sleep(period);
            }
            catch (InterruptedException e1) {
                logger.error((Object)"Error while ocr poller was preparing to sleep", (Throwable)e1);
            }
            logger.info((Object)"poller is going to retrieve all OCRService resources and poll all ocr jobs");
            OCRServiceResourceHome wsHome = (OCRServiceResourceHome)StatefulContext.getPortTypeContext().getWSHome();
            Collection resourceKeys = StatefulContext.getPortTypeContext().getWSHome().getIdentifiers();
            logger.info((Object)("OCR job poller collected " + resourceKeys.size() + " resource ids"));
            HashSet resourceKeysSet = new HashSet(resourceKeys);
            Iterator i$ = resourceKeysSet.iterator();
            while (true) {
                GCUBEWSResource resource;
                block9: {
                    if (!i$.hasNext()) continue block6;
                    GCUBEWSResourceKey resourceKey = (GCUBEWSResourceKey)i$.next();
                    try {
                        resource = wsHome.find((ResourceKey)resourceKey);
                        if (!(resource instanceof OCRServiceResource)) {
                        }
                        break block9;
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Failed to retrieve WS resource " + resourceKey + ". Skipping."));
                    }
                    continue;
                }
                try {
                    this.pollStatusOne((OCRServiceResource)resource);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"Error while polling status of OCR Job, we are going to stop polling the status of the job ", (Throwable)e);
                    ((OCRServiceResource)resource).setCompleted(true);
                    String error = ((OCRServiceResource)resource).getError() == null || ((OCRServiceResource)resource).getError().trim().equals("") ? "" : ((OCRServiceResource)resource).getError() + "\n";
                    String errorDetails = ((OCRServiceResource)resource).getErrorDetails() == null || ((OCRServiceResource)resource).getErrorDetails().trim().equals("") ? "" : ((OCRServiceResource)resource).getErrorDetails() + "\n";
                    ((OCRServiceResource)resource).setError(error + " Stopped polling status of job because of exception");
                    ((OCRServiceResource)resource).setErrorDetails(errorDetails + " Exception while polling: " + e.getMessage());
                    continue;
                }
                break;
            }
            break;
        }
    }

    private void pollStatusOne(OCRServiceResource resource) throws Exception {
        WorkflowEngineServicePortType wf;
        if (resource.getCompleted()) {
            return;
        }
        try {
            wf = ServiceUtils.GetWorkflowEnginePortType(resource.getSubScope(), resource.getEngineUrl());
        }
        catch (Exception e) {
            logger.error((Object)"Error while getting WorkflowEnginePortType to poll status of OCR job", (Throwable)e);
            throw e;
        }
        StatusRequest req = new StatusRequest();
        req.setExecutionID(resource.getExecutionId());
        req.setIncludePlan(Boolean.valueOf(false));
        StatusReport rep = wf.executionStatus(req);
        if (rep.isIsCompleted()) {
            String ocrType;
            String string = ocrType = resource.isBulk() ? "bulk" : "single";
            if (rep.getError() != null && !rep.getError().equals("") || rep.getErrorDetails() != null && !rep.getErrorDetails().equals("")) {
                resource.setStatusDescription("OCR " + ocrType + " job finished with some error");
            } else {
                resource.setStatusDescription("OCR " + ocrType + " job finished with no reported errors");
            }
            if (rep.getOutput() != null) {
                for (JobOutput jo : rep.getOutput()) {
                    logger.debug((Object)("---> JobOutput  Key:" + jo.getKey() + " subKey:" + jo.getSubKey() + "ssid:" + jo.getStorageSystemID()));
                    if (jo.getKey() == null || jo.getKey().trim().length() <= 0) continue;
                    if (jo.getKey().equals("job.out")) {
                        resource.setJoboutSSID(jo.getStorageSystemID());
                        continue;
                    }
                    if (jo.getKey().equals("job.err")) {
                        resource.setJoberrSSID(jo.getStorageSystemID());
                        continue;
                    }
                    if (!resource.isBulk()) {
                        if (jo.getKey().endsWith(".hocr")) {
                            resource.setHocrOutputSSID(jo.getStorageSystemID());
                            continue;
                        }
                        if (!jo.getKey().endsWith(".pdf")) continue;
                        resource.setPdfOutputSSID(jo.getStorageSystemID());
                        continue;
                    }
                    if (jo.getKey().trim().equals("hocrs.zip")) {
                        resource.setHocrOutputSSID(jo.getStorageSystemID());
                        continue;
                    }
                    if (!jo.getKey().trim().equals("pdfs.zip")) continue;
                    resource.setPdfOutputSSID(jo.getStorageSystemID());
                }
            }
            resource.setLastPollDate(ServiceUtils.getStringDate());
            resource.setCompleted(true);
            resource.setError(rep.getError());
            resource.setErrorDetails(rep.getErrorDetails());
            resource.store();
        } else {
            resource.setLastPollDate(ServiceUtils.getStringDate());
            resource.setCompleted(false);
            resource.store();
        }
    }
}

