/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.ocrservice;

import gr.uoa.di.madgik.environment.hint.EnvHint;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.hint.NamedEnvHint;
import gr.uoa.di.madgik.is.InformationSystem;
import java.util.ArrayList;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSHome;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.execution.ocrservice.OCRServiceResource;
import org.gcube.execution.ocrservice.ServiceContext;
import org.gcube.execution.ocrservice.StatefulContext;
import org.gcube.execution.ocrservice.stubs.LanguageEnumType;
import org.gcube.execution.ocrservice.stubs.Submit;
import org.gcube.execution.ocrservice.stubs.SubmitBulk;
import org.gcube.execution.ocrservice.stubs.SubmitResponse;
import org.gcube.execution.ocrservice.utils.CMUtils;
import org.gcube.execution.ocrservice.utils.ServiceUtils;
import org.gcube.execution.workflowengine.service.stubs.AccessInfo;
import org.gcube.execution.workflowengine.service.stubs.GRIDConfig;
import org.gcube.execution.workflowengine.service.stubs.GRIDParams;
import org.gcube.execution.workflowengine.service.stubs.GRIDResource;
import org.gcube.execution.workflowengine.service.stubs.JDLConfig;
import org.gcube.execution.workflowengine.service.stubs.JDLParams;
import org.gcube.execution.workflowengine.service.stubs.JDLResource;
import org.gcube.execution.workflowengine.service.stubs.WorkflowEngineServicePortType;

public class OCRServiceFactory
extends GCUBEPortType {
    private static GCUBELog logger = new GCUBELog(OCRServiceFactory.class);
    protected static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();

    public OCRServiceFactory() {
        logger.debug((Object)"OCRServiceFactory() was called!");
    }

    protected void onReady() throws Exception {
        super.onReady();
    }

    private String getOcropusCMReference() throws Exception {
        GCUBEScope scope = ServiceContext.getContext().getScope();
        logger.debug((Object)("Searching for ocrOcropusCollection in scope:" + scope));
        String ocrOcropusCollectionId = CMUtils.getOCROcropusCollection(scope);
        if (ocrOcropusCollectionId == null) {
            logger.debug((Object)("Did not find ocrOcropusCollection in scope " + scope + ", we can't perform OCR "));
            return null;
        }
        logger.debug((Object)("Found OCRCollection id: " + ocrOcropusCollectionId + " scope:" + scope));
        logger.debug((Object)("Getting reader on ocropus document by collectionId:" + ocrOcropusCollectionId + " scope:" + scope));
        DocumentReader reader = null;
        reader = CMUtils.getDocumentReaderByID(ocrOcropusCollectionId, scope);
        logger.debug((Object)"Searching for document with name \"ocropus.tar.gz.gz\"");
        String ocropusCMReference = CMUtils.findDocumentCMReferenceFromName(reader, "ocropus.tar.gz.gz", scope);
        return ocropusCMReference;
    }

    public SubmitResponse submit(Submit request) throws Exception {
        logger.debug((Object)"submit() was called");
        if (request.getGridProxy() == null || request.getGridProxy().length == 0) {
            return this.submitJDL(request);
        }
        return this.submitGrid(request);
    }

    public SubmitResponse submitBulk(SubmitBulk request) throws Exception {
        logger.debug((Object)"submitBulk() was called");
        if (request.getGridProxy() == null || request.getGridProxy().length == 0) {
            return this.submitJDLBulk(request);
        }
        return this.submitGridBulk(request);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SubmitResponse submitJDL(Submit request) throws Exception {
        logger.debug((Object)("submitJDL() was  called with inputResource (username='" + request.getFtpAccess().getUserName().trim() + "'"));
        AccessInfo ftpAccess = new AccessInfo();
        String outAccess = "CMSReference";
        String outReference = "";
        if (request.isStoreFTP()) {
            ftpAccess.setPassword(request.getFtpAccess().getPassword().trim());
            if (request.getFtpAccess().getPort() != null && !request.getFtpAccess().getPort().equals("")) {
                ftpAccess.setPort(request.getFtpAccess().getPort());
            } else {
                ftpAccess.setPort("-1");
            }
            ftpAccess.setUserId(request.getFtpAccess().getUserName().trim());
            outAccess = "Reference";
            outReference = request.getFtpAccess().getLocation();
            logger.debug((Object)("We set ftp credentials: username:" + request.getFtpAccess().getUserName() + " password:" + ftpAccess.getPassword() + " port:" + request.getFtpAccess().getPort() + " location:" + request.getFtpAccess().getLocation()));
        }
        if (request.getJobName() == null) {
            request.setJobName("");
        }
        if (request.getLanguage() == null) {
            request.setLanguage(LanguageEnumType.eng);
        }
        if (request.isStoreFTP() && (request.getFtpAccess() == null || request.getFtpAccess().getUserName() == null || request.getFtpAccess().getPassword() == null)) {
            throw new Exception("You asked for ftp storage but OCR service did not give ftp access credentials");
        }
        JDLParams params = new JDLParams();
        JDLConfig conf = new JDLConfig();
        conf.setChokePerformanceEvents(true);
        conf.setChokeProgressEvents(true);
        params.setConfig(conf);
        JDLResource r = null;
        ArrayList<JDLResource> resourceslst = null;
        String pdfOutputKey = "";
        if (!request.isChokePDFOutput()) {
            pdfOutputKey = "\"@\" ,";
        }
        EnvHintCollection hints = new EnvHintCollection();
        hints.AddHint(new NamedEnvHint("GCubeActionScope", new EnvHint(this.getServiceContext().getScope().toString())));
        if (InformationSystem.GetMatchingNode(null, (String)"other.GlueHostOperatingSystemName == ScientificSL && other.GlueHostOperatingSystemRelease == 5.0  && software.ocropus == true ", (EnvHintCollection)hints) != null) {
            logger.debug((Object)("A node with ocropus was found in scope " + this.getServiceContext().getScope().toString() + " and we will not send it"));
            String inputResourceKey = request.getInputResource().getResourceKey();
            String jdlDescription = "[\nType = \"Job\";\nJobType = \"Normal\";\nExecutable = \"ocrjob.sh\";\nStdOutput = \"job.out\";\nStdError = \"job.err\";\nVirtualOrganisation = \"d4science.research-infrastructures.eu\";\nInputSandbox = { \"@\" , \"ocrjob.sh\", \"ocr_options.job\"};\nOutputSandbox = {" + pdfOutputKey + " \"@.hocr\", \"job.out\", \"job.err\"};\n" + "Requirements = software.ocropus == true  ;\n" + "]\n";
            jdlDescription = jdlDescription.replaceAll("@", inputResourceKey);
            logger.debug((Object)("-------> Set jdl of OCR job: \n" + jdlDescription));
            params.setJdlDescription(jdlDescription);
            resourceslst = new ArrayList<JDLResource>();
            String ocrJobShFileName = System.getenv("GLOBUS_LOCATION") + "/ocrjob.sh";
            if (!ServiceUtils.fileExists(ocrJobShFileName)) {
                logger.error((Object)("ocrjob.sh script must exist under " + System.getenv("GLOBUS_LOCATION")));
                throw new Exception("ocrjob.sh script must exist under " + System.getenv("GLOBUS_LOCATION"));
            }
            r = new JDLResource();
            r.setResourceKey("ocrjob.sh");
            r.setResourceType("InData");
            r.setResourceAccess("InMessageString");
            r.setInMessageStringPayload(ServiceUtils.GetStringFilePayload(ocrJobShFileName));
            r.setResourceReference("");
            resourceslst.add(r);
        } else {
            logger.debug((Object)("A node with ocropus installed was not found in scope " + this.getServiceContext().getScope().toString() + " and we will try to find it in CMS"));
            String ocropusCMSReference = null;
            try {
                ocropusCMSReference = this.getOcropusCMReference();
            }
            catch (Exception ex) {
                logger.error((Object)("Could not find Collection with ocropus.tar.gz.gz in scope " + this.getServiceContext().getScope()), (Throwable)ex);
                throw new Exception("Could not find ocropus.tar.gz.gz in Content Management System in scope " + this.getServiceContext().getScope(), ex);
            }
            logger.debug((Object)("Found ocropus.tar.gz.gz with CMS Reference: " + ocropusCMSReference));
            if (ocropusCMSReference == null) {
                throw new Exception("We can't perform OCR, you must either set up a SL5 node with ocropus installed or use org.gcube.execution.ocrservice.tests.UploadOcropusClient client to upload ocropus.tar.gz.gz in Content Managegement System in scope " + ServiceContext.getContext().getScope().toString());
            }
            String inputResourceKey = request.getInputResource().getResourceKey();
            String jdlDescription = "[\nType = \"Job\";\nJobType = \"Normal\";\nExecutable = \"ocrjob.sh\";\nArguments = \"ocropus.tar.gz.gz\";\nStdOutput = \"job.out\";\nStdError = \"job.err\";\nVirtualOrganisation = \"d4science.research-infrastructures.eu\";\nInputSandbox = { \"@\" , \"ocrjob.sh\", \"ocr_options.job\"};\nInputSandbox = {" + pdfOutputKey + " \"@.hocr\", \"job.out\", \"job.err\"};\n" + "Requirements = other.GlueHostOperatingSystemName == ScientificSL && other.GlueHostOperatingSystemRelease == 5.0;\n" + "]\n";
            jdlDescription = jdlDescription.replaceAll("@", inputResourceKey);
            params.setJdlDescription(jdlDescription);
            resourceslst = new ArrayList();
            r = new JDLResource();
            r.setResourceKey("ocrjob.sh");
            r.setResourceType("InData");
            String ocrJobShFileName = System.getenv("GLOBUS_LOCATION") + "/ocrjob.sh";
            if (!ServiceUtils.fileExists(ocrJobShFileName)) {
                logger.error((Object)("ocrjob.sh script must exist under " + System.getenv("GLOBUS_LOCATION")));
                throw new Exception("ocrjob.sh script must exist under " + System.getenv("GLOBUS_LOCATION"));
            }
            r.setResourceAccess("InMessageBytes");
            r.setInMessageBytePayload(ServiceUtils.GetByteFilePayload(ocrJobShFileName));
            resourceslst.add(r);
            r = new JDLResource();
            r.setResourceKey("ocropus.tar.gz.gz");
            r.setResourceType("InData");
            r.setResourceAccess("CMSReference");
            r.setResourceReference(ocropusCMSReference);
            resourceslst.add(r);
        }
        r = new JDLResource();
        String jobFile = "@lang = " + request.getLanguage().getValue() + "\n";
        jobFile = jobFile + "@ jobgroup = ocr \n";
        jobFile = jobFile + "@ grid = d4science_jdl \n";
        jobFile = jobFile + "@ scope = " + this.getServiceContext().getScope().toString() + "\n";
        jobFile = jobFile + "@ vo = d4science.research-infrastructures.eu \n";
        jobFile = jobFile + request.getInputResource().getResourceKey() + "\n";
        jobFile = jobFile + "> " + request.getInputResource().getResourceKey() + ".hocr " + "\n\n";
        r.setInMessageStringPayload(jobFile);
        r.setResourceKey("ocr_options.job");
        r.setResourceType("InData");
        r.setResourceAccess("InMessageString");
        resourceslst.add(r);
        r = new JDLResource();
        r.setInMessageBytePayload(request.getInputResource().getInMessageBytePayload());
        r.setInMessageStringPayload(request.getInputResource().getInMessageStringPayload());
        r.setResourceAccess(request.getInputResource().getResourceAccess());
        r.setResourceKey(request.getInputResource().getResourceKey());
        r.setResourceType("InData");
        r.setResourceReference(request.getInputResource().getResourceReference());
        resourceslst.add(r);
        if (!request.isChokePDFOutput()) {
            r = new JDLResource();
            r.setResourceType("OutData");
            r.setResourceAccess(outAccess);
            r.setResourceReference(outReference);
            r.setResourceKey(request.getInputResource().getResourceKey());
            r.setResourceAccessInfo(ftpAccess);
            resourceslst.add(r);
        }
        r = new JDLResource();
        r.setResourceType("OutData");
        r.setResourceAccess(outAccess);
        r.setResourceReference(outReference);
        r.setResourceKey(request.getInputResource().getResourceKey() + ".hocr");
        r.setResourceAccessInfo(ftpAccess);
        resourceslst.add(r);
        r = new JDLResource();
        r.setResourceType("OutData");
        r.setResourceAccess(outAccess);
        r.setResourceReference(outReference);
        r.setResourceKey("job.out");
        r.setResourceAccessInfo(ftpAccess);
        resourceslst.add(r);
        r = new JDLResource();
        r.setResourceType("OutData");
        r.setResourceAccess(outAccess);
        r.setResourceReference(outReference);
        r.setResourceKey("job.err");
        r.setResourceAccessInfo(ftpAccess);
        resourceslst.add(r);
        params.setJdlResources(resourceslst.toArray(new JDLResource[0]));
        int i = 0;
        while (true) {
            if (i >= params.getJdlResources().length) {
                String submitDate;
                logger.info((Object)"Locating Workflow Engine to submit OCR job");
                String Scope = ServiceContext.getContext().getScope().toString();
                String endpoint = ServiceUtils.GetWorkflowEngineEndpoint(Scope);
                logger.info((Object)("Selected Workflow Engine for OCR job: " + endpoint));
                logger.info((Object)("Submitting OCR job to Workflow Engine (scope:" + ServiceContext.getContext().getScope().toString() + " , endpoint:" + endpoint));
                WorkflowEngineServicePortType wf = ServiceUtils.GetWorkflowEnginePortType(Scope, endpoint);
                String executionId = wf.adaptJDL(params);
                logger.info((Object)("Submitted OCR job successfully  (ExecutionId: " + executionId + " Scope: " + Scope + " WFE Endpoint: " + endpoint + ")"));
                GCUBEStatefulPortTypeContext ptcxt = StatefulContext.getPortTypeContext();
                GCUBEWSHome home = ptcxt.getWSHome();
                GCUBEWSResourceKey key = ptcxt.makeKey(uuidGen.nextUUID());
                String jobName = request.getJobName();
                String statusDescription = "OCR single job is running in gcube node";
                String lastPollDate = submitDate = ServiceUtils.getStringDate();
                Boolean complete = false;
                Boolean bulk = false;
                String ssid = "";
                String owner = request.getOwner();
                logger.debug((Object)"OCR creating resource now");
                OCRServiceResource resource = (OCRServiceResource)home.create(key, new Object[]{jobName, statusDescription, submitDate, lastPollDate, complete, bulk, ssid, ssid, ssid, ssid, new String(""), new String(""), executionId, endpoint, owner, Scope});
                resource.store();
                logger.debug((Object)("OCR resource was created (submited: " + resource.getSubmitDate() + " , executionId:" + resource.getExecutionId() + resource.getEngineUrl() + ")"));
                SubmitResponse response = new SubmitResponse();
                response.setEndpointReference(resource.getEPR());
                return response;
            }
            logger.debug((Object)(" Resource " + i + " Key:" + params.getJdlResources()[i].getResourceKey() + "Type: " + params.getJdlResources()[i].getResourceType() + " Access:" + params.getJdlResources()[i].getResourceAccess() + " Reference:" + params.getJdlResources()[i].getResourceReference() + " String:" + params.getJdlResources()[i].getInMessageStringPayload()));
            ++i;
        }
    }

    public SubmitResponse submitGrid(Submit request) throws Exception {
        String submitDate;
        logger.debug((Object)"submitGrid() was  called with inputResource: ");
        if (request.getJobName() == null) {
            request.setJobName("");
        }
        if (request.getLanguage() == null) {
            request.setLanguage(LanguageEnumType.eng);
        }
        String ocropusLocation = ServiceContext.getOcropusSoftwareDownloadLocation();
        logger.debug((Object)("Will download ocropus from: " + ocropusLocation));
        GRIDParams params = new GRIDParams();
        GRIDConfig conf = new GRIDConfig();
        conf.setChokePerformanceEvents(true);
        conf.setChokeProgressEvents(true);
        conf.setTimeout(-1L);
        params.setConfig(conf);
        GRIDResource r = null;
        ArrayList<GRIDResource> resourceslst = new ArrayList<GRIDResource>();
        String additionalGridRequirement = ServiceContext.getUniqueCEGridRequirement();
        String jdlDescription = "[\n    Type = \"Job\";\n    JobType = \"Normal\";\n    Executable = \"ocrjob_grid.sh\";\n    Arguments = \"" + ocropusLocation + "\";\n" + "    StdOutput = \"job.out\";\n" + "    StdError = \"job.err\";\n" + "    VirtualOrganisation = \"d4science.research-infrastructures.eu\";\n\n" + "    InputSandbox = {\"@\", \"ocrjob_grid.sh\", \"ocr.job\"  };\n" + "    OutputSandbox = {\"@\", \"@.hocr\", \"job.out\", \"job.err\"};\n" + " \n" + "    Requirements = other.GlueHostOperatingSystemName == \"ScientificSL\" && other.GlueHostOperatingSystemRelease >= 5.0 " + additionalGridRequirement + " \n" + "]";
        jdlDescription = jdlDescription.replaceAll("@", request.getInputResource().getResourceKey());
        logger.debug((Object)("JDL is: \n" + jdlDescription));
        r = new GRIDResource();
        r.setResourceKey("ocr.jdl");
        r.setResourceType("JDL");
        r.setResourceAccess("InMessageString");
        r.setInMessageStringPayload(jdlDescription);
        resourceslst.add(r);
        r = new GRIDResource();
        r.setResourceKey("userProxy");
        r.setResourceType("UserProxy");
        r.setResourceAccess("InMessageBytes");
        r.setInMessageBytePayload(request.getGridProxy());
        resourceslst.add(r);
        r = new GRIDResource();
        r.setResourceKey(request.getInputResource().getResourceKey());
        r.setResourceAccess(request.getInputResource().getResourceAccess());
        r.setResourceReference(request.getInputResource().getResourceReference());
        r.setInMessageBytePayload(request.getInputResource().getInMessageBytePayload());
        r.setInMessageStringPayload(request.getInputResource().getInMessageStringPayload());
        r.setResourceType("InData");
        resourceslst.add(r);
        String ocrJobShFileName = System.getenv("GLOBUS_LOCATION") + "/ocrjob_grid.sh";
        if (!ServiceUtils.fileExists(ocrJobShFileName)) {
            logger.error((Object)("ocrjob_grid.sh script must exist under " + System.getenv("GLOBUS_LOCATION")));
            throw new Exception("ocrjob_grid.sh script must exist under " + System.getenv("GLOBUS_LOCATION"));
        }
        r = new GRIDResource();
        r.setResourceKey("ocrjob_grid.sh");
        r.setResourceType("InData");
        r.setResourceAccess("InMessageBytes");
        r.setInMessageBytePayload(ServiceUtils.GetByteFilePayload(ocrJobShFileName));
        resourceslst.add(r);
        r = new GRIDResource();
        r.setResourceKey("ocr.job");
        r.setResourceType("InData");
        r.setResourceAccess("InMessageString");
        String jobFile = "@ lang = " + request.getLanguage().getValue() + "\n";
        jobFile = jobFile + "@ grid = d4science_grid \n";
        jobFile = jobFile + "@ scope = " + this.getServiceContext().getScope().toString() + "\n";
        jobFile = jobFile + "@ vo = d4science.research-infrastructures.eu \n";
        jobFile = jobFile + "@ proxy = /home/unused/proxy \n";
        jobFile = jobFile + "/home/unused/" + request.getInputResource().getResourceKey() + "\n";
        jobFile = jobFile + "> " + request.getInputResource().getResourceKey() + ".hocr " + "\n\n";
        r.setInMessageStringPayload(jobFile);
        resourceslst.add(r);
        r = new GRIDResource();
        r.setResourceKey(request.getInputResource().getResourceKey());
        r.setResourceType("OutData");
        r.setResourceAccess("Reference");
        resourceslst.add(r);
        r = new GRIDResource();
        r.setResourceKey(request.getInputResource().getResourceKey() + ".hocr");
        r.setResourceType("OutData");
        r.setResourceAccess("Reference");
        resourceslst.add(r);
        r = new GRIDResource();
        r.setResourceKey("job.out");
        r.setResourceType("OutData");
        r.setResourceAccess("Reference");
        resourceslst.add(r);
        r = new GRIDResource();
        r.setResourceKey("job.err");
        r.setResourceType("OutData");
        r.setResourceAccess("Reference");
        resourceslst.add(r);
        for (int i = 0; i < resourceslst.size(); ++i) {
            logger.debug((Object)("Resource " + i + ": Key:" + ((GRIDResource)resourceslst.get(i)).getResourceKey() + " Type:" + ((GRIDResource)resourceslst.get(i)).getResourceType() + " Access: " + ((GRIDResource)resourceslst.get(i)).getResourceAccess()));
        }
        params.setGridResources(resourceslst.toArray(new GRIDResource[0]));
        logger.info((Object)"Locating Workflow Engine to submit OCR job");
        String Scope = ServiceContext.getContext().getScope().toString();
        String endpoint = ServiceUtils.GetWorkflowEngineEndpoint(Scope);
        logger.info((Object)("Selected Workflow Engine for OCR job: " + endpoint));
        logger.info((Object)("Submitting OCR job to Workflow Engine (scope:" + ServiceContext.getContext().getScope().toString() + " , endpoint:" + endpoint));
        WorkflowEngineServicePortType wf = ServiceUtils.GetWorkflowEnginePortType(Scope, endpoint);
        String executionId = wf.adaptGRID(params);
        logger.info((Object)("Submitted OCR job successfully  (ExecutionId: " + executionId + " Scope: " + Scope + " WFE Endpoint: " + endpoint + ")"));
        GCUBEStatefulPortTypeContext ptcxt = StatefulContext.getPortTypeContext();
        GCUBEWSHome home = ptcxt.getWSHome();
        GCUBEWSResourceKey key = ptcxt.makeKey(uuidGen.nextUUID());
        String jobName = request.getJobName();
        String statusDescription = "OCR single job is running in grid";
        String lastPollDate = submitDate = ServiceUtils.getStringDate();
        Boolean complete = false;
        Boolean bulk = false;
        String ssid = "";
        String owner = request.getOwner();
        logger.debug((Object)"OCR creating resource now");
        OCRServiceResource resource = (OCRServiceResource)home.create(key, new Object[]{jobName, statusDescription, submitDate, lastPollDate, complete, bulk, ssid, ssid, ssid, ssid, new String(""), new String(""), executionId, endpoint, owner, Scope});
        resource.store();
        logger.debug((Object)("OCR resource was created (submited: " + resource.getSubmitDate() + " , executionId:" + resource.getExecutionId() + resource.getEngineUrl() + ")"));
        SubmitResponse response = new SubmitResponse();
        response.setEndpointReference(resource.getEPR());
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SubmitResponse submitJDLBulk(SubmitBulk request) throws Exception {
        logger.debug((Object)"submitJDLBulk() was  called with inputResource: ");
        if (request.getJobName() == null) {
            request.setJobName("");
        }
        if (request.getLanguage() == null) {
            request.setLanguage(LanguageEnumType.eng);
        }
        JDLParams params = new JDLParams();
        JDLConfig conf = new JDLConfig();
        conf.setChokePerformanceEvents(true);
        conf.setChokeProgressEvents(true);
        params.setConfig(conf);
        JDLResource r = null;
        ArrayList<JDLResource> resourceslst = null;
        EnvHintCollection hints = new EnvHintCollection();
        hints.AddHint(new NamedEnvHint("GCubeActionScope", new EnvHint(this.getServiceContext().getScope().toString())));
        if (InformationSystem.GetMatchingNode(null, (String)"other.GlueHostOperatingSystemName == ScientificSL && other.GlueHostOperatingSystemRelease == 5.0  && software.ocropus == true ", (EnvHintCollection)hints) != null) {
            logger.debug((Object)("A node with ocropus was found in scope " + this.getServiceContext().getScope().toString() + " and we will not send it"));
            String jdlDescription = "[\nType = \"Job\";\nJobType = \"Normal\";\nExecutable = \"ocrjobbulk.sh\";\nStdOutput = \"job.out\";\nStdError = \"job.err\";\nVirtualOrganisation = \"d4science.research-infrastructures.eu\";\nInputSandbox = { \"input_pdfs.zip\" , \"ocrjobbulk.sh\"  };\nOutputSandbox = { \"pdfs.zip\" , \"hocrs.zip\" , \"job.out\", \"job.err\"};\nRequirements = software.ocropus == true  ;\n]\n";
            logger.debug((Object)("-------> Set jdl of OCR job: \n" + jdlDescription));
            params.setJdlDescription(jdlDescription);
            resourceslst = new ArrayList<JDLResource>();
            String ocrJobShFileName = System.getenv("GLOBUS_LOCATION") + "/ocrjobbulk.sh";
            if (!ServiceUtils.fileExists(ocrJobShFileName)) {
                logger.error((Object)("ocrjobbulk.sh script must exist under " + System.getenv("GLOBUS_LOCATION")));
                throw new Exception("ocrjobbulk.sh script must exist under " + System.getenv("GLOBUS_LOCATION"));
            }
            r = new JDLResource();
            r.setResourceKey("ocrjobbulk.sh");
            r.setResourceAccess("InMessageString");
            r.setInMessageStringPayload(ServiceUtils.GetStringFilePayload(ocrJobShFileName));
            r.setResourceReference("");
            resourceslst.add(r);
        } else {
            logger.debug((Object)("A node with ocropus installed was not found in scope " + this.getServiceContext().getScope().toString() + " and we will try to find it in CMS"));
            String ocropusCMSReference = null;
            try {
                ocropusCMSReference = this.getOcropusCMReference();
            }
            catch (Exception ex) {
                logger.error((Object)("Could not find Collection with ocropus.tar.gz.gz in scope " + this.getServiceContext().getScope()), (Throwable)ex);
                throw new Exception("Could not find ocropus.tar.gz.gz in Content Management System in scope " + this.getServiceContext().getScope(), ex);
            }
            logger.debug((Object)("Found ocropus.tar.gz.gz with CMS Reference: " + ocropusCMSReference));
            if (ocropusCMSReference == null) {
                throw new Exception("We can't perform OCR, you must either set up a SL5 node with ocropus installed or use org.gcube.execution.ocrservice.tests.UploadOcropusClient client to upload ocropus.tar.gz.gz in Content Managegement System in scope " + ServiceContext.getContext().getScope().toString());
            }
            String jdlDescription = "[\nType = \"Job\";\nJobType = \"Normal\";\nExecutable = \"ocrjobbulk.sh\";\nArguments = \"ocropus.tar.gz.gz\";\nStdOutput = \"job.out\";\nStdError = \"job.err\";\nVirtualOrganisation = \"d4science.research-infrastructures.eu\";\nInputSandbox = {  \"input_pdfs.zip\" , \"ocrjobbulk.sh\", \"ocropus.tar.gz.gz\"  };\nOutputSandbox = { \"pdfs.zip\", \"hocrs.zip\" , \"job.out\", \"job.err\"};\nRequirements = other.GlueHostOperatingSystemName == ScientificSL && other.GlueHostOperatingSystemRelease == 5.0;\n]\n";
            params.setJdlDescription(jdlDescription);
            resourceslst = new ArrayList();
            r = new JDLResource();
            r.setResourceKey("ocrjobbulk.sh");
            String ocrJobShFileName = System.getenv("GLOBUS_LOCATION") + "/ocrjobbulk.sh";
            if (!ServiceUtils.fileExists(ocrJobShFileName)) {
                logger.error((Object)("ocrjobbulk.sh script must exist under " + System.getenv("GLOBUS_LOCATION")));
                throw new Exception("ocrjobbulk.sh script must exist under " + System.getenv("GLOBUS_LOCATION"));
            }
            r.setResourceAccess("InMessageBytes");
            r.setInMessageBytePayload(ServiceUtils.GetByteFilePayload(ocrJobShFileName));
            resourceslst.add(r);
            r = new JDLResource();
            r.setResourceKey("ocropus.tar.gz.gz");
            r.setResourceAccess("CMSReference");
            r.setResourceReference(ocropusCMSReference);
            resourceslst.add(r);
        }
        r = new JDLResource();
        r.setInMessageBytePayload(request.getInputResource().getInMessageBytePayload());
        r.setInMessageStringPayload(request.getInputResource().getInMessageStringPayload());
        r.setResourceAccess(request.getInputResource().getResourceAccess());
        r.setResourceKey("input_pdfs.zip");
        r.setResourceReference(request.getInputResource().getResourceReference());
        resourceslst.add(r);
        params.setJdlResources(resourceslst.toArray(new JDLResource[0]));
        int i = 0;
        while (true) {
            if (i >= params.getJdlResources().length) {
                String submitDate;
                logger.info((Object)"Locating Workflow Engine to submit OCR job");
                String Scope = ServiceContext.getContext().getScope().toString();
                String endpoint = ServiceUtils.GetWorkflowEngineEndpoint(Scope);
                logger.info((Object)("Selected Workflow Engine for OCR job: " + endpoint));
                logger.info((Object)("Submitting OCR job to Workflow Engine (scope:" + ServiceContext.getContext().getScope().toString() + " , endpoint:" + endpoint));
                WorkflowEngineServicePortType wf = ServiceUtils.GetWorkflowEnginePortType(Scope, endpoint);
                String executionId = wf.adaptJDL(params);
                logger.info((Object)("Submitted OCR job successfully  (ExecutionId: " + executionId + " Scope: " + Scope + " WFE Endpoint: " + endpoint + ")"));
                GCUBEStatefulPortTypeContext ptcxt = StatefulContext.getPortTypeContext();
                GCUBEWSHome home = ptcxt.getWSHome();
                GCUBEWSResourceKey key = ptcxt.makeKey(uuidGen.nextUUID());
                String jobName = request.getJobName();
                String statusDescription = "OCR bulk job is running in gcube node";
                String lastPollDate = submitDate = ServiceUtils.getStringDate();
                Boolean complete = false;
                Boolean bulk = true;
                String ssid = "";
                String owner = request.getOwner();
                logger.debug((Object)"OCR creating resource now");
                OCRServiceResource resource = (OCRServiceResource)home.create(key, new Object[]{jobName, statusDescription, submitDate, lastPollDate, complete, bulk, ssid, ssid, ssid, ssid, new String(""), new String(""), executionId, endpoint, owner, Scope});
                resource.store();
                logger.debug((Object)("OCR resource was created (submited: " + resource.getSubmitDate() + " , executionId:" + resource.getExecutionId() + resource.getEngineUrl() + ")"));
                SubmitResponse response = new SubmitResponse();
                response.setEndpointReference(resource.getEPR());
                return response;
            }
            logger.debug((Object)(" Resource " + i + " Key:" + params.getJdlResources()[i].getResourceKey() + " Access:" + params.getJdlResources()[i].getResourceAccess() + " Ref:" + params.getJdlResources()[i].getResourceReference() + " String:" + params.getJdlResources()[i].getInMessageStringPayload()));
            ++i;
        }
    }

    public SubmitResponse submitGridBulk(SubmitBulk request) throws Exception {
        String submitDate;
        logger.debug((Object)"submitGridBulk() was  called ");
        if (request.getJobName() == null) {
            request.setJobName("");
        }
        if (request.getLanguage() == null) {
            request.setLanguage(LanguageEnumType.eng);
        }
        String ocropusLocation = ServiceContext.getOcropusSoftwareDownloadLocation();
        logger.debug((Object)("Will download ocropus from: " + ocropusLocation));
        GRIDParams params = new GRIDParams();
        GRIDConfig conf = new GRIDConfig();
        conf.setChokePerformanceEvents(true);
        conf.setChokeProgressEvents(true);
        conf.setTimeout(-1L);
        params.setConfig(conf);
        GRIDResource r = null;
        ArrayList<GRIDResource> resourceslst = new ArrayList<GRIDResource>();
        String additionalGridRequirement = ServiceContext.getUniqueCEGridRequirement();
        String jdlDescription = "[\n    Type = \"Job\";\n    JobType = \"Normal\";\n    Executable = \"ocrjobbulk_grid.sh\";\n    Arguments = \"" + ocropusLocation + "\";\n" + "    StdOutput = \"job.out\";\n" + "    StdError = \"job.err\";\n" + "    VirtualOrganisation = \"d4science.research-infrastructures.eu\";\n\n" + "    InputSandbox = { \"input_pdfs.zip\", \"ocrjobbulk_grid.sh\" };\n" + "    OutputSandbox = { \"pdfs.zip\", \"hocrs.zip\" , \"job.out\", \"job.err\"};\n" + " \n" + "    Requirements = other.GlueHostOperatingSystemName == \"ScientificSL\" && other.GlueHostOperatingSystemRelease >= 5.0 " + additionalGridRequirement + " \n" + " \n" + "]";
        jdlDescription = jdlDescription.replaceAll("@", request.getInputResource().getResourceKey());
        logger.debug((Object)("JDL is: \n" + jdlDescription));
        r = new GRIDResource();
        r.setResourceKey("ocr.jdl");
        r.setResourceType("JDL");
        r.setResourceAccess("InMessageString");
        r.setInMessageStringPayload(jdlDescription);
        resourceslst.add(r);
        r = new GRIDResource();
        r.setResourceKey("userProxy");
        r.setResourceType("UserProxy");
        r.setResourceAccess("InMessageBytes");
        r.setInMessageBytePayload(request.getGridProxy());
        resourceslst.add(r);
        r = new GRIDResource();
        r.setResourceKey("input_pdfs.zip");
        r.setResourceAccess(request.getInputResource().getResourceAccess());
        r.setResourceReference(request.getInputResource().getResourceReference());
        r.setInMessageBytePayload(request.getInputResource().getInMessageBytePayload());
        r.setInMessageStringPayload(request.getInputResource().getInMessageStringPayload());
        r.setResourceType("InData");
        resourceslst.add(r);
        String ocrJobShFileName = System.getenv("GLOBUS_LOCATION") + "/ocrjobbulk_grid.sh";
        if (!ServiceUtils.fileExists(ocrJobShFileName)) {
            logger.error((Object)("ocrjobbulk_grid.sh script must exist under " + System.getenv("GLOBUS_LOCATION")));
            throw new Exception("ocrjobbulk_grid.sh script must exist under " + System.getenv("GLOBUS_LOCATION"));
        }
        r = new GRIDResource();
        r.setResourceKey("ocrjobbulk_grid.sh");
        r.setResourceType("InData");
        r.setResourceAccess("InMessageBytes");
        r.setInMessageBytePayload(ServiceUtils.GetByteFilePayload(ocrJobShFileName));
        resourceslst.add(r);
        r = new GRIDResource();
        r.setResourceKey("pdfs.zip");
        r.setResourceType("OutData");
        r.setResourceAccess("Reference");
        resourceslst.add(r);
        r = new GRIDResource();
        r.setResourceKey("hocrs.zip");
        r.setResourceType("OutData");
        r.setResourceAccess("Reference");
        resourceslst.add(r);
        r = new GRIDResource();
        r.setResourceKey("job.out");
        r.setResourceType("OutData");
        r.setResourceAccess("Reference");
        resourceslst.add(r);
        r = new GRIDResource();
        r.setResourceKey("job.err");
        r.setResourceType("OutData");
        r.setResourceAccess("Reference");
        resourceslst.add(r);
        for (int i = 0; i < resourceslst.size(); ++i) {
            logger.debug((Object)("Resource " + i + ": Key:" + ((GRIDResource)resourceslst.get(i)).getResourceKey() + " Type:" + ((GRIDResource)resourceslst.get(i)).getResourceType() + " Access: " + ((GRIDResource)resourceslst.get(i)).getResourceAccess()));
        }
        params.setGridResources(resourceslst.toArray(new GRIDResource[0]));
        logger.info((Object)"Locating Workflow Engine to submit OCR grid bulk job");
        String Scope = ServiceContext.getContext().getScope().toString();
        String endpoint = ServiceUtils.GetWorkflowEngineEndpoint(Scope);
        logger.info((Object)("Selected Workflow Engine for OCR grid bulk job: " + endpoint));
        logger.info((Object)("Submitting OCR bulk job in grid to Workflow Engine (scope:" + ServiceContext.getContext().getScope().toString() + " , endpoint:" + endpoint));
        WorkflowEngineServicePortType wf = ServiceUtils.GetWorkflowEnginePortType(Scope, endpoint);
        String executionId = wf.adaptGRID(params);
        logger.info((Object)("Submitted OCR bulk job in grid successfully  (ExecutionId: " + executionId + " Scope: " + Scope + " WFE Endpoint: " + endpoint + ")"));
        GCUBEStatefulPortTypeContext ptcxt = StatefulContext.getPortTypeContext();
        GCUBEWSHome home = ptcxt.getWSHome();
        GCUBEWSResourceKey key = ptcxt.makeKey(uuidGen.nextUUID());
        String jobName = request.getJobName();
        String statusDescription = "OCR bulk job is running in grid";
        String lastPollDate = submitDate = ServiceUtils.getStringDate();
        Boolean complete = false;
        Boolean bulk = true;
        String ssid = "";
        String owner = request.getOwner();
        logger.debug((Object)"OCR creating resource for OCR bulk grid job now");
        OCRServiceResource resource = (OCRServiceResource)home.create(key, new Object[]{jobName, statusDescription, submitDate, lastPollDate, complete, bulk, ssid, ssid, ssid, ssid, new String(""), new String(""), executionId, endpoint, owner, Scope});
        resource.store();
        logger.debug((Object)("OCR resource was created (submited: " + resource.getSubmitDate() + " , executionId:" + resource.getExecutionId() + resource.getEngineUrl() + ")"));
        SubmitResponse response = new SubmitResponse();
        response.setEndpointReference(resource.getEPR());
        return response;
    }

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }
}

