/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.ocrservice;

import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.execution.ocrservice.OCRServiceResource;
import org.gcube.execution.ocrservice.ServiceContext;
import org.gcube.execution.ocrservice.StatefulContext;
import org.gcube.execution.ocrservice.stubs.JobInfoResponseType;
import org.gcube.execution.ocrservice.stubs.StatusResponseType;

public class OCRService
extends GCUBEPortType {
    private static GCUBELog logger = new GCUBELog(OCRService.class);

    public OCRService() {
        logger.info((Object)"OCRService constructed");
    }

    protected ServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public StatusResponseType status() throws Exception {
        logger.debug((Object)"Asking for status of OCR job ");
        OCRServiceResource resource = (OCRServiceResource)StatefulContext.getPortTypeContext().getWSHome().find();
        StatusResponseType response = new StatusResponseType();
        response.setJobName(resource.getJobName());
        response.setStatusDescription(resource.getStatusDescritpion());
        response.setSubmitDate(resource.getSubmitDate());
        response.setLastPollDate(resource.getLastPollDate());
        response.setCompleted(resource.getCompleted());
        response.setHocrOutputSSID(!resource.getHocrOutputSSID().equals("") && !resource.getHocrOutputSSID().equals("not available") ? resource.getHocrOutputSSID() : null);
        response.setPdfOutputSSID(!resource.getPdfOutputSSID().equals("") && !resource.getPdfOutputSSID().equals("not available") ? resource.getPdfOutputSSID() : null);
        response.setJoboutSSID(!resource.getJoboutSSID().equals("") && !resource.getJoboutSSID().equals("not available") ? resource.getJoboutSSID() : null);
        response.setJoberrSSID(!resource.getJoberrSSID().equals("") && !resource.getJoberrSSID().equals("not available") ? resource.getJoberrSSID() : null);
        response.setError(resource.getError());
        response.setErrorDetails(resource.getErrorDetails());
        return response;
    }

    public JobInfoResponseType jobInfo() throws Exception {
        logger.debug((Object)"Asking for status of OCR job info");
        OCRServiceResource resource = (OCRServiceResource)StatefulContext.getPortTypeContext().getWSHome().find();
        JobInfoResponseType response = new JobInfoResponseType();
        response.setEngineUrl(resource.getEngineUrl());
        response.setExecutionId(resource.getExecutionId());
        response.setBulk(resource.isBulk());
        response.setOwner(resource.getOwner());
        response.setScope(resource.getSubScope());
        return response;
    }
}

