/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.server;

import gr.uoa.di.madgik.commons.server.ConnectionManager;
import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TCPConnectionManager
extends ConnectionManager {
    protected static Logger logger = Logger.getLogger(TCPConnectionManager.class.getName());
    private static TCPConnectionManager Manager = null;
    protected static final Map<ITCPConnectionManagerEntry.NamedEntry, ITCPConnectionManagerEntry> Entries = new Hashtable<ITCPConnectionManagerEntry.NamedEntry, ITCPConnectionManagerEntry>();
    private static final Object lockInit = new Object();
    protected static final Object lockEntries = new Object();
    protected static final Object synchStart = new Object();
    protected ServerSocket Sock = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Init(TCPConnectionManagerConfig Config) {
        ConnectionManager.Config = Config;
        Object object = lockInit;
        synchronized (object) {
            if (Manager == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Creating new instance of the connection manager");
                }
                Manager = new TCPConnectionManager(TCPConnectionManager.OpenSocket());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Init() throws FileNotFoundException, IOException {
        TCPConnectionManager.initializeConfigFromFile();
        Object object = lockInit;
        synchronized (object) {
            if (Manager == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Creating new instance of the connection manager");
                }
                Manager = new TCPConnectionManager(TCPConnectionManager.OpenSocket());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean IsInitialized() {
        Object object = lockInit;
        synchronized (object) {
            return Manager != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String GetConnectionManagerHostName() {
        Object object = lockInit;
        synchronized (object) {
            if (Manager != null) {
                if (TCPConnectionManager.Config.HostName != null) {
                    return TCPConnectionManager.Config.HostName;
                }
                return TCPConnectionManager.Manager.Sock.getInetAddress().getHostAddress();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int GetConnectionManagerPort() {
        Object object = lockInit;
        synchronized (object) {
            if (Manager != null) {
                return TCPConnectionManager.Manager.Sock.getLocalPort();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITCPConnectionManagerEntry RegisterEntry(ITCPConnectionManagerEntry Entry2) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Registering entry for entry name " + Entry2.GetName().toString());
        }
        Object object = lockEntries;
        synchronized (object) {
            if (!Entries.containsKey((Object)Entry2.GetName())) {
                Entries.put(Entry2.GetName(), Entry2);
            }
            return Entries.get((Object)Entry2.GetName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITCPConnectionManagerEntry GetEntry(ITCPConnectionManagerEntry.NamedEntry Name) {
        Object object = lockEntries;
        synchronized (object) {
            if (!Entries.containsKey((Object)Name)) {
                return null;
            }
            return Entries.get((Object)Name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCPConnectionManager(ServerSocket Sock) {
        this.Sock = Sock;
        this.setName(TCPConnectionManager.class.getName());
        this.setDaemon(true);
        Object object = synchStart;
        synchronized (object) {
            this.start();
            try {
                synchStart.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static ServerSocket OpenSocket() {
        block11: {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Opening socket");
            }
            for (PortRange range : TCPConnectionManager.Config.Ports) {
                for (int p = range.GetStart(); p <= range.GetEnd(); ++p) {
                    try {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Trying to open server socket on port " + p);
                        }
                        ServerSocket servSocktmp = new ServerSocket(p);
                        return servSocktmp;
                    }
                    catch (Exception ex) {
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.log(Level.FINE, "Could not open server socket on port " + p, ex);
                        continue;
                    }
                }
            }
            if (TCPConnectionManager.Config.UseRandomIfNoneAvailable) {
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Trying to open server socket on random port");
                    }
                    ServerSocket servSocktmp = new ServerSocket(0);
                    return servSocktmp;
                }
                catch (Exception ex) {
                    if (!logger.isLoggable(Level.FINE)) break block11;
                    logger.log(Level.FINE, "Could not open server socket on random port ", ex);
                }
            }
        }
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "Socket for proxy cannot be opened. No usable port could be found and bound to");
        }
        throw new IllegalArgumentException("Socket for proxy cannot be opened. No usable port could be found and bound to");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Connection manager initialized listening to port (" + this.Sock.getLocalPort() + ")");
        }
        Object object = synchStart;
        synchronized (object) {
            synchStart.notify();
        }
        while (true) {
            Socket consumerSock = null;
            try {
                consumerSock = this.Sock.accept();
                DataInputStream din = new DataInputStream(consumerSock.getInputStream());
                String EntryNameString = din.readUTF();
                ITCPConnectionManagerEntry.NamedEntry EntryName = ITCPConnectionManagerEntry.NamedEntry.valueOf(EntryNameString);
                ITCPConnectionManagerEntry Entry2 = TCPConnectionManager.GetEntry(EntryName);
                if (Entry2 == null) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "No handler set to forward connection for " + EntryName.toString());
                    }
                    consumerSock.close();
                    continue;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "New Connection opened and passed to " + EntryName.toString());
                }
                Entry2.HandleConnection(consumerSock);
                continue;
            }
            catch (Exception ex) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "Could not handle new connection request", ex);
                }
                try {
                    consumerSock.close();
                }
                catch (IOException iOException) {
                }
                continue;
            }
            break;
        }
    }
}

