/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.infra.nodeselection.cost;

import gr.uoa.di.madgik.commons.infra.HostingNode;
import gr.uoa.di.madgik.commons.infra.nodeselection.HostingNodeInfo;
import gr.uoa.di.madgik.commons.infra.nodeselection.NodeSelector;
import gr.uoa.di.madgik.commons.infra.nodeselection.cost.CostComparator;
import gr.uoa.di.madgik.commons.infra.nodeselection.cost.CostFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CostBasedNodeSelector
implements NodeSelector {
    private CostFunction function = null;

    public CostBasedNodeSelector(CostFunction function) {
        this.function = function;
    }

    @Override
    public HostingNode selectNode(List<HostingNode> candidates) {
        return this.assessNodes(candidates).get((int)0).node;
    }

    @Override
    public List<HostingNodeInfo> assessNodes(List<HostingNode> candidates) {
        ArrayList<HostingNodeInfo> hns = new ArrayList<HostingNodeInfo>();
        HashMap<HostingNode, Float> assessedNodes = new HashMap<HostingNode, Float>();
        HashMap<String, Float> extremeValues = new HashMap<String, Float>();
        ArrayList<String> factorsToRemove = new ArrayList<String>();
        for (CostFunction.CostFactor costFactor : this.function.costFactors.values()) {
            float min = Float.MAX_VALUE;
            float max = -1.0f;
            boolean skip = false;
            for (HostingNode candidate : candidates) {
                if (candidate.getPropertyByName(costFactor.name) == null) {
                    factorsToRemove.add(costFactor.name);
                    skip = true;
                    break;
                }
                float propertyValue = Float.parseFloat(candidate.getPropertyByName(costFactor.name));
                if (!(max < propertyValue)) continue;
                max = propertyValue;
            }
            if (skip) continue;
            extremeValues.put(costFactor.name, Float.valueOf(max));
        }
        for (String string : factorsToRemove) {
            this.function.costFactors.remove(string);
        }
        if (this.function.costFactors.size() == 0) {
            Collections.shuffle(candidates);
            int i = 0;
            for (HostingNode candidate : candidates) {
                hns.add(new HostingNodeInfo(candidate, Float.valueOf(1.0f - (float)i * (1.0f / (float)candidates.size()))));
                ++i;
            }
            return hns;
        }
        for (HostingNode hostingNode : candidates) {
            Float val = Float.valueOf(0.0f);
            for (CostFunction.CostFactor factor : this.function.costFactors.values()) {
                Float normalizedValue = Float.valueOf(Float.parseFloat(hostingNode.getPropertyByName(factor.name)) / ((Float)extremeValues.get(factor.name)).floatValue());
                if (factor.ascending) {
                    val = Float.valueOf(val.floatValue() + factor.coefficient * normalizedValue.floatValue());
                    continue;
                }
                val = Float.valueOf(val.floatValue() + factor.coefficient * (1.0f - normalizedValue.floatValue()));
            }
            assessedNodes.put(hostingNode, val);
        }
        TreeMap<HostingNode, Float> sortedNodes = new TreeMap<HostingNode, Float>(new CostComparator(assessedNodes));
        sortedNodes.putAll(assessedNodes);
        float f = ((Float)sortedNodes.entrySet().iterator().next().getValue()).floatValue();
        for (Map.Entry hn : sortedNodes.entrySet()) {
            hns.add(new HostingNodeInfo((HostingNode)hn.getKey(), Float.valueOf(((Float)hn.getValue()).floatValue() / f)));
        }
        return hns;
    }

    @Override
    public void markSelected(HostingNode node) {
    }
}

