/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.bridge.xml;

import gr.uoa.di.madgik.grs.GRS2Exception;
import gr.uoa.di.madgik.grs.bridge.BridgeUpgrade;
import gr.uoa.di.madgik.grs.bridge.exceptions.GCubeBridgeException;
import gr.uoa.di.madgik.grs.bridge.xml.GCubeXMLRecordDefinition;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.net.URI;
import java.util.logging.Logger;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBase;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceLocalType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLIterator;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLReader;

public class XMLUpgrade
extends BridgeUpgrade {
    private static Logger logger = Logger.getLogger(XMLUpgrade.class.getName());
    private RecordWriter<Record> writer = null;
    private RSXMLIterator iterator = null;
    private boolean compress = false;
    private IWriterProxy proxy = null;

    public XMLUpgrade() {
    }

    public XMLUpgrade(RSLocator locator) {
        this.locator = locator;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public void setProxy(IWriterProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public void initialize() throws GCubeBridgeException {
        try {
            this.writer = new RecordWriter(this.proxy, new RecordDefinition[]{new GCubeXMLRecordDefinition(this.compress)});
        }
        catch (GRS2Exception e) {
            throw new GCubeBridgeException("Could not initialize Record Writer", e);
        }
        try {
            this.iterator = RSXMLReader.getRSXMLReader((RSLocator)this.locator).makeLocal((RSResourceType)new RSResourceLocalType()).getRSIterator();
        }
        catch (Exception e) {
            throw new GCubeBridgeException("Could not initialize RS Reader Iterator", e);
        }
    }

    @Override
    public URI getLocator() throws GCubeBridgeException {
        try {
            return this.writer.getLocator();
        }
        catch (GRS2WriterException e) {
            throw new GCubeBridgeException("Could not retrieve locator", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doUpgrade() throws GCubeBridgeException {
        try {
            try {
                while (this.iterator.hasNext()) {
                    if (this.writer.getStatus() != IBuffer.Status.Open) {
                        return;
                    }
                    ResultElementBase rec = this.iterator.next(this.recordInputClass);
                    if (rec == null) continue;
                    this.writer.put((Record)this.getRecord(rec), RecordWriter.DefaultInactivityTimeout, RecordWriter.DefaultInactivityTimeUnit);
                }
                return;
            }
            catch (Exception ex) {
                throw new GCubeBridgeException("Could not add the downgraded record", ex);
            }
        }
        finally {
            try {
                this.writer.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Logger getLogger() {
        return logger;
    }
}

