/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.bridge;

import gr.uoa.di.madgik.grs.bridge.GCubeRecord;
import gr.uoa.di.madgik.grs.bridge.exceptions.GCubeBridgeException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBase;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;

public abstract class BridgeUpgrade
extends Thread {
    protected RSLocator locator = null;
    protected Class<ResultElementBase> recordInputClass = null;
    protected Class<GCubeRecord> recordOutputClass = null;

    public URI upgrade() throws GCubeBridgeException {
        URI locator = null;
        this.initialize();
        locator = this.getLocator();
        this.setName("gRS2 bridge upgrade");
        this.setDaemon(true);
        this.start();
        return locator;
    }

    public void setLocator(RSLocator locator) {
        this.locator = locator;
    }

    public void setRecordInputClass(Class<ResultElementBase> recordClass) {
        this.recordInputClass = recordClass;
    }

    public void setRecordOutputClass(Class<GCubeRecord> recordClass) {
        this.recordOutputClass = recordClass;
    }

    protected GCubeRecord getRecord(ResultElementBase record) throws GCubeBridgeException {
        try {
            GCubeRecord rec = this.recordOutputClass.newInstance();
            rec.upgrade(record.RS_toXML());
            return rec;
        }
        catch (Exception e) {
            throw new GCubeBridgeException("Could not retrieve the downgraded version of the record", e);
        }
    }

    public abstract void doUpgrade() throws GCubeBridgeException;

    public abstract void initialize() throws GCubeBridgeException;

    public abstract URI getLocator() throws GCubeBridgeException;

    public abstract Logger getLogger();

    @Override
    public void run() {
        block2: {
            try {
                this.doUpgrade();
            }
            catch (Exception ex) {
                if (!this.getLogger().isLoggable(Level.WARNING)) break block2;
                this.getLogger().log(Level.WARNING, "Could not complete the upgrade procedure", ex);
            }
        }
    }
}

