/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.bridge;

import gr.uoa.di.madgik.grs.bridge.GCubeRecord;
import gr.uoa.di.madgik.grs.bridge.exceptions.GCubeBridgeException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBase;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;

public abstract class BridgeDowngrade
extends Thread {
    protected URI locator = null;
    protected Class<? extends ResultElementBase> recordClass = null;

    public RSLocator downgrade() throws GCubeBridgeException {
        RSLocator locator = null;
        this.initialize();
        locator = this.getLocator();
        this.setName("gRS2 bridge downgrade");
        this.setDaemon(true);
        this.start();
        return locator;
    }

    public void setLocator(URI locator) {
        this.locator = locator;
    }

    public void setRecordClass(Class<? extends ResultElementBase> recordClass) {
        this.recordClass = recordClass;
    }

    protected ResultElementBase getRecord(GCubeRecord record) throws GCubeBridgeException {
        try {
            ResultElementBase rec = this.recordClass.newInstance();
            rec.RS_fromXML(record.downgrade());
            return rec;
        }
        catch (Exception e) {
            throw new GCubeBridgeException("Could not retrieve the downgraded version of the record", e);
        }
    }

    public abstract void doDowngrade() throws GCubeBridgeException;

    public abstract void initialize() throws GCubeBridgeException;

    public abstract RSLocator getLocator() throws GCubeBridgeException;

    public abstract Logger getLogger();

    @Override
    public void run() {
        block2: {
            try {
                this.doDowngrade();
            }
            catch (Exception ex) {
                if (!this.getLogger().isLoggable(Level.WARNING)) break block2;
                this.getLogger().log(Level.WARNING, "Could not complete the downgrade procedure", ex);
            }
        }
    }
}

