/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.vomsapi.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.gcube.vomanagement.vomsapi.ExtendedVOMSAdmin;
import org.gcube.vomanagement.vomsapi.impl.VOMSAPIConfiguration;
import org.gcube.vomanagement.vomsapi.impl.VOMSAPIConfigurationProperty;
import org.gcube.vomanagement.vomsapi.impl.VOMSAdminException;
import org.gcube.vomanagement.vomsapi.impl.utils.VOMSServerBean;
import org.gcube.vomanagement.vomsapi.util.CredentialsUtil;
import org.gcube.vomanagement.vomsapi.util.InMemoryVOMSProxyFactory;
import org.gcube.vomanagement.vomsapi.util.VOMSInfo;
import org.gcube.vomanagement.vomsapi.util.VOMSRole;
import org.gridforum.jgss.ExtendedGSSCredential;

public abstract class VOMSAttributeAdder {
    private Logger logger = Logger.getLogger(this.getClass());
    VOMSAPIConfiguration config = null;
    ExtendedVOMSAdmin extendedVOMSAdmin = null;
    List<VOMSServerBean> serverList;

    VOMSAttributeAdder(VOMSAPIConfiguration config, ExtendedVOMSAdmin extendedVOMSAdmin) {
        this.config = config;
        this.extendedVOMSAdmin = extendedVOMSAdmin;
        this.serverList = new ArrayList<VOMSServerBean>();
    }

    public void addServer(VOMSServerBean serverBean) {
        this.serverList.add(serverBean);
    }

    public void setServerList(List<VOMSServerBean> serverList) {
        if (serverList != null) {
            this.serverList = serverList;
        }
    }

    ExtendedGSSCredential addVOMSRoles(ExtendedGSSCredential credentials, String ... groupNames) throws VOMSAdminException {
        this.logger.debug((Object)"Generating and adding VO roles");
        String userDN = CredentialsUtil.getIdentityDN(credentials);
        String userCA = CredentialsUtil.getIssuerDN(credentials);
        this.logger.debug((Object)("User DN " + userDN));
        this.logger.debug((Object)("User CA " + userCA));
        InMemoryVOMSProxyFactory factory = this.generateInMemoryProxyFactorty();
        if (groupNames != null && groupNames.length > 0) {
            this.addRoles(factory, userDN, userCA, groupNames, CredentialsUtil.stringCredentials(credentials));
        } else {
            this.logger.debug((Object)"No role defined: adding only VO info");
            String voName = this.config.getProperty(VOMSAPIConfigurationProperty.VO_NAME);
            this.logger.debug((Object)("VO name " + voName));
            factory.addVomsFQANInfo(new VOMSInfo(voName));
        }
        try {
            ExtendedGSSCredential attributedCredentials = factory.createInMemoryProxy(credentials);
            this.logger.debug((Object)("Created VOMS proxy " + CredentialsUtil.stringCredentials(attributedCredentials)));
            return attributedCredentials;
        }
        catch (Exception e) {
            this.logger.error((Object)("Cannot create the VOMS proxy for " + CredentialsUtil.stringCredentials(credentials)), (Throwable)e);
            throw new VOMSAdminException("Cannot create the VOMS proxy for " + CredentialsUtil.stringCredentials(credentials), e);
        }
    }

    private InMemoryVOMSProxyFactory generateInMemoryProxyFactorty() throws VOMSAdminException {
        InMemoryVOMSProxyFactory factory;
        String proxiesDir = this.config.getProperty(VOMSAPIConfigurationProperty.PROXIES_DIR);
        try {
            factory = new InMemoryVOMSProxyFactory(proxiesDir);
            for (VOMSServerBean server : this.serverList) {
                factory.addVomsServer(server.getHostName(), server.getHostDN(), server.getHostPort(), server.getVoName());
            }
            this.logger.debug((Object)("Intialized factory for VOMS proxies with directory " + proxiesDir));
        }
        catch (IOException e) {
            this.logger.error((Object)"Cannot create the factory for VOMS proxies", (Throwable)e);
            throw new VOMSAdminException("Cannot create the factory for VOMS proxies", e);
        }
        return factory;
    }

    private void addRoles(InMemoryVOMSProxyFactory factory, String userDN, String userCA, String[] groupNames, String credentialsLogString) throws VOMSAdminException {
        for (String groupName : groupNames) {
            String strRoles;
            String[] roles;
            this.logger.debug((Object)("Adding VOMS roles in group " + groupName + " to " + credentialsLogString));
            try {
                roles = this.extendedVOMSAdmin.listRoles(groupName, userDN, userCA);
            }
            catch (Exception e) {
                this.logger.error((Object)("Cannot get roles for " + credentialsLogString + " in group " + groupName), (Throwable)e);
                throw new VOMSAdminException("Cannot get roles for " + credentialsLogString + " in group " + groupName, e);
            }
            if (roles.length > 0) {
                strRoles = roles.length + " roles found in group " + groupName + " for " + credentialsLogString + ":";
                for (String role : roles) {
                    strRoles = strRoles + "\n\t" + role;
                }
            } else {
                strRoles = "No roles found in group " + groupName + " for " + credentialsLogString;
            }
            this.logger.debug((Object)strRoles);
            String voName = this.config.getProperty(VOMSAPIConfigurationProperty.VO_NAME);
            for (String role : roles) {
                VOMSRole vomsRole = new VOMSRole(groupName, voName, role);
                factory.addVomsFQANInfo(vomsRole);
                this.logger.debug((Object)("Configured factory for VOMS proxies with VOMS role [group=" + groupName + ", vo=" + voName + ", role=" + role));
            }
        }
    }
}

