/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.pm.connector.impl;

import it.eng.rdlab.soa3.connector.utils.SoapUtils;
import it.eng.rdlab.soa3.connector.utils.XMLUtils;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class PolicyGetUtils {
    private static Logger logger = LoggerFactory.getLogger(PolicyGetUtils.class);
    protected String url;

    PolicyGetUtils() {
    }

    private static SOAPMessage generateSoapMessage(String alias, String elementId, String tagRequest, String tagElementId) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document requestDocument = builder.newDocument();
        Element root = requestDocument.createElementNS("http://services.pap.authz.glite.org", "ser:" + tagRequest);
        if (alias != null) {
            logger.debug("Creating alias element...");
            root.appendChild(XMLUtils.createElement((Document)requestDocument, (String)"alias", (String)alias, null));
            logger.debug("Alias element created");
        }
        if (elementId != null) {
            root.appendChild(XMLUtils.createElement((Document)requestDocument, (String)tagElementId, (String)elementId, null));
        }
        requestDocument.appendChild(root);
        return SoapUtils.generateSoapMessage((Document)requestDocument);
    }

    public static SOAPMessage identifyElement(String url, String alias, String elementId, String tagRequest, String tagElementId) throws Exception {
        logger.debug("Generating request soap message");
        SOAPMessage message = PolicyGetUtils.generateSoapMessage(alias, elementId, tagRequest, tagElementId);
        logger.debug("Soap Message generated");
        try {
            logger.debug("Sending message");
            SOAPMessage response = SoapUtils.performCall((SOAPMessage)message, (String)url);
            logger.debug("Message sent");
            return response;
        }
        catch (Exception e) {
            logger.error("Error in sending the message", (Throwable)e);
            return null;
        }
    }
}

