/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.records.aggregation;

import java.util.concurrent.TimeUnit;

public class AggregationConfiguration {
    public static final int DEFAULT_MAX_RECORDS_NUMBER = 1000;
    public static final long DEFAULT_MAX_TIME_ELAPSED = 1800000L;
    public static final int DEFAULT_INITIAL_DELAY = 30;
    public static final int DEFAULT_DELAY = 30;
    public static final TimeUnit TIME_UNIT = TimeUnit.MINUTES;
    protected int initialDelay;
    protected int delay;
    protected int maxRecordsNumber;
    protected long maxTimeElapsed;

    public static AggregationConfiguration getDefaultConfiguration() {
        return new AggregationConfiguration(30, 30, 1000, 1800000L);
    }

    public AggregationConfiguration(int initialDelay, int delay, int maxRecordsNumber, long maxTimeElapsed) {
        this.initialDelay = initialDelay;
        this.delay = delay;
        this.maxRecordsNumber = maxRecordsNumber;
        this.maxTimeElapsed = maxTimeElapsed;
    }

    public int getInitialDelay() {
        if (this.initialDelay > 0) {
            return this.initialDelay;
        }
        return 30;
    }

    public void setInitialDelay(int initialDelay) {
        this.initialDelay = initialDelay;
    }

    public int getDelay() {
        if (this.delay > 0) {
            return this.delay;
        }
        return 30;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getMaxRecordsNumber() {
        if (this.maxRecordsNumber > 0) {
            return this.maxRecordsNumber;
        }
        return 1000;
    }

    public void setMaxRecordsNumber(int maxRecordsNumber) {
        this.maxRecordsNumber = maxRecordsNumber;
    }

    public long getMaxTimeElapsed() {
        if (this.maxTimeElapsed > 0L) {
            return this.maxTimeElapsed;
        }
        return 1800000L;
    }

    public void setMaxTimeElapsed(long maxTimeElapsed) {
        this.maxTimeElapsed = maxTimeElapsed;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.delay;
        result = 31 * result + this.initialDelay;
        result = 31 * result + this.maxRecordsNumber;
        result = 31 * result + (int)(this.maxTimeElapsed ^ this.maxTimeElapsed >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggregationConfiguration other = (AggregationConfiguration)obj;
        if (this.delay != other.delay) {
            return false;
        }
        if (this.initialDelay != other.initialDelay) {
            return false;
        }
        if (this.maxRecordsNumber != other.maxRecordsNumber) {
            return false;
        }
        return this.maxTimeElapsed == other.maxTimeElapsed;
    }

    public String toString() {
        return "AggregationConfig [initialDelay=" + this.initialDelay + ", delay=" + this.delay + ", maxRecordsNumber=" + this.maxRecordsNumber + ", maxTimeElapsed=" + this.maxTimeElapsed + "]";
    }
}

