PS1='$ '
TOMCAT_DST_FOLDER="tomcat"
TOMCAT_VERSION="7.0.61"
TOMCAT_PID_FILENAME="tomcat.pid"
SMARTGEAR_DISTRIBUTION_DIRECTORY="smartgears-distribution-1.2.2-3.7.0"
SMARTGEAR_ROOT=${PWD}

BUNDLE_HOME=${SMARTGEAR_ROOT}
STARTUP_SCRIPT="startContainer.sh"
STOP_SCRIPT="stopContainer.sh"

GHN_HOME=${SMARTGEAR_ROOT}/SmartGears
CONTAINER_FILENAME="container.xml"
CONTAINER_XML=${GHN_HOME}/${CONTAINER_FILENAME}

ENV_VARIABLES="export CATALINA_OPTS=\"-Xmx2000m -Xms2000m\"
export GHN_HOME=${GHN_HOME}
export CATALINA_PID=${SMARTGEAR_ROOT}/${TOMCAT_PID_FILENAME}
export CATALINA_HOME=${SMARTGEAR_ROOT}/${TOMCAT_DST_FOLDER}
export BUNDLE_HOME=${SMARTGEAR_ROOT}"


function showhelp {
	echo -e "\nUsage:  setup.sh [-f |-h] \n"
	echo    "  f     = Really run the setup. By default it will be a dry-run"
	echo -e "  h     = shows this help.\n"
}

while getopts ":d:fh" opt; do
	case $opt in
    	f) force=true;;
    	h) showhelp
exit 0 ;;
		\?) echo -e "\nERROR:invalid option: -$OPTARG"; 
			showhelp; 
			echo -e "\naborting.\n" 
			exit 1 >&2 ;;
  	esac
done

if [ $force ]; then
	echo "Creating tomcat symlink..."
	ln -s apache-tomcat-${TOMCAT_VERSION} ${TOMCAT_DST_FOLDER}
	echo "done."
	ls -l ${TOMCAT_DST_FOLDER}

	echo -e "\n"
	echo "Adding the following variables to environment..."
	echo "${ENV_VARIABLES}"
	echo "${ENV_VARIABLES}" >> ~/.bashrc
	echo "done."
	
	echo -e "\n"
	echo "Creating GHN_HOME ${GHN_HOME}"
	mkdir -p ${GHN_HOME}
	
	
	echo -e "\n"
	echo "Loading new environment..."
	source ~/.bashrc
	
	echo -e "\n"
	echo -e "Entering on SmartGear distribution directory ${SMARTGEAR_DISTRIBUTION_DIRECTORY}\n"
	export CATALINA_HOME=${SMARTGEAR_ROOT}/${TOMCAT_DST_FOLDER}
	cd ${SMARTGEAR_DISTRIBUTION_DIRECTORY}
	
	echo ""
	echo "Launching SmartGear install for Tomcat...."
	
	./install -s tomcat -g ${GHN_HOME}
	
	echo -e "\n\n\n"
	echo "Just few steps to do to reach the goal:"
		
	echo "Load new environments with the following command:"
	echo "source ~/.bashrc"
	
	echo -e "\n\n"
	echo "Then:"
else
	echo "We are showing the list of steps to setup SmartGear."
	echo "Use -h to see the script help."
	echo "Use -f to allow this script to perform automatically the required steps to setup Smartgear"
	
	echo ""
	echo "Create tomcat symlink with the following command:"
	echo "ln -s apache-tomcat-${TOMCAT_VERSION} ${TOMCAT_DST_FOLDER}"
		
	echo ""
	echo "Add the following variables to your ~/.bashrc"
	echo "${ENV_VARIABLES}"
	
	echo ""
	echo "Create GHN_HOME ${GHN_HOME}"
	echo "mkdir -p ${GHN_HOME}"
	
	echo ""
	echo "Load new environments with the following command:"
	echo "source ~/.bashrc"
	
	echo ""
	echo "Enter on SmartGear distribution directory"
	echo "cd ${SMARTGEAR_DISTRIBUTION_DIRECTORY}"
	
	echo ""
	echo "Launch SmartGear install for Tomcat with the following command:"
	echo "./install -s tomcat"
	
	echo ""
	echo "The previous steps can be made by launching this script with -f option"
	
	echo -e "\n\n"
	echo "Then:"
	
fi


echo "- Modify ${CONTAINER_XML} with your hostname"
echo "- Modify ${CONTAINER_XML} startup infrastructure and vres"

echo "- You can Start the container from ${BUNDLE_HOME} directory using the command ./${STARTUP_SCRIPT}"
echo "- You can Stop the container from ${BUNDLE_HOME} directory using the command ./${STOP_SCRIPT}"

echo ""
echo "PLEASE NOTE: 
By default Tomcat start on 8080 port. If you want to change this port REMEMBER to modify ${CONTAINER_XML} consistently"



