/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.samplesqlbuilder;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.util.SortedProperties;
import com.liferay.portal.tools.DBLoader;
import com.liferay.portal.tools.samplesqlbuilder.DataFactory;
import com.liferay.portal.tools.samplesqlbuilder.SampleSQLBuilder;
import com.liferay.portal.util.InitUtil;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Properties;

public class TestSampleSQLBuilder {
    public static void main(String[] args) {
        block12: {
            InitUtil.initWithSpring();
            Reader reader = null;
            try {
                try {
                    SortedProperties properties = new SortedProperties();
                    reader = new FileReader(args[0]);
                    properties.load(reader);
                    DataFactory dataFactory = new DataFactory((Properties)properties);
                    new SampleSQLBuilder((Properties)properties, dataFactory);
                    String sqlDir = properties.getProperty("sql.dir");
                    String outputDir = properties.getProperty("sample.sql.output.dir");
                    TestSampleSQLBuilder.loadHypersonic(sqlDir, outputDir);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    if (reader == null) break block12;
                    try {
                        reader.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
        }
    }

    protected static void loadHypersonic(String sqlDir, String outputDir) throws Exception {
        Class.forName("org.hsqldb.jdbcDriver");
        Connection connection = null;
        Statement statement = null;
        try {
            connection = DriverManager.getConnection("jdbc:hsqldb:mem:testSampleSQLBuilderDB;shutdown=true", "sa", "");
            DBLoader.loadHypersonic(connection, String.valueOf(sqlDir) + "/portal/portal-hypersonic.sql");
            DBLoader.loadHypersonic(connection, String.valueOf(sqlDir) + "/indexes/indexes-hypersonic.sql");
            DBLoader.loadHypersonic(connection, String.valueOf(outputDir) + "/sample-hypersonic.sql");
            statement = connection.createStatement();
            statement.execute("SHUTDOWN COMPACT");
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)connection, statement);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)connection, (Statement)statement);
    }
}

