/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.PropsValues;
import flexjson.BeanAnalyzer;
import flexjson.BeanProperty;
import flexjson.JSONException;
import flexjson.ObjectBinder;
import flexjson.factories.BeanObjectFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PortalBeanObjectFactory
extends BeanObjectFactory {
    private static Log _log = LogFactoryUtil.getLog(PortalBeanObjectFactory.class);
    private Map<Class<?>, Map<String, Field>> _declaredFields = new ConcurrentHashMap();
    private boolean _safeMode;

    public Object instantiate(ObjectBinder objectBinder, Object value, Type targetType, Class targetClass) {
        if (this._safeMode) {
            HashMap<String, String> target = new HashMap<String, String>();
            target.put("class", targetClass.getName());
            Map values = (Map)value;
            return objectBinder.bindIntoMap(values, target, null, null);
        }
        String targetClassName = targetClass.getName();
        if (targetClassName.contains("com.liferay") && targetClassName.contains("Util")) {
            throw new JSONException("Not instantiating " + targetClass.getName() + " at " + objectBinder.getCurrentPath());
        }
        try {
            Object target = this.instantiate(targetClass);
            Map values = (Map)value;
            if (PropsValues.JSON_DESERIALIZER_STRICT_MODE) {
                this.removeInvalidFields(values, targetClass);
            }
            return objectBinder.bindIntoObject(values, target, targetType);
        }
        catch (Exception e2) {
            throw new JSONException("Unable to instantiate " + targetClass.getName() + " at " + objectBinder.getCurrentPath(), (Throwable)e2);
        }
    }

    public void setSafeMode(boolean safeMode) {
        this._safeMode = safeMode;
    }

    protected Map<String, Field> getDeclaredFields(Class targetClass) {
        Map<String, Field> declaredFieldsMap = this._declaredFields.get(targetClass);
        if (declaredFieldsMap == null) {
            Field[] declaredFields;
            declaredFieldsMap = new ConcurrentHashMap<String, Field>();
            Field[] fieldArray = declaredFields = targetClass.getDeclaredFields();
            int n = declaredFields.length;
            int n2 = 0;
            while (n2 < n) {
                Field declaredField = fieldArray[n2];
                String fieldName = declaredField.getName();
                if (fieldName.startsWith("_")) {
                    fieldName = fieldName.substring(1);
                }
                declaredFieldsMap.put(fieldName, declaredField);
                ++n2;
            }
            this._declaredFields.put(targetClass, declaredFieldsMap);
        }
        return declaredFieldsMap;
    }

    protected boolean isValidField(Map<String, Field> declaredFields, String beanName) {
        Field declaredField = declaredFields.get(beanName);
        if (declaredField == null) {
            return false;
        }
        int modifier = declaredField.getModifiers();
        return !Modifier.isStatic(modifier);
    }

    protected void removeInvalidFields(Map<?, ?> values, Class<?> targetClass) {
        Map<String, Field> declaredFields = this.getDeclaredFields(targetClass);
        BeanAnalyzer beanAnalyzer = BeanAnalyzer.analyze(targetClass);
        for (BeanProperty beanProperty : beanAnalyzer.getProperties()) {
            String beanName = beanProperty.getName();
            String capitalizedBeanName = null;
            Object beanValue = values.get(beanName);
            if (beanValue == null) {
                capitalizedBeanName = String.valueOf(Character.toUpperCase(beanName.charAt(0))) + beanName.substring(1);
                beanValue = values.get(capitalizedBeanName);
            }
            if (beanValue == null || this.isValidField(declaredFields, beanName)) continue;
            if (capitalizedBeanName != null) {
                beanName = capitalizedBeanName;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Removing non-JavaBeans field " + beanName));
            }
            values.remove(beanName);
        }
    }
}

