/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.util;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiNodeServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.permission.WikiPagePermission;
import com.liferay.portlet.wiki.service.persistence.WikiNodeActionableDynamicQuery;
import com.liferay.portlet.wiki.service.persistence.WikiPageActionableDynamicQuery;
import com.liferay.portlet.wiki.util.WikiPageAttachmentsUtil;
import com.liferay.portlet.wiki.util.WikiUtil;
import java.util.Locale;
import javax.portlet.PortletURL;

public class WikiPageIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{WikiPage.class.getName()};
    public static final String PORTLET_ID = "36";

    public WikiPageIndexer() {
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public void addRelatedEntryFields(Document document, Object obj) throws Exception {
        WikiPage page = null;
        try {
            if (obj instanceof DLFileEntry) {
                DLFileEntry dlFileEntry = (DLFileEntry)obj;
                page = WikiPageAttachmentsUtil.getPage(dlFileEntry.getFileEntryId());
                document.addKeyword("classNameId", PortalUtil.getClassNameId((String)WikiPage.class.getName()));
                document.addKeyword("classPK", page.getResourcePrimKey());
            } else if (obj instanceof MBMessage) {
                MBMessage message = (MBMessage)obj;
                page = WikiPageLocalServiceUtil.getPage((long)message.getClassPK());
            }
        }
        catch (Exception exception) {
            return;
        }
        document.addKeyword("nodeId", page.getNodeId());
        document.addKeyword("relatedEntry", true);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)entryClassPK);
        return WikiPagePermission.contains(permissionChecker, page, "VIEW");
    }

    public boolean isVisible(long classPK, int status) throws Exception {
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)classPK);
        return this.isVisible(page.getStatus(), status);
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        this.addStatus(contextQuery, searchContext);
        long[] nodeIds = searchContext.getNodeIds();
        if (ArrayUtil.isNotEmpty((long[])nodeIds)) {
            BooleanQuery nodeIdsQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            long[] lArray = nodeIds;
            int n = nodeIds.length;
            int n2 = 0;
            while (n2 < n) {
                block4: {
                    long nodeId = lArray[n2];
                    try {
                        WikiNodeServiceUtil.getNode((long)nodeId);
                    }
                    catch (Exception exception) {
                        break block4;
                    }
                    nodeIdsQuery.addTerm("nodeId", nodeId);
                }
                ++n2;
            }
            contextQuery.add((Query)nodeIdsQuery, BooleanClauseOccur.MUST);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        SearchContext searchContext = new SearchContext();
        searchContext.setSearchEngineId(this.getSearchEngineId());
        if (obj instanceof Object[]) {
            Object[] array = (Object[])obj;
            long companyId = (Long)array[0];
            long nodeId = (Long)array[1];
            String title = (String)array[2];
            DocumentImpl document = new DocumentImpl();
            document.addUID(PORTLET_ID, nodeId, title);
            SearchEngineUtil.deleteDocument((String)this.getSearchEngineId(), (long)companyId, (String)document.get("uid"));
        } else if (obj instanceof WikiPage) {
            WikiPage page = (WikiPage)obj;
            this.deleteDocument(page.getCompanyId(), page.getResourcePrimKey());
        }
    }

    protected Document doGetDocument(Object obj) throws Exception {
        WikiPage page = (WikiPage)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)page);
        document.addUID(PORTLET_ID, page.getResourcePrimKey());
        String content = HtmlUtil.extractText((String)WikiUtil.convert(page, null, null, null));
        document.addText("content", content);
        document.addKeyword("nodeId", page.getNodeId());
        document.addText("title", page.getTitle());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        Summary summary = this.createSummary(document, "title", "content");
        summary.setMaxContentLength(200);
        String nodeId = document.get("nodeId");
        portletURL.setParameter("struts_action", "/wiki/view");
        portletURL.setParameter("nodeId", nodeId);
        portletURL.setParameter("title", summary.getTitle());
        summary.setPortletURL(portletURL);
        return summary;
    }

    protected void doReindex(Object obj) throws Exception {
        WikiPage page = (WikiPage)obj;
        if (!page.isHead() || !page.isApproved() && !page.isInTrash()) {
            return;
        }
        if (Validator.isNotNull((String)page.getRedirectTitle())) {
            return;
        }
        Document document = this.getDocument(page);
        SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)page.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        WikiPage page = WikiPageLocalServiceUtil.fetchWikiPage((long)classPK);
        if (page == null) {
            page = WikiPageLocalServiceUtil.getPage((long)classPK, null);
        }
        this.doReindex(page);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexNodes(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexNodes(final long companyId) throws PortalException, SystemException {
        WikiNodeActionableDynamicQuery actionableDynamicQuery = new WikiNodeActionableDynamicQuery(){

            protected void performAction(Object object) throws PortalException, SystemException {
                WikiNode node = (WikiNode)object;
                WikiPageIndexer.this.reindexPages(companyId, node.getGroupId(), node.getNodeId());
            }
        };
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.performActions();
    }

    protected void reindexPages(long companyId, long groupId, final long nodeId) throws PortalException, SystemException {
        WikiPageActionableDynamicQuery actionableDynamicQuery = new WikiPageActionableDynamicQuery(){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                Property nodeIdProperty = PropertyFactoryUtil.forName((String)"nodeId");
                dynamicQuery.add(nodeIdProperty.eq((Object)nodeId));
                Property headProperty = PropertyFactoryUtil.forName((String)"head");
                dynamicQuery.add(headProperty.eq((Object)true));
            }

            protected void performAction(Object object) throws PortalException {
                WikiPage page = (WikiPage)object;
                Document document = WikiPageIndexer.this.getDocument(page);
                this.addDocument(document);
            }
        };
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setGroupId(groupId);
        actionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        actionableDynamicQuery.performActions();
    }
}

